/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailUnitOfMeasureValidation;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerInvoiceDetailUnitOfMeasureValidationTest {
    private static final String VALID_UNIT_OF_MEASURE_CODE = "EA";
    private static final String INVALID_UNIT_OF_MEASURE_CODE = "XX";
    private CustomerInvoiceDetailUnitOfMeasureValidation cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new CustomerInvoiceDetailUnitOfMeasureValidation();
        this.cut.setCustomerInvoiceDetail(new CustomerInvoiceDetail());
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
    }

    @Test
    public void validate_ValidUnitOfMeasure() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("itemUnitOfMeasureCode", VALID_UNIT_OF_MEASURE_CODE);
        Mockito.when((Object)((UnitOfMeasure)this.businessObjectSvcMock.findByPrimaryKey(UnitOfMeasure.class, criteria))).thenReturn((Object)new UnitOfMeasure());
        this.cut.getCustomerInvoiceDetail().setInvoiceItemUnitOfMeasureCode(VALID_UNIT_OF_MEASURE_CODE);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_InvalidUnitOfMeasure() {
        this.cut.getCustomerInvoiceDetail().setInvoiceItemUnitOfMeasureCode(INVALID_UNIT_OF_MEASURE_CODE);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }
}

