/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailUnitPriceValidation;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceDetailFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SpringContext.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerInvoiceDetailUnitPriceValidationTest {
    private CustomerInvoiceDetailUnitPriceValidation cut;
    @Mock
    private AccountService accountSvcMock;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        PowerMockito.mockStatic(SpringContext.class, (Class[])new Class[0]);
        Mockito.when((Object)((AccountService)SpringContext.getBean(AccountService.class))).thenReturn((Object)this.accountSvcMock);
        this.cut = new CustomerInvoiceDetailUnitPriceValidation();
    }

    @Test
    public void validate_UnitPriceNotEqualToZero() {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
        this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_UnitPriceEqualToZero() {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_AMOUNT_EQUALS_ZERO.createCustomerInvoiceDetail();
        this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_UnitPricePositiveWhenReversalAndDiscount() {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_POSITIVE_AMOUNT.createCustomerInvoiceDetail();
        Mockito.when((Object)this.customerInvoiceDocumentMock.isInvoiceReversal()).thenReturn((Object)true);
        this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_UnitPriceNegativeWhenReversalAndDiscount() {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_DISCOUNT_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        Mockito.when((Object)this.customerInvoiceDocumentMock.isInvoiceReversal()).thenReturn((Object)true);
        this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_UnitPriceNegativeWhenReversalAndNotDiscount() {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        Mockito.when((Object)this.customerInvoiceDocumentMock.isInvoiceReversal()).thenReturn((Object)true);
        this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_UnitPricePositiveWhenReversalAndNotDiscount() {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
        Mockito.when((Object)this.customerInvoiceDocumentMock.isInvoiceReversal()).thenReturn((Object)true);
        this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_UnitPricePositiveWhenNotReversalAndNotDiscount() {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.BASE_CUSTOMER_INVOICE_DETAIL.createCustomerInvoiceDetail();
        this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        Assert.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    public void validate_UnitPriceNegativeWhenNotReversalAndNotDiscount() {
        CustomerInvoiceDetail customerInvoiceDetail = CustomerInvoiceDetailFixture.CUSTOMER_INVOICE_DETAIL_WITH_NEGATIVE_AMOUNT.createCustomerInvoiceDetail();
        this.cut.setCustomerInvoiceDetail(customerInvoiceDetail);
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        Assert.assertFalse((boolean)this.cut.validate(null));
    }
}

