/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceWriteoffDocumentRule;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerInvoiceWriteoffDocumentRuleTest {
    private static final String VALID_CHART_OF_ACCOUNTS_CODE_FOR_PARM = "BL";
    private static final String INVALID_CHART_OF_ACCOUNTS_CODE_FOR_PARM = "XX";
    private static final String CHART_WRITEOFF_PARM_VALUE = "BL=5105";
    private static final String ORG_ACCT_DEFAULT_CHART = "UA";
    private static final String ORG_ACCT_DEFAULT_ORG = "VPIT";
    private static final String ORG_ACCT_DEFAULT_WRITEOFF_ACCT = "1031400";
    private static final String ORG_ACCT_DEFAULT_WRITEOFF_CHART = "BL";
    private static final String ORG_ACCT_DEFAULT_WRITEOFF_OBJECT_CODE = "1500";
    private static final int FISCAL_YEAR = 2018;
    private CustomerInvoiceWriteoffDocumentRule cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private UniversityDateService universityDateSvcMock;
    private CustomerInvoiceWriteoffDocument customerInvoiceWriteoffDocMock;
    private CustomerInvoiceDocument customerInvoiceDocMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2018);
        this.customerInvoiceWriteoffDocMock = (CustomerInvoiceWriteoffDocument)Mockito.mock(CustomerInvoiceWriteoffDocument.class);
        this.customerInvoiceDocMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)this.customerInvoiceDocMock.getBillByChartOfAccountCode()).thenReturn((Object)ORG_ACCT_DEFAULT_CHART);
        Mockito.when((Object)this.customerInvoiceDocMock.getBilledByOrganizationCode()).thenReturn((Object)ORG_ACCT_DEFAULT_ORG);
        Mockito.when((Object)this.customerInvoiceWriteoffDocMock.getCustomerInvoiceDocument()).thenReturn((Object)this.customerInvoiceDocMock);
        this.cut = new CustomerInvoiceWriteoffDocumentRule();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setParameterService(this.parameterSvcMock);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
    }

    @Test
    public void doesChartCodeHaveCorrespondingWriteoffObjectCode_Valid() {
        Mockito.when((Object)this.parameterSvcMock.getSubParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "GLPE_WRITEOFF_OBJECT_CODE_BY_CHART", "BL")).thenReturn((Object)CHART_WRITEOFF_PARM_VALUE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setChartOfAccountsCode("BL");
        Assert.assertTrue((boolean)this.cut.doesChartCodeHaveCorrespondingWriteoffObjectCode(customerInvoiceDetail));
    }

    @Test
    public void doesChartCodeHaveCorrespondingWriteoffObjectCode_Invalid() {
        Mockito.when((Object)this.parameterSvcMock.getSubParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "GLPE_WRITEOFF_OBJECT_CODE_BY_CHART", "BL")).thenReturn((Object)CHART_WRITEOFF_PARM_VALUE);
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setChartOfAccountsCode(INVALID_CHART_OF_ACCOUNTS_CODE_FOR_PARM);
        Assert.assertFalse((boolean)this.cut.doesChartCodeHaveCorrespondingWriteoffObjectCode(customerInvoiceDetail));
    }

    @Test
    public void doesOrganizationAccountingDefaultHaveWriteoffInformation_Valid() {
        this.setupOrganizationAccountingDefault(true);
        Assert.assertTrue((boolean)this.cut.doesOrganizationAccountingDefaultHaveWriteoffInformation(this.customerInvoiceWriteoffDocMock));
    }

    private void setupOrganizationAccountingDefault(boolean includeWriteoffInfo) {
        OrganizationAccountingDefault organizationAccountingDefault = new OrganizationAccountingDefault();
        organizationAccountingDefault.setChartOfAccountsCode(ORG_ACCT_DEFAULT_CHART);
        organizationAccountingDefault.setOrganizationCode(ORG_ACCT_DEFAULT_ORG);
        organizationAccountingDefault.setUniversityFiscalYear(Integer.valueOf(2018));
        if (includeWriteoffInfo) {
            organizationAccountingDefault.setWriteoffAccountNumber(ORG_ACCT_DEFAULT_WRITEOFF_ACCT);
            organizationAccountingDefault.setWriteoffFinancialObjectCode(ORG_ACCT_DEFAULT_WRITEOFF_OBJECT_CODE);
            organizationAccountingDefault.setWriteoffChartOfAccountsCode("BL");
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", 2018);
        criteria.put("chartOfAccountsCode", ORG_ACCT_DEFAULT_CHART);
        criteria.put("organizationCode", ORG_ACCT_DEFAULT_ORG);
        Mockito.when((Object)((OrganizationAccountingDefault)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria))).thenReturn((Object)organizationAccountingDefault);
    }

    @Test
    public void doesOrganizationAccountingDefaultHaveWriteoffInformation_Invalid() {
        Assert.assertFalse((boolean)this.cut.doesOrganizationAccountingDefaultHaveWriteoffInformation(this.customerInvoiceWriteoffDocMock));
        this.setupOrganizationAccountingDefault(false);
        Assert.assertFalse((boolean)this.cut.doesOrganizationAccountingDefaultHaveWriteoffInformation(this.customerInvoiceWriteoffDocMock));
    }

    @Test
    public void doesCustomerInvoiceDocumentHaveValidBalance_Valid() {
        Mockito.when((Object)this.customerInvoiceDocMock.getOpenAmount()).thenReturn((Object)new KualiDecimal(1));
        Assert.assertTrue((boolean)this.cut.doesCustomerInvoiceDocumentHaveValidBalance(this.customerInvoiceWriteoffDocMock));
    }

    @Test
    public void doesCustomerInvoiceDocumentHaveValidBalance_Invalid() {
        Mockito.when((Object)this.customerInvoiceDocMock.getOpenAmount()).thenReturn((Object)new KualiDecimal(-1));
        Assert.assertFalse((boolean)this.cut.doesCustomerInvoiceDocumentHaveValidBalance(this.customerInvoiceWriteoffDocMock));
    }
}

