/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import java.time.LocalDate;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerAddressEmail;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerRule;
import org.kuali.rice.krad.bo.BusinessObject;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class CustomerRuleTest {
    private static final String ERROR_PATH_PREFIX_ROOT = "document.newMaintainableObject.customerAddresses";
    private static final String CUSTOMER_ADDRESS_NAME = "Address Name";
    private static final String CUSTOMER_ADDRESS_COUNTRY_CODE_US = "US";
    private static final String CUSTOMER_ADDRESS_COUNTRY_CODE_RO = "RO";
    private static final String CUSTOMER_ADDRESS_STATE_CODE = "NY";
    private static final String CUSTOMER_ADDRESS_ZIP_CODE = "14850";
    private CustomerRule cut;
    private Customer customer;
    private CustomerAddress customerAddress;
    @Mock
    private DictionaryValidationService dictionaryValidationSvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new CustomerRule();
        this.cut.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        this.customer = new Customer();
        this.customerAddress = new CustomerAddress();
    }

    @After
    public void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.cut.setDictionaryValidationService(null);
    }

    @Test
    public void checkCustomerHasAddress_HasAddress() {
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkCustomerHasAddress(this.customer);
        Assert.assertTrue((String)"When customer has an address checkCustomerHasAddress should return true. ", (boolean)result);
    }

    @Test
    public void checkCustomerHasAddress_NoAddress() {
        this.customer.getCustomerAddresses().clear();
        boolean result = this.cut.checkCustomerHasAddress(this.customer);
        Assert.assertFalse((String)"When customer does not have an address checkCustomerHasAddress should return false. ", (boolean)result);
    }

    @Test
    public void checkAddressIsValid_CountryUS_StateAndZipCodeSet() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_US);
        this.customerAddress.setCustomerStateCode(CUSTOMER_ADDRESS_STATE_CODE);
        this.customerAddress.setCustomerZipCode(CUSTOMER_ADDRESS_ZIP_CODE);
        boolean result = this.cut.checkAddressIsValid(this.customerAddress);
        Assert.assertTrue((String)"When customer address has country code US and state code and zip code are not empty checkAddressIsValid should return true. ", (boolean)result);
    }

    @Test
    public void testCheckAddressIsValid_CountryUS_StateAndZipCodeEmpty() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_US);
        this.customerAddress.setCustomerStateCode("");
        this.customerAddress.setCustomerZipCode("");
        boolean result = this.cut.checkAddressIsValid(this.customerAddress);
        Assert.assertFalse((String)"When customer address has country code US and state code and zip code are empty checkAddressIsValid should return false. ", (boolean)result);
    }

    @Test
    public void checkAddressIsValid_CountryNonUS_InternationalProvinceNameAndMailCodeEmpty() {
        this.customerAddress.setCustomerAddressName(CUSTOMER_ADDRESS_NAME);
        this.customerAddress.setCustomerCountryCode(CUSTOMER_ADDRESS_COUNTRY_CODE_RO);
        this.customerAddress.setCustomerAddressInternationalProvinceName("");
        this.customerAddress.setCustomerZipCode("");
        boolean result = this.cut.checkAddressIsValid(this.customerAddress);
        Assert.assertTrue((String)"When customer address has country code RO and province and International Mail Code are empty checkAddressIsValid should return true; province and international mail code are never required. ", (boolean)result);
    }

    @Test
    public void checkAddresses_OnePrimaryAddress() {
        this.customerAddress.setCustomerAddressTypeCode("P");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkAddresses(this.customer);
        Assert.assertTrue((String)"When customer has one primary address checkAddresses should return true. ", (boolean)result);
    }

    @Test
    public void checkAddresses_HasMore_MoreThanOnePrimaryAddress() {
        this.customerAddress.setCustomerAddressTypeCode("P");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkAddresses(this.customer);
        Assert.assertFalse((String)"When customer has more than one primary address checkAddresses should return false. ", (boolean)result);
    }

    @Test
    public void checkAddresses_HasNone_NoPrimaryAddress() {
        this.customerAddress.setCustomerAddressTypeCode("A");
        this.customer.getCustomerAddresses().add(this.customerAddress);
        boolean result = this.cut.checkAddresses(this.customer);
        Assert.assertFalse((String)"When customer has no primary address checkAddresses should return false. ", (boolean)result);
    }

    @Test
    public void checkEndDateIsValid_Today_Invalid() {
        Date endDate = Date.valueOf(LocalDate.now());
        Assert.assertFalse((boolean)this.cut.checkEndDateIsValid(endDate, false));
    }

    @Test
    public void checkEndDateIsValid_Today_Valid() {
        Date endDate = Date.valueOf(LocalDate.now());
        Assert.assertTrue((boolean)this.cut.checkEndDateIsValid(endDate, true));
    }

    @Test
    public void checkEndDateIsValid_Tomorrow_Valid() {
        Date endDate = Date.valueOf(LocalDate.now().plusDays(1L));
        Assert.assertTrue((boolean)this.cut.checkEndDateIsValid(endDate, false));
    }

    @Test
    public void checkEmailAddress_TransmissionCodeNotEmail_NoEmailAddress() {
        Assert.assertTrue((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
    }

    @Test
    public void checkEmailAddress_TransmissionCodeNotEmail_ValidEmailAddress() {
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 0);
        Assert.assertTrue((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
    }

    @Test
    public void checkEmailAddress_TransmissionCodeNotEmail_InvalidEmailAddress() {
        this.setupEmailAddress("hedgehog@kuali.co", true, false, 0);
        Assert.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void checkEmailAddress_TransmissionCodeNotEmail_DuplicateEmailAddresses() {
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 0);
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 1);
        Assert.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.customerAddresses[0].customerAddressEmails[1].customerEmailAddress");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.document.customer.duplicateEmailForAddress", (Object)errorMessage.getErrorKey());
    }

    @Test
    public void checkEmailAddress_TransmissionCodeEmail_NoEmailAddress() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        Assert.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get(ERROR_PATH_PREFIX_ROOT);
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.document.customer.atLeastOneEmailRequired", (Object)errorMessage.getErrorKey());
    }

    @Test
    public void checkEmailAddress_TransmissionCodeEmail_OneInactiveEmailAddress() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        this.setupEmailAddress("hedgehog@kuali.co", false, true, 0);
        Assert.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get(ERROR_PATH_PREFIX_ROOT);
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.document.customer.atLeastOneEmailRequired", (Object)errorMessage.getErrorKey());
    }

    @Test
    public void checkEmailAddress_TransmissionCodeEmail_OneInactiveEmailAddress_OneActiveEmailAddress() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        this.setupEmailAddress("active@kuali.co", true, true, 0);
        this.setupEmailAddress("inactive@kuali.co", false, true, 1);
        Assert.assertTrue((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
    }

    @Test
    public void checkEmailAddress_TransmissionCodeEmail_InvalidEmailAddress() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        this.setupEmailAddress("hedgehog@kuali.co", true, false, 0);
        Assert.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void checkEmailAddress_TransmissionCodeEmail_DuplicateEmailAddresses() {
        this.customerAddress.setInvoiceTransmissionMethodCode("EMAIL");
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 0);
        this.setupEmailAddress("hedgehog@kuali.co", true, true, 1);
        Assert.assertFalse((boolean)this.cut.validateEmailAddressForCurrentAddress(this.customerAddress, 0));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.customerAddresses[0].customerAddressEmails[1].customerEmailAddress");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.document.customer.duplicateEmailForAddress", (Object)errorMessage.getErrorKey());
    }

    private void setupEmailAddress(String customerEmailAddress, boolean active, boolean valid, int index) {
        CustomerAddressEmail customerAddressEmail = new CustomerAddressEmail();
        customerAddressEmail.setCustomerEmailAddress(customerEmailAddress);
        customerAddressEmail.setActive(active);
        this.customerAddress.getCustomerAddressEmails().add(customerAddressEmail);
        String errorPathPrefix = "document.newMaintainableObject.customerAddresses[0].customerAddressEmails[" + index + "]";
        Mockito.when((Object)this.dictionaryValidationSvcMock.isBusinessObjectValid((BusinessObject)customerAddressEmail, errorPathPrefix)).thenReturn((Object)valid);
    }
}

