/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.LinkedList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.document.validation.impl.InvoiceAmountLessThanInvoiceMinimumSuspensionCategory;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;

@Execution(value=ExecutionMode.SAME_THREAD)
public class InvoiceAmountLessThanInvoiceMinimumSuspensionCategoryTest {
    private InvoiceAmountLessThanInvoiceMinimumSuspensionCategory cut;
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock
    private ContractsAndGrantsBillingAward awardMock;
    @Spy
    private ContractsGrantsInvoiceDocumentServiceImpl contractsGrantsInvoiceDocumentSvcSpy;
    @Mock
    private InvoiceGeneralDetail invoiceGeneralDetailMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.awardMock.getMinInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceInvoiceAmount()).thenReturn((Object)KualiDecimal.ZERO);
        ((ContractsGrantsInvoiceDocumentServiceImpl)Mockito.doNothing().when((Object)this.contractsGrantsInvoiceDocumentSvcSpy)).recalculateTotalAmountBilledToDate(this.contractsGrantsInvoiceDocumentMock);
        ((ContractsGrantsInvoiceDocumentServiceImpl)Mockito.doNothing().when((Object)this.contractsGrantsInvoiceDocumentSvcSpy)).calculatePreviouslyBilledAmounts(this.contractsGrantsInvoiceDocumentMock);
        this.cut = new InvoiceAmountLessThanInvoiceMinimumSuspensionCategory();
        this.cut.setContractsGrantsInvoiceDocumentService((ContractsGrantsInvoiceDocumentService)this.contractsGrantsInvoiceDocumentSvcSpy);
    }

    @Test
    public void shouldSuspend_Monthly_InvoiceAmountGreaterThanMinimum_No() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceInvoiceAmount()).thenReturn((Object)new KualiDecimal(500.0));
        Assert.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    public void shouldSuspend_Monthly_InvoiceAmountLessThanMinimum_Yes() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceInvoiceAmount()).thenReturn((Object)new KualiDecimal(50.0));
        Assert.assertTrue((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    public void shouldSuspend_PredeterminedBilling_TotalBillAmountGreaterThanMinimum_No() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        LinkedList<InvoiceBill> bills = new LinkedList<InvoiceBill>();
        InvoiceBill bill = new InvoiceBill();
        bill.setEstimatedAmount(new KualiDecimal(500.0));
        bills.add(bill);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceBills()).thenReturn(bills);
        Assert.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    public void shouldSuspend_PredeterminedBilling_TotalBillAmountLessThanMinimum_Yes() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        LinkedList<InvoiceBill> bills = new LinkedList<InvoiceBill>();
        InvoiceBill bill = new InvoiceBill();
        bill.setEstimatedAmount(new KualiDecimal(50.0));
        bills.add(bill);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceBills()).thenReturn(bills);
        Assert.assertTrue((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    public void shouldSuspend_Milestone_TotalBillAmountGreaterThanMinimum_No() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        LinkedList<InvoiceMilestone> milestones = new LinkedList<InvoiceMilestone>();
        InvoiceMilestone milestone = new InvoiceMilestone();
        milestone.setMilestoneAmount(new KualiDecimal(500.0));
        milestones.add(milestone);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceMilestones()).thenReturn(milestones);
        Assert.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    public void shouldSuspend_Milestone_TotalBillAmountLessThanMinimum_Yes() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        LinkedList<InvoiceMilestone> milestones = new LinkedList<InvoiceMilestone>();
        InvoiceMilestone milestone = new InvoiceMilestone();
        milestone.setMilestoneAmount(new KualiDecimal(50.0));
        milestones.add(milestone);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceMilestones()).thenReturn(milestones);
        Assert.assertTrue((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }
}

