/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectTypeService;
import org.kuali.kfs.coa.service.impl.ObjectTypeServiceImpl;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.validation.impl.OrganizationAccountingDefaultRule;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class OrganizationAccountingDefaultRuleTest {
    private static final int FISCAL_YEAR = 2018;
    private static String EXPENSE_OBJECT_CODE = "3310";
    private static String INCOME_OBJECT_CODE = "0776";
    private OrganizationAccountingDefaultRule cut;
    private OrganizationAccountingDefault organizationAccountingDefault;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    private ObjectCode incomeObjectCode;
    private ObjectCode expenseObjectCode;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.incomeObjectCode = new ObjectCode();
        this.incomeObjectCode.setFinancialObjectCode(INCOME_OBJECT_CODE);
        this.incomeObjectCode.setFinancialObjectTypeCode("IN");
        this.expenseObjectCode = new ObjectCode();
        this.expenseObjectCode.setFinancialObjectCode(EXPENSE_OBJECT_CODE);
        this.expenseObjectCode.setFinancialObjectTypeCode("EX");
        SystemOptions systemOptions = new SystemOptions();
        systemOptions.setUniversityFiscalYear(Integer.valueOf(2018));
        systemOptions.setFinObjectTypeIncomecashCode("IN");
        systemOptions.setFinObjTypeIncomeNotCashCd("IC");
        systemOptions.setFinObjTypeCshNotIncomeCd("CH");
        Mockito.when((Object)((SystemOptions)this.businessObjectSvcMock.findBySinglePrimaryKey(SystemOptions.class, (Object)2018))).thenReturn((Object)systemOptions);
        ObjectTypeServiceImpl objectTypeService = new ObjectTypeServiceImpl();
        objectTypeService.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut = new OrganizationAccountingDefaultRule();
        this.cut.setObjectTypeService((ObjectTypeService)objectTypeService);
        this.organizationAccountingDefault = new OrganizationAccountingDefault();
        this.organizationAccountingDefault.setUniversityFiscalYear(Integer.valueOf(2018));
        this.organizationAccountingDefault.setChartOfAccountsCode("IU");
    }

    @Test
    public void isLateChargeObjectValidIncome_IncomeObjectCode() {
        this.organizationAccountingDefault.setOrganizationLateChargeObject(this.incomeObjectCode);
        boolean result = this.cut.isLateChargeObjectValidIncome(this.organizationAccountingDefault);
        Assert.assertTrue((String)("When late charge object code is " + INCOME_OBJECT_CODE + ", isLateChargeObjectValidIncome should return true. "), (boolean)result);
    }

    @Test
    public void isLateChargeObjectValidIncome_ExpenseObjectCode() {
        this.organizationAccountingDefault.setOrganizationLateChargeObject(this.expenseObjectCode);
        boolean result = this.cut.isLateChargeObjectValidIncome(this.organizationAccountingDefault);
        Assert.assertFalse((String)("When late charge object code is " + EXPENSE_OBJECT_CODE + ", isLateChargeObjectValidIncome should return false. "), (boolean)result);
    }

    @Test
    public void isDefaultInvoiceFinancialObjectValidIncome_IncomeObjectCode() {
        this.organizationAccountingDefault.setDefaultInvoiceFinancialObject(this.incomeObjectCode);
        boolean result = this.cut.isDefaultInvoiceFinancialObjectValidIncome(this.organizationAccountingDefault);
        Assert.assertTrue((String)("When default invoice financial  is " + INCOME_OBJECT_CODE + ", isDefaultInvoiceFinancialObjectValidIncome should return true. "), (boolean)result);
    }

    @Test
    public void isDefaultInvoiceFinancialObjectValidIncome_ExpenseObjectCode() {
        this.organizationAccountingDefault.setDefaultInvoiceFinancialObject(this.expenseObjectCode);
        boolean result = this.cut.isDefaultInvoiceFinancialObjectValidIncome(this.organizationAccountingDefault);
        Assert.assertFalse((String)("When default invoice financial object code is " + EXPENSE_OBJECT_CODE + ", isDefaultInvoiceFinancialObjectValidIncome should return false. "), (boolean)result);
    }
}

