/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.NonAppliedHoldingService;
import org.kuali.kfs.module.ar.document.service.PaymentApplicationDocumentService;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationAdjustmentAction;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.Spy;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.springframework.mock.web.MockHttpServletResponse;

class PaymentApplicationAdjustmentActionTest {
    @Mock
    private BusinessObjectService businessObjectServiceMock;
    @Spy
    private PaymentApplicationAdjustmentAction cutSpy;

    PaymentApplicationAdjustmentActionTest() {
    }

    @BeforeEach
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)this.businessObjectServiceMock).when((Object)this.cutSpy)).getBusinessObjectService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)Mockito.mock(CustomerInvoiceDetailService.class)).when((Object)this.cutSpy)).getCustomerInvoiceDetailService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)Mockito.mock(CustomerInvoiceDocumentService.class)).when((Object)this.cutSpy)).getCustomerInvoiceDocumentService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)Mockito.mock(NonAppliedHoldingService.class)).when((Object)this.cutSpy)).getNonAppliedHoldingService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)Mockito.mock(PaymentApplicationDocumentService.class)).when((Object)this.cutSpy)).getPaymentApplicationDocumentService();
    }

    @DisplayName(value="Given the 'invoiceNumber' request parameter is invalid, then a BAD_REQUEST error should be returned")
    @ParameterizedTest(name="invoiceNumber = {0}")
    @MethodSource(value={"addInvoiceInvalidBadRequestArgs"})
    void addInvoice_invalid_bad_request(String invoiceNumber) throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)("{ \"invoiceNumber\":\"" + invoiceNumber + "\"}"));
        ActionForward actual = this.cutSpy.addInvoice(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = "{  \"status\": \"" + expectedStatus.name() + "\",  \"message\": \"Missing 'invoiceNumber' request parameter\"}";
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    private static Stream<Arguments> addInvoiceInvalidBadRequestArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{""}), Arguments.of((Object[])new Object[]{" "}));
    }

    @Test
    void addInvoice_invalid_invoice_not_found() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String invoiceNumber = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"invoiceNumber\":\"123\"}");
        Mockito.when((Object)((CustomerInvoiceDocument)this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"123"))).thenReturn(null);
        ActionForward actual = this.cutSpy.addInvoice(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.NOT_FOUND;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = "{  \"status\": \"" + expectedStatus.name() + "\",  \"message\": \"Requested invoice not found : invoiceNumber=123\"}";
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addInvoice_invalid_invoice_does_not_have_open_amount() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String invoiceNumber = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"invoiceNumber\":\"123\"}");
        CustomerInvoiceDocument invoice = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)((CustomerInvoiceDocument)this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"123"))).thenReturn((Object)invoice);
        Mockito.when((Object)invoice.getOpenAmount()).thenReturn(null);
        ActionForward actual = this.cutSpy.addInvoice(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.PRECONDITION_FAILED;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = "{  \"status\": \"" + expectedStatus.name() + "\",  \"message\": \"Invoice does not have an open amount : invoiceNumber=123\"}";
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addInvoice_invalid_invoice_has_open_amount_that_is_not_positive() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String invoiceNumber = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"invoiceNumber\":\"123\"}");
        CustomerInvoiceDocument invoice = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)((CustomerInvoiceDocument)this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"123"))).thenReturn((Object)invoice);
        KualiDecimal openAmount = new KualiDecimal(0);
        Mockito.when((Object)invoice.getOpenAmount()).thenReturn((Object)openAmount);
        ActionForward actual = this.cutSpy.addInvoice(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.PRECONDITION_FAILED;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = "{  \"status\": \"" + expectedStatus.name() + "\",  \"message\": \"Invoice does not have an open amount : invoiceNumber=123\"}";
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @DisplayName(value="Given the 'customerNumber' request parameter is invalid, then a BAD_REQUEST error should be returned")
    @ParameterizedTest(name="customerNumber = {0}")
    @MethodSource(value={"addCustomerInvalidBadRequestArgs"})
    void addCustomer_invalid_bad_request(String customerNumber) throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)("{ \"customerNumber\":\"" + customerNumber + "\"}"));
        ActionForward actual = this.cutSpy.addCustomer(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = "{  \"status\": \"" + expectedStatus.name() + "\",  \"message\": \"Missing 'customerNumber' request parameter\"}";
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    private static Stream<Arguments> addCustomerInvalidBadRequestArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{""}), Arguments.of((Object[])new Object[]{" "}));
    }

    @Test
    void addCustomer_invalid_customer_not_found() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String customerNumber = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"customerNumber\":\"123\"}");
        Mockito.when((Object)((Customer)this.businessObjectServiceMock.findBySinglePrimaryKey(Customer.class, (Object)"123"))).thenReturn(null);
        ActionForward actual = this.cutSpy.addCustomer(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.NOT_FOUND;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = "{  \"status\": \"" + expectedStatus.name() + "\",  \"message\": \"Requested customer not found : customerNumber=123\"}";
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }
}

