/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.integration.cg.CGIntegrationConstants;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.integration.cg.ContractsAndGrantsInstrumentType;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.ModuleService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceObjectCode;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLetterOfCreditReviewDetail;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceDetailAccountObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.dataaccess.AwardAccountObjectCodeTotalBilledDao;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsBillingAwardVerificationServiceImpl;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.service.impl.ContractsGrantsInvoiceCreateDocumentServiceImpl;
import org.kuali.kfs.sys.businessobject.ChartOrgHolderImpl;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.fixture.AccountFixture;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@Execution(value=ExecutionMode.SAME_THREAD)
public class ContractsGrantsInvoiceCreateDocumentServiceImplTest {
    private static final KualiDecimal AWARD_TOTAL_AMOUNT = new KualiDecimal(100000.0);
    private static final Date ONE_YEAR_AGO = Date.valueOf(LocalDate.now().minusYears(1L));
    private static final Date TODAY = Date.valueOf(LocalDate.now());
    private static final DateFormat formatter = new SimpleDateFormat("MM/dd/yyyy", Locale.US);
    private static final String AWARD_DATE_RANGE = formatter.format(ONE_YEAR_AGO) + " to " + formatter.format(TODAY);
    private static final String CHART_OF_ACCOUNTS_CODE = "BA";
    private static final String INSTRUMENT_TYPE_CODE = "ITC";
    private static final String INSTRUMENT_TYPE_DESCRIPTION = "ITC-Description";
    private static final String ORGANIZATION_CODE = "CHEM";
    private static final String PRINCIPAL_ID = "012345678";
    private static final String PROCESSING_CHART_OF_ACCOUNTS_CODE = "BL";
    private static final String PROCESSING_ORGANIZATION_CODE = "SRS";
    private static final String PROPOSAL_NUMBER = "1";
    private ContractsGrantsInvoiceCreateDocumentServiceImpl cut;
    @Mock
    private FinancialSystemUserService financialSystemUserServiceMock;
    @Mock
    private Person personMock;
    @Mock
    private ContractsAndGrantsFundManager awardFundManagerMock;
    @Mock
    private DocumentService documentServiceMock;
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock
    private InvoiceGeneralDetail invoiceGeneralDetailMock;
    @Mock
    private DocumentHeader documentHeaderMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentServiceMock;
    @Mock
    private AccountingPeriodService accountingPeriodServiceMock;
    @Mock
    private VerifyBillingFrequencyService verifyBillingFrequencyServiceMock;
    @Mock
    private BillingPeriod billingPeriodMock;
    @Mock
    private DateTimeService dateTimeServiceMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private UniversityDateService universityDateServiceMock;
    @Mock
    private AccountingPeriod accountingPeriodMock;
    @Mock
    private OptionsService optionsServiceMock;
    @Mock
    private SystemOptions systemOptionsMock;
    @Mock
    private BusinessObjectService businessObjectServiceMock;
    @Mock
    private AwardAccountObjectCodeTotalBilledDao awardAccountObjectCodeTotalBilledDaoMock;
    @Mock
    private CustomerService customerServiceMock;
    @Mock
    private FinancialSystemDocumentService financialSystemDocumentService;
    @Mock
    private ConfigurationService configurationService;
    @Mock
    private ContractsAndGrantsBillingAward awardMock;
    @Mock
    private ContractsAndGrantsInstrumentType instrumentTypeMock;
    @Mock
    private KualiModuleService kualiModuleSvcMock;
    @Mock
    private CustomerAddressService customerAddressSvcMock;
    @Mock
    private SubFundGroup subFundGroupMock;
    private List<ContractsAndGrantsBillingAwardAccount> validAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
    private List<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
    private List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails = new ArrayList<ContractsGrantsLetterOfCreditReviewDetail>();
    private String agencyNumber;
    private String customerNumber;

    @Before
    public void setUp() throws WorkflowException {
        MockitoAnnotations.initMocks((Object)this);
        this.setupCut();
        this.setupCgbAwardVerificationService();
        this.setupAwardMock();
        this.setupMockingToSupportAwardValidation();
        this.setupMockingToSupportInvoiceCreation();
        this.setupModuleServiceMocking();
    }

    private void setupCut() {
        this.cut = new ContractsGrantsInvoiceCreateDocumentServiceImpl();
        this.cut.setFinancialSystemUserService(this.financialSystemUserServiceMock);
        this.cut.setDocumentService(this.documentServiceMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentServiceMock);
        this.cut.setAccountingPeriodService(this.accountingPeriodServiceMock);
        this.cut.setVerifyBillingFrequencyService(this.verifyBillingFrequencyServiceMock);
        this.cut.setDateTimeService(this.dateTimeServiceMock);
        this.cut.setDataDictionaryService(this.dataDictionarySvcMock);
        this.cut.setUniversityDateService(this.universityDateServiceMock);
        this.cut.setOptionsService(this.optionsServiceMock);
        this.cut.setBusinessObjectService(this.businessObjectServiceMock);
        this.cut.setAwardAccountObjectCodeTotalBilledDao(this.awardAccountObjectCodeTotalBilledDaoMock);
        this.cut.setConfigurationService(this.configurationService);
        this.cut.setCustomerService(this.customerServiceMock);
        this.cut.setFinancialSystemDocumentService(this.financialSystemDocumentService);
        this.cut.setCustomerAddressService(this.customerAddressSvcMock);
    }

    private void setupCgbAwardVerificationService() {
        ContractsGrantsBillingAwardVerificationServiceImpl contractsGrantsBillingAwardVerificationServiceImpl = new ContractsGrantsBillingAwardVerificationServiceImpl();
        this.cut.setContractsGrantsBillingAwardVerificationService((ContractsGrantsBillingAwardVerificationService)contractsGrantsBillingAwardVerificationServiceImpl);
        contractsGrantsBillingAwardVerificationServiceImpl.setFinancialSystemUserService(this.financialSystemUserServiceMock);
        contractsGrantsBillingAwardVerificationServiceImpl.setUniversityDateService(this.universityDateServiceMock);
        contractsGrantsBillingAwardVerificationServiceImpl.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentServiceMock);
        contractsGrantsBillingAwardVerificationServiceImpl.setCustomerService(this.customerServiceMock);
        contractsGrantsBillingAwardVerificationServiceImpl.setBusinessObjectService(this.businessObjectServiceMock);
    }

    private void setupAwardMock() {
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)this.awardMock.getAwardPrimaryFundManager()).thenReturn((Object)this.awardFundManagerMock);
        Mockito.when((Object)this.awardMock.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.awardMock.getAwardTotalAmount()).thenReturn((Object)AWARD_TOTAL_AMOUNT);
        Mockito.when((Object)this.awardMock.getInstrumentTypeCode()).thenReturn((Object)INSTRUMENT_TYPE_CODE);
        Mockito.when((Object)this.awardMock.getInvoicingOptionCode()).thenReturn((Object)CGIntegrationConstants.AwardInvoicingOption.Types.AWARD.getCode());
        Mockito.when((Object)this.awardMock.getAwardBeginningDate()).thenReturn((Object)ONE_YEAR_AGO);
        Mockito.when((Object)this.awardMock.getAwardEndingDate()).thenReturn((Object)TODAY);
        Mockito.when((Object)this.instrumentTypeMock.getInstrumentTypeDescription()).thenReturn((Object)INSTRUMENT_TYPE_DESCRIPTION);
        Mockito.when((Object)this.awardMock.getInstrumentType()).thenReturn((Object)this.instrumentTypeMock);
        Mockito.when((Object)this.subFundGroupMock.getFundGroupCode()).thenReturn((Object)"S");
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccountMocks = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_1.createAwardAccountMock();
        Account awardAccount = AccountFixture.EXPIRED_ACCOUNT.createAccount();
        awardAccount.setSubFundGroup(this.subFundGroupMock);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)awardAccount);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)awardAccount.getAccountNumber());
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(awardAccountMocks);
        ContractsAndGrantsBillingAgency agencyMock = ARAgencyMockFixture.CG_AGENCY1.createAgencyMock();
        this.agencyNumber = agencyMock.getAgencyNumber();
        Mockito.when((Object)this.awardMock.getAgency()).thenReturn((Object)agencyMock);
        Mockito.when((Object)this.awardMock.getAgencyNumber()).thenReturn((Object)this.agencyNumber);
        this.customerNumber = agencyMock.getCustomerNumber();
        Mockito.when((Object)this.awardMock.getCustomerNumber()).thenReturn((Object)this.customerNumber);
        ((CustomerService)Mockito.doReturn((Object)new Customer()).when((Object)this.customerServiceMock)).getByPrimaryKey(this.customerNumber);
        CustomerAddress customerAddress = new CustomerAddress();
        customerAddress.setCustomerNumber(this.customerNumber);
        customerAddress.setCustomerAddressIdentifier(Integer.valueOf(1));
        customerAddress.setCustomerInvoiceTemplateCode("STD");
        Mockito.when((Object)this.customerAddressSvcMock.getPrimaryAddress(this.customerNumber)).thenReturn((Object)customerAddress);
        Mockito.when((Object)this.customerAddressSvcMock.getByPrimaryKey(this.customerNumber, Integer.valueOf(1))).thenReturn((Object)customerAddress);
        Mockito.when((Object)this.awardMock.getCustomerAddressIdentifier()).thenReturn((Object)1);
    }

    private void setupMockingToSupportAwardValidation() {
        ((VerifyBillingFrequencyService)Mockito.doReturn((Object)true).when((Object)this.verifyBillingFrequencyServiceMock)).validateBillingFrequency((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), (ContractsAndGrantsBillingAwardAccount)ArgumentMatchers.any(ContractsAndGrantsBillingAwardAccount.class), ArgumentMatchers.anyBoolean());
        ((ConfigurationService)Mockito.doReturn((Object)false).when((Object)this.configurationService)).getPropertyValueAsBoolean("module.external.kuali.coeus.enabled");
        ((ContractsGrantsInvoiceDocumentService)Mockito.doReturn(Arrays.asList(PROCESSING_CHART_OF_ACCOUNTS_CODE, PROCESSING_ORGANIZATION_CODE)).when((Object)this.contractsGrantsInvoiceDocumentServiceMock)).getProcessingFromBillingCodes((String)ArgumentMatchers.eq((Object)CHART_OF_ACCOUNTS_CODE), (String)ArgumentMatchers.eq((Object)ORGANIZATION_CODE));
        HashMap<String, Object> organizationAccountingDefaultPrimaryKeys = new HashMap<String, Object>();
        organizationAccountingDefaultPrimaryKeys.put("chartOfAccountsCode", CHART_OF_ACCOUNTS_CODE);
        organizationAccountingDefaultPrimaryKeys.put("organizationCode", ORGANIZATION_CODE);
        organizationAccountingDefaultPrimaryKeys.put("universityFiscalYear", 0);
        ((BusinessObjectService)Mockito.doReturn((Object)new OrganizationAccountingDefault()).when((Object)this.businessObjectServiceMock)).findByPrimaryKey(OrganizationAccountingDefault.class, organizationAccountingDefaultPrimaryKeys);
        HashMap<String, Object> systemInformationPrimaryKeys = new HashMap<String, Object>();
        systemInformationPrimaryKeys.put("processingChartOfAccountCode", PROCESSING_CHART_OF_ACCOUNTS_CODE);
        systemInformationPrimaryKeys.put("processingOrganizationCode", PROCESSING_ORGANIZATION_CODE);
        systemInformationPrimaryKeys.put("universityFiscalYear", 0);
        ((BusinessObjectService)Mockito.doReturn((Object)new SystemInformation()).when((Object)this.businessObjectServiceMock)).findByPrimaryKey(SystemInformation.class, systemInformationPrimaryKeys);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.contractGrantsInvoiceObjectCodeForSubFundGroup(this.subFundGroupMock, PROCESSING_CHART_OF_ACCOUNTS_CODE)).thenReturn((Object)new ContractsGrantsInvoiceObjectCode());
    }

    private void setupMockingToSupportInvoiceCreation() throws WorkflowException {
        ContractsAndGrantsBillingAwardAccount awardAccountMock = (ContractsAndGrantsBillingAwardAccount)Mockito.mock(ContractsAndGrantsBillingAwardAccount.class);
        Account awardAccount = AccountFixture.ACTIVE_ACCOUNT.createAccount();
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)awardAccount);
        this.validAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)PRINCIPAL_ID);
        Mockito.when((Object)this.awardFundManagerMock.getFundManager()).thenReturn((Object)this.personMock);
        ChartOrgHolderImpl chartOrgHolder = new ChartOrgHolderImpl(CHART_OF_ACCOUNTS_CODE, ORGANIZATION_CODE);
        ((FinancialSystemUserService)Mockito.doReturn((Object)chartOrgHolder).when((Object)this.financialSystemUserServiceMock)).getPrimaryOrganization(PRINCIPAL_ID, "KFS-AR");
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)this.contractsGrantsInvoiceDocumentMock)).setBillByChartOfAccountCode(ArgumentMatchers.anyString());
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)this.contractsGrantsInvoiceDocumentMock)).setBilledByOrganizationCode(ArgumentMatchers.anyString());
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)this.contractsGrantsInvoiceDocumentMock)).getBillByChartOfAccountCode();
        ((ContractsGrantsInvoiceDocument)Mockito.doCallRealMethod().when((Object)this.contractsGrantsInvoiceDocumentMock)).getBilledByOrganizationCode();
        ((InvoiceGeneralDetail)Mockito.doReturn((Object)new KualiDecimal(0)).when((Object)this.invoiceGeneralDetailMock)).getTotalPreviouslyBilled();
        ((InvoiceGeneralDetail)Mockito.doReturn((Object)PROPOSAL_NUMBER).when((Object)this.invoiceGeneralDetailMock)).getProposalNumber();
        ((ContractsGrantsInvoiceDocument)Mockito.doReturn((Object)this.invoiceGeneralDetailMock).when((Object)this.contractsGrantsInvoiceDocumentMock)).getInvoiceGeneralDetail();
        ((DocumentService)Mockito.doReturn((Object)this.contractsGrantsInvoiceDocumentMock).when((Object)this.documentServiceMock)).getNewDocument(ContractsGrantsInvoiceDocument.class);
        ((ContractsGrantsInvoiceDocument)Mockito.doReturn((Object)this.documentHeaderMock).when((Object)this.contractsGrantsInvoiceDocumentMock)).getDocumentHeader();
        ((VerifyBillingFrequencyService)Mockito.doReturn((Object)this.billingPeriodMock).when((Object)this.verifyBillingFrequencyServiceMock)).getStartDateAndEndDateOfPreviousBillingPeriod((ContractsAndGrantsBillingAward)ArgumentMatchers.any(ContractsAndGrantsBillingAward.class), (AccountingPeriod)ArgumentMatchers.any());
        ((AccountingPeriodService)Mockito.doReturn((Object)this.accountingPeriodMock).when((Object)this.accountingPeriodServiceMock)).getByDate((Date)ArgumentMatchers.any());
        ((OptionsService)Mockito.doReturn((Object)this.systemOptionsMock).when((Object)this.optionsServiceMock)).getOptions(Integer.valueOf(ArgumentMatchers.anyInt()));
        ((ContractsGrantsInvoiceDocumentService)Mockito.doReturn((Object)new KualiDecimal(0)).when((Object)this.contractsGrantsInvoiceDocumentServiceMock)).getOtherTotalBilledForAwardPeriod((ContractsGrantsInvoiceDocument)ArgumentMatchers.any(ContractsGrantsInvoiceDocument.class));
        ((DateTimeService)Mockito.doReturn((Object)formatter.format(TODAY)).when((Object)this.dateTimeServiceMock)).toDateString((java.util.Date)TODAY);
        ((DateTimeService)Mockito.doReturn((Object)formatter.format(ONE_YEAR_AGO)).when((Object)this.dateTimeServiceMock)).toDateString((java.util.Date)ONE_YEAR_AGO);
        Mockito.when((Object)this.configurationService.getPropertyValueAsString("contracts.grants.invoice.document.description.format")).thenReturn((Object)"{0} [{2}] {1}");
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeMaxLength(DocumentHeader.class, "documentDescription")).thenReturn((Object)40);
    }

    private void setupModuleServiceMocking() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("instrumentTypeCode", INSTRUMENT_TYPE_CODE);
        ModuleService moduleSvcMock = (ModuleService)Mockito.mock(ModuleService.class);
        Mockito.when((Object)((ContractsAndGrantsInstrumentType)moduleSvcMock.getExternalizableBusinessObject(ContractsAndGrantsInstrumentType.class, fieldValues))).thenReturn((Object)this.instrumentTypeMock);
        Mockito.when((Object)this.kualiModuleSvcMock.getResponsibleModuleService(ContractsAndGrantsInstrumentType.class)).thenReturn((Object)moduleSvcMock);
    }

    @Test
    public void generateAndSaveContractsAndGrantsInvoiceDocument_COA_AND_ORG_CODE_FROM_FUND_MANAGER() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getAwardBilledToDateAmount(PROPOSAL_NUMBER)).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100));
        String locCreationType = "";
        this.cut.generateAndSaveContractsAndGrantsInvoiceDocument(this.awardMock, this.validAwardAccounts, this.errorMessages, this.accountDetails, locCreationType);
        Assert.assertEquals((Object)CHART_OF_ACCOUNTS_CODE, (Object)this.contractsGrantsInvoiceDocumentMock.getBillByChartOfAccountCode());
        Assert.assertEquals((Object)ORGANIZATION_CODE, (Object)this.contractsGrantsInvoiceDocumentMock.getBilledByOrganizationCode());
    }

    @Test
    public void generateAndSaveContractsAndGrantsInvoiceDocument_ZeroAmountFails() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)KualiDecimal.ZERO);
        String locCreationType = "";
        this.cut.generateAndSaveContractsAndGrantsInvoiceDocument(this.awardMock, this.validAwardAccounts, this.errorMessages, this.accountDetails, locCreationType);
        Assert.assertEquals((long)1L, (long)this.errorMessages.size());
        Assert.assertEquals((Object)"error.invoice.create.document.non.billable", (Object)this.errorMessages.get(0).getErrorKey());
    }

    @Test
    public void generateAndSaveContractsAndGrantsInvoiceDocument_NegativeAmountFails() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(-100.0));
        String locCreationType = "";
        this.cut.generateAndSaveContractsAndGrantsInvoiceDocument(this.awardMock, this.validAwardAccounts, this.errorMessages, this.accountDetails, locCreationType);
        Assert.assertEquals((long)1L, (long)this.errorMessages.size());
        Assert.assertEquals((Object)"error.invoice.create.document.non.billable", (Object)this.errorMessages.get(0).getErrorKey());
    }

    @Test
    public void generateAndSaveContractsAndGrantsInvoiceDocument_PositiveAmountSucceeds() {
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        String locCreationType = "";
        this.cut.generateAndSaveContractsAndGrantsInvoiceDocument(this.awardMock, this.validAwardAccounts, this.errorMessages, this.accountDetails, locCreationType);
        Assert.assertEquals((long)0L, (long)this.errorMessages.size());
    }

    @Test
    public void generateAndSaveContractsAndGrantsInvoiceDocument_ErrorMessageHasCorrectAccountNumber() {
        String accountNumber = "123";
        ContractsAndGrantsBillingAwardAccount awardAccount = (ContractsAndGrantsBillingAwardAccount)Mockito.mock(ContractsAndGrantsBillingAwardAccount.class);
        Mockito.when((Object)awardAccount.getAccountNumber()).thenReturn((Object)accountNumber);
        Mockito.when((Object)awardAccount.getAccount()).thenReturn((Object)AccountFixture.ACTIVE_ACCOUNT.createAccount());
        ArrayList<ContractsAndGrantsBillingAwardAccount> awardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        awardAccounts.add(awardAccount);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getPredeterminedBillingBilledToDateAmount((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getMilestonesBilledToDateAmount((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceAmount()).thenReturn((Object)KualiDecimal.ZERO);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = (InvoiceAccountDetail)Mockito.mock(InvoiceAccountDetail.class);
        invoiceAccountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        String locCreationType = "";
        this.cut.generateAndSaveContractsAndGrantsInvoiceDocument(this.awardMock, awardAccounts, this.errorMessages, this.accountDetails, locCreationType);
        Assert.assertEquals((long)1L, (long)this.errorMessages.size());
        Assert.assertEquals((Object)"error.invoice.create.document.non.billable", (Object)this.errorMessages.get(0).getErrorKey());
        Assert.assertEquals((Object)this.errorMessages.get(0).getMessageParameters()[0], (Object)accountNumber);
    }

    @Test
    public void buildInvoiceBills_NoBills() {
        List invoiceBills = this.cut.buildInvoiceBills(Collections.emptyList());
        Assert.assertEquals((long)0L, (long)invoiceBills.size());
    }

    @Test
    public void buildInvoiceBills_NoUnbilledBills() {
        List<Bill> bills = this.setupBills(null, true, 1000.0);
        List invoiceBills = this.cut.buildInvoiceBills(bills);
        Assert.assertEquals((long)0L, (long)invoiceBills.size());
    }

    @Test
    public void buildInvoiceBills_OneUnbilledBillDueLastMonth() {
        List<Bill> bills = this.setupBills(LocalDate.now().minusMonths(1L), false, 1000.0);
        List invoiceBills = this.cut.buildInvoiceBills(bills);
        Assert.assertEquals((long)1L, (long)invoiceBills.size());
    }

    @Test
    public void buildInvoiceBills_OneUnbilledBillDueNextMonth() {
        List<Bill> bills = this.setupBills(LocalDate.now().plusMonths(1L), false, 1000.0);
        List invoiceBills = this.cut.buildInvoiceBills(bills);
        Assert.assertEquals((long)0L, (long)invoiceBills.size());
    }

    @Test
    public void buildInvoiceBills_OneUnbilledBillDueToday() {
        List<Bill> bills = this.setupBills(LocalDate.now(), false, 1000.0);
        List invoiceBills = this.cut.buildInvoiceBills(bills);
        Assert.assertEquals((long)1L, (long)invoiceBills.size());
    }

    @Test
    public void buildInvoiceBills_OneUnbilledBillDueToday_ZeroDollars() {
        List<Bill> bills = this.setupBills(LocalDate.now(), false, 0.0);
        List invoiceBills = this.cut.buildInvoiceBills(bills);
        Assert.assertEquals((long)0L, (long)invoiceBills.size());
    }

    @Test
    public void buildInvoiceBills_ThreeUnbilledBillsTwoEligible() {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.addAll(this.setupBills(LocalDate.now().minusMonths(1L), false, 1000.0));
        bills.addAll(this.setupBills(LocalDate.now(), false, 1000.0));
        bills.addAll(this.setupBills(LocalDate.now().plusMonths(1L), false, 1000.0));
        List invoiceBills = this.cut.buildInvoiceBills(bills);
        Assert.assertEquals((long)2L, (long)invoiceBills.size());
    }

    private List<Bill> setupBills(LocalDate billDate, boolean hasSecondBillBeenBilled, double secondBillEstimatedAmount) {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        Bill bill = new Bill();
        bill.setBilled(true);
        Bill anotherBill = new Bill();
        anotherBill.setBilled(hasSecondBillBeenBilled);
        if (billDate != null) {
            anotherBill.setBillDate(Date.valueOf(billDate));
        }
        anotherBill.setEstimatedAmount(new KualiDecimal(secondBillEstimatedAmount));
        bills.add(bill);
        bills.add(anotherBill);
        return bills;
    }

    @Test
    public void buildInvoiceMilestones_NoMilestones() {
        List invoiceMilestones = this.cut.buildInvoiceMilestones(Collections.emptyList());
        Assert.assertEquals((long)0L, (long)invoiceMilestones.size());
    }

    @Test
    public void buildInvoiceMilestones_NoUnbilledMilestones() {
        List<Milestone> milestones = this.setupMilestones(null, true, new KualiDecimal(1000.0));
        List invoiceMilestones = this.cut.buildInvoiceMilestones(milestones);
        Assert.assertEquals((long)0L, (long)invoiceMilestones.size());
    }

    @Test
    public void buildInvoiceMilestones_OneUnbilledMilestoneDueLastMonth() {
        List<Milestone> milestones = this.setupMilestones(LocalDate.now().minusMonths(1L), false, new KualiDecimal(1000.0));
        List invoiceMilestones = this.cut.buildInvoiceMilestones(milestones);
        Assert.assertEquals((long)1L, (long)invoiceMilestones.size());
    }

    @Test
    public void buildInvoiceMilestones_OneUnbilledMilestoneDueNextMonth() {
        List<Milestone> milestones = this.setupMilestones(LocalDate.now().plusMonths(1L), false, new KualiDecimal(1000.0));
        List invoiceMilestones = this.cut.buildInvoiceMilestones(milestones);
        Assert.assertEquals((long)0L, (long)invoiceMilestones.size());
    }

    @Test
    public void buildInvoiceMilestones_OneUnbilledMilestoneDueToday() {
        List<Milestone> milestones = this.setupMilestones(LocalDate.now(), false, new KualiDecimal(1000.0));
        List invoiceMilestones = this.cut.buildInvoiceMilestones(milestones);
        Assert.assertEquals((long)1L, (long)invoiceMilestones.size());
    }

    @Test
    public void buildInvoiceMilestones_OneUnbilledMilestoneDueToday_ZeroDollars() {
        List<Milestone> milestones = this.setupMilestones(LocalDate.now(), false, new KualiDecimal(0.0));
        List invoiceMilestones = this.cut.buildInvoiceMilestones(milestones);
        Assert.assertEquals((long)0L, (long)invoiceMilestones.size());
    }

    @Test
    public void buildInvoiceMilestones_ThreeUnbilledMilestonesTwoEligible() {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        milestones.addAll(this.setupMilestones(LocalDate.now().minusMonths(1L), false, new KualiDecimal(1000.0)));
        milestones.addAll(this.setupMilestones(LocalDate.now(), false, new KualiDecimal(1000.0)));
        milestones.addAll(this.setupMilestones(LocalDate.now().plusMonths(1L), false, new KualiDecimal(1000.0)));
        List invoiceMilestones = this.cut.buildInvoiceMilestones(milestones);
        Assert.assertEquals((long)2L, (long)invoiceMilestones.size());
    }

    @Test
    public void buildInvoiceMilestones_NullAmount_IneligibleToBeBilled() {
        List<Milestone> milestones = this.setupMilestones(LocalDate.now().minusMonths(1L), false, null);
        List invoiceMilestones = this.cut.buildInvoiceMilestones(milestones);
        Assert.assertEquals((long)0L, (long)invoiceMilestones.size());
    }

    @Test
    public void validateAward_ExpiredAwardsAllowed() {
        ArrayList errorList = new ArrayList();
        this.cut.validateAward(errorList, this.awardMock, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.BATCH);
        Assert.assertEquals((long)0L, (long)errorList.size());
    }

    private List<Milestone> setupMilestones(LocalDate actualCompletionDate, boolean hasSecondMilestoneBeenBilled, KualiDecimal milestoneAmount) {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        Milestone milestone = new Milestone();
        milestone.setBilled(true);
        Milestone anotherMilestone = new Milestone();
        anotherMilestone.setBilled(hasSecondMilestoneBeenBilled);
        if (actualCompletionDate != null) {
            anotherMilestone.setMilestoneActualCompletionDate(Date.valueOf(actualCompletionDate));
        }
        anotherMilestone.setMilestoneAmount(milestoneAmount);
        milestones.add(milestone);
        milestones.add(anotherMilestone);
        return milestones;
    }

    @Test
    public void calculateTotalExpenditureAmount_WithPreviouslyBilledMilestones() {
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2408", "EMPB", new KualiDecimal(200.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2008", "SAL", new KualiDecimal(250.0), KualiDecimal.ZERO));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail(new KualiDecimal(450.0), KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getMilestonesBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)new KualiDecimal(250.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getPredeterminedBillingBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)KualiDecimal.ZERO);
        KualiDecimal totalExpenditureAmount = this.cut.calculateTotalExpenditureAmount(this.contractsGrantsInvoiceDocumentMock, Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(200.0), (Object)totalExpenditureAmount);
        Assert.assertEquals((Object)new KualiDecimal(2000.0), (Object)invoiceAccountDetail.getTotalBudget());
        Assert.assertEquals((Object)new KualiDecimal(200.0), (Object)invoiceAccountDetail.getInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getCumulativeExpenditures());
        Assert.assertEquals((Object)new KualiDecimal(1550.0), (Object)invoiceAccountDetail.getBudgetRemaining());
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)invoiceAccountDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getTotalAmountBilledToDate());
    }

    private InvoiceDetailAccountObjectCode setupInvoiceDetailAccountObjectCode(String financialObjectCode, String categoryCode, KualiDecimal currentExpenditures, KualiDecimal totalBilled) {
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = new InvoiceDetailAccountObjectCode();
        invoiceDetailAccountObjectCode.setChartOfAccountsCode(PROCESSING_CHART_OF_ACCOUNTS_CODE);
        invoiceDetailAccountObjectCode.setAccountNumber("0211905");
        invoiceDetailAccountObjectCode.setFinancialObjectCode(financialObjectCode);
        invoiceDetailAccountObjectCode.setCategoryCode(categoryCode);
        invoiceDetailAccountObjectCode.setCurrentExpenditures(currentExpenditures);
        invoiceDetailAccountObjectCode.setTotalBilled(totalBilled);
        return invoiceDetailAccountObjectCode;
    }

    private InvoiceAccountDetail setupInvoiceAccountDetail(KualiDecimal cumulativeExpenditures, KualiDecimal totalPreviouslyBilled) {
        InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
        invoiceAccountDetail.setChartOfAccountsCode(PROCESSING_CHART_OF_ACCOUNTS_CODE);
        invoiceAccountDetail.setAccountNumber("0211905");
        invoiceAccountDetail.setCumulativeExpenditures(cumulativeExpenditures);
        invoiceAccountDetail.setTotalBudget(new KualiDecimal(2000.0));
        invoiceAccountDetail.setTotalPreviouslyBilled(totalPreviouslyBilled);
        return invoiceAccountDetail;
    }

    @Test
    public void calculateTotalExpenditureAmount_WithPreviouslyBilledBills() {
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2408", "EMPB", new KualiDecimal(200.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2008", "SAL", new KualiDecimal(250.0), KualiDecimal.ZERO));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail(new KualiDecimal(450.0), KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getMilestonesBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getPredeterminedBillingBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)new KualiDecimal(250.0));
        KualiDecimal totalExpenditureAmount = this.cut.calculateTotalExpenditureAmount(this.contractsGrantsInvoiceDocumentMock, Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(200.0), (Object)totalExpenditureAmount);
        Assert.assertEquals((Object)new KualiDecimal(2000.0), (Object)invoiceAccountDetail.getTotalBudget());
        Assert.assertEquals((Object)new KualiDecimal(200.0), (Object)invoiceAccountDetail.getInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getCumulativeExpenditures());
        Assert.assertEquals((Object)new KualiDecimal(1550.0), (Object)invoiceAccountDetail.getBudgetRemaining());
        Assert.assertEquals((Object)new KualiDecimal(250.0), (Object)invoiceAccountDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getTotalAmountBilledToDate());
    }

    @Test
    public void calculateTotalExpenditureAmount_WithoutPreviouslyBilledMilestonesOrBills() {
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2408", "EMPB", new KualiDecimal(200.0), KualiDecimal.ZERO));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2008", "SAL", new KualiDecimal(250.0), KualiDecimal.ZERO));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail(new KualiDecimal(450.0), KualiDecimal.ZERO);
        invoiceAccountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getMilestonesBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getPredeterminedBillingBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)KualiDecimal.ZERO);
        KualiDecimal totalExpenditureAmount = this.cut.calculateTotalExpenditureAmount(this.contractsGrantsInvoiceDocumentMock, Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)totalExpenditureAmount);
        Assert.assertEquals((Object)new KualiDecimal(2000.0), (Object)invoiceAccountDetail.getTotalBudget());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getCumulativeExpenditures());
        Assert.assertEquals((Object)new KualiDecimal(1550.0), (Object)invoiceAccountDetail.getBudgetRemaining());
        Assert.assertEquals((Object)new KualiDecimal(0.0), (Object)invoiceAccountDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getTotalAmountBilledToDate());
    }

    @Test
    public void calculateTotalExpenditureAmount_WithPreviouslyBilledMonthlyAndMilestones() {
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2408", "EMPB", new KualiDecimal(200.0), new KualiDecimal(200.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2008", "SAL", new KualiDecimal(500.0), new KualiDecimal(250.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("6000", "TRAV", new KualiDecimal(50.0), KualiDecimal.ZERO));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail(new KualiDecimal(750.0), new KualiDecimal(450.0));
        invoiceAccountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getMilestonesBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)new KualiDecimal(250.0));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getPredeterminedBillingBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)KualiDecimal.ZERO);
        KualiDecimal totalExpenditureAmount = this.cut.calculateTotalExpenditureAmount(this.contractsGrantsInvoiceDocumentMock, Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)totalExpenditureAmount);
        Assert.assertEquals((Object)new KualiDecimal(2000.0), (Object)invoiceAccountDetail.getTotalBudget());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)invoiceAccountDetail.getInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(750.0), (Object)invoiceAccountDetail.getCumulativeExpenditures());
        Assert.assertEquals((Object)new KualiDecimal(1250.0), (Object)invoiceAccountDetail.getBudgetRemaining());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)new KualiDecimal(750.0), (Object)invoiceAccountDetail.getTotalAmountBilledToDate());
    }

    @Test
    public void calculateTotalExpenditureAmount_WithPreviouslyBilledMonthlyAndBills() {
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2408", "EMPB", new KualiDecimal(200.0), new KualiDecimal(200.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2008", "SAL", new KualiDecimal(500.0), new KualiDecimal(250.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("6000", "TRAV", new KualiDecimal(50.0), KualiDecimal.ZERO));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail(new KualiDecimal(750.0), new KualiDecimal(450.0));
        invoiceAccountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getMilestonesBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getPredeterminedBillingBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)new KualiDecimal(250.0));
        KualiDecimal totalExpenditureAmount = this.cut.calculateTotalExpenditureAmount(this.contractsGrantsInvoiceDocumentMock, Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)totalExpenditureAmount);
        Assert.assertEquals((Object)new KualiDecimal(2000.0), (Object)invoiceAccountDetail.getTotalBudget());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)invoiceAccountDetail.getInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(750.0), (Object)invoiceAccountDetail.getCumulativeExpenditures());
        Assert.assertEquals((Object)new KualiDecimal(1250.0), (Object)invoiceAccountDetail.getBudgetRemaining());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)new KualiDecimal(750.0), (Object)invoiceAccountDetail.getTotalAmountBilledToDate());
    }

    @Test
    public void calculateTotalExpenditureAmount_WithPreviouslyBilledMonthlyButNoMilestonesOrBills() {
        ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2408", "EMPB", new KualiDecimal(200.0), new KualiDecimal(200.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("2008", "SAL", new KualiDecimal(500.0), new KualiDecimal(250.0)));
        invoiceDetailAccountObjectCodes.add(this.setupInvoiceDetailAccountObjectCode("6000", "TRAV", new KualiDecimal(50.0), KualiDecimal.ZERO));
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceDetailAccountObjectCodes()).thenReturn(invoiceDetailAccountObjectCodes);
        ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
        InvoiceAccountDetail invoiceAccountDetail = this.setupInvoiceAccountDetail(new KualiDecimal(750.0), new KualiDecimal(450.0));
        invoiceAccountDetails.add(invoiceAccountDetail);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getAccountDetails()).thenReturn(invoiceAccountDetails);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getMilestonesBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getPredeterminedBillingBilledToDateAmount(PROPOSAL_NUMBER, PROCESSING_CHART_OF_ACCOUNTS_CODE, "0211905")).thenReturn((Object)KualiDecimal.ZERO);
        KualiDecimal totalExpenditureAmount = this.cut.calculateTotalExpenditureAmount(this.contractsGrantsInvoiceDocumentMock, Collections.emptyList());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)totalExpenditureAmount);
        Assert.assertEquals((Object)new KualiDecimal(2000.0), (Object)invoiceAccountDetail.getTotalBudget());
        Assert.assertEquals((Object)new KualiDecimal(300.0), (Object)invoiceAccountDetail.getInvoiceAmount());
        Assert.assertEquals((Object)new KualiDecimal(750.0), (Object)invoiceAccountDetail.getCumulativeExpenditures());
        Assert.assertEquals((Object)new KualiDecimal(1250.0), (Object)invoiceAccountDetail.getBudgetRemaining());
        Assert.assertEquals((Object)new KualiDecimal(450.0), (Object)invoiceAccountDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)new KualiDecimal(750.0), (Object)invoiceAccountDetail.getTotalAmountBilledToDate());
    }

    @Test
    public void populateInvoiceDetailFromAward_Milestone() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setKualiModuleService(this.kualiModuleSvcMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getAwardBilledToDateAmount(PROPOSAL_NUMBER)).thenReturn((Object)new KualiDecimal(500.0));
        this.cut.populateInvoiceDetailFromAward(invoiceGeneralDetail, this.awardMock);
        Assert.assertEquals((Object)this.agencyNumber, (Object)invoiceGeneralDetail.getAgencyNumber());
        Assert.assertEquals((Object)AWARD_TOTAL_AMOUNT, (Object)invoiceGeneralDetail.getAwardTotal());
        Assert.assertEquals((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode(), (Object)invoiceGeneralDetail.getBillingFrequencyCode());
        Assert.assertEquals((Object)INSTRUMENT_TYPE_CODE, (Object)invoiceGeneralDetail.getInstrumentTypeCode());
        Assert.assertEquals((Object)INSTRUMENT_TYPE_DESCRIPTION, (Object)invoiceGeneralDetail.getInstrumentTypeDescription());
        Assert.assertEquals((Object)AWARD_DATE_RANGE, (Object)invoiceGeneralDetail.getAwardDateRange());
        Assert.assertEquals((Object)new KualiDecimal(500.0), (Object)invoiceGeneralDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)"STD", (Object)invoiceGeneralDetail.getCustomerInvoiceTemplateCode());
        Assert.assertEquals((Object)this.customerNumber, (Object)invoiceGeneralDetail.getCustomerNumber());
        Assert.assertEquals((long)1L, (long)invoiceGeneralDetail.getCustomerAddressIdentifier());
    }

    @Test
    public void populateInvoiceDetailFromAward_PredeterminedBilling() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setKualiModuleService(this.kualiModuleSvcMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getAwardBilledToDateAmount(PROPOSAL_NUMBER)).thenReturn((Object)new KualiDecimal(500.0));
        this.cut.populateInvoiceDetailFromAward(invoiceGeneralDetail, this.awardMock);
        Assert.assertEquals((Object)this.agencyNumber, (Object)invoiceGeneralDetail.getAgencyNumber());
        Assert.assertEquals((Object)AWARD_TOTAL_AMOUNT, (Object)invoiceGeneralDetail.getAwardTotal());
        Assert.assertEquals((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), (Object)invoiceGeneralDetail.getBillingFrequencyCode());
        Assert.assertEquals((Object)INSTRUMENT_TYPE_CODE, (Object)invoiceGeneralDetail.getInstrumentTypeCode());
        Assert.assertEquals((Object)INSTRUMENT_TYPE_DESCRIPTION, (Object)invoiceGeneralDetail.getInstrumentTypeDescription());
        Assert.assertEquals((Object)AWARD_DATE_RANGE, (Object)invoiceGeneralDetail.getAwardDateRange());
        Assert.assertEquals((Object)new KualiDecimal(500.0), (Object)invoiceGeneralDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)"STD", (Object)invoiceGeneralDetail.getCustomerInvoiceTemplateCode());
        Assert.assertEquals((Object)this.customerNumber, (Object)invoiceGeneralDetail.getCustomerNumber());
        Assert.assertEquals((long)1L, (long)invoiceGeneralDetail.getCustomerAddressIdentifier());
    }

    @Test
    public void populateInvoiceDetailFromAward_Monthly() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setKualiModuleService(this.kualiModuleSvcMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentServiceMock.getAwardBilledToDateAmount(PROPOSAL_NUMBER)).thenReturn((Object)new KualiDecimal(500.0));
        this.cut.populateInvoiceDetailFromAward(invoiceGeneralDetail, this.awardMock);
        Assert.assertEquals((Object)this.agencyNumber, (Object)invoiceGeneralDetail.getAgencyNumber());
        Assert.assertEquals((Object)AWARD_TOTAL_AMOUNT, (Object)invoiceGeneralDetail.getAwardTotal());
        Assert.assertEquals((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode(), (Object)invoiceGeneralDetail.getBillingFrequencyCode());
        Assert.assertEquals((Object)INSTRUMENT_TYPE_CODE, (Object)invoiceGeneralDetail.getInstrumentTypeCode());
        Assert.assertEquals((Object)INSTRUMENT_TYPE_DESCRIPTION, (Object)invoiceGeneralDetail.getInstrumentTypeDescription());
        Assert.assertEquals((Object)AWARD_DATE_RANGE, (Object)invoiceGeneralDetail.getAwardDateRange());
        Assert.assertEquals((Object)new KualiDecimal(500.0), (Object)invoiceGeneralDetail.getTotalPreviouslyBilled());
        Assert.assertEquals((Object)"STD", (Object)invoiceGeneralDetail.getCustomerInvoiceTemplateCode());
        Assert.assertEquals((Object)this.customerNumber, (Object)invoiceGeneralDetail.getCustomerNumber());
        Assert.assertEquals((long)1L, (long)invoiceGeneralDetail.getCustomerAddressIdentifier());
    }
}

