/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.integration.ar.AccountsReceivableDunningCampaign;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;

import java.util.ArrayList;
import java.util.List;

/**
 * Business Object for Dunning Campaigns
 */
public class DunningCampaign extends PersistableBusinessObjectBase implements AccountsReceivableDunningCampaign, MutableInactivatable {

    private String campaignID;
    private String campaignDescription;
    private boolean active;

    private List<DunningLetterDistribution> dunningLetterDistributions;

    public DunningCampaign() {
        dunningLetterDistributions = new ArrayList<>();
    }

    @Override
    public String getCampaignID() {
        return campaignID;
    }

    public void setCampaignID(String campaignID) {
        this.campaignID = campaignID;
    }

    @Override
    public String getCampaignDescription() {
        return campaignDescription;
    }

    public void setCampaignDescription(String campaignDescription) {
        this.campaignDescription = campaignDescription;
    }

    @Override
    public boolean isActive() {
        return active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    public List<DunningLetterDistribution> getDunningLetterDistributions() {
        return dunningLetterDistributions;
    }

    public void setDunningLetterDistributions(List<DunningLetterDistribution> dunningLetterDistributions) {
        this.dunningLetterDistributions = dunningLetterDistributions;
    }

}
