/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.core.api.util.type.KualiDecimal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NonAppliedHolding extends PersistableBusinessObjectBase {

    private String referenceFinancialDocumentNumber;
    private KualiDecimal financialDocumentLineAmount = KualiDecimal.ZERO;
    private String customerNumber;
    private Customer customer;
    private KualiDecimal availableUnappliedAmount = KualiDecimal.ZERO;
    private KualiDecimal appliedUnappliedAmount = KualiDecimal.ZERO;
    private Collection<NonInvoicedDistribution> nonInvoicedDistributions;
    private Collection<NonAppliedDistribution> nonAppliedDistributions;
    private FinancialSystemDocumentHeader documentHeader;

    public NonAppliedHolding() {
        nonAppliedDistributions = new ArrayList<>();
    }

    public String getReferenceFinancialDocumentNumber() {
        return referenceFinancialDocumentNumber;
    }

    public void setReferenceFinancialDocumentNumber(String referenceFinancialDocumentNumber) {
        this.referenceFinancialDocumentNumber = referenceFinancialDocumentNumber;
    }

    public KualiDecimal getFinancialDocumentLineAmount() {
        return financialDocumentLineAmount;
    }

    public void setFinancialDocumentLineAmount(KualiDecimal financialDocumentLineAmount) {
        this.financialDocumentLineAmount = financialDocumentLineAmount;
    }

    public String getCustomerNumber() {
        return customerNumber;
    }

    public void setCustomerNumber(String customerNumber) {
        this.customerNumber = customerNumber;
    }

    public Customer getCustomer() {
        return customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    public Collection<NonInvoicedDistribution> getNonInvoicedDistributions() {
        return nonInvoicedDistributions;
    }

    public void setNonInvoicedDistributions(Collection<NonInvoicedDistribution> nonInvoicedDistributions) {
        this.nonInvoicedDistributions = nonInvoicedDistributions;
    }

    public Collection<NonAppliedDistribution> getNonAppliedDistributions() {
        return nonAppliedDistributions;
    }

    public void setNonAppliedDistributions(List<NonAppliedDistribution> nonAppliedDistributions) {
        this.nonAppliedDistributions = nonAppliedDistributions;
    }

    public KualiDecimal getAvailableUnappliedAmount() {
        //  start with the original unapplied amount
        KualiDecimal amount = financialDocumentLineAmount;

        //  subtract any non-invoiced distributions made against it
        for (NonInvoicedDistribution nonInvoicedDistribution : nonInvoicedDistributions) {
            amount = amount.subtract(nonInvoicedDistribution.getFinancialDocumentLineAmount());
        }

        //  subtract any non-applied distributions made against it
        for (NonAppliedDistribution nonAppliedDistribution : nonAppliedDistributions) {
            amount = amount.subtract(nonAppliedDistribution.getFinancialDocumentLineAmount());
        }
        return amount;
    }

    public KualiDecimal getAppliedUnappliedAmount() {
        //  start with zero
        KualiDecimal amount = KualiDecimal.ZERO;

        //  add any non-invoiced distributions made against it
        for (NonInvoicedDistribution nonInvoicedDistribution : nonInvoicedDistributions) {
            amount = amount.add(nonInvoicedDistribution.getFinancialDocumentLineAmount());
        }

        //  add any non-applied distributions made against it
        for (NonAppliedDistribution nonAppliedDistribution : nonAppliedDistributions) {
            amount = amount.add(nonAppliedDistribution.getFinancialDocumentLineAmount());
        }
        return amount;
    }

    public FinancialSystemDocumentHeader getDocumentHeader() {
        return documentHeader;
    }

    public void setDocumentHeader(FinancialSystemDocumentHeader documentHeader) {
        this.documentHeader = documentHeader;
    }

}
