/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.defaultvalue;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.valuefinder.DefaultValueFinder;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.ArParameterConstants;
import org.kuali.kfs.sys.context.SpringContext;

/**
 * This class returns the default value for the invoice template
 */
public class DefaultInvoiceTemplateFinder implements DefaultValueFinder {

    @Override
    public String getDefaultValue() {
        String value = SpringContext.getBean(ParameterService.class)
                .getParameterValueAsString(ArConstants.AR_NAMESPACE_CODE, ArConstants.CUSTOMER_COMPONENT,
                        ArParameterConstants.DEFAULT_INVOICE_TEMPLATE);
        if (StringUtils.isEmpty(value)) {
            return "";
        }
        return value;
    }

}
