/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.options;

import org.kuali.kfs.krad.keyvalues.KeyValuesBase;
import org.kuali.kfs.krad.valuefinder.DefaultValueFinder;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

import java.util.ArrayList;
import java.util.List;

/**
 * An implementation of DefaultValueFinder that allows balance inquiries to choose between consolidated results or detailed results
 */
public class InvoiceReportOptionFinder extends KeyValuesBase implements DefaultValueFinder {

    /**
     * @return a List of key value pairs to allow inquirers to choose between consolidated results or detailed results
     */
    public List<KeyValue> getKeyValues() {
        List<KeyValue> labels = new ArrayList<>();
        labels.add(new ConcreteKeyValue(ArConstants.OUTSTANDING_INVOICES, ArConstants.OUTSTANDING_INVOICES));
        labels.add(new ConcreteKeyValue(ArConstants.PAST_DUE_INVOICES, ArConstants.PAST_DUE_INVOICES));
        return labels;
    }

    /**
     * Gets the default value for this DefaultValueFinder, in this case CONSOLIDATED
     *
     * @return a String with the default value for this DefaultValueFinder
     */
    public String getDefaultValue() {
        return ArConstants.OUTSTANDING_INVOICES;
    }
}
