/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArPropertyConstants;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.MilestoneScheduleMaintenanceService;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Default implementation of the Milestone Schedule maintenance service
 */
public class MilestoneScheduleMaintenanceServiceImpl implements MilestoneScheduleMaintenanceService {

    protected BusinessObjectService businessObjectService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;

    @Override
    public boolean hasMilestoneBeenCopiedToInvoice(String proposalNumber, String milestoneId) {
        Map<String, Object> map = new HashMap<>();
        map.put(ArPropertyConstants.MilestoneFields.MILESTONE_IDENTIFIER, milestoneId);
        Collection<InvoiceMilestone> invoiceMilestones = getBusinessObjectService().findMatching(InvoiceMilestone.class, map);
        // skip ineffective milestones, based on invoice
        Set<String> effectiveDocumentNumbers = new HashSet<>();
        List<InvoiceMilestone> effectiveInvoiceMilestones = new ArrayList<>();
        for (InvoiceMilestone invoiceMilestone : invoiceMilestones) {
            if (effectiveDocumentNumbers.contains(invoiceMilestone.getDocumentNumber())
                    || getContractsGrantsInvoiceDocumentService().isInvoiceDocumentEffective(invoiceMilestone.getDocumentNumber())) {
                effectiveInvoiceMilestones.add(invoiceMilestone);
                effectiveDocumentNumbers.add(invoiceMilestone.getDocumentNumber());
            }
        }

        return CollectionUtils.isNotEmpty(effectiveInvoiceMilestones);
    }

    public BusinessObjectService getBusinessObjectService() {
        return businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }
}
