/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.InputStream;
import java.sql.Date;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.batch.MilestoneScheduleCsvInputFileType;
import org.kuali.kfs.module.ar.batch.vo.MilestoneScheduleCsvHeaders;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class MilestoneScheduleCsvInputFileTypeTest {
    private static final String CSV_SAMPLE_DIRECTORY = "org/kuali/kfs/module/ar/batch/sample/";
    private static final String[] STRING_TO_DATE_FORMATS = new String[]{"MM/dd/yy", "MM/dd/yyyy", "MM-dd-yy", "MM-dd-yyyy", "MMddyy", "yyyy", "yyyy-MM-dd"};
    private MilestoneScheduleCsvInputFileType cut;
    private Milestone milestone;

    MilestoneScheduleCsvInputFileTypeTest() {
    }

    @BeforeEach
    void setUp(@Mock AccountService accountSvcMock) throws Exception {
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.milestone = this.setupMilestone("1", Date.valueOf(LocalDate.now().minusDays(1L)), true, "1", "milestone 1", new KualiDecimal(100.0), Date.valueOf(LocalDate.now()));
        DateTimeServiceImpl dateTimeSvc = new DateTimeServiceImpl();
        ReflectionTestUtils.setField((Object)dateTimeSvc, (String)"stringToDateFormats", (Object)STRING_TO_DATE_FORMATS);
        this.cut = new MilestoneScheduleCsvInputFileType();
        this.cut.setAccountService(accountSvcMock);
        this.cut.setCsvEnumClass(MilestoneScheduleCsvHeaders.class);
        this.cut.setDateTimeService((DateTimeService)dateTimeSvc);
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void convertParsedObjectToVO_MultipleSchedules_MultipleMilestones() {
        Milestone expectedMilestone1 = this.setupMilestone("1", Date.valueOf(LocalDate.now().minusDays(1L)), true, "1", "milestone 1", new KualiDecimal(100.0), Date.valueOf(LocalDate.now()));
        Milestone expectedMilestone2 = this.setupMilestone("1", Date.valueOf(LocalDate.now().plusMonths(1L)), true, "2", "milestone 2", new KualiDecimal(50.0), Date.valueOf(LocalDate.now()));
        Milestone expectedMilestone3 = this.setupMilestone("2", Date.valueOf(LocalDate.now().minusDays(1L)), true, "1", "milestone 1", new KualiDecimal(200.0), Date.valueOf(LocalDate.now()));
        LinkedList<Milestone> expectedMilestones1 = new LinkedList<Milestone>();
        expectedMilestones1.add(expectedMilestone1);
        expectedMilestones1.add(expectedMilestone2);
        LinkedList<Milestone> expectedMilestones2 = new LinkedList<Milestone>();
        expectedMilestones2.add(expectedMilestone3);
        MilestoneSchedule expectedMilestoneSchedule1 = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").addMilestone(expectedMilestone1).addMilestone(expectedMilestone2).build();
        MilestoneSchedule expectedMilestoneSchedule2 = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("2").setChartOfAccountsCode("BL").setAccountNumber("1031400").addMilestone(expectedMilestone3).build();
        LinkedList<MilestoneSchedule> expectedMilestoneSchedules = new LinkedList<MilestoneSchedule>();
        expectedMilestoneSchedules.add(expectedMilestoneSchedule1);
        expectedMilestoneSchedules.add(expectedMilestoneSchedule2);
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(expectedMilestone1));
        parsedContent.add(this.setupContentRow(expectedMilestone2));
        parsedContent.add(this.setupContentRow(expectedMilestone3));
        List actualMilestoneSchedules = (List)this.cut.convertParsedObjectToVO(parsedContent);
        Assertions.assertEquals((Object)actualMilestoneSchedules, expectedMilestoneSchedules);
        MilestoneSchedule actualMilestoneSchedule1 = (MilestoneSchedule)actualMilestoneSchedules.get(actualMilestoneSchedules.indexOf(expectedMilestoneSchedule1));
        MilestoneSchedule actualMilestoneSchedule2 = (MilestoneSchedule)actualMilestoneSchedules.get(actualMilestoneSchedules.indexOf(expectedMilestoneSchedule2));
        List actualMilestoneSchedule1Milestones = actualMilestoneSchedule1.getMilestones();
        Assertions.assertEquals(expectedMilestones1, (Object)actualMilestoneSchedule1Milestones);
        for (Milestone actualMilestone : actualMilestoneSchedule1Milestones) {
            Assertions.assertTrue((boolean)actualMilestone.isNewCollectionRecord());
        }
        List actualMilestoneSchedule2Milestones = actualMilestoneSchedule2.getMilestones();
        Assertions.assertEquals(expectedMilestones2, (Object)actualMilestoneSchedule2Milestones);
        for (Milestone actualMilestone : actualMilestoneSchedule2Milestones) {
            Assertions.assertTrue((boolean)actualMilestone.isNewCollectionRecord());
        }
    }

    private Milestone setupMilestone(String proposalNumber, Date milestoneExpectedCompletionDate, boolean active, String milestoneNumber, String milestoneDescription, KualiDecimal milestoneAmount, Date milestoneActualCompletionDate) {
        return new Milestone.MilestoneBuilder().setProposalNumber(proposalNumber).setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(milestoneExpectedCompletionDate).setActive(active).setMilestoneNumber(milestoneNumber).setMilestoneDescription(milestoneDescription).setMilestoneAmount(milestoneAmount).setMilestoneActualCompletionDate(milestoneActualCompletionDate).build();
    }

    private Map<String, String> setupContentRow(Milestone milestone) {
        LinkedHashMap<String, String> contentRow = new LinkedHashMap<String, String>();
        contentRow.put("proposalNumber", milestone.getProposalNumber());
        contentRow.put("chartOfAccountsCode", milestone.getChartOfAccountsCode());
        contentRow.put("accountNumber", milestone.getAccountNumber());
        contentRow.put("milestoneNumber", milestone.getMilestoneNumber());
        contentRow.put("milestoneDescription", milestone.getMilestoneDescription());
        KualiDecimal milestoneAmount = milestone.getMilestoneAmount();
        if (milestoneAmount == null) {
            contentRow.put("milestoneAmount", "");
        } else {
            contentRow.put("milestoneAmount", milestone.getMilestoneAmount().toString());
        }
        Date milestoneExpectedCompletionDate = milestone.getMilestoneExpectedCompletionDate();
        if (milestoneExpectedCompletionDate == null) {
            contentRow.put("milestoneExpectedCompletionDate", "");
        } else {
            contentRow.put("milestoneExpectedCompletionDate", milestone.getMilestoneExpectedCompletionDate().toString());
        }
        Date milestoneActualCompletionDate = milestone.getMilestoneActualCompletionDate();
        if (milestoneActualCompletionDate == null) {
            contentRow.put("milestoneActualCompletionDate", "");
        } else {
            contentRow.put("milestoneActualCompletionDate", milestone.getMilestoneActualCompletionDate().toString());
        }
        contentRow.put("active", String.valueOf(milestone.isActive()));
        return contentRow;
    }

    @Test
    void convertParsedObjectToVO_InvalidDateFormat_AddsMessageToGlobalErrors() {
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        Map<String, String> contentRow = this.setupContentRow(this.milestone);
        contentRow.put("milestoneExpectedCompletionDate", "10_30_2018");
        parsedContent.add(contentRow);
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Date or date/time string '10_30_2018' could not be converted using any of the accepted formats: MM/dd/yy (error offset=2),MM/dd/yyyy (error offset=2),MM-dd-yy (error offset=2),MM-dd-yyyy (error offset=2),MMddyy (error offset=2),yyyy (error offset=2),yyyy-MM-dd (error offset=2)", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingProposalNumber_AddsMessageToGlobalErrors() {
        this.milestone.setProposalNumber("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Proposal Number is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingChartOfAccountsCode_AddsMessageToGlobalErrors() {
        this.milestone.setChartOfAccountsCode("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Chart of Accounts Code is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingAccountNumber_AddsMessageToGlobalErrors() {
        this.milestone.setAccountNumber("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Account Number is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingMilestoneNumber_AddsMessageToGlobalErrors() {
        this.milestone.setMilestoneNumber("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Milestone Number is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingMilestoneExpectedCompletionDate_AddsMessageToGlobalErrors() {
        this.milestone.setMilestoneExpectedCompletionDate(null);
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.milestone));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Milestone Expected Completion Date is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void parse_incorrectNumberOfHeaders_throwsParseException() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-incorrectNumberOfHeaders.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        Exception e = (Exception)Assertions.assertThrows(ParseException.class, () -> this.cut.parse(fileByteContent));
        Assertions.assertEquals((Object)"CSV Batch Input File contains incorrect number of headers", (Object)e.getMessage());
    }

    @Test
    void parse_incorrectHeaders_throwsParseException() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-incorrectHeaders.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        Exception e = (Exception)Assertions.assertThrows(ParseException.class, () -> this.cut.parse(fileByteContent));
        Assertions.assertEquals((Object)"CSV Batch Input File contains incorrect number of headers", (Object)e.getMessage());
    }

    @Test
    void parse_incorrectHeaderOrder_throwsParseException() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-incorrectHeaderOrder.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        Exception e = (Exception)Assertions.assertThrows(ParseException.class, () -> this.cut.parse(fileByteContent));
        Assertions.assertEquals((Object)"CSV Batch Input File headers are different", (Object)e.getMessage());
    }

    @Test
    void parse_detailLineDoesNotMatchHeaders_throwsParseException() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-invalid-detailLineDoesNotMatchHeaders.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        Exception e = (Exception)Assertions.assertThrows(ParseException.class, () -> this.cut.parse(fileByteContent));
        Assertions.assertEquals((Object)"line 13 layout does not match the header", (Object)e.getMessage());
    }

    @Test
    void parse_validFile() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-valid.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals((int)1, (int)milestoneSchedules.size());
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)milestoneSchedules.get(0);
        Assertions.assertEquals((Object)"80075", (Object)milestoneSchedule.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)milestoneSchedule.getAccountNumber());
        Assertions.assertEquals((int)1, (int)milestoneSchedule.getMilestones().size());
        Milestone milestone = (Milestone)milestoneSchedule.getMilestones().get(0);
        Assertions.assertEquals((Object)"80075", (Object)milestone.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestone.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)milestone.getAccountNumber());
        Assertions.assertEquals((Object)"1", (Object)milestone.getMilestoneNumber());
        Assertions.assertEquals((Object)"milestone 1", (Object)milestone.getMilestoneDescription());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)milestone.getMilestoneAmount());
        Assertions.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)milestone.getMilestoneExpectedCompletionDate());
        Assertions.assertNull((Object)milestone.getMilestoneActualCompletionDate());
        Assertions.assertTrue((boolean)milestone.isActive());
        Assertions.assertTrue((boolean)milestone.isNewCollectionRecord());
    }

    @Test
    void parse_validFile_withoutOptionalFields() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-valid-withoutOptionalFields.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals((int)1, (int)milestoneSchedules.size());
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)milestoneSchedules.get(0);
        Assertions.assertEquals((Object)"80075", (Object)milestoneSchedule.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)milestoneSchedule.getAccountNumber());
        Assertions.assertEquals((int)1, (int)milestoneSchedule.getMilestones().size());
        Milestone milestone = (Milestone)milestoneSchedule.getMilestones().get(0);
        Assertions.assertEquals((Object)"80075", (Object)milestone.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestone.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)milestone.getAccountNumber());
        Assertions.assertEquals((Object)"1", (Object)milestone.getMilestoneNumber());
        Assertions.assertEquals((Object)"", (Object)milestone.getMilestoneDescription());
        Assertions.assertNull((Object)milestone.getMilestoneAmount());
        Assertions.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)milestone.getMilestoneExpectedCompletionDate());
        Assertions.assertNull((Object)milestone.getMilestoneActualCompletionDate());
        Assertions.assertTrue((boolean)milestone.isActive());
        Assertions.assertTrue((boolean)milestone.isNewCollectionRecord());
    }

    @Test
    void parse_validFileWithMultipleActiveFormats() throws Exception {
        Milestone expectedMilestone1 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "1", "milestone 1", new KualiDecimal(100.0), null);
        Milestone expectedMilestone2 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "2", "milestone 2", new KualiDecimal(100.0), null);
        Milestone expectedMilestone3 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "3", "milestone 3", new KualiDecimal(100.0), null);
        Milestone expectedMilestone4 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "4", "milestone 4", new KualiDecimal(100.0), null);
        Milestone expectedMilestone5 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "5", "milestone 5", new KualiDecimal(100.0), null);
        Milestone expectedMilestone6 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "6", "milestone 6", new KualiDecimal(100.0), null);
        Milestone expectedMilestone7 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "7", "milestone 7", new KualiDecimal(100.0), null);
        Milestone expectedMilestone8 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "8", "milestone 8", new KualiDecimal(100.0), null);
        Milestone expectedMilestone9 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "9", "milestone 9", new KualiDecimal(100.0), null);
        Milestone expectedMilestone10 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "10", "milestone 10", new KualiDecimal(100.0), null);
        Milestone expectedMilestone11 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "11", "milestone 11", new KualiDecimal(100.0), null);
        Milestone expectedMilestone12 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "12", "milestone 12", new KualiDecimal(100.0), null);
        Milestone expectedMilestone13 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "13", "milestone 13", new KualiDecimal(100.0), null);
        Milestone expectedMilestone14 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "14", "milestone 14", new KualiDecimal(100.0), null);
        Milestone expectedMilestone15 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "15", "milestone 15", new KualiDecimal(100.0), null);
        Milestone expectedMilestone16 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "16", "milestone 16", new KualiDecimal(100.0), null);
        Milestone expectedMilestone17 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "17", "milestone 17", new KualiDecimal(100.0), null);
        Milestone expectedMilestone18 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "18", "milestone 18", new KualiDecimal(100.0), null);
        Milestone expectedMilestone19 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "19", "milestone 19", new KualiDecimal(100.0), null);
        Milestone expectedMilestone20 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "20", "milestone 20", new KualiDecimal(100.0), null);
        Milestone expectedMilestone21 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "21", "milestone 21", new KualiDecimal(100.0), null);
        Milestone expectedMilestone22 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "22", "milestone 22", new KualiDecimal(100.0), null);
        Milestone expectedMilestone23 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "23", "milestone 23", new KualiDecimal(100.0), null);
        Milestone expectedMilestone24 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "24", "milestone 24", new KualiDecimal(100.0), null);
        Milestone expectedMilestone25 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), false, "25", "milestone 25", new KualiDecimal(100.0), null);
        LinkedList<Milestone> expectedMilestones = new LinkedList<Milestone>();
        expectedMilestones.add(expectedMilestone1);
        expectedMilestones.add(expectedMilestone2);
        expectedMilestones.add(expectedMilestone3);
        expectedMilestones.add(expectedMilestone4);
        expectedMilestones.add(expectedMilestone5);
        expectedMilestones.add(expectedMilestone6);
        expectedMilestones.add(expectedMilestone7);
        expectedMilestones.add(expectedMilestone8);
        expectedMilestones.add(expectedMilestone9);
        expectedMilestones.add(expectedMilestone10);
        expectedMilestones.add(expectedMilestone11);
        expectedMilestones.add(expectedMilestone12);
        expectedMilestones.add(expectedMilestone13);
        expectedMilestones.add(expectedMilestone14);
        expectedMilestones.add(expectedMilestone15);
        expectedMilestones.add(expectedMilestone16);
        expectedMilestones.add(expectedMilestone17);
        expectedMilestones.add(expectedMilestone18);
        expectedMilestones.add(expectedMilestone19);
        expectedMilestones.add(expectedMilestone20);
        expectedMilestones.add(expectedMilestone21);
        expectedMilestones.add(expectedMilestone22);
        expectedMilestones.add(expectedMilestone23);
        expectedMilestones.add(expectedMilestone24);
        expectedMilestones.add(expectedMilestone25);
        MilestoneSchedule expectedMilestoneSchedule = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("80075").setChartOfAccountsCode("BL").setAccountNumber("1031400").addMilestone(expectedMilestone1).addMilestone(expectedMilestone2).addMilestone(expectedMilestone3).addMilestone(expectedMilestone4).addMilestone(expectedMilestone5).addMilestone(expectedMilestone6).addMilestone(expectedMilestone7).addMilestone(expectedMilestone8).addMilestone(expectedMilestone9).addMilestone(expectedMilestone10).addMilestone(expectedMilestone11).addMilestone(expectedMilestone12).addMilestone(expectedMilestone13).addMilestone(expectedMilestone14).addMilestone(expectedMilestone15).addMilestone(expectedMilestone16).addMilestone(expectedMilestone17).addMilestone(expectedMilestone18).addMilestone(expectedMilestone19).addMilestone(expectedMilestone20).addMilestone(expectedMilestone21).addMilestone(expectedMilestone22).addMilestone(expectedMilestone23).addMilestone(expectedMilestone24).addMilestone(expectedMilestone25).build();
        LinkedList<MilestoneSchedule> expectedMilestoneSchedules = new LinkedList<MilestoneSchedule>();
        expectedMilestoneSchedules.add(expectedMilestoneSchedule);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-valid-multipleActiveFormats.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List actualMilestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals(expectedMilestoneSchedules, (Object)actualMilestoneSchedules);
        MilestoneSchedule actualMilestoneSchedule = (MilestoneSchedule)actualMilestoneSchedules.get(actualMilestoneSchedules.indexOf(expectedMilestoneSchedule));
        Assertions.assertEquals((Object)expectedMilestoneSchedule, (Object)actualMilestoneSchedule);
        List actualMilestoneScheduleMilestones = actualMilestoneSchedule.getMilestones();
        Assertions.assertEquals(expectedMilestones, (Object)actualMilestoneScheduleMilestones);
        for (Milestone actualMilestone : actualMilestoneScheduleMilestones) {
            Assertions.assertTrue((boolean)actualMilestone.isNewCollectionRecord());
        }
    }

    @Test
    void parse_missingChartValue_accountsCannotCrossCharts_validFile(@Mock AccountService accountSvcMock, @Mock Account accountMock) throws Exception {
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountSvcMock.getUniqueAccountForAccountNumber("1031400")).thenReturn((Object)accountMock);
        this.cut.setAccountService(accountSvcMock);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-no-chart-value-accounts-cannot-cross-charts-valid.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals((int)1, (int)milestoneSchedules.size());
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)milestoneSchedules.get(0);
        Assertions.assertEquals((Object)"80075", (Object)milestoneSchedule.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)milestoneSchedule.getAccountNumber());
        Assertions.assertEquals((int)1, (int)milestoneSchedule.getMilestones().size());
        Milestone milestone = (Milestone)milestoneSchedule.getMilestones().get(0);
        Assertions.assertEquals((Object)"80075", (Object)milestone.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestone.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)milestone.getAccountNumber());
        Assertions.assertEquals((Object)"1", (Object)milestone.getMilestoneNumber());
        Assertions.assertEquals((Object)"milestone 1", (Object)milestone.getMilestoneDescription());
        Assertions.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)milestone.getMilestoneExpectedCompletionDate());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)milestone.getMilestoneAmount());
        Assertions.assertTrue((boolean)milestone.isActive());
        Assertions.assertTrue((boolean)milestone.isNewCollectionRecord());
    }

    @Test
    void parse_missingChartColumn_accountsCannotCrossCharts_validFile(@Mock AccountService accountSvcMock, @Mock Account accountMock) throws Exception {
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountSvcMock.getUniqueAccountForAccountNumber("1031400")).thenReturn((Object)accountMock);
        this.cut.setAccountService(accountSvcMock);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-no-chart-column-accounts-cannot-cross-charts-valid.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List milestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals((int)1, (int)milestoneSchedules.size());
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)milestoneSchedules.get(0);
        Assertions.assertEquals((Object)"80075", (Object)milestoneSchedule.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestoneSchedule.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)milestoneSchedule.getAccountNumber());
        Assertions.assertEquals((int)1, (int)milestoneSchedule.getMilestones().size());
        Milestone milestone = (Milestone)milestoneSchedule.getMilestones().get(0);
        Assertions.assertEquals((Object)"80075", (Object)milestone.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)milestone.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)milestone.getAccountNumber());
        Assertions.assertEquals((Object)"1", (Object)milestone.getMilestoneNumber());
        Assertions.assertEquals((Object)"milestone 1", (Object)milestone.getMilestoneDescription());
        Assertions.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)milestone.getMilestoneExpectedCompletionDate());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)milestone.getMilestoneAmount());
        Assertions.assertTrue((boolean)milestone.isActive());
        Assertions.assertTrue((boolean)milestone.isNewCollectionRecord());
    }

    @Test
    void parse_validFileWithMultipleDateFormats() throws Exception {
        Milestone expectedMilestone1 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "1", "milestone 1", new KualiDecimal(100.0), null);
        Milestone expectedMilestone2 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "2", "milestone 2", new KualiDecimal(100.0), null);
        Milestone expectedMilestone3 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "3", "milestone 3", new KualiDecimal(100.0), null);
        Milestone expectedMilestone4 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "4", "milestone 4", new KualiDecimal(100.0), null);
        Milestone expectedMilestone5 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "5", "milestone 5", new KualiDecimal(100.0), null);
        Milestone expectedMilestone6 = this.setupMilestone("80075", Date.valueOf("2018-01-01"), true, "6", "milestone 6", new KualiDecimal(100.0), null);
        Milestone expectedMilestone7 = this.setupMilestone("80075", Date.valueOf("2018-10-30"), true, "7", "milestone 7", new KualiDecimal(100.0), null);
        LinkedList<Milestone> expectedMilestones = new LinkedList<Milestone>();
        expectedMilestones.add(expectedMilestone1);
        expectedMilestones.add(expectedMilestone2);
        expectedMilestones.add(expectedMilestone3);
        expectedMilestones.add(expectedMilestone4);
        expectedMilestones.add(expectedMilestone5);
        expectedMilestones.add(expectedMilestone6);
        expectedMilestones.add(expectedMilestone7);
        MilestoneSchedule expectedMilestoneSchedule = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("80075").setChartOfAccountsCode("BL").setAccountNumber("1031400").addMilestone(expectedMilestone1).addMilestone(expectedMilestone2).addMilestone(expectedMilestone3).addMilestone(expectedMilestone4).addMilestone(expectedMilestone5).addMilestone(expectedMilestone6).addMilestone(expectedMilestone7).build();
        LinkedList<MilestoneSchedule> expectedMilestoneSchedules = new LinkedList<MilestoneSchedule>();
        expectedMilestoneSchedules.add(expectedMilestoneSchedule);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/MilestoneScheduleUpload-valid-multipleDateFormats.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List actualMilestoneSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals(expectedMilestoneSchedules, (Object)actualMilestoneSchedules);
        MilestoneSchedule actualMilestoneSchedule = (MilestoneSchedule)actualMilestoneSchedules.get(actualMilestoneSchedules.indexOf(expectedMilestoneSchedule));
        Assertions.assertEquals((Object)expectedMilestoneSchedule, (Object)actualMilestoneSchedule);
        List actualMilestoneScheduleMilestones = actualMilestoneSchedule.getMilestones();
        Assertions.assertEquals(expectedMilestones, (Object)actualMilestoneScheduleMilestones);
        for (Milestone actualMilestone : actualMilestoneScheduleMilestones) {
            Assertions.assertTrue((boolean)actualMilestone.isNewCollectionRecord());
        }
    }
}

