/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.InputStream;
import java.sql.Date;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.batch.PredeterminedBillingScheduleCsvInputFileType;
import org.kuali.kfs.module.ar.batch.vo.PredeterminedBillingScheduleCsvHeaders;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.sys.exception.ParseException;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.test.util.ReflectionTestUtils;

@ExtendWith(value={MockitoExtension.class})
class PredeterminedBillingScheduleCsvInputFileTypeTest {
    private static final String CSV_SAMPLE_DIRECTORY = "org/kuali/kfs/module/ar/batch/sample/";
    private static final String[] STRING_TO_DATE_FORMATS = new String[]{"MM/dd/yy", "MM/dd/yyyy", "MM-dd-yy", "MM-dd-yyyy", "MMddyy", "yyyy", "yyyy-MM-dd"};
    private PredeterminedBillingScheduleCsvInputFileType cut;
    private Bill bill;

    PredeterminedBillingScheduleCsvInputFileTypeTest() {
    }

    @BeforeEach
    void setUp(@Mock AccountService accountSvcMock) throws Exception {
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.bill = this.setupBill("1", true, "1", "bill 1", new KualiDecimal(100.0), Date.valueOf(LocalDate.now()));
        DateTimeServiceImpl dateTimeSvc = new DateTimeServiceImpl();
        ReflectionTestUtils.setField((Object)dateTimeSvc, (String)"stringToDateFormats", (Object)STRING_TO_DATE_FORMATS);
        this.cut = new PredeterminedBillingScheduleCsvInputFileType();
        this.cut.setAccountService(accountSvcMock);
        this.cut.setCsvEnumClass(PredeterminedBillingScheduleCsvHeaders.class);
        this.cut.setDateTimeService((DateTimeService)dateTimeSvc);
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void convertParsedObjectToVO_MultipleSchedules_MultipleBills() {
        Bill expectedBill1 = this.setupBill("1", true, "1", "bill 1", new KualiDecimal(100.0), Date.valueOf(LocalDate.now().minusDays(1L)));
        Bill expectedBill2 = this.setupBill("1", true, "2", "bill 2", new KualiDecimal(50.0), Date.valueOf(LocalDate.now().plusMonths(1L)));
        Bill expectedBill3 = this.setupBill("2", true, "1", "bill 1", new KualiDecimal(200.0), Date.valueOf(LocalDate.now().minusDays(1L)));
        LinkedList<Bill> expectedBills1 = new LinkedList<Bill>();
        expectedBills1.add(expectedBill1);
        expectedBills1.add(expectedBill2);
        LinkedList<Bill> expectedBills2 = new LinkedList<Bill>();
        expectedBills2.add(expectedBill3);
        PredeterminedBillingSchedule expectedPredeterminedBillingSchedule1 = new PredeterminedBillingSchedule.PredeterminedBillingScheduleBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").addBill(expectedBill1).addBill(expectedBill2).build();
        PredeterminedBillingSchedule expectedPredeterminedBillingSchedule2 = new PredeterminedBillingSchedule.PredeterminedBillingScheduleBuilder().setProposalNumber("2").setChartOfAccountsCode("BL").setAccountNumber("1031400").addBill(expectedBill3).build();
        LinkedList<PredeterminedBillingSchedule> expectedPredeterminedBillingSchedules = new LinkedList<PredeterminedBillingSchedule>();
        expectedPredeterminedBillingSchedules.add(expectedPredeterminedBillingSchedule1);
        expectedPredeterminedBillingSchedules.add(expectedPredeterminedBillingSchedule2);
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(expectedBill1));
        parsedContent.add(this.setupContentRow(expectedBill2));
        parsedContent.add(this.setupContentRow(expectedBill3));
        List actualPredeterminedBillingSchedules = (List)this.cut.convertParsedObjectToVO(parsedContent);
        Assertions.assertEquals((Object)actualPredeterminedBillingSchedules, expectedPredeterminedBillingSchedules);
        PredeterminedBillingSchedule actualPredeterminedBillingSchedule1 = (PredeterminedBillingSchedule)actualPredeterminedBillingSchedules.get(actualPredeterminedBillingSchedules.indexOf(expectedPredeterminedBillingSchedule1));
        PredeterminedBillingSchedule actualPredeterminedBillingSchedule2 = (PredeterminedBillingSchedule)actualPredeterminedBillingSchedules.get(actualPredeterminedBillingSchedules.indexOf(expectedPredeterminedBillingSchedule2));
        List actualPredeterminedBillingSchedule1Bills = actualPredeterminedBillingSchedule1.getBills();
        Assertions.assertEquals(expectedBills1, (Object)actualPredeterminedBillingSchedule1Bills);
        for (Bill actualBill : actualPredeterminedBillingSchedule1Bills) {
            Assertions.assertTrue((boolean)actualBill.isNewCollectionRecord());
        }
        List actualPredeterminedBillingSchedule2Bills = actualPredeterminedBillingSchedule2.getBills();
        Assertions.assertEquals(expectedBills2, (Object)actualPredeterminedBillingSchedule2Bills);
        for (Bill actualBill : actualPredeterminedBillingSchedule2Bills) {
            Assertions.assertTrue((boolean)actualBill.isNewCollectionRecord());
        }
    }

    private Bill setupBill(String proposalNumber, boolean active, String billNumber, String billDescription, KualiDecimal estimatedAmount, Date billDate) {
        return new Bill.BillBuilder().setProposalNumber(proposalNumber).setChartOfAccountsCode("BL").setAccountNumber("1031400").setActive(active).setBillNumber(billNumber).setBillDescription(billDescription).setBillDate(billDate).setEstimatedAmount(estimatedAmount).build();
    }

    private Map<String, String> setupContentRow(Bill bill) {
        LinkedHashMap<String, String> contentRow = new LinkedHashMap<String, String>();
        contentRow.put("proposalNumber", bill.getProposalNumber());
        contentRow.put("chartOfAccountsCode", bill.getChartOfAccountsCode());
        contentRow.put("accountNumber", bill.getAccountNumber());
        contentRow.put("billNumber", bill.getBillNumber());
        contentRow.put("billDescription", bill.getBillDescription());
        KualiDecimal estimatedAmount = bill.getEstimatedAmount();
        if (estimatedAmount == null) {
            contentRow.put("estimatedAmount", "");
        } else {
            contentRow.put("estimatedAmount", bill.getEstimatedAmount().toString());
        }
        Date billDate = bill.getBillDate();
        if (billDate == null) {
            contentRow.put("billDate", "");
        } else {
            contentRow.put("billDate", bill.getBillDate().toString());
        }
        contentRow.put("active", String.valueOf(bill.isActive()));
        return contentRow;
    }

    @Test
    void convertParsedObjectToVO_InvalidDateFormat_AddsMessageToGlobalErrors() {
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        Map<String, String> contentRow = this.setupContentRow(this.bill);
        contentRow.put("billDate", "10_30_2018");
        parsedContent.add(contentRow);
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Date or date/time string '10_30_2018' could not be converted using any of the accepted formats: MM/dd/yy (error offset=2),MM/dd/yyyy (error offset=2),MM-dd-yy (error offset=2),MM-dd-yyyy (error offset=2),MMddyy (error offset=2),yyyy (error offset=2),yyyy-MM-dd (error offset=2)", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingProposalNumber_AddsMessageToGlobalErrors() {
        this.bill.setProposalNumber("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.bill));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Proposal Number is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingChartOfAccountsCode_AddsMessageToGlobalErrors() {
        this.bill.setChartOfAccountsCode("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.bill));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Chart of Accounts Code is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingAccountNumber_AddsMessageToGlobalErrors() {
        this.bill.setAccountNumber("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.bill));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Account Number is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingBillNumber_AddsMessageToGlobalErrors() {
        this.bill.setBillNumber("");
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.bill));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Bill Number is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingEstimatedAmount_AddsMessageToGlobalErrors() {
        this.bill.setEstimatedAmount(null);
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.bill));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Estimated Amount is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void convertParsedObjectToVO_MissingBillDate_AddsMessageToGlobalErrors() {
        this.bill.setBillDate(null);
        LinkedList<Map<String, String>> parsedContent = new LinkedList<Map<String, String>>();
        parsedContent.add(this.setupContentRow(this.bill));
        Assertions.assertNull((Object)this.cut.convertParsedObjectToVO(parsedContent));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("GLOBAL_ERRORS");
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.batchUpload.parse", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)1, (int)errorMessage.getMessageParameters().length);
        Assertions.assertEquals((Object)"Bill Date is required.", (Object)errorMessage.getMessageParameters()[0]);
    }

    @Test
    void parse_incorrectNumberOfHeaders_throwsParseException() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/PredeterminedBillingScheduleUpload-incorrectNumberOfHeaders.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        Exception e = (Exception)Assertions.assertThrows(ParseException.class, () -> this.cut.parse(fileByteContent));
        Assertions.assertEquals((Object)"CSV Batch Input File contains incorrect number of headers", (Object)e.getMessage());
    }

    @Test
    void parse_incorrectHeaders_throwsParseException() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/PredeterminedBillingScheduleUpload-incorrectHeaders.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        Exception e = (Exception)Assertions.assertThrows(ParseException.class, () -> this.cut.parse(fileByteContent));
        Assertions.assertEquals((Object)"CSV Batch Input File contains incorrect number of headers", (Object)e.getMessage());
    }

    @Test
    void parse_incorrectHeaderOrder_throwsParseException() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/PredeterminedBillingScheduleUpload-incorrectHeaderOrder.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        Exception e = (Exception)Assertions.assertThrows(ParseException.class, () -> this.cut.parse(fileByteContent));
        Assertions.assertEquals((Object)"CSV Batch Input File headers are different", (Object)e.getMessage());
    }

    @Test
    void parse_detailLineDoesNotMatchHeaders_throwsParseException() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/PredeterminedBillingScheduleUpload-invalid-detailLineDoesNotMatchHeaders.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        Exception e = (Exception)Assertions.assertThrows(ParseException.class, () -> this.cut.parse(fileByteContent));
        Assertions.assertEquals((Object)"line 13 layout does not match the header", (Object)e.getMessage());
    }

    @Test
    void parse_validFile() throws Exception {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/PredeterminedBillingScheduleUpload-valid.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List predeterminedBillingSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals((int)1, (int)predeterminedBillingSchedules.size());
        PredeterminedBillingSchedule predeterminedBillingSchedule = (PredeterminedBillingSchedule)predeterminedBillingSchedules.get(0);
        Assertions.assertEquals((Object)"80078", (Object)predeterminedBillingSchedule.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)predeterminedBillingSchedule.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)predeterminedBillingSchedule.getAccountNumber());
        Assertions.assertEquals((int)1, (int)predeterminedBillingSchedule.getBills().size());
        Bill bill = (Bill)predeterminedBillingSchedule.getBills().get(0);
        Assertions.assertEquals((Object)"80078", (Object)bill.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)bill.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)bill.getAccountNumber());
        Assertions.assertEquals((Object)"1", (Object)bill.getBillNumber());
        Assertions.assertEquals((Object)"bill 1", (Object)bill.getBillDescription());
        Assertions.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)bill.getBillDate());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)bill.getEstimatedAmount());
        Assertions.assertTrue((boolean)bill.isActive());
        Assertions.assertTrue((boolean)bill.isNewCollectionRecord());
    }

    @Test
    void parse_validFileWithMultipleActiveFormats() throws Exception {
        Bill expectedBill1 = this.setupBill("80078", true, "1", "bill 1", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill2 = this.setupBill("80078", true, "2", "bill 2", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill3 = this.setupBill("80078", true, "3", "bill 3", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill4 = this.setupBill("80078", true, "4", "bill 4", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill5 = this.setupBill("80078", true, "5", "bill 5", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill6 = this.setupBill("80078", true, "6", "bill 6", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill7 = this.setupBill("80078", true, "7", "bill 7", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill8 = this.setupBill("80078", true, "8", "bill 8", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill9 = this.setupBill("80078", true, "9", "bill 9", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill10 = this.setupBill("80078", true, "10", "bill 10", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill11 = this.setupBill("80078", true, "11", "bill 11", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill12 = this.setupBill("80078", true, "12", "bill 12", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill13 = this.setupBill("80078", false, "13", "bill 13", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill14 = this.setupBill("80078", false, "14", "bill 14", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill15 = this.setupBill("80078", false, "15", "bill 15", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill16 = this.setupBill("80078", false, "16", "bill 16", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill17 = this.setupBill("80078", false, "17", "bill 17", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill18 = this.setupBill("80078", false, "18", "bill 18", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill19 = this.setupBill("80078", false, "19", "bill 19", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill20 = this.setupBill("80078", false, "20", "bill 20", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill21 = this.setupBill("80078", false, "21", "bill 21", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill22 = this.setupBill("80078", false, "22", "bill 22", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill23 = this.setupBill("80078", false, "23", "bill 23", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill24 = this.setupBill("80078", false, "24", "bill 24", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill25 = this.setupBill("80078", false, "25", "bill 25", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        LinkedList<Bill> expectedBills = new LinkedList<Bill>();
        expectedBills.add(expectedBill1);
        expectedBills.add(expectedBill2);
        expectedBills.add(expectedBill3);
        expectedBills.add(expectedBill4);
        expectedBills.add(expectedBill5);
        expectedBills.add(expectedBill6);
        expectedBills.add(expectedBill7);
        expectedBills.add(expectedBill8);
        expectedBills.add(expectedBill9);
        expectedBills.add(expectedBill10);
        expectedBills.add(expectedBill11);
        expectedBills.add(expectedBill12);
        expectedBills.add(expectedBill13);
        expectedBills.add(expectedBill14);
        expectedBills.add(expectedBill15);
        expectedBills.add(expectedBill16);
        expectedBills.add(expectedBill17);
        expectedBills.add(expectedBill18);
        expectedBills.add(expectedBill19);
        expectedBills.add(expectedBill20);
        expectedBills.add(expectedBill21);
        expectedBills.add(expectedBill22);
        expectedBills.add(expectedBill23);
        expectedBills.add(expectedBill24);
        expectedBills.add(expectedBill25);
        PredeterminedBillingSchedule expectedPredeterminedBillingSchedule = new PredeterminedBillingSchedule.PredeterminedBillingScheduleBuilder().setProposalNumber("80078").setChartOfAccountsCode("BL").setAccountNumber("1031400").addBill(expectedBill1).addBill(expectedBill2).addBill(expectedBill3).addBill(expectedBill4).addBill(expectedBill5).addBill(expectedBill6).addBill(expectedBill7).addBill(expectedBill8).addBill(expectedBill9).addBill(expectedBill10).addBill(expectedBill11).addBill(expectedBill12).addBill(expectedBill13).addBill(expectedBill14).addBill(expectedBill15).addBill(expectedBill16).addBill(expectedBill17).addBill(expectedBill18).addBill(expectedBill19).addBill(expectedBill20).addBill(expectedBill21).addBill(expectedBill22).addBill(expectedBill23).addBill(expectedBill24).addBill(expectedBill25).build();
        LinkedList<PredeterminedBillingSchedule> expectedPredeterminedBillingSchedules = new LinkedList<PredeterminedBillingSchedule>();
        expectedPredeterminedBillingSchedules.add(expectedPredeterminedBillingSchedule);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/PredeterminedBillingScheduleUpload-valid-multipleActiveFormats.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List actualPredeterminedBillingSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals(expectedPredeterminedBillingSchedules, (Object)actualPredeterminedBillingSchedules);
        PredeterminedBillingSchedule actualPredeterminedBillingSchedule = (PredeterminedBillingSchedule)actualPredeterminedBillingSchedules.get(actualPredeterminedBillingSchedules.indexOf(expectedPredeterminedBillingSchedule));
        Assertions.assertEquals((Object)expectedPredeterminedBillingSchedule, (Object)actualPredeterminedBillingSchedule);
        List actualPredeterminedBillingScheduleBills = actualPredeterminedBillingSchedule.getBills();
        Assertions.assertEquals(expectedBills, (Object)actualPredeterminedBillingScheduleBills);
        for (Bill actualBill : actualPredeterminedBillingScheduleBills) {
            Assertions.assertTrue((boolean)actualBill.isNewCollectionRecord());
        }
    }

    @Test
    void parse_missingChartValue_accountsCannotCrossCharts_validFile(@Mock AccountService accountSvcMock, @Mock Account accountMock) throws Exception {
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountSvcMock.getUniqueAccountForAccountNumber("1031400")).thenReturn((Object)accountMock);
        this.cut.setAccountService(accountSvcMock);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/PredeterminedBillingScheduleUpload-no-chart-value-accounts-cannot-cross-charts-valid.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List predeterminedBillingSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals((int)1, (int)predeterminedBillingSchedules.size());
        PredeterminedBillingSchedule predeterminedBillingSchedule = (PredeterminedBillingSchedule)predeterminedBillingSchedules.get(0);
        Assertions.assertEquals((Object)"80078", (Object)predeterminedBillingSchedule.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)predeterminedBillingSchedule.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)predeterminedBillingSchedule.getAccountNumber());
        Assertions.assertEquals((int)1, (int)predeterminedBillingSchedule.getBills().size());
        Bill bill = (Bill)predeterminedBillingSchedule.getBills().get(0);
        Assertions.assertEquals((Object)"80078", (Object)bill.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)bill.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)bill.getAccountNumber());
        Assertions.assertEquals((Object)"1", (Object)bill.getBillNumber());
        Assertions.assertEquals((Object)"bill 1", (Object)bill.getBillDescription());
        Assertions.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)bill.getBillDate());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)bill.getEstimatedAmount());
        Assertions.assertTrue((boolean)bill.isActive());
        Assertions.assertTrue((boolean)bill.isNewCollectionRecord());
    }

    @Test
    void parse_missingChartColumn_accountsCannotCrossCharts_validFile(@Mock AccountService accountSvcMock, @Mock Account accountMock) throws Exception {
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountSvcMock.getUniqueAccountForAccountNumber("1031400")).thenReturn((Object)accountMock);
        this.cut.setAccountService(accountSvcMock);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/PredeterminedBillingScheduleUpload-no-chart-column-accounts-cannot-cross-charts-valid.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List predeterminedBillingSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals((int)1, (int)predeterminedBillingSchedules.size());
        PredeterminedBillingSchedule predeterminedBillingSchedule = (PredeterminedBillingSchedule)predeterminedBillingSchedules.get(0);
        Assertions.assertEquals((Object)"80078", (Object)predeterminedBillingSchedule.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)predeterminedBillingSchedule.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)predeterminedBillingSchedule.getAccountNumber());
        Assertions.assertEquals((int)1, (int)predeterminedBillingSchedule.getBills().size());
        Bill bill = (Bill)predeterminedBillingSchedule.getBills().get(0);
        Assertions.assertEquals((Object)"80078", (Object)bill.getProposalNumber());
        Assertions.assertEquals((Object)"BL", (Object)bill.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"1031400", (Object)bill.getAccountNumber());
        Assertions.assertEquals((Object)"1", (Object)bill.getBillNumber());
        Assertions.assertEquals((Object)"bill 1", (Object)bill.getBillDescription());
        Assertions.assertEquals((Object)Date.valueOf("2018-10-30"), (Object)bill.getBillDate());
        Assertions.assertEquals((Object)new KualiDecimal(100.0), (Object)bill.getEstimatedAmount());
        Assertions.assertTrue((boolean)bill.isActive());
        Assertions.assertTrue((boolean)bill.isNewCollectionRecord());
    }

    @Test
    void parse_validFileWithMultipleDateFormats() throws Exception {
        Bill expectedBill1 = this.setupBill("80078", true, "1", "bill 1", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill2 = this.setupBill("80078", true, "2", "bill 2", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill3 = this.setupBill("80078", true, "3", "bill 3", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill4 = this.setupBill("80078", true, "4", "bill 4", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill5 = this.setupBill("80078", true, "5", "bill 5", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        Bill expectedBill6 = this.setupBill("80078", true, "6", "bill 6", new KualiDecimal(100.0), Date.valueOf("2018-01-01"));
        Bill expectedBill7 = this.setupBill("80078", true, "7", "bill 7", new KualiDecimal(100.0), Date.valueOf("2018-10-30"));
        LinkedList<Bill> expectedBills = new LinkedList<Bill>();
        expectedBills.add(expectedBill1);
        expectedBills.add(expectedBill2);
        expectedBills.add(expectedBill3);
        expectedBills.add(expectedBill4);
        expectedBills.add(expectedBill5);
        expectedBills.add(expectedBill6);
        expectedBills.add(expectedBill7);
        PredeterminedBillingSchedule expectedPredeterminedBillingSchedule = new PredeterminedBillingSchedule.PredeterminedBillingScheduleBuilder().setProposalNumber("80078").setChartOfAccountsCode("BL").setAccountNumber("1031400").addBill(expectedBill1).addBill(expectedBill2).addBill(expectedBill3).addBill(expectedBill4).addBill(expectedBill5).addBill(expectedBill6).addBill(expectedBill7).build();
        LinkedList<PredeterminedBillingSchedule> expectedPredeterminedBillingSchedules = new LinkedList<PredeterminedBillingSchedule>();
        expectedPredeterminedBillingSchedules.add(expectedPredeterminedBillingSchedule);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("org/kuali/kfs/module/ar/batch/sample/PredeterminedBillingScheduleUpload-valid-multipleDateFormats.csv");
        Assertions.assertNotNull((Object)inputStream);
        byte[] fileByteContent = IOUtils.toByteArray((InputStream)inputStream);
        List actualPredeterminedBillingSchedules = (List)this.cut.parse(fileByteContent);
        Assertions.assertEquals(expectedPredeterminedBillingSchedules, (Object)actualPredeterminedBillingSchedules);
        PredeterminedBillingSchedule actualPredeterminedBillingSchedule = (PredeterminedBillingSchedule)actualPredeterminedBillingSchedules.get(actualPredeterminedBillingSchedules.indexOf(expectedPredeterminedBillingSchedule));
        Assertions.assertEquals((Object)expectedPredeterminedBillingSchedule, (Object)actualPredeterminedBillingSchedule);
        List actualPredeterminedBillingScheduleBills = actualPredeterminedBillingSchedule.getBills();
        Assertions.assertEquals(expectedBills, (Object)actualPredeterminedBillingScheduleBills);
        for (Bill actualBill : actualPredeterminedBillingScheduleBills) {
            Assertions.assertTrue((boolean)actualBill.isNewCollectionRecord());
        }
    }
}

