/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.module.ar.batch.service.CustomerInvoiceWriteoffBatchService;
import org.kuali.kfs.module.ar.batch.vo.CustomerInvoiceWriteoffBatchVO;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

@ConfigureContext
public class CustomerInvoiceWriteoffBatchServiceIntegTest
extends KualiIntegTestBase {
    private static final String EXPECTED_RESULT = "<?xml version='1.0' encoding='UTF-8'?><invoiceWriteoffBatch xmlns=\"http://www.kuali.org/kfs/ar/customerInvoiceWriteoffBatch\"><submittedByPrincipalId>kfs</submittedByPrincipalId><submittedOn>2018-03-07 16:05:59.348</submittedOn><note>This is the user note added with the batch documents.</note><invoiceNumbers><invoiceNumber>2222222</invoiceNumber><invoiceNumber>3333333</invoiceNumber><invoiceNumber>1111111</invoiceNumber></invoiceNumbers></invoiceWriteoffBatch>";
    private PersonService personService;
    private CustomerInvoiceWriteoffBatchService batchService;

    public void setUp() throws Exception {
        super.setUp();
        this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        this.batchService = (CustomerInvoiceWriteoffBatchService)SpringContext.getBean(CustomerInvoiceWriteoffBatchService.class);
    }

    public void testFilesDropCorrectly() throws IOException {
        String readLine;
        Person person = this.personService.getPersonByPrincipalName("kfs");
        CustomerInvoiceWriteoffBatchVO batchVO = this.createBatchVO(person);
        batchVO.setSubmittedOn("2018-03-07 16:05:59.348");
        batchVO.setNote("This is the user note added with the batch documents.");
        batchVO.addInvoiceNumber("1111111");
        batchVO.addInvoiceNumber("2222222");
        batchVO.addInvoiceNumber("3333333");
        String batchXmlFileName = this.batchService.createBatchDrop(person, batchVO);
        CustomerInvoiceWriteoffBatchServiceIntegTest.assertTrue((String)"Returned xml file name should not be blank.", (boolean)StringUtils.isNotBlank((CharSequence)batchXmlFileName));
        File batchXML = new File(batchXmlFileName);
        CustomerInvoiceWriteoffBatchServiceIntegTest.assertTrue((String)"Batch XML file should be present in the file system.", (boolean)batchXML.exists());
        CustomerInvoiceWriteoffBatchServiceIntegTest.assertTrue((String)"Batch XML file should not be zero bytes.", (batchXML.length() > 0L ? 1 : 0) != 0);
        FileInputStream fileInputStream = new FileInputStream(batchXML);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8));
        StringBuilder batchXmlStringBuilder = new StringBuilder();
        while ((readLine = bufferedReader.readLine()) != null) {
            batchXmlStringBuilder.append(readLine);
        }
        CustomerInvoiceWriteoffBatchServiceIntegTest.assertEquals((String)("Contents of Batch XML file " + batchXmlFileName + " should match the expected result."), (String)EXPECTED_RESULT, (String)batchXmlStringBuilder.toString());
    }

    private CustomerInvoiceWriteoffBatchVO createBatchVO(Person person) {
        return new CustomerInvoiceWriteoffBatchVO(person.getPrincipalName());
    }
}

