/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.vo;

import java.util.ArrayList;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddressEmail;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.module.ar.batch.report.CustomerLoadBatchErrors;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterAdapter;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerLoadVOGenerator;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.impl.datetime.DateTimeServiceImpl;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerDigesterAdapterTest {
    private CustomerDigesterAdapter cut;

    CustomerDigesterAdapterTest() {
    }

    @BeforeEach
    void setUp(@Mock MaintenanceDocumentDictionaryService maintenanceDocumentDictionaryServiceMock, @Mock SequenceAccessorService sequenceAccessorServiceMock) {
        this.cut = new CustomerDigesterAdapter();
        this.cut.setDateTimeService((DateTimeService)new DateTimeServiceImpl());
        this.cut.setMaintDocDDService(maintenanceDocumentDictionaryServiceMock);
        this.cut.setSequenceAccessorService(sequenceAccessorServiceMock);
    }

    @Test
    void convert_ValidBatchFile() {
        ArrayList<Map<String, String>> addresses = new ArrayList<Map<String, String>>();
        addresses.add(CustomerLoadVOGenerator.getValidAddressVO1());
        CustomerDigesterVO customerVO = CustomerLoadVOGenerator.generateCustomerVO(CustomerLoadVOGenerator.getValidCustomerVO1(), addresses);
        CustomerLoadBatchErrors batchErrors = new CustomerLoadBatchErrors();
        Customer customer = this.cut.convert(customerVO, batchErrors);
        Assertions.assertTrue((boolean)batchErrors.isEmpty(), (String)"No errors should have occurred on conversion from VO to BO.");
        Assertions.assertNotNull((Object)customer, (String)"Customer object should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerName(), (String)"Customer name should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerParentCompanyNumber(), (String)"Parent Company Number should be null.");
        Assertions.assertNotNull((Object)customer.getCustomerTypeCode(), (String)"Customer Type Code should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerLastActivityDate(), (String)"Customer Last Activity Date should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerTaxTypeCode(), (String)"Customer Tax Type Code should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerTaxNbr(), (String)"Customer Tax Number should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerPhoneNumber(), (String)"Customer Phone Number should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomer800PhoneNumber(), (String)"Customer 800 Phone Number should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerContactName(), (String)"Customer Contact Name should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerContactPhoneNumber(), (String)"Customer Contact Phone Number should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerFaxNumber(), (String)"Customer Fax Number should not be null.");
        Assertions.assertNull((Object)customer.getCustomerBirthDate(), (String)"Customer Birth Date should be null.");
        Assertions.assertNull((Object)customer.getCustomerCreditLimitAmount(), (String)"Customer Credit Limit Amount should be null.");
        Assertions.assertNotNull((Object)customer.getCustomerCreditApprovedByName(), (String)"Customer Credit Approved By Name should not be null.");
        Assertions.assertNotNull((Object)customer.getCustomerEmailAddress(), (String)"Customer Email Address should not be null.");
        CustomerAddress address = (CustomerAddress)customer.getCustomerAddresses().get(0);
        Assertions.assertNotNull((Object)address, (String)"The first address should not be null.");
        Assertions.assertNotNull((Object)address.getCustomerAddressName(), (String)"Customer Address Name should not be null.");
        Assertions.assertNotNull((Object)address.getCustomerLine1StreetAddress(), (String)"Customer Line1 Street Address should not be null.");
        Assertions.assertNotNull((Object)address.getCustomerLine2StreetAddress(), (String)"Customer Line2 Street Address should not be null.");
        Assertions.assertNotNull((Object)address.getCustomerCityName(), (String)"Customer City Name should not be null.");
        Assertions.assertNotNull((Object)address.getCustomerStateCode(), (String)"Customer State Code should not be null.");
        Assertions.assertNotNull((Object)address.getCustomerZipCode(), (String)"Customer Zip Code should not be null.");
        Assertions.assertNotNull((Object)address.getCustomerCountryCode(), (String)"Customer Country Code should not be null.");
        Assertions.assertNotNull((Object)address.getCustomerAddressInternationalProvinceName(), (String)"Customer Address International Province Name should be null.");
        Assertions.assertEquals((Object)"", (Object)address.getCustomerAddressInternationalProvinceName(), (String)"Customer Address International Province Name should be empty string.");
        Assertions.assertNotNull((Object)address.getCustomerInternationalMailCode(), (String)"Customer International Mail Code should be null.");
        Assertions.assertEquals((Object)"", (Object)address.getCustomerInternationalMailCode(), (String)"Customer International Mail Code should be empty string.");
        Assertions.assertNotEquals((int)0, (int)address.getCustomerAddressEmails().size(), (String)"Customer should have at least one customer address email.");
        for (AccountsReceivableCustomerAddressEmail customerAddressEmail : address.getCustomerAddressEmails()) {
            if (!customerAddressEmail.isActive()) continue;
            Assertions.assertNotNull((Object)customerAddressEmail.getCustomerEmailAddress(), (String)"Customer Email Address should not be null.");
        }
        Assertions.assertNotNull((Object)address.getCustomerAddressTypeCode(), (String)"Customer Address Type Code should not be null.");
        Assertions.assertNotNull((Object)address.getCustomerAddressEndDate(), (String)"Customer Address End Date should not be null.");
    }

    @Test
    void convert_InvalidDates() {
        ArrayList<Map<String, String>> addresses = new ArrayList<Map<String, String>>();
        addresses.add(CustomerLoadVOGenerator.getBadAddressVO_InvalidDates_01());
        CustomerDigesterVO customerVO = CustomerLoadVOGenerator.generateCustomerVO(CustomerLoadVOGenerator.getBadCustomerVO_InvalidDates_01(), addresses);
        CustomerLoadBatchErrors batchErrors = new CustomerLoadBatchErrors();
        Customer customer = this.cut.convert(customerVO, batchErrors);
        Assertions.assertNotNull((Object)customer, (String)"Customer object should not be null.");
        Assertions.assertFalse((boolean)batchErrors.isEmpty(), (String)"Batch Errors should not be empty.");
        Assertions.assertEquals((int)1, (int)batchErrors.getCompaniesWithErrors(), (String)"Should be one companyName with errors.");
        Assertions.assertEquals((int)2, (int)batchErrors.getTotalErrors(), (String)"Should be two errors total.");
        Assertions.assertNull((Object)customer.getCustomerBirthDate(), (String)"The failed customer birthDate should be null.");
        Assertions.assertNull((Object)((CustomerAddress)customer.getCustomerAddresses().get(0)).getCustomerAddressEndDate(), (String)"The address should have a null end-date.");
    }
}

