/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResultAward;

class ContractsGrantsInvoiceLookupResultAwardTest {
    private ContractsGrantsInvoiceLookupResultAward cut;

    ContractsGrantsInvoiceLookupResultAwardTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new ContractsGrantsInvoiceLookupResultAward();
        this.cut.setProposalNumber("1");
        this.cut.setChartOfAccountsCode("BL");
        this.cut.setAccountNumber("1234567");
    }

    @Test
    void getObjectIdMilestone() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertEquals((Object)"1-BL-1234567", (Object)this.cut.getObjectId());
    }

    @Test
    void getObjectIdPredeterminedBilling() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assertions.assertEquals((Object)"1-BL-1234567", (Object)this.cut.getObjectId());
    }

    @Test
    void getObjectIdMonthly() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Assertions.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }

    @Test
    void getObjectIdQuarterly() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.QUARTERLY.getCode());
        Assertions.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }

    @Test
    void getObjectIdSemiAnnually() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.SEMI_ANNUALLY.getCode());
        Assertions.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }

    @Test
    void getObjectIdAnnually() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.ANNUALLY.getCode());
        Assertions.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }

    @Test
    void getObjectIdLetterOfCredit() {
        this.cut.setBillingFrequencyCode(ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Assertions.assertEquals((Object)"1-*-*", (Object)this.cut.getObjectId());
    }
}

