/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.TransmissionDetailStatus;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class InvoiceAddressDetailTest {
    @Mock
    private Person personMock;
    @Spy
    private InvoiceAddressDetail cutSpy;

    InvoiceAddressDetailTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)this.personMock);
        ((InvoiceAddressDetail)Mockito.doReturn((Object)userSessionMock).when((Object)this.cutSpy)).getUserSession();
    }

    @Test
    void markSent_noPreviousValues() {
        this.cutSpy.markSent();
        Date today = Date.valueOf(LocalDate.now());
        Assertions.assertEquals((Object)today, (Object)this.cutSpy.getInitialTransmissionDate());
        Assertions.assertEquals((Object)"khuntley", (Object)this.cutSpy.getTransmittedByPrincipalId());
        Assertions.assertEquals((Object)today, (Object)this.cutSpy.getTransmissionDate());
        Assertions.assertEquals((Object)TransmissionDetailStatus.Sent.getCode(), (Object)this.cutSpy.getTransmissionStatusCode());
        Assertions.assertEquals((int)1, (int)this.cutSpy.getTransmissionCount());
    }

    @Test
    void markSent_previousValues_initialDateUnchanged() {
        Date yesterday = Date.valueOf(LocalDate.now().minusDays(1L));
        this.cutSpy.setInitialTransmissionDate(yesterday);
        this.cutSpy.setTransmittedByPrincipalId("ahlers");
        this.cutSpy.setTransmissionDate(yesterday);
        this.cutSpy.setTransmissionStatusCode(TransmissionDetailStatus.Queued.getCode());
        this.cutSpy.setTransmissionCount(1);
        this.cutSpy.markSent();
        Date today = Date.valueOf(LocalDate.now());
        Assertions.assertEquals((Object)yesterday, (Object)this.cutSpy.getInitialTransmissionDate());
        Assertions.assertEquals((Object)"khuntley", (Object)this.cutSpy.getTransmittedByPrincipalId());
        Assertions.assertEquals((Object)today, (Object)this.cutSpy.getTransmissionDate());
        Assertions.assertEquals((Object)TransmissionDetailStatus.Sent.getCode(), (Object)this.cutSpy.getTransmissionStatusCode());
        Assertions.assertEquals((int)2, (int)this.cutSpy.getTransmissionCount());
    }
}

