/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.time.LocalDate;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.rice.core.api.util.type.KualiDecimal;

class MilestoneScheduleBuilderTest {
    private MilestoneSchedule.MilestoneScheduleBuilder cut;

    MilestoneScheduleBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400");
    }

    @Test
    void milestoneScheduleBuilder_build_withoutMilestones_valid() {
        MilestoneSchedule milestoneSchedule = this.cut.build();
        Assertions.assertNotNull((Object)milestoneSchedule);
    }

    @Test
    void milestoneScheduleBuilder_build_withOneMilestone_valid() {
        Milestone milestone = new Milestone.MilestoneBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(Date.valueOf(LocalDate.now().minusDays(1L))).setActive(true).setMilestoneNumber("1").setMilestoneAmount(new KualiDecimal(100.0)).build();
        this.cut.addMilestone(milestone);
        MilestoneSchedule milestoneSchedule = this.cut.build();
        Assertions.assertNotNull((Object)milestoneSchedule);
    }

    @Test
    void milestoneScheduleBuilder_build_withMultipleMilestone_valid() {
        Milestone milestone1 = new Milestone.MilestoneBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(Date.valueOf(LocalDate.now().minusDays(1L))).setActive(true).setMilestoneNumber("1").setMilestoneAmount(new KualiDecimal(100.0)).build();
        Milestone milestone2 = new Milestone.MilestoneBuilder().setProposalNumber("1").setChartOfAccountsCode("BL").setAccountNumber("1031400").setMilestoneExpectedCompletionDate(Date.valueOf(LocalDate.now().minusDays(1L))).setActive(true).setMilestoneNumber("2").setMilestoneAmount(new KualiDecimal(200.0)).build();
        this.cut.addMilestone(milestone1).addMilestone(milestone2);
        MilestoneSchedule milestoneSchedule = this.cut.build();
        Assertions.assertNotNull((Object)milestoneSchedule);
    }

    @Test
    void milestoneScheduleBuilder_build_MissingProposalNumber_validateThrowsException() {
        this.cut.setProposalNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Proposal Number is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneScheduleBuilder_build_MissingChartOfAccountsCode_validateThrowsException() {
        this.cut.setChartOfAccountsCode("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Chart of Accounts Code is required.", (Object)e.getMessage());
    }

    @Test
    void milestoneScheduleBuilder_build_MissingAccountNumber_validateThrowsException() {
        this.cut.setAccountNumber("");
        Exception e = (Exception)Assertions.assertThrows(IllegalStateException.class, () -> this.cut.build());
        Assertions.assertEquals((Object)"Account Number is required.", (Object)e.getMessage());
    }
}

