/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.admin;

import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.datadictionary.legacy.DocumentDictionaryService;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.module.ar.businessobject.InvoiceTemplate;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.admin.InvoiceTemplateAdminService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class InvoiceTemplateAdminServiceTest {
    private InvoiceTemplateAdminService cut = new InvoiceTemplateAdminService();
    private InvoiceTemplate invoiceTemplate;
    private Map<String, String> roleQualifications = new HashMap<String, String>();
    @Mock
    private DocumentDictionaryService documentDictionaryServiceMock;
    @Mock
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock;
    @Mock
    private PermissionService permissionServiceMock;
    @Mock
    private Person personMock;

    InvoiceTemplateAdminServiceTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.cut.setDocumentDictionaryService(this.documentDictionaryServiceMock);
        this.cut.setMaintenanceDocumentDictionaryService(this.maintenanceDocumentDictionarySvcMock);
        this.cut.setPermissionService(this.permissionServiceMock);
        this.setupInvoiceTemplate();
        Mockito.when((Object)this.documentDictionaryServiceMock.getMaintenanceDocumentTypeName(OrganizationOptions.class)).thenReturn((Object)"ITM");
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getDocumentTypeName(this.invoiceTemplate.getClass())).thenReturn((Object)"ITM");
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getAllowsNewOrCopy("ITM")).thenReturn((Object)true);
        Mockito.when((Object)this.personMock.getPrincipalId()).thenReturn((Object)"khuntley");
        try (MockedStatic kradServiceLocatorWebMockedStatic = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            kradServiceLocatorWebMockedStatic.when(KRADServiceLocatorWeb::getKualiModuleService).thenReturn(Mockito.mock(KualiModuleService.class));
            this.roleQualifications = this.cut.buildRoleQualifications((Object)this.invoiceTemplate, this.personMock.getPrincipalId());
        }
    }

    private void setupInvoiceTemplate() {
        this.invoiceTemplate = new InvoiceTemplate();
        this.invoiceTemplate.setBillByChartOfAccountCode("BL");
        this.invoiceTemplate.setBilledByOrganizationCode("PSY");
    }

    @Test
    void allowsCopy_nullBo_returnsFalse() {
        Assertions.assertFalse((boolean)this.cut.allowsCopy(null, this.personMock));
    }

    @Test
    void allowsCopy_nullDocType_returnsFalse() {
        this.isAuthorized();
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getDocumentTypeName(this.invoiceTemplate.getClass())).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    private void isAuthorized() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq(this.roleQualifications))).thenReturn((Object)true);
    }

    @Test
    void allowsCopy_allowsNewOrCopyFalse_returnsFalse() {
        this.isAuthorized();
        Mockito.when((Object)this.maintenanceDocumentDictionarySvcMock.getAllowsNewOrCopy("ITM")).thenReturn((Object)false);
        Assertions.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    @Test
    void allowsCopy_createMaintainPermissionTrue_returnsTrue() {
        this.isAuthorized();
        Assertions.assertTrue((boolean)this.cut.allowsCopy((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    @Test
    void allowsCopy_createMaintainPermissionFalse_returnsFalse() {
        this.defaultAuthorizationToTrue();
        this.isNotAuthorized();
        Assertions.assertFalse((boolean)this.cut.allowsCopy((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    private void defaultAuthorizationToTrue() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), ArgumentMatchers.anyMap())).thenReturn((Object)true);
    }

    private void isNotAuthorized() {
        Mockito.when((Object)this.permissionServiceMock.isAuthorizedByTemplate(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyMap(), (Map)ArgumentMatchers.eq(this.roleQualifications))).thenReturn((Object)false);
    }

    @Test
    void allowsEdit_createMaintainPermissionTrue_returnsTrue() {
        this.isAuthorized();
        Assertions.assertTrue((boolean)this.cut.allowsEdit((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }

    @Test
    void allowsEdit_createMaintainPermissionFalse_returnsFalse() {
        this.defaultAuthorizationToTrue();
        this.isNotAuthorized();
        Assertions.assertFalse((boolean)this.cut.allowsEdit((BusinessObjectBase)this.invoiceTemplate, this.personMock));
    }
}

