/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.legacy.BusinessObjectDictionaryService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.BusinessObjectAuthorizationService;
import org.kuali.kfs.kns.service.BusinessObjectMetaDataService;
import org.kuali.kfs.kns.service.KNSServiceLocator;
import org.kuali.kfs.kns.util.FieldUtils;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.LookupService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CollectionEvent;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.TicklersReport;
import org.kuali.kfs.module.ar.businessobject.lookup.TicklersReportLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsCollectionActivityDocumentService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardAccountMockFixture;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsReportHelperServiceImpl;
import org.kuali.kfs.module.ar.web.struts.TicklersReportLookupForm;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class TicklersReportLookupableHelperServiceImplTest {
    private static final String CHART_OF_ACCOUNTS_CODE = "BL";
    private static final String ORGANIZATION_CODE = "SRS";
    private TicklersReportLookupableHelperServiceImpl cut;
    private TicklersReportLookupForm ticklersReportLookupForm;
    @Mock
    private BusinessObjectAuthorizationService businessObjectAuthorizationSvcMock;
    @Mock
    private BusinessObjectDictionaryService businessObjectDictionarySvcMock;
    @Mock
    private BusinessObjectMetaDataService businessObjectMetaDataSvcMock;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock;
    @Mock
    private ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService;
    @Mock
    private ConfigurationService configurationSvcMock;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private LookupService lookupSvcMock;
    @Mock
    private Person personMock;
    @Mock
    private MaintenanceDocumentDictionaryService maintenanceDocumentDictionarySvcMock;
    private final UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);

    TicklersReportLookupableHelperServiceImplTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Mockito.when((Object)this.userSessionMock.getPerson()).thenReturn((Object)this.personMock);
        Mockito.when((Object)this.configurationSvcMock.getPropertyValueAsString("title.return.url.value.prependtext")).thenReturn((Object)"return value").thenReturn((Object)"with");
        Mockito.when((Object)this.dataDictionarySvcMock.getAttributeLabel(TicklersReport.class, "proposalNumber")).thenReturn((Object)"Proposal Number");
        FieldUtils.setBusinessObjectDictionaryService((BusinessObjectDictionaryService)this.businessObjectDictionarySvcMock);
        BusinessObjectEntry businessObjectEntryMock = (BusinessObjectEntry)Mockito.mock(BusinessObjectEntry.class);
        Mockito.when((Object)businessObjectEntryMock.hasLookupDefinition()).thenReturn((Object)false);
        Mockito.when((Object)this.businessObjectDictionarySvcMock.getBusinessObjectEntry(TicklersReport.class.getName())).thenReturn((Object)businessObjectEntryMock);
        ContractsGrantsReportHelperServiceImpl contractsGrantsReportHelperService = new ContractsGrantsReportHelperServiceImpl();
        contractsGrantsReportHelperService.setConfigurationService(this.configurationSvcMock);
        contractsGrantsReportHelperService.setBusinessObjectDictionaryService(this.businessObjectDictionarySvcMock);
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.isLookupable(TicklersReport.class)).thenReturn((Object)true);
        ArrayList lookupFieldAttributeList = new ArrayList();
        Mockito.when((Object)this.businessObjectMetaDataSvcMock.getLookupableFieldNames(TicklersReport.class)).thenReturn(lookupFieldAttributeList);
        this.cut = new TicklersReportLookupableHelperServiceImpl();
        this.cut.setBusinessObjectAuthorizationService(this.businessObjectAuthorizationSvcMock);
        this.cut.setBusinessObjectDictionaryService(this.businessObjectDictionarySvcMock);
        this.cut.setBusinessObjectMetaDataService(this.businessObjectMetaDataSvcMock);
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setConfigurationService(this.configurationSvcMock);
        this.cut.setContractsGrantsCollectionActivityDocumentService(this.contractsGrantsCollectionActivityDocumentService);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentSvcMock);
        this.cut.setContractsGrantsReportHelperService((ContractsGrantsReportHelperService)contractsGrantsReportHelperService);
        this.cut.setLookupService(this.lookupSvcMock);
        this.cut.setMaintenanceDocumentDictionaryService(this.maintenanceDocumentDictionarySvcMock);
        this.cut.setBusinessObjectClass(TicklersReport.class);
        this.ticklersReportLookupForm = new TicklersReportLookupForm();
        this.ticklersReportLookupForm.setFieldsForLookup(new LinkedHashMap());
        this.setupDocumentAndBusinessObjectMocks();
    }

    @AfterEach
    void cleanUpAfterOurselfSoSubsequentTestsDoNotReuseOurMocking() {
        FieldUtils.setBusinessObjectDictionaryService(null);
    }

    private void setupDocumentAndBusinessObjectMocks() {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_MONTHLY_BILLED_DATE_NULL.createAwardMock();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = ARAwardAccountMockFixture.AWD_ACCT_1.createAwardAccountMock();
        List awardAccountMocks = awardMock.getActiveAwardAccounts();
        awardAccountMocks.add(awardAccountMock);
        Mockito.when((Object)awardMock.getActiveAwardAccounts()).thenReturn((Object)awardAccountMocks);
        ContractsAndGrantsBillingAgency agencyMock = ARAgencyMockFixture.CG_AGENCY1.createAgencyMock();
        Mockito.when((Object)awardMock.getAgency()).thenReturn((Object)agencyMock);
        String agencyNumber = agencyMock.getAgencyNumber();
        Mockito.when((Object)awardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
        OrganizationOptions organizationOptions = new OrganizationOptions();
        organizationOptions.setChartOfAccountsCode(CHART_OF_ACCOUNTS_CODE);
        organizationOptions.setOrganizationCode(ORGANIZATION_CODE);
        organizationOptions.setProcessingChartOfAccountCode(CHART_OF_ACCOUNTS_CODE);
        organizationOptions.setProcessingOrganizationCode(ORGANIZATION_CODE);
        ContractsGrantsInvoiceDocument cgInvoice = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        FinancialSystemDocumentHeader financialSystemDocumentHeader = new FinancialSystemDocumentHeader();
        financialSystemDocumentHeader.setFinancialDocumentStatusCode("A");
        Mockito.when((Object)cgInvoice.getFinancialSystemDocumentHeader()).thenReturn((Object)financialSystemDocumentHeader);
        Mockito.when((Object)cgInvoice.isOpenInvoiceIndicator()).thenReturn((Object)true);
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        InvoiceAddressDetail invoiceAddressDetail = new InvoiceAddressDetail();
        invoiceAddressDetail.setCustomerInvoiceTemplateCode("STD");
        invoiceAddressDetail.setInvoiceTransmissionMethodCode("MAIL");
        invoiceAddressDetails.add(invoiceAddressDetail);
        Mockito.when((Object)cgInvoice.getInvoiceAddressDetails()).thenReturn(invoiceAddressDetails);
        InvoiceGeneralDetail invoiceGeneralDetail = (InvoiceGeneralDetail)Mockito.mock(InvoiceGeneralDetail.class);
        Mockito.when((Object)invoiceGeneralDetail.getProposalNumber()).thenReturn((Object)"1");
        Mockito.when((Object)invoiceGeneralDetail.getAward()).thenReturn((Object)awardMock);
        Mockito.when((Object)cgInvoice.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        Mockito.when((Object)cgInvoice.getSourceTotal()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)cgInvoice.getPaymentAmount()).thenReturn((Object)new KualiDecimal(100.0));
        CollectionEvent event = new CollectionEvent();
        event.setId(Long.valueOf(1L));
        event.setInvoiceNumber(cgInvoice.getDocumentNumber());
        event.setActivityCode("TEST");
        event.setUser(this.personMock);
        HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
        primaryKeys.put("id", 1L);
        Mockito.when((Object)((CollectionEvent)this.businessObjectSvcMock.findByPrimaryKey(CollectionEvent.class, primaryKeys))).thenReturn((Object)event);
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        Date today = new Date(ts.getTime());
        event.setFollowupDate(today);
        event.setInvoiceDocument(cgInvoice);
        event.setInvoiceNumber("1");
        ArrayList<CollectionEvent> collectionEvents = new ArrayList<CollectionEvent>();
        collectionEvents.add(event);
        Mockito.when((Object)cgInvoice.getCollectionEvents()).thenReturn(collectionEvents);
        HashMap<String, String> formProps = new HashMap<String, String>();
        formProps.put("followup", "true");
        Mockito.when((Object)this.lookupSvcMock.findCollectionBySearchUnbounded(CollectionEvent.class, formProps)).thenReturn(collectionEvents);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentSvcMock.canViewInvoice(cgInvoice, null)).thenReturn((Object)true);
    }

    @Test
    void performLookup() {
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);
             MockedStatic knsServiceLocatorMockedStatic = Mockito.mockStatic(KNSServiceLocator.class);){
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            knsServiceLocatorMockedStatic.when(KNSServiceLocator::getDataDictionaryService).thenReturn((Object)this.dataDictionarySvcMock);
            Collection lookupResults = this.cut.performLookup((LookupForm)this.ticklersReportLookupForm, new ArrayList(), true);
            Assertions.assertEquals((int)1, (int)lookupResults.size());
        }
    }

    @Test
    void performLookup_NoEventsFound() {
        try (MockedStatic globalVariablesMockedStatic = Mockito.mockStatic(GlobalVariables.class);){
            globalVariablesMockedStatic.when(GlobalVariables::getUserSession).thenReturn((Object)this.userSessionMock);
            HashMap<String, String> formProps = new HashMap<String, String>();
            formProps.put("followup", "true");
            Mockito.when((Object)this.lookupSvcMock.findCollectionBySearchUnbounded(CollectionEvent.class, formProps)).thenReturn(Collections.emptyList());
            Collection lookupResults = this.cut.performLookup((LookupForm)this.ticklersReportLookupForm, new ArrayList(), true);
            Assertions.assertEquals((int)0, (int)lookupResults.size());
        }
    }
}

