/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ARAwardMockFixture;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class FinalBilledIndicatorDocumentTest {
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentSvcMock;
    @Mock
    private DocumentService documentSvcMock;
    private FinalBilledIndicatorDocument cut;

    FinalBilledIndicatorDocumentTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            Class<FinancialSystemDocumentHeader> documentHeaderBaseClass = FinancialSystemDocumentHeader.class;
            Mockito.when((Object)documentHeaderServiceMock.getDocumentHeaderBaseClass()).thenReturn(documentHeaderBaseClass);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.cut = new FinalBilledIndicatorDocument();
        }
        this.cut.setDocumentService(this.documentSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocumentSvcMock);
    }

    @Test
    void updateContractsGrantsInvoiceDocument() throws WorkflowException {
        ContractsAndGrantsBillingAward awardMock = ARAwardMockFixture.CG_AWARD_INV_ACCOUNT.createAwardMock();
        InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
        invoiceGeneralDetail.setAward(awardMock);
        invoiceGeneralDetail.setFinalBillIndicator(true);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)invoiceGeneralDetail);
        FinalBilledIndicatorEntry entry = new FinalBilledIndicatorEntry();
        entry.setInvoiceDocumentNumber(this.contractsGrantsInvoiceDocumentMock.getDocumentNumber());
        ArrayList<FinalBilledIndicatorEntry> invoiceEntries = new ArrayList<FinalBilledIndicatorEntry>();
        invoiceEntries.add(entry);
        this.cut.setInvoiceEntries(invoiceEntries);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId(entry.getInvoiceDocumentNumber())).thenReturn((Object)this.contractsGrantsInvoiceDocumentMock);
        this.cut.updateContractsGrantsInvoiceDocument();
        Assertions.assertFalse((boolean)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().isFinalBillIndicator());
        ((ContractsGrantsInvoiceDocumentService)Mockito.verify((Object)this.contractsGrantsInvoiceDocumentSvcMock)).updateUnfinalizationToAwardAccount(this.contractsGrantsInvoiceDocumentMock.getAccountDetails(), this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail().getProposalNumber());
    }
}

