/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class PaymentApplicationAdjustmentDocumentTest {
    @Mock
    private DocumentService documentServiceMock;
    private PaymentApplicationAdjustmentDocument cutSpy;

    PaymentApplicationAdjustmentDocumentTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            Class<FinancialSystemDocumentHeader> clazz = FinancialSystemDocumentHeader.class;
            Mockito.when((Object)documentHeaderServiceMock.getDocumentHeaderBaseClass()).thenReturn(clazz);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.cutSpy = (PaymentApplicationAdjustmentDocument)Mockito.spy((Object)new PaymentApplicationAdjustmentDocument());
        }
        ((PaymentApplicationAdjustmentDocument)Mockito.doReturn((Object)this.documentServiceMock).when((Object)this.cutSpy)).getDocumentService();
    }

    @Test
    void setter_illegalArg_null() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setAdjusteeDocumentNumber(null));
    }

    @Test
    void setter_illegalArg_empty() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setAdjusteeDocumentNumber(""));
    }

    @Test
    void setter_illegalArg_blank() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setAdjusteeDocumentNumber("    "));
    }

    @Test
    void setter_validArg() {
        String expected = "ABC123";
        this.cutSpy.setAdjusteeDocumentNumber("ABC123");
        Assertions.assertEquals((Object)"ABC123", (Object)this.cutSpy.getAdjusteeDocumentNumber());
    }

    @Test
    void nonAppliedHoldings_is_not_null_after_construction() {
        List actual = this.cutSpy.getNonAppliedHoldings();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    void nonAppliedHoldings_setter_does_not_allow_null() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setNonAppliedHoldings(null));
    }

    @Test
    void nonAppliedHoldings_setter_overwrites_previous_contents() {
        List<NonAppliedHolding> initial = List.of((NonAppliedHolding)Mockito.mock(NonAppliedHolding.class));
        List secondary = List.of();
        this.cutSpy.setNonAppliedHoldings(initial);
        this.cutSpy.setNonAppliedHoldings(secondary);
        List actual = this.cutSpy.getNonAppliedHoldings();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    void invoicePaidApplieds_is_not_null_after_construction() {
        List actual = this.cutSpy.getInvoicePaidApplieds();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    void invoicePaidApplieds_setter_does_not_allow_null() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.cutSpy.setInvoicePaidApplieds(null));
    }

    @Test
    void invoicePaidApplieds_setter_overwrites_previous_contents() {
        List<InvoicePaidApplied> initial = List.of((InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class));
        List secondary = List.of();
        this.cutSpy.setInvoicePaidApplieds(initial);
        this.cutSpy.setInvoicePaidApplieds(secondary);
        List actual = this.cutSpy.getInvoicePaidApplieds();
        Assertions.assertNotNull((Object)actual);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    void getTotalDollarAmount_() throws Exception {
        KualiDecimal rootAdjusteeTotalFromControl = new KualiDecimal("7");
        KualiDecimal rootAdjusteeNonArTotal = new KualiDecimal("3");
        PaymentApplicationDocument rootAdjusteeDocument = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)rootAdjusteeDocument.getTotalFromControl()).thenReturn((Object)rootAdjusteeTotalFromControl);
        Mockito.when((Object)rootAdjusteeDocument.getNonArTotal()).thenReturn((Object)rootAdjusteeNonArTotal);
        Mockito.when((Object)this.documentServiceMock.getByDocumentHeaderId((String)ArgumentMatchers.any())).thenReturn((Object)rootAdjusteeDocument);
        KualiDecimal actual = this.cutSpy.getTotalDollarAmount();
        KualiDecimal expected = (KualiDecimal)rootAdjusteeTotalFromControl.subtract((AbstractKualiDecimal)rootAdjusteeNonArTotal);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }
}

