/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.Date;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.module.ar.document.authorization.ContractsGrantsInvoiceDocumentPresentationController;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class ContractsGrantsInvoiceDocumentPresentationControllerTest {
    @Spy
    private ContractsGrantsInvoiceDocumentPresentationController cut;
    @Mock
    private UniversityDateService universityDateSvcMock;

    ContractsGrantsInvoiceDocumentPresentationControllerTest() {
    }

    @BeforeEach
    void setUp() {
        UniversityDate universityDate = new UniversityDate();
        universityDate.setUniversityDate(java.sql.Date.valueOf("2014-07-02"));
        Mockito.when((Object)this.universityDateSvcMock.getCurrentUniversityDate()).thenReturn((Object)universityDate);
        Mockito.when((Object)this.universityDateSvcMock.getFiscalYear((Date)ArgumentMatchers.any(Date.class))).thenReturn((Object)2015);
        Mockito.when((Object)this.universityDateSvcMock.getFirstDateOfFiscalYear(Integer.valueOf(ArgumentMatchers.anyInt()))).thenReturn((Object)java.sql.Date.valueOf("2014-07-01"));
        Mockito.when((Object)this.universityDateSvcMock.getLastDateOfFiscalYear(Integer.valueOf(ArgumentMatchers.anyInt()))).thenReturn((Object)java.sql.Date.valueOf("2015-06-30"));
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2015);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
        ((ContractsGrantsInvoiceDocumentPresentationController)Mockito.doReturn((Object)true).when((Object)this.cut)).isDocFinalWithNoAppliedAmountsExceptDiscounts(null);
    }

    @Test
    void cannotCorrectAlreadyCorrectedDocument() {
        this.validateCanErrorCorrect(this.cut, null, "hi there, i am testing", false, false);
    }

    @Test
    void cannotCorrectReversedInvoice() {
        this.validateCanErrorCorrect(this.cut, null, "", true, false);
    }

    @Test
    void cannotCorrectNonFinalDocument() {
        Mockito.when((Object)this.cut.isDocFinalWithNoAppliedAmountsExceptDiscounts(null)).thenReturn((Object)false);
        this.validateCanErrorCorrect(this.cut, null, "", false, false);
    }

    @Test
    void canCorrectFinalDocumentWithAppliedInvoices() {
        this.validateCanErrorCorrect(this.cut, null, "", false, true);
    }

    @Test
    void canCorrectFinalDocumentWithAppliedInvoicesNullDate() {
        this.validateCanErrorCorrect(this.cut, null, "", false, true);
    }

    @Test
    void cannotCorrectPriorYearInvoice() {
        this.validateCanErrorCorrect(this.cut, "2014-06-25", "", false, false);
    }

    @Test
    void canCorrectEarlierPriorYearInvoice() {
        this.validateCanErrorCorrect(this.cut, "2014-07-01", "", false, true);
    }

    private void validateCanErrorCorrect(ContractsGrantsInvoiceDocumentPresentationController presentationController, String dateApprovedString, String correctedByDocumentId, boolean invoiceReversal, boolean expectedResult) {
        FinancialSystemDocumentHeader documentHeader = new FinancialSystemDocumentHeader();
        documentHeader.setCorrectedByDocumentId(correctedByDocumentId);
        DateTime dateApproved = null;
        if (dateApprovedString != null) {
            dateApproved = new DateTime((Object)java.sql.Date.valueOf(dateApprovedString));
        }
        Assertions.assertEquals((Object)expectedResult, (Object)presentationController.canErrorCorrect(null, documentHeader, invoiceReversal, dateApproved), (String)"canErrorCorrect returned unexpected value ");
    }
}

