/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CashControlDocumentService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;

@ConfigureContext(session=UserNameFixture.khuntley)
public class CashControlDocumentServiceIntegTest
extends KualiIntegTestBase {
    private static final Logger LOG = LogManager.getLogger();
    private static final String CUSTOMER_NUMBER = "ABB2";
    private static final KualiDecimal DETAIL_AMOUNT = new KualiDecimal("100.00");
    private static final String PAYMENT_MEDIUM_CODE = "CK";
    private CashControlDocumentService cut;
    private DocumentService documentService;
    private AccountsReceivableDocumentHeaderService arDocHeaderService;
    private DataDictionaryService dataDictionaryService;

    public void setUp() throws Exception {
        super.setUp();
        this.arDocHeaderService = (AccountsReceivableDocumentHeaderService)SpringContext.getBean(AccountsReceivableDocumentHeaderService.class);
        this.cut = (CashControlDocumentService)SpringContext.getBean(CashControlDocumentService.class);
        this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        this.dataDictionaryService = (DataDictionaryService)SpringContext.getBean(DataDictionaryService.class);
    }

    protected void tearDown() throws Exception {
        this.cut = null;
        this.documentService = null;
        super.tearDown();
    }

    public void testCreateAndSavePaymentApplicationDocument() throws WorkflowException {
        CashControlDocument cashControlDocument = this.createCashControlDocumentWithOneDetail();
        PaymentApplicationDocument applicationDocument = this.cut.createAndSavePaymentApplicationDocument("message.ar.createdByCashControlDocument", cashControlDocument, cashControlDocument.getCashControlDetail(0));
        CashControlDocumentServiceIntegTest.assertNotNull((Object)applicationDocument);
        PaymentApplicationDocument applicationDocument2 = (PaymentApplicationDocument)this.documentService.getByDocumentHeaderId(applicationDocument.getDocumentNumber());
        CashControlDocumentServiceIntegTest.assertNotNull((Object)applicationDocument2);
        CashControlDocumentServiceIntegTest.assertEquals((String)"Document status is incorrect", (Object)DocumentStatus.SAVED, (Object)applicationDocument2.getDocumentHeader().getWorkflowDocument().getStatus());
    }

    private CashControlDocument createCashControlDocumentWithOneDetail() {
        AccountsReceivableDocumentHeader arDocHeader;
        CashControlDocument cashControlDocument;
        try {
            cashControlDocument = (CashControlDocument)this.documentService.getNewDocument(this.dataDictionaryService.getDocumentTypeNameByClass(CashControlDocument.class));
        }
        catch (Exception e) {
            LOG.error("A Exception was thrown while trying to initiate a new CashControl document.", (Throwable)e);
            throw new RuntimeException("A Exception was thrown while trying to initiate a new CashControl document.", e);
        }
        cashControlDocument.setCustomerPaymentMediumCode(PAYMENT_MEDIUM_CODE);
        cashControlDocument.getDocumentHeader().setDocumentDescription("CashControlDocument created for testing.");
        try {
            arDocHeader = this.arDocHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
        }
        catch (Exception e) {
            LOG.error("An Exception was thrown while trying to create a new AccountsReceivableDocumentHeader.", (Throwable)e);
            throw new RuntimeException("An Exception was thrown while trying to create a new AccountsReceivableDocumentHeader.", e);
        }
        arDocHeader.setDocumentNumber(cashControlDocument.getDocumentNumber());
        arDocHeader.setCustomerNumber(CUSTOMER_NUMBER);
        cashControlDocument.setAccountsReceivableDocumentHeader(arDocHeader);
        CashControlDetail detail = new CashControlDetail();
        detail.setCustomerNumber(CUSTOMER_NUMBER);
        detail.setFinancialDocumentLineAmount(DETAIL_AMOUNT);
        detail.setCustomerPaymentDescription("Test Detail");
        try {
            this.cut.addNewCashControlDetail("Test Document", cashControlDocument, detail);
        }
        catch (Exception e) {
            LOG.error("A Exception was thrown while trying to create a new CashControl detail.", (Throwable)e);
            throw new RuntimeException("A Exception was thrown while trying to create a new CashControl detail.", e);
        }
        return cashControlDocument;
    }
}

