/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.SubFundGroup;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsBillingAwardVerificationServiceImpl;
import org.kuali.kfs.sys.businessobject.ChartOrgHolderImpl;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.service.impl.FinancialSystemDocumentServiceImpl;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class ContractsGrantsBillingAwardVerificationServiceTest {
    private static final String ACCOUNT_NUMBER = "1234567";
    private static final String ANOTHER_ACCOUNT_NUMBER = "2345678";
    private static final String PROPOSAL_NUMBER = "1";
    private ContractsGrantsBillingAwardVerificationServiceImpl cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocSvcMock;
    @Mock
    private UniversityDateService universityDateSvcMock;
    @Mock
    private FinancialSystemUserService financialSystemUserServiceMock;
    @Mock
    private ContractsAndGrantsFundManager awardFundManagerMock;
    @Mock
    private ContractsAndGrantsBillingAward awardMock;
    @Mock
    private Person fundManagerMock;
    private FinancialSystemDocumentServiceImpl financialSystemDocumentService;

    ContractsGrantsBillingAwardVerificationServiceTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        this.financialSystemDocumentService = new FinancialSystemDocumentServiceImpl();
        this.cut = new ContractsGrantsBillingAwardVerificationServiceImpl();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setContractsGrantsInvoiceDocumentService(this.contractsGrantsInvoiceDocSvcMock);
        this.cut.setUniversityDateService(this.universityDateSvcMock);
        this.cut.setFinancialSystemUserService(this.financialSystemUserServiceMock);
        this.cut.setFinancialSystemDocumentService((FinancialSystemDocumentService)this.financialSystemDocumentService);
    }

    private void executeIsChartAndOrgSetupForInvoicingTest(boolean hasPrimaryAwardOrganization, boolean hasProcessing, boolean hasOrganizationAccountingDefault, boolean hasSystemInformation, boolean expectedResult) {
        ContractsAndGrantsBillingAward award = (ContractsAndGrantsBillingAward)Mockito.mock(ContractsAndGrantsBillingAward.class);
        if (hasPrimaryAwardOrganization) {
            String FUND_MANAGER_PRINCIPAL_ID = "012345678";
            Mockito.when((Object)this.fundManagerMock.getPrincipalId()).thenReturn((Object)"012345678");
            Mockito.when((Object)this.awardFundManagerMock.getFundManager()).thenReturn((Object)this.fundManagerMock);
            Mockito.when((Object)award.getAwardPrimaryFundManager()).thenReturn((Object)this.awardFundManagerMock);
            ChartOrgHolderImpl chartOrgHolder = new ChartOrgHolderImpl("C1", "11111");
            Mockito.when((Object)this.financialSystemUserServiceMock.getPrimaryOrganization("012345678", "KFS-AR")).thenReturn((Object)chartOrgHolder);
        }
        Mockito.when((Object)this.universityDateSvcMock.getCurrentFiscalYear()).thenReturn((Object)2015);
        if (hasProcessing) {
            Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes("C1", "11111")).thenReturn(Arrays.asList("C2", "22222"));
        } else {
            Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.getProcessingFromBillingCodes("C1", "11111")).thenReturn(new ArrayList());
        }
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", 2015);
        criteria.put("chartOfAccountsCode", "C1");
        criteria.put("organizationCode", "11111");
        if (hasOrganizationAccountingDefault) {
            Mockito.when((Object)((OrganizationAccountingDefault)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria))).thenReturn((Object)new OrganizationAccountingDefault());
        } else {
            Mockito.when((Object)((OrganizationAccountingDefault)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria))).thenReturn(null);
        }
        HashMap<String, Object> sysCriteria = new HashMap<String, Object>();
        sysCriteria.put("universityFiscalYear", 2015);
        sysCriteria.put("processingChartOfAccountCode", "C2");
        sysCriteria.put("processingOrganizationCode", "22222");
        if (hasSystemInformation) {
            Mockito.when((Object)((SystemInformation)this.businessObjectSvcMock.findByPrimaryKey(SystemInformation.class, sysCriteria))).thenReturn((Object)new SystemInformation());
        } else {
            Mockito.when((Object)((SystemInformation)this.businessObjectSvcMock.findByPrimaryKey(SystemInformation.class, sysCriteria))).thenReturn(null);
        }
        boolean result = this.cut.isChartAndOrgSetupForInvoicing(award);
        Assertions.assertEquals((Object)expectedResult, (Object)result);
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_ChartAndOrgValid() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, true, true, true);
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_NoAwardPrimaryFundManager() {
        this.executeIsChartAndOrgSetupForInvoicingTest(false, true, true, true, false);
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_NoProcessingFromBillingCodes() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, false, true, true, false);
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_NoOrganizationAccountingDefault() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, false, true, false);
    }

    @Test
    void executeIsChartAndOrgSetupForInvoicingTest_NoSystemInformation() {
        this.executeIsChartAndOrgSetupForInvoicingTest(true, true, true, false, false);
    }

    @Test
    void hasBillsToInvoice_NotPredeterminedBilling() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    void hasBillsToInvoice_NoBills() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    void hasBillsToInvoice_NoUnbilledBills() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(null, true, 1000.0, ACCOUNT_NUMBER);
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    void hasBillsToInvoice_OneUnbilledBillsDueLastMonth() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(LocalDate.now().minusMonths(1L), false, 1000.0, ACCOUNT_NUMBER);
        this.setupBills(LocalDate.now().minusMonths(1L), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assertions.assertTrue((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    private List<ContractsAndGrantsBillingAwardAccount> setupAwardAccounts() {
        ArrayList<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = this.setupAwardAccount(ACCOUNT_NUMBER, "S");
        activeAwardAccounts.add(awardAccountMock);
        return activeAwardAccounts;
    }

    private ContractsAndGrantsBillingAwardAccount setupAwardAccount(String accountNumber, String subFundGroupCode) {
        ContractsAndGrantsBillingAwardAccount awardAccountMock = (ContractsAndGrantsBillingAwardAccount)Mockito.mock(ContractsAndGrantsBillingAwardAccount.class);
        Mockito.when((Object)awardAccountMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUMBER);
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Account accountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)accountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)accountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode(subFundGroupCode);
        Mockito.when((Object)accountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Mockito.when((Object)awardAccountMock.getAccount()).thenReturn((Object)accountMock);
        return awardAccountMock;
    }

    @Test
    void hasBillsToInvoice_OneUnbilledBillsDueNextMonth() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(LocalDate.now().plusMonths(1L), false, 1000.0, ACCOUNT_NUMBER);
        this.setupBills(LocalDate.now().plusMonths(1L), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    void hasBillsToInvoice_OneUnbilledBillsDueToday() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(LocalDate.now(), false, 1000.0, ACCOUNT_NUMBER);
        this.setupBills(LocalDate.now(), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assertions.assertTrue((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    @Test
    void hasBillsToInvoice_OneUnbilledBillsDueToday_ZeroAmount() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        this.setupBills(LocalDate.now(), false, 0.0, ACCOUNT_NUMBER);
        this.setupBills(LocalDate.now(), false, 0.0, ANOTHER_ACCOUNT_NUMBER);
        Assertions.assertFalse((boolean)this.cut.hasBillsToInvoice(this.awardMock));
    }

    private void setupBills(LocalDate billDate, boolean hasSecondBillBeenBilled, double secondBillEstimatedAmount, String accountNumber) {
        ArrayList<Bill> bills = new ArrayList<Bill>();
        Bill bill = new Bill();
        bill.setBilled(true);
        Bill anotherBill = new Bill();
        anotherBill.setBilled(hasSecondBillBeenBilled);
        if (billDate != null) {
            anotherBill.setBillDate(Date.valueOf(billDate));
        }
        anotherBill.setEstimatedAmount(new KualiDecimal(secondBillEstimatedAmount));
        bills.add(bill);
        bills.add(anotherBill);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", this.awardMock.getProposalNumber());
        map.put("chartOfAccountsCode", "BL");
        map.put("accountNumber", accountNumber);
        map.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Bill.class, map)).thenReturn(bills);
    }

    @Test
    void hasMilestonesToInvoice_NotMilestoneBilling() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    void hasMilestonesToInvoice_NoBills() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    void hasMilestonesToInvoice_NoUnbilledBills() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(null, true, 1000.0, ACCOUNT_NUMBER);
        this.setupMilestones(null, true, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    void hasMilestonesToInvoice_OneUnbilledBillsDueLastMonth() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(LocalDate.now().minusMonths(1L), false, 1000.0, ACCOUNT_NUMBER);
        this.setupMilestones(LocalDate.now().minusMonths(1L), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assertions.assertTrue((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    void hasMilestonesToInvoice_OneUnbilledBillsDueNextMonth() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(LocalDate.now().plusMonths(1L), false, 1000.0, ACCOUNT_NUMBER);
        this.setupMilestones(LocalDate.now().plusMonths(1L), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    void hasMilestonesToInvoice_OneUnbilledBillsDueToday() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(LocalDate.now(), false, 1000.0, ACCOUNT_NUMBER);
        this.setupMilestones(LocalDate.now(), false, 1000.0, ANOTHER_ACCOUNT_NUMBER);
        Assertions.assertTrue((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    @Test
    void hasMilestonesToInvoice_OneUnbilledBillsDueToday_ZeroAmount() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        this.setupMilestones(LocalDate.now(), false, 0.0, ACCOUNT_NUMBER);
        this.setupMilestones(LocalDate.now(), false, 0.0, ANOTHER_ACCOUNT_NUMBER);
        Assertions.assertFalse((boolean)this.cut.hasMilestonesToInvoice(this.awardMock));
    }

    private void setupMilestones(LocalDate milestoneCompletionDate, boolean hasSecondMilestoneBeenBilled, double secondMilestoneAmount, String accountNumber) {
        ArrayList<Milestone> milestones = new ArrayList<Milestone>();
        Milestone milestone = new Milestone();
        milestone.setBilled(true);
        Milestone anotherMilestone = new Milestone();
        anotherMilestone.setBilled(hasSecondMilestoneBeenBilled);
        if (milestoneCompletionDate != null) {
            anotherMilestone.setMilestoneActualCompletionDate(Date.valueOf(milestoneCompletionDate));
        }
        anotherMilestone.setMilestoneAmount(new KualiDecimal(secondMilestoneAmount));
        milestones.add(milestone);
        milestones.add(anotherMilestone);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", this.awardMock.getProposalNumber());
        map.put("chartOfAccountsCode", "BL");
        map.put("accountNumber", accountNumber);
        map.put("active", true);
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(Milestone.class, map)).thenReturn(milestones);
    }

    @Test
    void isInvoiceInProgress_NoInvoices() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cut.isInvoiceInProgress(this.awardMock));
    }

    @Test
    void isInvoiceInProgress_InvoicesInProgressForDifferentAwardAccount() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cut.isInvoiceInProgress(this.awardMock));
    }

    @Test
    void isInvoiceInProgress_HasInvoices() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        List<String> accountNumbers = Arrays.asList(ACCOUNT_NUMBER, ANOTHER_ACCOUNT_NUMBER);
        this.setupInvoicesInProgress(accountNumbers);
        Assertions.assertTrue((boolean)this.cut.isInvoiceInProgress(this.awardMock));
    }

    private void setupInvoicesInProgress(List<String> accountNumbers) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", this.awardMock.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", this.financialSystemDocumentService.getPendingDocumentStatuses());
        ArrayList<ContractsGrantsInvoiceDocument> invoiceDocuments = new ArrayList<ContractsGrantsInvoiceDocument>();
        for (String accountNumber : accountNumbers) {
            ContractsGrantsInvoiceDocument invoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
            ArrayList<InvoiceAccountDetail> accountDetails = new ArrayList<InvoiceAccountDetail>();
            InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
            invoiceAccountDetail.setChartOfAccountsCode("BL");
            invoiceAccountDetail.setAccountNumber(accountNumber);
            accountDetails.add(invoiceAccountDetail);
            Mockito.when((Object)invoiceDocumentMock.getAccountDetails()).thenReturn(accountDetails);
            invoiceDocuments.add(invoiceDocumentMock);
        }
        Mockito.when((Object)this.businessObjectSvcMock.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues)).thenReturn(invoiceDocuments);
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByAccount_HasCodes_Valid() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getInvoicingOptionCode()).thenReturn((Object)"2");
        SubFundGroup subFundGroup = ((ContractsAndGrantsBillingAwardAccount)this.awardMock.getActiveAwardAccounts().get(0)).getAccount().getSubFundGroup();
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroup, "BL")).thenReturn((Object)new ContractsGrantsInvoiceObjectCode());
        Assertions.assertTrue((boolean)this.cut.hasIncomeAndReceivableObjectCodes(this.awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByAccount_DoesNotHaveCodes_Invalid() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getInvoicingOptionCode()).thenReturn((Object)"2");
        Assertions.assertFalse((boolean)this.cut.hasIncomeAndReceivableObjectCodes(this.awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceBySchedule_HasCodes_Valid() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getInvoicingOptionCode()).thenReturn((Object)"4");
        SubFundGroup subFundGroup = ((ContractsAndGrantsBillingAwardAccount)this.awardMock.getActiveAwardAccounts().get(0)).getAccount().getSubFundGroup();
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroup, "BL")).thenReturn((Object)new ContractsGrantsInvoiceObjectCode());
        Assertions.assertTrue((boolean)this.cut.hasIncomeAndReceivableObjectCodes(this.awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceBySchedule_DoesNotHaveCodes_Invalid() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getInvoicingOptionCode()).thenReturn((Object)"4");
        Assertions.assertFalse((boolean)this.cut.hasIncomeAndReceivableObjectCodes(this.awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByContractControlAccount_HasCodes_Valid() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getInvoicingOptionCode()).thenReturn((Object)"3");
        Account contractControlAccountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)contractControlAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)contractControlAccountMock.getAccountNumber()).thenReturn((Object)ANOTHER_ACCOUNT_NUMBER);
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode("C");
        Mockito.when((Object)contractControlAccountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Account accountMock = ((ContractsAndGrantsBillingAwardAccount)this.awardMock.getActiveAwardAccounts().get(0)).getAccount();
        Mockito.when((Object)accountMock.getContractControlAccount()).thenReturn((Object)contractControlAccountMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroup, "BL")).thenReturn((Object)new ContractsGrantsInvoiceObjectCode());
        Assertions.assertTrue((boolean)this.cut.hasIncomeAndReceivableObjectCodes(this.awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByContractControlAccount_DoesNotHaveCodes_Invalid() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getInvoicingOptionCode()).thenReturn((Object)"3");
        Account contractControlAccountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)contractControlAccountMock.getChartOfAccountsCode()).thenReturn((Object)"BL");
        Mockito.when((Object)contractControlAccountMock.getAccountNumber()).thenReturn((Object)ANOTHER_ACCOUNT_NUMBER);
        SubFundGroup subFundGroup = new SubFundGroup();
        subFundGroup.setSubFundGroupCode("C");
        Mockito.when((Object)contractControlAccountMock.getSubFundGroup()).thenReturn((Object)subFundGroup);
        Account accountMock = ((ContractsAndGrantsBillingAwardAccount)this.awardMock.getActiveAwardAccounts().get(0)).getAccount();
        Mockito.when((Object)accountMock.getContractControlAccount()).thenReturn((Object)contractControlAccountMock);
        Assertions.assertFalse((boolean)this.cut.hasIncomeAndReceivableObjectCodes(this.awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByAward_HasCodes_Valid() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = this.setupAwardAccount(ANOTHER_ACCOUNT_NUMBER, "S");
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getInvoicingOptionCode()).thenReturn((Object)PROPOSAL_NUMBER);
        SubFundGroup subFundGroup = ((ContractsAndGrantsBillingAwardAccount)this.awardMock.getActiveAwardAccounts().get(0)).getAccount().getSubFundGroup();
        Mockito.when((Object)this.contractsGrantsInvoiceDocSvcMock.contractGrantsInvoiceObjectCodeForSubFundGroup(subFundGroup, "BL")).thenReturn((Object)new ContractsGrantsInvoiceObjectCode());
        Assertions.assertTrue((boolean)this.cut.hasIncomeAndReceivableObjectCodes(this.awardMock));
    }

    @Test
    void hasIncomeAndReceivableObjectCodes_InvoiceByAward_DoesNotHaveCodes_Invalid() {
        List<ContractsAndGrantsBillingAwardAccount> activeAwardAccounts = this.setupAwardAccounts();
        ContractsAndGrantsBillingAwardAccount awardAccountMock = this.setupAwardAccount(ANOTHER_ACCOUNT_NUMBER, "C");
        activeAwardAccounts.add(awardAccountMock);
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(activeAwardAccounts);
        Mockito.when((Object)this.awardMock.getInvoicingOptionCode()).thenReturn((Object)PROPOSAL_NUMBER);
        Assertions.assertFalse((boolean)this.cut.hasIncomeAndReceivableObjectCodes(this.awardMock));
    }
}

