/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.HashMap;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.fixture.ContractsGrantsInvoiceDocumentFixture;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;
import org.kuali.rice.kim.api.role.RoleService;

@ConfigureContext(session=UserNameFixture.wklykins)
public class ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest
extends KualiIntegTestBase {
    private static final String PRINCIPAL_ID1 = "6164904958";
    private static final String PRINCIPAL_ID2 = "6165100953";
    private static final String PRINCIPAL_ID3 = "6170904981";
    private static final String PRINCIPAL_ID4 = "6172204597";
    private static final String PRINCIPAL_ID5 = "6176006856";
    private static final String PRINCIPAL_ID6 = "6176204753";
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    private ContractsGrantsInvoiceDocument invoice;

    protected void setUp() throws Exception {
        super.setUp();
        RoleService roleService = (RoleService)SpringContext.getBean(RoleService.class);
        this.contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        this.invoice = ContractsGrantsInvoiceDocumentFixture.CG_INV_DOC1.createContractsGrantsInvoiceDocument();
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
        accountsReceivableDocumentHeader.setDocumentNumber(this.invoice.getDocumentNumber());
        this.invoice.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        HashMap<String, String> qualifications = new HashMap<String, String>(4);
        qualifications.put("billingChartOfAccountsCode", "BL");
        qualifications.put("billingOrganizationCode", "BL");
        qualifications.put("customerNameStartingLetter", "A");
        qualifications.put("customerNameEndingLetter", "B");
        roleService.assignPrincipalToRole(PRINCIPAL_ID1, "KFS-AR", "CGB Collector", qualifications);
        qualifications = new HashMap(2);
        qualifications.put("billingChartOfAccountsCode", "BL");
        qualifications.put("billingOrganizationCode", "ACAC");
        roleService.assignPrincipalToRole(PRINCIPAL_ID2, "KFS-AR", "CGB Collector", qualifications);
        qualifications = new HashMap(4);
        qualifications.put("processingChartOfAccountsCode", "BL");
        qualifications.put("processingOrganizationCode", "BL");
        qualifications.put("customerNameStartingLetter", "A");
        qualifications.put("customerNameEndingLetter", "B");
        roleService.assignPrincipalToRole(PRINCIPAL_ID4, "KFS-AR", "CGB Collector", qualifications);
        qualifications = new HashMap(2);
        qualifications.put("processingChartOfAccountsCode", "BL");
        qualifications.put("processingOrganizationCode", "ACAC");
        roleService.assignPrincipalToRole(PRINCIPAL_ID5, "KFS-AR", "CGB Collector", qualifications);
    }

    public void testCanViewInvoiceBilling() {
        this.invoice.setCustomerName("ABERCROMBIE");
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertTrue((String)"should have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID1));
        this.invoice.setBillByChartOfAccountCode(null);
        this.invoice.setBilledByOrganizationCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID1));
    }

    public void testCannotViewInvoiceCustomerNameDoesNotMatchBilling() {
        this.invoice.setCustomerName("COLUMBIA");
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID1));
        this.invoice.setBillByChartOfAccountCode(null);
        this.invoice.setBilledByOrganizationCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID1));
    }

    public void testCannotViewInvoiceCustomerChartDoesNotMatchBilling() {
        this.invoice.setCustomerName("ABERCROMBIE");
        this.invoice.setBillByChartOfAccountCode("EA");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID1));
        this.invoice.setBillByChartOfAccountCode(null);
        this.invoice.setBilledByOrganizationCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("EA");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID1));
    }

    public void testCanViewInvoice2Billing() {
        this.invoice.setCustomerName("COLUMBIA");
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAC");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertTrue((String)"should have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID2));
        this.invoice.setBillByChartOfAccountCode(null);
        this.invoice.setBilledByOrganizationCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAC");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID2));
    }

    public void testCannotViewInvoiceCustomerOrgDoesNotMatchBilling() {
        this.invoice.setCustomerName("ABERCROMBIE");
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID2));
        this.invoice.setBillByChartOfAccountCode(null);
        this.invoice.setBilledByOrganizationCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID2));
    }

    public void testCannotViewInvoiceCustomerDoesNotHaveRoleBilling() {
        this.invoice.setCustomerName("ABERCROMBIE");
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID3));
        this.invoice.setBillByChartOfAccountCode(null);
        this.invoice.setBilledByOrganizationCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID3));
    }

    public void testCanViewInvoiceProcessing() {
        this.invoice.setCustomerName("ABERCROMBIE");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertTrue((String)"should have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID4));
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode(null);
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID4));
    }

    public void testCannotViewInvoiceCustomerNameDoesNotMatchProcessing() {
        this.invoice.setCustomerName("COLUMBIA");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID4));
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode(null);
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID4));
    }

    public void testCannotViewInvoiceCustomerChartDoesNotMatchProcessing() {
        this.invoice.setCustomerName("ABERCROMBIE");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("EA");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID4));
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode(null);
        this.invoice.setBillByChartOfAccountCode("EA");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID4));
    }

    public void testCanViewInvoice2Processing() {
        this.invoice.setCustomerName("COLUMBIA");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAC");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertTrue((String)"should have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID5));
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode(null);
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAC");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID5));
    }

    public void testCannotViewInvoiceCustomerOrgDoesNotMatchProcessing() {
        this.invoice.setCustomerName("ABERCROMBIE");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID5));
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode(null);
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID5));
    }

    public void testCannotViewInvoiceCustomerDoesNotHaveRoleProcessing() {
        this.invoice.setCustomerName("ABERCROMBIE");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode("BL");
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID6));
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingChartOfAccountCode(null);
        this.invoice.getAccountsReceivableDocumentHeader().setProcessingOrganizationCode(null);
        this.invoice.setBillByChartOfAccountCode("BL");
        this.invoice.setBilledByOrganizationCode("ACAD");
        ContractsGrantsInvoiceDocumentServiceViewInvoiceIntegTest.assertFalse((String)"should not have been able to view invoice", (boolean)this.contractsGrantsInvoiceDocumentService.canViewInvoice(this.invoice, PRINCIPAL_ID6));
    }
}

