/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceItemCode;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.service.impl.CustomerInvoiceDetailServiceImpl;
import org.kuali.kfs.module.ar.fixture.CustomerInvoiceItemCodeFixture;
import org.kuali.kfs.module.ar.fixture.OrganizationAccountingDefaultFixture;
import org.kuali.kfs.sys.context.SpringContext;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class CustomerInvoiceDetailServiceTest {
    private CustomerInvoiceDetailServiceImpl cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    CustomerInvoiceDetailServiceTest() {
    }

    @BeforeEach
    void setUp() {
        CustomerInvoiceItemCode customerInvoiceItemCode = CustomerInvoiceItemCodeFixture.BASE_CIIC.createCustomerInvoiceItemCode();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("invoiceItemCode", customerInvoiceItemCode.getInvoiceItemCode());
        criteria.put("chartOfAccountsCode", customerInvoiceItemCode.getChartOfAccountsCode());
        criteria.put("organizationCode", customerInvoiceItemCode.getOrganizationCode());
        Mockito.when((Object)((CustomerInvoiceItemCode)this.businessObjectSvcMock.findByPrimaryKey(CustomerInvoiceItemCode.class, criteria))).thenReturn((Object)customerInvoiceItemCode);
        OrganizationAccountingDefault orgAcctDefault = OrganizationAccountingDefaultFixture.BASE_OAD.createOrganizationAccountingDefault();
        HashMap<String, Object> criteria2 = new HashMap<String, Object>();
        criteria2.put("universityFiscalYear", orgAcctDefault.getUniversityFiscalYear());
        criteria2.put("chartOfAccountsCode", orgAcctDefault.getChartOfAccountsCode());
        criteria2.put("organizationCode", orgAcctDefault.getOrganizationCode());
        Mockito.when((Object)((OrganizationAccountingDefault)this.businessObjectSvcMock.findByPrimaryKey(OrganizationAccountingDefault.class, criteria2))).thenReturn((Object)orgAcctDefault);
        this.cut = new CustomerInvoiceDetailServiceImpl();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
    }

    @Test
    void getCustomerInvoiceDetailFromCustomerInvoiceItemCode() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = this.cut.getCustomerInvoiceDetailFromCustomerInvoiceItemCode(CustomerInvoiceItemCodeFixture.BASE_CIIC.invoiceItemCode, CustomerInvoiceItemCodeFixture.BASE_CIIC.chartOfAccountsCode, CustomerInvoiceItemCodeFixture.BASE_CIIC.organizationCode);
            Assertions.assertEquals((Object)CustomerInvoiceItemCodeFixture.BASE_CIIC.defaultInvoiceChartOfAccountsCode, (Object)customerInvoiceDetail.getChartOfAccountsCode());
            Assertions.assertEquals((Object)CustomerInvoiceItemCodeFixture.BASE_CIIC.defaultInvoiceAccountNumber, (Object)customerInvoiceDetail.getAccountNumber());
            Assertions.assertEquals((Object)CustomerInvoiceItemCodeFixture.BASE_CIIC.defaultInvoiceFinancialObjectCode, (Object)customerInvoiceDetail.getFinancialObjectCode());
        }
    }

    @Test
    void getCustomerInvoiceDetailFromOrganizationAccountingDefault() {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(AccountService.class)).thenReturn(Mockito.mock(AccountService.class));
            CustomerInvoiceDetail customerInvoiceDetail = this.cut.getCustomerInvoiceDetailFromOrganizationAccountingDefault(OrganizationAccountingDefaultFixture.BASE_OAD.universityFiscalYear, OrganizationAccountingDefaultFixture.BASE_OAD.chartOfAccountsCode, OrganizationAccountingDefaultFixture.BASE_OAD.organizationCode);
            Assertions.assertEquals((Object)OrganizationAccountingDefaultFixture.BASE_OAD.defaultInvoiceChartOfAccountsCode, (Object)customerInvoiceDetail.getChartOfAccountsCode());
            Assertions.assertEquals((Object)OrganizationAccountingDefaultFixture.BASE_OAD.defaultInvoiceAccountNumber, (Object)customerInvoiceDetail.getAccountNumber());
            Assertions.assertEquals((Object)OrganizationAccountingDefaultFixture.BASE_OAD.defaultInvoiceFinancialObjectCode, (Object)customerInvoiceDetail.getFinancialObjectCode());
        }
    }
}

