/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.time.Year;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.businessobject.OffsetDefinition;
import org.kuali.kfs.coa.service.OffsetDefinitionService;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.module.ar.document.service.impl.PaymentApplicationAdjustmentDocumentService;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntry;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.UniversityDate;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kim.api.identity.Person;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class PaymentApplicationAdjustmentDocumentServiceTest {
    private final PaymentApplicationAdjustmentDocument appaDocMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
    private final BusinessObjectService businessObjectServiceMock = (BusinessObjectService)Mockito.mock(BusinessObjectService.class);
    private final DataDictionaryService dataDictionaryServiceMock = (DataDictionaryService)Mockito.mock(DataDictionaryService.class);
    private final DocumentService documentServiceMock = (DocumentService)Mockito.mock(DocumentService.class);
    private final FinancialSystemUserService financialSystemUserServiceMock = (FinancialSystemUserService)Mockito.mock(FinancialSystemUserService.class);
    private final GeneralLedgerPendingEntryService generalLedgerPendingEntryServiceMock = (GeneralLedgerPendingEntryService)Mockito.mock(GeneralLedgerPendingEntryService.class);
    private final NoteService noteServiceMock = (NoteService)Mockito.mock(NoteService.class);
    private final OffsetDefinitionService offsetDefinitionServiceMock = (OffsetDefinitionService)Mockito.mock(OffsetDefinitionService.class);
    private final SystemInformationService systemInformationServiceMock = (SystemInformationService)Mockito.mock(SystemInformationService.class);
    private final UniversityDateService universityDateServiceMock = (UniversityDateService)Mockito.mock(UniversityDateService.class);
    private final CustomerInvoiceDocumentService customerInvoiceDocumentServiceMock = (CustomerInvoiceDocumentService)Mockito.mock(CustomerInvoiceDocumentService.class);
    private final CustomerInvoiceDetailService customerInvoiceDetailServiceMock = (CustomerInvoiceDetailService)Mockito.mock(CustomerInvoiceDetailService.class);
    private final PaymentApplicationAdjustmentDocumentService cut = new PaymentApplicationAdjustmentDocumentService(this.businessObjectServiceMock, this.dataDictionaryServiceMock, this.documentServiceMock, this.financialSystemUserServiceMock, this.generalLedgerPendingEntryServiceMock, this.noteServiceMock, this.offsetDefinitionServiceMock, this.systemInformationServiceMock, this.universityDateServiceMock, this.customerInvoiceDocumentServiceMock, this.customerInvoiceDetailServiceMock);

    PaymentApplicationAdjustmentDocumentServiceTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"constructionInvalidArgs"})
    void construction_invalid(BusinessObjectService businessObjectService, DataDictionaryService dataDictionaryService, DocumentService documentService, FinancialSystemUserService financialSystemUserService, GeneralLedgerPendingEntryService generalLedgerPendingEntryService, NoteService noteService, OffsetDefinitionService offsetDefinitionService, SystemInformationService systemInformationService, UniversityDateService universityDateService, CustomerInvoiceDocumentService customerInvoiceDocumentService, CustomerInvoiceDetailService customerInvoiceDetailService, String paramName) {
        Exception e = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> new PaymentApplicationAdjustmentDocumentService(businessObjectService, dataDictionaryService, documentService, financialSystemUserService, generalLedgerPendingEntryService, noteService, offsetDefinitionService, systemInformationService, universityDateService, customerInvoiceDocumentService, customerInvoiceDetailService));
        String expectedMessage = String.format("%s must be provided", paramName);
        Assertions.assertEquals((Object)expectedMessage, (Object)e.getMessage());
    }

    private static Stream<Arguments> constructionInvalidArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(CustomerInvoiceDetailService.class), "businessObjectService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), null, Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(CustomerInvoiceDetailService.class), "dataDictionaryService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), Mockito.mock(DataDictionaryService.class), null, Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(CustomerInvoiceDetailService.class), "documentService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), null, Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(CustomerInvoiceDetailService.class), "financialSystemUserService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), null, Mockito.mock(NoteService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(CustomerInvoiceDetailService.class), "generalLedgerPendingEntryService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), null, Mockito.mock(OffsetDefinitionService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(CustomerInvoiceDetailService.class), "noteService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), null, Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(CustomerInvoiceDetailService.class), "offsetDefinitionService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(OffsetDefinitionService.class), null, Mockito.mock(UniversityDateService.class), Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(CustomerInvoiceDetailService.class), "systemInformationService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(SystemInformationService.class), null, Mockito.mock(CustomerInvoiceDocumentService.class), Mockito.mock(CustomerInvoiceDetailService.class), "universityDateService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), null, Mockito.mock(CustomerInvoiceDetailService.class), "customerInvoiceDocumentService"}), Arguments.of((Object[])new Object[]{Mockito.mock(BusinessObjectService.class), Mockito.mock(DataDictionaryService.class), Mockito.mock(DocumentService.class), Mockito.mock(FinancialSystemUserService.class), Mockito.mock(GeneralLedgerPendingEntryService.class), Mockito.mock(NoteService.class), Mockito.mock(OffsetDefinitionService.class), Mockito.mock(SystemInformationService.class), Mockito.mock(UniversityDateService.class), Mockito.mock(CustomerInvoiceDocumentService.class), null, "customerInvoiceDetailService"}));
    }

    @Test
    void createPaymentApplicationAdjustment_does_not_include_invoice_with_an_appliedamount_of_zero() throws Exception {
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)this.documentServiceMock.getNewDocument(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)adjustmentDocumentMock);
        CustomerInvoiceDocument invoiceMock1 = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        InvoicePaidApplied ipaMock1 = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)ipaMock1.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock1);
        Mockito.when((Object)this.customerInvoiceDocumentServiceMock.getPaidAppliedTotalForInvoice(invoiceMock1)).thenReturn((Object)KualiDecimal.ZERO);
        CustomerInvoiceDocument invoiceMock2 = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        InvoicePaidApplied ipaMock2 = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)ipaMock2.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock2);
        Mockito.when((Object)this.customerInvoiceDocumentServiceMock.getPaidAppliedTotalForInvoice(invoiceMock2)).thenReturn((Object)new KualiDecimal(7));
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(ipaMock1, ipaMock2);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeaderMock = (AccountsReceivableDocumentHeader)Mockito.mock(AccountsReceivableDocumentHeader.class);
        PaymentApplicationAdjustmentDocument adjusteeDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        Mockito.when((Object)adjusteeDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeaderMock);
        this.cut.createPaymentApplicationAdjustment(adjusteeDocumentMock);
        ((PaymentApplicationAdjustmentDocument)Mockito.verify((Object)adjustmentDocumentMock)).setInvoicePaidApplieds(List.of(ipaMock2));
    }

    @Test
    void createPaymentApplicationAdjustment_does_not_include_nonappliedholdings_with_a_financialdocumentlineamount_of_zero() throws Exception {
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)this.documentServiceMock.getNewDocument(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)adjustmentDocumentMock);
        NonAppliedHolding nahMock1 = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
        Mockito.when((Object)nahMock1.getFinancialDocumentLineAmount()).thenReturn((Object)KualiDecimal.ZERO);
        NonAppliedHolding nahMock2 = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
        Mockito.when((Object)nahMock2.getFinancialDocumentLineAmount()).thenReturn((Object)new KualiDecimal("7.00"));
        List<NonAppliedHolding> adjusteeNonAppliedHoldings = List.of(nahMock1, nahMock2);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeaderMock = (AccountsReceivableDocumentHeader)Mockito.mock(AccountsReceivableDocumentHeader.class);
        PaymentApplicationAdjustmentDocument adjusteeDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
        Mockito.when((Object)adjusteeDocumentMock.getAccountsReceivableDocumentHeader()).thenReturn((Object)accountsReceivableDocumentHeaderMock);
        this.cut.createPaymentApplicationAdjustment(adjusteeDocumentMock);
        ((PaymentApplicationAdjustmentDocument)Mockito.verify((Object)adjustmentDocumentMock)).setNonAppliedHoldings(List.of(nahMock2));
    }

    @Test
    void updateNonAppliedHoldings_matchingCustomerNumber_updatesAmount() {
        String matchingCustomerNumber = "123";
        NonAppliedHolding matchingNonAppliedHolding = new NonAppliedHolding();
        matchingNonAppliedHolding.setCustomerNumber("123");
        matchingNonAppliedHolding.setFinancialDocumentLineAmount(new KualiDecimal(1000));
        Mockito.when((Object)this.appaDocMock.getNonAppliedHoldings()).thenReturn(Arrays.asList(matchingNonAppliedHolding));
        PaymentApplicationAdjustmentRequest.NonAppliedHolding nonAppliedHolding = new PaymentApplicationAdjustmentRequest.NonAppliedHolding(new KualiDecimal(3000), "123");
        this.cut.updateNonAppliedHoldings(this.appaDocMock, List.of(nonAppliedHolding));
        Assertions.assertEquals((Object)nonAppliedHolding.getAmount(), (Object)matchingNonAppliedHolding.getFinancialDocumentLineAmount());
        Assertions.assertEquals((int)1, (int)this.appaDocMock.getNonAppliedHoldings().size());
    }

    @Test
    void updateNonAppliedHoldings_noMatchingCustomerNumber_createsNewNonAppliedHolding() {
        String documentNumber = "ABC";
        Mockito.when((Object)this.appaDocMock.getNonAppliedHoldings()).thenReturn(new ArrayList());
        Mockito.when((Object)this.appaDocMock.getDocumentNumber()).thenReturn((Object)"ABC");
        PaymentApplicationAdjustmentRequest.NonAppliedHolding nonAppliedHoldingRequest = new PaymentApplicationAdjustmentRequest.NonAppliedHolding(new KualiDecimal(3000), "888");
        this.cut.updateNonAppliedHoldings(this.appaDocMock, Arrays.asList(nonAppliedHoldingRequest));
        Assertions.assertEquals((int)1, (int)this.appaDocMock.getNonAppliedHoldings().size());
        NonAppliedHolding addedNonAppliedHolding = (NonAppliedHolding)this.appaDocMock.getNonAppliedHoldings().get(0);
        Assertions.assertEquals((Object)nonAppliedHoldingRequest.getCustomerNumber(), (Object)addedNonAppliedHolding.getCustomerNumber());
        Assertions.assertEquals((Object)this.appaDocMock.getDocumentNumber(), (Object)addedNonAppliedHolding.getReferenceFinancialDocumentNumber());
        Assertions.assertEquals((Object)nonAppliedHoldingRequest.getAmount(), (Object)addedNonAppliedHolding.getFinancialDocumentLineAmount());
    }

    @Test
    void updateNonAppliedHoldings_customerNumberOmitted_removedNonAppliedHolding() {
        String customerNumber = "123";
        NonAppliedHolding nonAppliedHolding = new NonAppliedHolding();
        nonAppliedHolding.setCustomerNumber("123");
        Mockito.when((Object)this.appaDocMock.getNonAppliedHoldings()).thenReturn(new ArrayList<NonAppliedHolding>(List.of(nonAppliedHolding)));
        this.cut.updateNonAppliedHoldings(this.appaDocMock, Collections.emptyList());
        Assertions.assertTrue((boolean)this.appaDocMock.getNonAppliedHoldings().isEmpty());
    }

    @Test
    void updateInvoicePaidApplieds_matchingInvoiceAndSequence_updatesAmount() {
        String documentNumber = "123";
        String refDocNumber = "456";
        int sequenceNumber = 10;
        InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(0), Integer.valueOf(2000), "A");
        this.mockUniversityDateService();
        Mockito.when((Object)this.appaDocMock.getInvoicePaidApplieds()).thenReturn(Arrays.asList(matchingInvoicePaidApplied));
        PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail invoiceDetail = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(new KualiDecimal(2000), Integer.valueOf(10));
        PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplication("A", "456", List.of(invoiceDetail));
        this.cut.updateInvoicePaidApplieds(this.appaDocMock, List.of(invoiceApplication));
        Assertions.assertEquals((Object)invoiceDetail.getAmountApplied(), (Object)matchingInvoicePaidApplied.getInvoiceItemAppliedAmount());
    }

    @Test
    void updateInvoicePaidApplieds_noMatchingDocumentInvoice_matchingInvoiceDetail_doesNotCreateNewInvoiceApplied() {
        String documentNumber = "123";
        Mockito.when((Object)this.appaDocMock.getDocumentNumber()).thenReturn((Object)"123");
        String refDocNumber = "456";
        int sequenceNumber = 10;
        int paidAppliedItemNumber = 10;
        InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(10), Integer.valueOf(2000), "A");
        ArrayList invoicePaidApplieds = new ArrayList();
        Collections.addAll(invoicePaidApplieds, matchingInvoicePaidApplied);
        Mockito.when((Object)this.appaDocMock.getInvoicePaidApplieds()).thenReturn(invoicePaidApplieds);
        KualiDecimal invoiceApplicationDetailAmountApplied = KualiDecimal.ZERO;
        int invoiceApplicationDetailSequenceNumber = 12;
        PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail invoiceDetail = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(invoiceApplicationDetailAmountApplied, Integer.valueOf(12));
        PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplication("A", "456", List.of(invoiceDetail));
        this.mockUniversityDateService();
        CustomerInvoiceDetail customerInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)customerInvoiceDetailMock.getInvoiceItemNumber()).thenReturn((Object)12);
        Mockito.when((Object)customerInvoiceDetailMock.getAmountApplied()).thenReturn((Object)invoiceApplicationDetailAmountApplied);
        List<CustomerInvoiceDetail> invoiceDetailMocks = List.of(customerInvoiceDetailMock);
        CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)customerInvoiceDocumentMock.getCustomerInvoiceDetailsWithoutDiscounts()).thenReturn(invoiceDetailMocks);
        Mockito.when((Object)((CustomerInvoiceDocument)this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"456"))).thenReturn((Object)customerInvoiceDocumentMock);
        this.cut.updateInvoicePaidApplieds(this.appaDocMock, List.of(invoiceApplication));
        Assertions.assertEquals((int)1, (int)invoicePaidApplieds.size());
        Assertions.assertEquals((Object)matchingInvoicePaidApplied, invoicePaidApplieds.get(0));
    }

    @Test
    void updateInvoicePaidApplieds_noMatchingInvoice_createsNewInvoiceApplied() {
        String documentNumber = "123";
        String refDocNumber = "456";
        int sequenceNumber = 10;
        int paidAppliedItemNumber = 10;
        InvoicePaidApplied matchingInvoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(10), Integer.valueOf(2000), "A");
        ArrayList<InvoicePaidApplied> invoicePaidApplieds = new ArrayList<InvoicePaidApplied>(List.of(matchingInvoicePaidApplied));
        Mockito.when((Object)this.appaDocMock.getInvoicePaidApplieds()).thenReturn(invoicePaidApplieds);
        Mockito.when((Object)this.appaDocMock.getDocumentNumber()).thenReturn((Object)"123");
        KualiDecimal invoiceApplicationDetailAmountApplied = new KualiDecimal(2000);
        int invoiceApplicationDetailSequenceNumber = 11;
        PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail invoiceDetail = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(invoiceApplicationDetailAmountApplied, Integer.valueOf(11));
        PaymentApplicationAdjustmentRequest.InvoiceApplication invoiceApplication = new PaymentApplicationAdjustmentRequest.InvoiceApplication("A", "456", List.of(invoiceDetail));
        this.mockUniversityDateService();
        CustomerInvoiceDetail customerInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)customerInvoiceDetailMock.getInvoiceItemNumber()).thenReturn((Object)11);
        Mockito.when((Object)customerInvoiceDetailMock.getAmountApplied()).thenReturn((Object)((KualiDecimal)invoiceApplicationDetailAmountApplied.add((AbstractKualiDecimal)new KualiDecimal("5"))));
        List<CustomerInvoiceDetail> invoiceDetailMocks = List.of(customerInvoiceDetailMock);
        CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)customerInvoiceDocumentMock.getCustomerInvoiceDetailsWithoutDiscounts()).thenReturn(invoiceDetailMocks);
        Mockito.when((Object)((CustomerInvoiceDocument)this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"456"))).thenReturn((Object)customerInvoiceDocumentMock);
        this.cut.updateInvoicePaidApplieds(this.appaDocMock, List.of(invoiceApplication));
        Assertions.assertEquals((Object)new KualiDecimal(1000), (Object)matchingInvoicePaidApplied.getInvoiceItemAppliedAmount());
        Assertions.assertEquals((int)2, (int)invoicePaidApplieds.size());
        InvoicePaidApplied newlyAddedInvoicePaidApplied = invoicePaidApplieds.stream().filter(invoicePaidApplied -> invoicePaidApplied.getInvoiceItemNumber().equals(invoiceDetail.getSequenceNumber())).findFirst().orElse(null);
        Assertions.assertEquals((Object)invoiceDetail.getAmountApplied(), (Object)newlyAddedInvoicePaidApplied.getInvoiceItemAppliedAmount());
        Assertions.assertEquals((Object)"123", (Object)newlyAddedInvoicePaidApplied.getDocumentNumber());
        Assertions.assertEquals((Object)"456", (Object)newlyAddedInvoicePaidApplied.getFinancialDocumentReferenceInvoiceNumber());
        Assertions.assertEquals((Integer)invoiceDetail.getSequenceNumber(), (Integer)newlyAddedInvoicePaidApplied.getInvoiceItemNumber());
        Assertions.assertEquals((int)11, (Integer)newlyAddedInvoicePaidApplied.getInvoiceItemNumber());
        Assertions.assertEquals((Integer)this.universityDateServiceMock.getCurrentFiscalYear(), (Integer)newlyAddedInvoicePaidApplied.getUniversityFiscalYear());
        Assertions.assertEquals((Object)this.universityDateServiceMock.getCurrentUniversityDate().getAccountingPeriod().getUniversityFiscalPeriodCode(), (Object)newlyAddedInvoicePaidApplied.getUniversityFiscalPeriodCode());
    }

    @Test
    void updateInvoicePaidApplieds_invoiceOmitted_deletesPaidApplied() {
        this.mockUniversityDateService();
        InvoicePaidApplied invoicePaidApplied = new InvoicePaidApplied("123", "456", Integer.valueOf(10), new KualiDecimal(1000), Integer.valueOf(0), Integer.valueOf(2000), "A");
        Mockito.when((Object)this.appaDocMock.getInvoicePaidApplieds()).thenReturn(new ArrayList<InvoicePaidApplied>(List.of(invoicePaidApplied)));
        this.cut.updateInvoicePaidApplieds(this.appaDocMock, Collections.emptyList());
        Assertions.assertTrue((boolean)this.appaDocMock.getInvoicePaidApplieds().isEmpty());
    }

    private void mockUniversityDateService() {
        Mockito.when((Object)this.universityDateServiceMock.getCurrentFiscalYear()).thenReturn((Object)1000);
        UniversityDate universityDateMock = (UniversityDate)Mockito.mock(UniversityDate.class);
        Mockito.when((Object)this.universityDateServiceMock.getCurrentUniversityDate()).thenReturn((Object)universityDateMock);
        AccountingPeriod accountingPeriodMock = (AccountingPeriod)Mockito.mock(AccountingPeriod.class);
        Mockito.when((Object)universityDateMock.getAccountingPeriod()).thenReturn((Object)accountingPeriodMock);
        Mockito.when((Object)accountingPeriodMock.getUniversityFiscalPeriodCode()).thenReturn((Object)"ABC");
    }

    @Test
    void createPendingEntries_nonAppliedHoldings_new() throws Exception {
        String currentUserPrincipalId = "currentUserPrincipalId";
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)personMock.getPrincipalId()).thenReturn((Object)"currentUserPrincipalId");
        String dash = "-";
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashFinancialSubObjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashProjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashSubAccountNumber();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)personMock).when((Object)localCutSpy)).getPerson();
        Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
        String appaDocumentTypeCode = "APPA";
        List adjusteeNonAppliedHoldings = List.of();
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
        String initiatorChartOfAccountsCode = "initiatorChartOfAccountsCode";
        String initiatorOrganizationCode = "initiatorOrganizationCode";
        Account universityClearingAccountMock = (Account)Mockito.mock(Account.class);
        String universityClearingAccountNumber = "universityClearingAccountNumber";
        String universityClearingAccountChartOfAccounts = "universityClearingAccountChartOfAccounts";
        String unappliedSubAccountNumber = "unappliedSubAccountNumber";
        String unappliedObjectCode = "unappliedObjectCode";
        String unappliedObjectTypeCode = "unappliedObjectTypeCode";
        String unappliedSubObjectCode = "unappliedSubObjectCode";
        this.setupSystemInformationMockingForCurrentInitiator("initiatorChartOfAccountsCode", "initiatorOrganizationCode", universityClearingAccountMock, "universityClearingAccountNumber", "universityClearingAccountChartOfAccounts", "unappliedSubAccountNumber", "unappliedObjectCode", "unappliedObjectTypeCode", "unappliedSubObjectCode", "currentUserPrincipalId", currentYear);
        String offsetDefinitionFinancialObjectFinancialObjectTypeCode = "offsetDefinitionFinancialObjectFinancialObjectTypeCode";
        String offsetDefinitionFinancialObjectCode = "offsetDefinitionFinancialObjectCode";
        this.setupOffsetDefinitionMocking("offsetDefinitionFinancialObjectFinancialObjectTypeCode", "offsetDefinitionFinancialObjectCode", currentYear, "universityClearingAccountChartOfAccounts", "APPA");
        String adjustmentNahCustomerNumber = "CN1";
        KualiDecimal adjustmentNahFinancialDocumentLineAmount = new KualiDecimal(3);
        NonAppliedHolding adjustmentNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
        Mockito.when((Object)adjustmentNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
        Mockito.when((Object)adjustmentNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjustmentNahFinancialDocumentLineAmount);
        List<NonAppliedHolding> adjustmentNonAppliedHoldings = List.of(adjustmentNonAppliedHoldingMock);
        String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
        String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
        DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
        Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getNonAppliedHoldings()).thenReturn(adjustmentNonAppliedHoldings);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
        int initialSequenceNumber = 1;
        GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
        Mockito.when((Object)sequenceHelperMock.getSequenceCounter()).thenReturn((Object)initialSequenceNumber).thenReturn((Object)(initialSequenceNumber + 1));
        Mockito.when((Object)this.dataDictionaryServiceMock.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)"APPA");
        List pendingEntries = localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock, currentYear, sequenceHelperMock);
        Assertions.assertEquals((int)2, (int)pendingEntries.size());
        GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
        Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)actualCredit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)actualCredit.getAccountNumber());
        Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)actualCredit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"unappliedObjectCode", (Object)actualCredit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"unappliedObjectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"unappliedSubObjectCode", (Object)actualCredit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"-", (Object)actualCredit.getProjectCode());
        Assertions.assertEquals((Object)"unappliedSubAccountNumber", (Object)actualCredit.getSubAccountNumber());
        Assertions.assertEquals((Object)adjustmentNahFinancialDocumentLineAmount, (Object)actualCredit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)actualCredit.getUniversityFiscalYear());
        Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
        GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
        Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)offsetDebit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)offsetDebit.getAccountNumber());
        Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)offsetDebit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectCode", (Object)offsetDebit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectFinancialObjectTypeCode", (Object)offsetDebit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"-", (Object)offsetDebit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"-", (Object)offsetDebit.getProjectCode());
        Assertions.assertEquals((Object)"-", (Object)offsetDebit.getSubAccountNumber());
        Assertions.assertEquals((Object)adjustmentNahFinancialDocumentLineAmount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetDebit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)offsetDebit.getUniversityFiscalYear());
        Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetDebit.getTransactionLedgerEntrySequenceNumber());
    }

    @Test
    void createPendingEntries_nonAppliedHoldings_increased() throws Exception {
        String currentUserPrincipalId = "currentUserPrincipalId";
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)personMock.getPrincipalId()).thenReturn((Object)"currentUserPrincipalId");
        String dash = "-";
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashFinancialSubObjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashProjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashSubAccountNumber();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)personMock).when((Object)localCutSpy)).getPerson();
        Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
        String appaDocumentTypeCode = "APPA";
        String adjusteeNahCustomerNumber = "CN1";
        KualiDecimal adjusteeNahFinancialDocumentLineAmount = new KualiDecimal(1);
        NonAppliedHolding adjusteeNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
        Mockito.when((Object)adjusteeNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
        Mockito.when((Object)adjusteeNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjusteeNahFinancialDocumentLineAmount);
        List<NonAppliedHolding> adjusteeNonAppliedHoldings = List.of(adjusteeNonAppliedHoldingMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
        String initiatorChartOfAccountsCode = "initiatorChartOfAccountsCode";
        String initiatorOrganizationCode = "initiatorOrganizationCode";
        Account universityClearingAccountMock = (Account)Mockito.mock(Account.class);
        String universityClearingAccountNumber = "universityClearingAccountNumber";
        String universityClearingAccountChartOfAccounts = "universityClearingAccountChartOfAccounts";
        String unappliedSubAccountNumber = "unappliedSubAccountNumber";
        String unappliedObjectCode = "unappliedObjectCode";
        String unappliedObjectTypeCode = "unappliedObjectTypeCode";
        String unappliedSubObjectCode = "unappliedSubObjectCode";
        this.setupSystemInformationMockingForCurrentInitiator("initiatorChartOfAccountsCode", "initiatorOrganizationCode", universityClearingAccountMock, "universityClearingAccountNumber", "universityClearingAccountChartOfAccounts", "unappliedSubAccountNumber", "unappliedObjectCode", "unappliedObjectTypeCode", "unappliedSubObjectCode", "currentUserPrincipalId", currentYear);
        String offsetDefinitionFinancialObjectFinancialObjectTypeCode = "offsetDefinitionFinancialObjectFinancialObjectTypeCode";
        String offsetDefinitionFinancialObjectCode = "offsetDefinitionFinancialObjectCode";
        this.setupOffsetDefinitionMocking("offsetDefinitionFinancialObjectFinancialObjectTypeCode", "offsetDefinitionFinancialObjectCode", currentYear, "universityClearingAccountChartOfAccounts", "APPA");
        String adjustmentNahCustomerNumber = "CN1";
        KualiDecimal adjustmentNahFinancialDocumentLineAmount = new KualiDecimal(3);
        NonAppliedHolding adjustmentNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
        Mockito.when((Object)adjustmentNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
        Mockito.when((Object)adjustmentNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjustmentNahFinancialDocumentLineAmount);
        List<NonAppliedHolding> adjustmentNonAppliedHoldings = List.of(adjustmentNonAppliedHoldingMock);
        String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
        String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
        DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
        Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getNonAppliedHoldings()).thenReturn(adjustmentNonAppliedHoldings);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
        int initialSequenceNumber = 1;
        GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
        Mockito.when((Object)sequenceHelperMock.getSequenceCounter()).thenReturn((Object)initialSequenceNumber).thenReturn((Object)(initialSequenceNumber + 1));
        Mockito.when((Object)this.dataDictionaryServiceMock.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)"APPA");
        List pendingEntries = localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock, currentYear, sequenceHelperMock);
        Assertions.assertEquals((int)2, (int)pendingEntries.size());
        KualiDecimal expectedAmount = (KualiDecimal)adjustmentNahFinancialDocumentLineAmount.subtract((AbstractKualiDecimal)adjusteeNahFinancialDocumentLineAmount);
        GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
        Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)actualCredit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)actualCredit.getAccountNumber());
        Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)actualCredit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"unappliedObjectCode", (Object)actualCredit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"unappliedObjectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"unappliedSubObjectCode", (Object)actualCredit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"-", (Object)actualCredit.getProjectCode());
        Assertions.assertEquals((Object)"unappliedSubAccountNumber", (Object)actualCredit.getSubAccountNumber());
        Assertions.assertEquals((Object)expectedAmount, (Object)actualCredit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)actualCredit.getUniversityFiscalYear());
        Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
        GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
        Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)offsetDebit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)offsetDebit.getAccountNumber());
        Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)offsetDebit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectCode", (Object)offsetDebit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectFinancialObjectTypeCode", (Object)offsetDebit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"-", (Object)offsetDebit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"-", (Object)offsetDebit.getProjectCode());
        Assertions.assertEquals((Object)"-", (Object)offsetDebit.getSubAccountNumber());
        Assertions.assertEquals((Object)expectedAmount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetDebit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)offsetDebit.getUniversityFiscalYear());
        Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetDebit.getTransactionLedgerEntrySequenceNumber());
    }

    @Test
    void createPendingEntries_nonAppliedHoldings_decreased() throws Exception {
        String dash = "-";
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashFinancialSubObjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashProjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashSubAccountNumber();
        Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
        String appaDocumentTypeCode = "APPA";
        String adjusteeNahCustomerNumber = "CN1";
        KualiDecimal adjusteeNahFinancialDocumentLineAmount = new KualiDecimal(3);
        NonAppliedHolding adjusteeNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
        Mockito.when((Object)adjusteeNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
        Mockito.when((Object)adjusteeNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjusteeNahFinancialDocumentLineAmount);
        List<NonAppliedHolding> adjusteeNonAppliedHoldings = List.of(adjusteeNonAppliedHoldingMock);
        DocumentHeader adjusteeDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
        Mockito.when((Object)adjusteeDocumentMock.getDocumentHeader()).thenReturn((Object)adjusteeDocumentHeaderMock);
        String initiatorChartOfAccountsCode = "initiatorChartOfAccountsCode";
        String initiatorOrganizationCode = "initiatorOrganizationCode";
        Account universityClearingAccountMock = (Account)Mockito.mock(Account.class);
        String universityClearingAccountNumber = "universityClearingAccountNumber";
        String universityClearingAccountChartOfAccounts = "universityClearingAccountChartOfAccounts";
        String unappliedSubAccountNumber = "unappliedSubAccountNumber";
        String unappliedObjectCode = "unappliedObjectCode";
        String unappliedObjectTypeCode = "unappliedObjectTypeCode";
        String unappliedSubObjectCode = "unappliedSubObjectCode";
        this.setupSystemInformationMockingForAdjusteeDocumentInitiator(adjusteeDocumentHeaderMock, "initiatorChartOfAccountsCode", "initiatorOrganizationCode", universityClearingAccountMock, "universityClearingAccountNumber", "universityClearingAccountChartOfAccounts", "unappliedSubAccountNumber", "unappliedObjectCode", "unappliedObjectTypeCode", "unappliedSubObjectCode", currentYear);
        String offsetDefinitionFinancialObjectFinancialObjectTypeCode = "offsetDefinitionFinancialObjectFinancialObjectTypeCode";
        String offsetDefinitionFinancialObjectCode = "offsetDefinitionFinancialObjectCode";
        this.setupOffsetDefinitionMocking("offsetDefinitionFinancialObjectFinancialObjectTypeCode", "offsetDefinitionFinancialObjectCode", currentYear, "universityClearingAccountChartOfAccounts", "APPA");
        String adjustmentNahCustomerNumber = "CN1";
        KualiDecimal adjustmentNahFinancialDocumentLineAmount = new KualiDecimal(1);
        NonAppliedHolding adjustmentNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
        Mockito.when((Object)adjustmentNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
        Mockito.when((Object)adjustmentNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjustmentNahFinancialDocumentLineAmount);
        List<NonAppliedHolding> adjustmentNonAppliedHoldings = List.of(adjustmentNonAppliedHoldingMock);
        String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
        String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
        DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
        Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getNonAppliedHoldings()).thenReturn(adjustmentNonAppliedHoldings);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
        int initialSequenceNumber = 1;
        GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
        Mockito.when((Object)sequenceHelperMock.getSequenceCounter()).thenReturn((Object)initialSequenceNumber).thenReturn((Object)(initialSequenceNumber + 1));
        Mockito.when((Object)this.dataDictionaryServiceMock.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)"APPA");
        List pendingEntries = localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock, currentYear, sequenceHelperMock);
        Assertions.assertEquals((int)2, (int)pendingEntries.size());
        KualiDecimal expectedAmount = (KualiDecimal)adjusteeNahFinancialDocumentLineAmount.subtract((AbstractKualiDecimal)adjustmentNahFinancialDocumentLineAmount);
        GeneralLedgerPendingEntry actualDebit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
        Assertions.assertEquals((Object)"D", (Object)actualDebit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)actualDebit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)actualDebit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)actualDebit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualDebit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)actualDebit.getAccountNumber());
        Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)actualDebit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"unappliedObjectCode", (Object)actualDebit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"unappliedObjectTypeCode", (Object)actualDebit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"-", (Object)actualDebit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"-", (Object)actualDebit.getProjectCode());
        Assertions.assertEquals((Object)"unappliedSubAccountNumber", (Object)actualDebit.getSubAccountNumber());
        Assertions.assertEquals((Object)expectedAmount, (Object)actualDebit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualDebit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)actualDebit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)actualDebit.getUniversityFiscalYear());
        Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualDebit.getTransactionLedgerEntrySequenceNumber());
        GeneralLedgerPendingEntry offsetCredit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
        Assertions.assertEquals((Object)"C", (Object)offsetCredit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)offsetCredit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)offsetCredit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)offsetCredit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetCredit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)offsetCredit.getAccountNumber());
        Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)offsetCredit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectCode", (Object)offsetCredit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectFinancialObjectTypeCode", (Object)offsetCredit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"-", (Object)offsetCredit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"-", (Object)offsetCredit.getProjectCode());
        Assertions.assertEquals((Object)"-", (Object)offsetCredit.getSubAccountNumber());
        Assertions.assertEquals((Object)expectedAmount, (Object)offsetCredit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetCredit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)offsetCredit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)offsetCredit.getUniversityFiscalYear());
        Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetCredit.getTransactionLedgerEntrySequenceNumber());
    }

    @Test
    void createPendingEntries_nonAppliedHoldings_removed() throws Exception {
        String dash = "-";
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashFinancialSubObjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashProjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashSubAccountNumber();
        Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
        String appaDocumentTypeCode = "APPA";
        String adjusteeNahCustomerNumber = "CN1";
        KualiDecimal adjusteeNahFinancialDocumentLineAmount = new KualiDecimal(3);
        NonAppliedHolding adjusteeNonAppliedHoldingMock = (NonAppliedHolding)Mockito.mock(NonAppliedHolding.class);
        Mockito.when((Object)adjusteeNonAppliedHoldingMock.getCustomerNumber()).thenReturn((Object)"CN1");
        Mockito.when((Object)adjusteeNonAppliedHoldingMock.getFinancialDocumentLineAmount()).thenReturn((Object)adjusteeNahFinancialDocumentLineAmount);
        List<NonAppliedHolding> adjusteeNonAppliedHoldings = List.of(adjusteeNonAppliedHoldingMock);
        DocumentHeader adjusteeDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getNonAppliedHoldings()).thenReturn(adjusteeNonAppliedHoldings);
        Mockito.when((Object)adjusteeDocumentMock.getDocumentHeader()).thenReturn((Object)adjusteeDocumentHeaderMock);
        String initiatorChartOfAccountsCode = "initiatorChartOfAccountsCode";
        String initiatorOrganizationCode = "initiatorOrganizationCode";
        Account universityClearingAccountMock = (Account)Mockito.mock(Account.class);
        String universityClearingAccountNumber = "universityClearingAccountNumber";
        String universityClearingAccountChartOfAccounts = "universityClearingAccountChartOfAccounts";
        String unappliedSubAccountNumber = "unappliedSubAccountNumber";
        String unappliedObjectCode = "unappliedObjectCode";
        String unappliedObjectTypeCode = "unappliedObjectTypeCode";
        String unappliedSubObjectCode = "unappliedSubObjectCode";
        this.setupSystemInformationMockingForAdjusteeDocumentInitiator(adjusteeDocumentHeaderMock, "initiatorChartOfAccountsCode", "initiatorOrganizationCode", universityClearingAccountMock, "universityClearingAccountNumber", "universityClearingAccountChartOfAccounts", "unappliedSubAccountNumber", "unappliedObjectCode", "unappliedObjectTypeCode", "unappliedSubObjectCode", currentYear);
        String offsetDefinitionFinancialObjectFinancialObjectTypeCode = "offsetDefinitionFinancialObjectFinancialObjectTypeCode";
        String offsetDefinitionFinancialObjectCode = "offsetDefinitionFinancialObjectCode";
        this.setupOffsetDefinitionMocking("offsetDefinitionFinancialObjectFinancialObjectTypeCode", "offsetDefinitionFinancialObjectCode", currentYear, "universityClearingAccountChartOfAccounts", "APPA");
        List adjustmentNonAppliedHoldings = List.of();
        String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
        String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
        DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
        Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getNonAppliedHoldings()).thenReturn(adjustmentNonAppliedHoldings);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
        int initialSequenceNumber = 1;
        GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
        Mockito.when((Object)sequenceHelperMock.getSequenceCounter()).thenReturn((Object)initialSequenceNumber).thenReturn((Object)(initialSequenceNumber + 1));
        Mockito.when((Object)this.dataDictionaryServiceMock.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)"APPA");
        List pendingEntries = localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock, currentYear, sequenceHelperMock);
        Assertions.assertEquals((int)2, (int)pendingEntries.size());
        GeneralLedgerPendingEntry actualDebit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
        Assertions.assertEquals((Object)"D", (Object)actualDebit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)actualDebit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)actualDebit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)actualDebit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualDebit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)actualDebit.getAccountNumber());
        Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)actualDebit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"unappliedObjectCode", (Object)actualDebit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"unappliedObjectTypeCode", (Object)actualDebit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"-", (Object)actualDebit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"-", (Object)actualDebit.getProjectCode());
        Assertions.assertEquals((Object)"unappliedSubAccountNumber", (Object)actualDebit.getSubAccountNumber());
        Assertions.assertEquals((Object)adjusteeNahFinancialDocumentLineAmount, (Object)actualDebit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualDebit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)actualDebit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)actualDebit.getUniversityFiscalYear());
        Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualDebit.getTransactionLedgerEntrySequenceNumber());
        GeneralLedgerPendingEntry offsetCredit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
        Assertions.assertEquals((Object)"C", (Object)offsetCredit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)offsetCredit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)offsetCredit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)offsetCredit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetCredit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"universityClearingAccountNumber", (Object)offsetCredit.getAccountNumber());
        Assertions.assertEquals((Object)"universityClearingAccountChartOfAccounts", (Object)offsetCredit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectCode", (Object)offsetCredit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"offsetDefinitionFinancialObjectFinancialObjectTypeCode", (Object)offsetCredit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"-", (Object)offsetCredit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"-", (Object)offsetCredit.getProjectCode());
        Assertions.assertEquals((Object)"-", (Object)offsetCredit.getSubAccountNumber());
        Assertions.assertEquals((Object)adjusteeNahFinancialDocumentLineAmount, (Object)offsetCredit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"TP Generated Offset", (Object)offsetCredit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)offsetCredit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)offsetCredit.getUniversityFiscalYear());
        Assertions.assertEquals((int)(initialSequenceNumber + 1), (Integer)offsetCredit.getTransactionLedgerEntrySequenceNumber());
    }

    @Test
    void createPendingEntries_invoicePaidApplieds_new() throws Exception {
        String dash = "-";
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashFinancialSubObjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashProjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashSubAccountNumber();
        Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
        String appaDocumentTypeCode = "APPA";
        List adjusteeInvoicePaidApplieds = List.of();
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        String adjustmentIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
        KualiDecimal adjustmentIpaInvoiceItemAppliedAmount = new KualiDecimal(3);
        String invoiceDetailAccountAccountNumber = "invoiceDetailAccountAccountNumber";
        String invoiceDetailAccountChartOfAccounts = "invoiceDetailAccountChartOfAccounts";
        Account invoiceDetailAccountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)invoiceDetailAccountMock.getAccountNumber()).thenReturn((Object)"invoiceDetailAccountAccountNumber");
        Mockito.when((Object)invoiceDetailAccountMock.getChartOfAccountsCode()).thenReturn((Object)"invoiceDetailAccountChartOfAccounts");
        String invoiceDetailAccountsReceivableObjectCode = "invoiceDetailAccountsReceivableObjectCode";
        String financialObjectCode = "financialObjectCode";
        String financialObjectTypeCode = "financialObjectTypeCode";
        ObjectCode invoiceDetailAccountsReceivableObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
        Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectCode()).thenReturn((Object)"financialObjectCode");
        Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)"financialObjectTypeCode");
        String adjustmentInvoiceDetailProjectCode = "adjustmentInvoiceDetailProjectCode";
        String adjustmentInvoiceDetailSubAccountNumber = "adjustmentInvoiceDetailSubAccountNumber";
        String financialSubObjectCode = "financialSubObjectCode";
        CustomerInvoiceDetail adjustmentInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)adjustmentInvoiceDetailMock.getAccount()).thenReturn((Object)invoiceDetailAccountMock);
        Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObjectCode()).thenReturn((Object)"invoiceDetailAccountsReceivableObjectCode");
        Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObject()).thenReturn((Object)invoiceDetailAccountsReceivableObjectMock);
        Mockito.when((Object)adjustmentInvoiceDetailMock.getProjectCode()).thenReturn((Object)"adjustmentInvoiceDetailProjectCode");
        Mockito.when((Object)adjustmentInvoiceDetailMock.getSubAccountNumber()).thenReturn((Object)"adjustmentInvoiceDetailSubAccountNumber");
        Mockito.when((Object)adjustmentInvoiceDetailMock.getFinancialSubObjectCode()).thenReturn((Object)"financialSubObjectCode");
        CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        InvoicePaidApplied adjustmentInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentIpaInvoiceItemAppliedAmount);
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceDetail()).thenReturn((Object)adjustmentInvoiceDetailMock);
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocumentMock);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentInvoicePaidAppliedMock);
        String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
        String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
        DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
        Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
        int initialSequenceNumber = 1;
        GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
        Mockito.when((Object)sequenceHelperMock.getSequenceCounter()).thenReturn((Object)initialSequenceNumber).thenReturn((Object)(initialSequenceNumber + 1));
        Mockito.when((Object)this.dataDictionaryServiceMock.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)"APPA");
        List pendingEntries = localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock, currentYear, sequenceHelperMock);
        Assertions.assertEquals((int)2, (int)pendingEntries.size());
        GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
        Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)actualCredit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)actualCredit.getAccountNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)actualCredit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"financialObjectCode", (Object)actualCredit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"financialObjectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"financialSubObjectCode", (Object)actualCredit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)actualCredit.getProjectCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)actualCredit.getSubAccountNumber());
        Assertions.assertEquals((Object)adjustmentIpaInvoiceItemAppliedAmount, (Object)actualCredit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)actualCredit.getUniversityFiscalYear());
        Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
        GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
        Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)offsetDebit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)offsetDebit.getAccountNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)offsetDebit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)offsetDebit.getProjectCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)offsetDebit.getSubAccountNumber());
        Assertions.assertEquals((Object)adjustmentIpaInvoiceItemAppliedAmount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
        Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)offsetDebit.getUniversityFiscalYear());
    }

    @Test
    void createPendingEntries_invoicePaidApplieds_increased() throws Exception {
        String dash = "-";
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashFinancialSubObjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashProjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashSubAccountNumber();
        Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
        String appaDocumentTypeCode = "APPA";
        String adjusteeIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
        KualiDecimal adjusteeIpaInvoiceItemAppliedAmount = new KualiDecimal(1);
        InvoicePaidApplied adjusteeInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
        Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeIpaInvoiceItemAppliedAmount);
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeInvoicePaidAppliedMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        String adjustmentIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
        KualiDecimal adjustmentIpaInvoiceItemAppliedAmount = new KualiDecimal(3);
        String invoiceDetailAccountAccountNumber = "invoiceDetailAccountAccountNumber";
        String invoiceDetailAccountChartOfAccounts = "invoiceDetailAccountChartOfAccounts";
        Account invoiceDetailAccountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)invoiceDetailAccountMock.getAccountNumber()).thenReturn((Object)"invoiceDetailAccountAccountNumber");
        Mockito.when((Object)invoiceDetailAccountMock.getChartOfAccountsCode()).thenReturn((Object)"invoiceDetailAccountChartOfAccounts");
        String invoiceDetailAccountsReceivableObjectCode = "invoiceDetailAccountsReceivableObjectCode";
        String financialObjectCode = "financialObjectCode";
        String financialObjectTypeCode = "financialObjectTypeCode";
        ObjectCode invoiceDetailAccountsReceivableObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
        Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectCode()).thenReturn((Object)"financialObjectCode");
        Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)"financialObjectTypeCode");
        String adjustmentInvoiceDetailProjectCode = "adjustmentInvoiceDetailProjectCode";
        String adjustmentInvoiceDetailSubAccountNumber = "adjustmentInvoiceDetailSubAccountNumber";
        String financialSubObjectCode = "financialSubObjectCode";
        CustomerInvoiceDetail adjustmentInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)adjustmentInvoiceDetailMock.getAccount()).thenReturn((Object)invoiceDetailAccountMock);
        Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObjectCode()).thenReturn((Object)"invoiceDetailAccountsReceivableObjectCode");
        Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObject()).thenReturn((Object)invoiceDetailAccountsReceivableObjectMock);
        Mockito.when((Object)adjustmentInvoiceDetailMock.getProjectCode()).thenReturn((Object)"adjustmentInvoiceDetailProjectCode");
        Mockito.when((Object)adjustmentInvoiceDetailMock.getSubAccountNumber()).thenReturn((Object)"adjustmentInvoiceDetailSubAccountNumber");
        Mockito.when((Object)adjustmentInvoiceDetailMock.getFinancialSubObjectCode()).thenReturn((Object)"financialSubObjectCode");
        CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        InvoicePaidApplied adjustmentInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentIpaInvoiceItemAppliedAmount);
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceDetail()).thenReturn((Object)adjustmentInvoiceDetailMock);
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocumentMock);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentInvoicePaidAppliedMock);
        String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
        String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
        DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
        Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
        int initialSequenceNumber = 1;
        GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
        Mockito.when((Object)sequenceHelperMock.getSequenceCounter()).thenReturn((Object)initialSequenceNumber).thenReturn((Object)(initialSequenceNumber + 1));
        Mockito.when((Object)this.dataDictionaryServiceMock.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)"APPA");
        List pendingEntries = localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock, currentYear, sequenceHelperMock);
        Assertions.assertEquals((int)2, (int)pendingEntries.size());
        KualiDecimal expectedAmount = (KualiDecimal)adjustmentIpaInvoiceItemAppliedAmount.subtract((AbstractKualiDecimal)adjusteeIpaInvoiceItemAppliedAmount);
        GeneralLedgerPendingEntry actualCredit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
        Assertions.assertEquals((Object)"C", (Object)actualCredit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)actualCredit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)actualCredit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)actualCredit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualCredit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)actualCredit.getAccountNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)actualCredit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"financialObjectCode", (Object)actualCredit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"financialObjectTypeCode", (Object)actualCredit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"financialSubObjectCode", (Object)actualCredit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)actualCredit.getProjectCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)actualCredit.getSubAccountNumber());
        Assertions.assertEquals((Object)expectedAmount, (Object)actualCredit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualCredit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)actualCredit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)actualCredit.getUniversityFiscalYear());
        Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualCredit.getTransactionLedgerEntrySequenceNumber());
        GeneralLedgerPendingEntry offsetDebit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
        Assertions.assertEquals((Object)"D", (Object)offsetDebit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)offsetDebit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)offsetDebit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)offsetDebit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetDebit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)offsetDebit.getAccountNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)offsetDebit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)offsetDebit.getProjectCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)offsetDebit.getSubAccountNumber());
        Assertions.assertEquals((Object)expectedAmount, (Object)offsetDebit.getTransactionLedgerEntryAmount());
        Assertions.assertNull((Object)offsetDebit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)offsetDebit.getUniversityFiscalYear());
    }

    @Test
    void createPendingEntries_invoicePaidApplieds_decreased() throws Exception {
        String dash = "-";
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashFinancialSubObjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashProjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashSubAccountNumber();
        Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
        String appaDocumentTypeCode = "APPA";
        String adjusteeIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
        KualiDecimal adjusteeIpaInvoiceItemAppliedAmount = new KualiDecimal(3);
        InvoicePaidApplied adjusteeInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
        Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeIpaInvoiceItemAppliedAmount);
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeInvoicePaidAppliedMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        String adjustmentIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
        KualiDecimal adjustmentIpaInvoiceItemAppliedAmount = new KualiDecimal(1);
        String invoiceDetailAccountAccountNumber = "invoiceDetailAccountAccountNumber";
        String invoiceDetailAccountChartOfAccounts = "invoiceDetailAccountChartOfAccounts";
        Account invoiceDetailAccountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)invoiceDetailAccountMock.getAccountNumber()).thenReturn((Object)"invoiceDetailAccountAccountNumber");
        Mockito.when((Object)invoiceDetailAccountMock.getChartOfAccountsCode()).thenReturn((Object)"invoiceDetailAccountChartOfAccounts");
        String invoiceDetailAccountsReceivableObjectCode = "invoiceDetailAccountsReceivableObjectCode";
        String financialObjectCode = "financialObjectCode";
        String financialObjectTypeCode = "financialObjectTypeCode";
        ObjectCode invoiceDetailAccountsReceivableObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
        Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectCode()).thenReturn((Object)"financialObjectCode");
        Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)"financialObjectTypeCode");
        String adjustmentInvoiceDetailProjectCode = "adjustmentInvoiceDetailProjectCode";
        String adjustmentInvoiceDetailSubAccountNumber = "adjustmentInvoiceDetailSubAccountNumber";
        String financialSubObjectCode = "financialSubObjectCode";
        CustomerInvoiceDetail adjustmentInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)adjustmentInvoiceDetailMock.getAccount()).thenReturn((Object)invoiceDetailAccountMock);
        Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObjectCode()).thenReturn((Object)"invoiceDetailAccountsReceivableObjectCode");
        Mockito.when((Object)adjustmentInvoiceDetailMock.getAccountsReceivableObject()).thenReturn((Object)invoiceDetailAccountsReceivableObjectMock);
        Mockito.when((Object)adjustmentInvoiceDetailMock.getProjectCode()).thenReturn((Object)"adjustmentInvoiceDetailProjectCode");
        Mockito.when((Object)adjustmentInvoiceDetailMock.getSubAccountNumber()).thenReturn((Object)"adjustmentInvoiceDetailSubAccountNumber");
        Mockito.when((Object)adjustmentInvoiceDetailMock.getFinancialSubObjectCode()).thenReturn((Object)"financialSubObjectCode");
        CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        InvoicePaidApplied adjustmentInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentIpaInvoiceItemAppliedAmount);
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getInvoiceDetail()).thenReturn((Object)adjustmentInvoiceDetailMock);
        Mockito.when((Object)adjustmentInvoicePaidAppliedMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocumentMock);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentInvoicePaidAppliedMock);
        String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
        String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
        DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
        Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
        int initialSequenceNumber = 1;
        GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
        Mockito.when((Object)sequenceHelperMock.getSequenceCounter()).thenReturn((Object)initialSequenceNumber).thenReturn((Object)(initialSequenceNumber + 1));
        Mockito.when((Object)this.dataDictionaryServiceMock.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)"APPA");
        List pendingEntries = localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock, currentYear, sequenceHelperMock);
        Assertions.assertEquals((int)2, (int)pendingEntries.size());
        KualiDecimal expectedAmount = (KualiDecimal)adjusteeIpaInvoiceItemAppliedAmount.subtract((AbstractKualiDecimal)adjustmentIpaInvoiceItemAppliedAmount);
        GeneralLedgerPendingEntry actualDebit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
        Assertions.assertEquals((Object)"D", (Object)actualDebit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)actualDebit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)actualDebit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)actualDebit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualDebit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)actualDebit.getAccountNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)actualDebit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"financialObjectCode", (Object)actualDebit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"financialObjectTypeCode", (Object)actualDebit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"financialSubObjectCode", (Object)actualDebit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)actualDebit.getProjectCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)actualDebit.getSubAccountNumber());
        Assertions.assertEquals((Object)expectedAmount, (Object)actualDebit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualDebit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)actualDebit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)actualDebit.getUniversityFiscalYear());
        Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualDebit.getTransactionLedgerEntrySequenceNumber());
        GeneralLedgerPendingEntry offsetCredit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
        Assertions.assertEquals((Object)"C", (Object)offsetCredit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)offsetCredit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)offsetCredit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)offsetCredit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetCredit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)offsetCredit.getAccountNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)offsetCredit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailProjectCode", (Object)offsetCredit.getProjectCode());
        Assertions.assertEquals((Object)"adjustmentInvoiceDetailSubAccountNumber", (Object)offsetCredit.getSubAccountNumber());
        Assertions.assertEquals((Object)expectedAmount, (Object)offsetCredit.getTransactionLedgerEntryAmount());
        Assertions.assertNull((Object)offsetCredit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)offsetCredit.getUniversityFiscalYear());
    }

    @Test
    void createPendingEntries_invoicePaidApplieds_removed() throws Exception {
        String dash = "-";
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashFinancialSubObjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashProjectCode();
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"-").when((Object)localCutSpy)).getDashSubAccountNumber();
        Integer currentYear = Year.now(ZoneId.of("America/New_York")).getValue();
        String appaDocumentTypeCode = "APPA";
        String adjusteeIpaFinancialDocumentReferenceInvoiceNumber = "RN1";
        KualiDecimal adjusteeIpaInvoiceItemAppliedAmount = new KualiDecimal(1);
        String invoiceDetailAccountAccountNumber = "invoiceDetailAccountAccountNumber";
        String invoiceDetailAccountChartOfAccounts = "invoiceDetailAccountChartOfAccounts";
        Account invoiceDetailAccountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)invoiceDetailAccountMock.getAccountNumber()).thenReturn((Object)"invoiceDetailAccountAccountNumber");
        Mockito.when((Object)invoiceDetailAccountMock.getChartOfAccountsCode()).thenReturn((Object)"invoiceDetailAccountChartOfAccounts");
        String invoiceDetailAccountsReceivableObjectCode = "invoiceDetailAccountsReceivableObjectCode";
        String financialObjectCode = "financialObjectCode";
        String financialObjectTypeCode = "financialObjectTypeCode";
        ObjectCode invoiceDetailAccountsReceivableObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
        Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectCode()).thenReturn((Object)"financialObjectCode");
        Mockito.when((Object)invoiceDetailAccountsReceivableObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)"financialObjectTypeCode");
        String adjusteeInvoiceDetailProjectCode = "adjusteeInvoiceDetailProjectCode";
        String adjusteeInvoiceDetailSubAccountNumber = "adjusteeInvoiceDetailSubAccountNumber";
        String financialSubObjectCode = "financialSubObjectCode";
        CustomerInvoiceDetail adjusteeInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)adjusteeInvoiceDetailMock.getAccount()).thenReturn((Object)invoiceDetailAccountMock);
        Mockito.when((Object)adjusteeInvoiceDetailMock.getAccountsReceivableObjectCode()).thenReturn((Object)"invoiceDetailAccountsReceivableObjectCode");
        Mockito.when((Object)adjusteeInvoiceDetailMock.getAccountsReceivableObject()).thenReturn((Object)invoiceDetailAccountsReceivableObjectMock);
        Mockito.when((Object)adjusteeInvoiceDetailMock.getProjectCode()).thenReturn((Object)"adjusteeInvoiceDetailProjectCode");
        Mockito.when((Object)adjusteeInvoiceDetailMock.getSubAccountNumber()).thenReturn((Object)"adjusteeInvoiceDetailSubAccountNumber");
        Mockito.when((Object)adjusteeInvoiceDetailMock.getFinancialSubObjectCode()).thenReturn((Object)"financialSubObjectCode");
        CustomerInvoiceDocument customerInvoiceDocumentMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        InvoicePaidApplied adjusteeInvoicePaidAppliedMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"RN1");
        Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeIpaInvoiceItemAppliedAmount);
        Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getInvoiceDetail()).thenReturn((Object)adjusteeInvoiceDetailMock);
        Mockito.when((Object)adjusteeInvoicePaidAppliedMock.getCustomerInvoiceDocument()).thenReturn((Object)customerInvoiceDocumentMock);
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeInvoicePaidAppliedMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        List adjustmentInvoicePaidApplieds = List.of();
        String adjustmentDocumentHeaderOrganizationDocumentNumber = "adjustmentDocumentHeaderOrganizationDocumentNumber";
        String adjustmentDocumentHeaderDocumentDescription = "adjustmentDocumentHeaderDocumentDescription";
        DocumentHeader adjustmentDocumentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)adjustmentDocumentHeaderMock.getOrganizationDocumentNumber()).thenReturn((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber");
        Mockito.when((Object)adjustmentDocumentHeaderMock.getDocumentDescription()).thenReturn((Object)"adjustmentDocumentHeaderDocumentDescription");
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentHeader()).thenReturn((Object)adjustmentDocumentHeaderMock);
        int initialSequenceNumber = 1;
        GeneralLedgerPendingEntrySequenceHelper sequenceHelperMock = (GeneralLedgerPendingEntrySequenceHelper)Mockito.mock(GeneralLedgerPendingEntrySequenceHelper.class);
        Mockito.when((Object)sequenceHelperMock.getSequenceCounter()).thenReturn((Object)initialSequenceNumber).thenReturn((Object)(initialSequenceNumber + 1));
        Mockito.when((Object)this.dataDictionaryServiceMock.getDocumentTypeNameByClass(PaymentApplicationAdjustmentDocument.class)).thenReturn((Object)"APPA");
        List pendingEntries = localCutSpy.createPendingEntries((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock, currentYear, sequenceHelperMock);
        Assertions.assertEquals((int)2, (int)pendingEntries.size());
        GeneralLedgerPendingEntry actualDebit = (GeneralLedgerPendingEntry)pendingEntries.get(0);
        Assertions.assertEquals((Object)"D", (Object)actualDebit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)actualDebit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)actualDebit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)actualDebit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)actualDebit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)actualDebit.getAccountNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)actualDebit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"financialObjectCode", (Object)actualDebit.getFinancialObjectCode());
        Assertions.assertEquals((Object)"financialObjectTypeCode", (Object)actualDebit.getFinancialObjectTypeCode());
        Assertions.assertEquals((Object)"financialSubObjectCode", (Object)actualDebit.getFinancialSubObjectCode());
        Assertions.assertEquals((Object)"adjusteeInvoiceDetailProjectCode", (Object)actualDebit.getProjectCode());
        Assertions.assertEquals((Object)"adjusteeInvoiceDetailSubAccountNumber", (Object)actualDebit.getSubAccountNumber());
        Assertions.assertEquals((Object)adjusteeIpaInvoiceItemAppliedAmount, (Object)actualDebit.getTransactionLedgerEntryAmount());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderDocumentDescription", (Object)actualDebit.getTransactionLedgerEntryDescription());
        Assertions.assertNull((Object)actualDebit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)actualDebit.getUniversityFiscalYear());
        Assertions.assertEquals((int)initialSequenceNumber, (Integer)actualDebit.getTransactionLedgerEntrySequenceNumber());
        GeneralLedgerPendingEntry offsetCredit = (GeneralLedgerPendingEntry)pendingEntries.get(1);
        Assertions.assertEquals((Object)"C", (Object)offsetCredit.getTransactionDebitCreditCode());
        Assertions.assertEquals((Object)"AC", (Object)offsetCredit.getFinancialBalanceTypeCode());
        Assertions.assertEquals((Object)"APPA", (Object)offsetCredit.getFinancialDocumentTypeCode());
        Assertions.assertEquals((Object)"01", (Object)offsetCredit.getFinancialSystemOriginationCode());
        Assertions.assertEquals((Object)"adjustmentDocumentHeaderOrganizationDocumentNumber", (Object)offsetCredit.getOrganizationDocumentNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountAccountNumber", (Object)offsetCredit.getAccountNumber());
        Assertions.assertEquals((Object)"invoiceDetailAccountChartOfAccounts", (Object)offsetCredit.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"adjusteeInvoiceDetailProjectCode", (Object)offsetCredit.getProjectCode());
        Assertions.assertEquals((Object)"adjusteeInvoiceDetailSubAccountNumber", (Object)offsetCredit.getSubAccountNumber());
        Assertions.assertEquals((Object)adjusteeIpaInvoiceItemAppliedAmount, (Object)offsetCredit.getTransactionLedgerEntryAmount());
        Assertions.assertNull((Object)offsetCredit.getUniversityFiscalPeriodCode());
        Assertions.assertEquals((Integer)currentYear, (Integer)offsetCredit.getUniversityFiscalYear());
    }

    private void setupSystemInformationMockingForAdjusteeDocumentInitiator(DocumentHeader documentHeaderMock, String initiatorChartOfAccountsCode, String initiatorOrganizationCode, Account universityClearingAccountMock, String universityClearingAccountNumber, String universityClearingAccountChartOfAccounts, String unappliedSubAccountNumber, String unappliedObjectCode, String unappliedObjectTypeCode, String unappliedSubObjectCode, Integer currentYear) {
        String initiatorPrincipalId = "adjusteeInitiator";
        WorkflowDocument adjusteeWorkflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)adjusteeWorkflowDocumentMock.getInitiatorPrincipalId()).thenReturn((Object)"adjusteeInitiator");
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)adjusteeWorkflowDocumentMock);
        this.setupSystemInformationMockingForCurrentInitiator(initiatorChartOfAccountsCode, initiatorOrganizationCode, universityClearingAccountMock, universityClearingAccountNumber, universityClearingAccountChartOfAccounts, unappliedSubAccountNumber, unappliedObjectCode, unappliedObjectTypeCode, unappliedSubObjectCode, "adjusteeInitiator", currentYear);
    }

    private void setupSystemInformationMockingForCurrentInitiator(String initiatorChartOfAccountsCode, String initiatorOrganizationCode, Account universityClearingAccountMock, String universityClearingAccountNumber, String universityClearingAccountChartOfAccounts, String unappliedSubAccountNumber, String unappliedObjectCode, String unappliedObjectTypeCode, String unappliedSubObjectCode, String principalId, Integer currentYear) {
        ChartOrgHolder adjusteeChartOrgHolderMock = (ChartOrgHolder)Mockito.mock(ChartOrgHolder.class);
        Mockito.when((Object)adjusteeChartOrgHolderMock.getChartOfAccountsCode()).thenReturn((Object)initiatorChartOfAccountsCode);
        Mockito.when((Object)adjusteeChartOrgHolderMock.getOrganizationCode()).thenReturn((Object)initiatorOrganizationCode);
        Mockito.when((Object)this.financialSystemUserServiceMock.getPrimaryOrganization(principalId, "KFS-AR")).thenReturn((Object)adjusteeChartOrgHolderMock);
        Mockito.when((Object)this.universityDateServiceMock.getCurrentFiscalYear()).thenReturn((Object)currentYear);
        Mockito.when((Object)universityClearingAccountMock.getAccountNumber()).thenReturn((Object)universityClearingAccountNumber);
        Mockito.when((Object)universityClearingAccountMock.getChartOfAccountsCode()).thenReturn((Object)universityClearingAccountChartOfAccounts);
        ObjectCode adjusteeUniversityClearingObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
        Mockito.when((Object)adjusteeUniversityClearingObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)unappliedObjectTypeCode);
        SystemInformation adjusteeSystemInformationMock = (SystemInformation)Mockito.mock(SystemInformation.class);
        Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingAccount()).thenReturn((Object)universityClearingAccountMock);
        Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingSubAccountNumber()).thenReturn((Object)unappliedSubAccountNumber);
        Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingObjectCode()).thenReturn((Object)unappliedObjectCode);
        Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingObject()).thenReturn((Object)adjusteeUniversityClearingObjectMock);
        Mockito.when((Object)adjusteeSystemInformationMock.getUniversityClearingSubObjectCode()).thenReturn((Object)unappliedSubObjectCode);
        Mockito.when((Object)this.systemInformationServiceMock.getByProcessingChartOrgAndFiscalYear(initiatorChartOfAccountsCode, initiatorOrganizationCode, currentYear)).thenReturn((Object)adjusteeSystemInformationMock);
    }

    private void setupOffsetDefinitionMocking(String offsetDefinitionFinancialObjectFinancialObjectTypeCode, String offsetDefinitionFinancialObjectCode, Integer currentYear, String chartOfAccountsCode, String financialDocumentTypeCode) {
        ObjectCode offsetDefinitionFinancialObjectMock = (ObjectCode)Mockito.mock(ObjectCode.class);
        Mockito.when((Object)offsetDefinitionFinancialObjectMock.getFinancialObjectTypeCode()).thenReturn((Object)offsetDefinitionFinancialObjectFinancialObjectTypeCode);
        OffsetDefinition offsetDefinitionMock = (OffsetDefinition)Mockito.mock(OffsetDefinition.class);
        Mockito.when((Object)offsetDefinitionMock.getFinancialObjectCode()).thenReturn((Object)offsetDefinitionFinancialObjectCode);
        Mockito.when((Object)offsetDefinitionMock.getFinancialObject()).thenReturn((Object)offsetDefinitionFinancialObjectMock);
        Mockito.when((Object)this.offsetDefinitionServiceMock.getByPrimaryId(currentYear, chartOfAccountsCode, financialDocumentTypeCode, "AC")).thenReturn((Object)offsetDefinitionMock);
    }

    @Test
    void postProcess_invoiceWasRemoved() {
        String principalName = "pn1";
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
        InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        String adjusteeInvoiceNumber = "1";
        Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        CustomerInvoiceDocument invoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)adjusteeIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock);
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        List adjustmentInvoicePaidApplieds = List.of();
        String documentNumber = "dn1";
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
        String noteText = String.format("Reopened by %s with APPA %s", "pn1", "dn1");
        Note noteMock = (Note)Mockito.mock(Note.class);
        Mockito.when((Object)this.documentServiceMock.createNoteFromDocument((Document)invoiceMock, noteText)).thenReturn((Object)noteMock);
        localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
        ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setOpenInvoiceIndicator(true);
        ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setClosedDate(null);
        ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).addNote(noteMock);
        ((NoteService)Mockito.verify((Object)this.noteServiceMock)).save(noteMock);
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).updateDocument((Document)invoiceMock);
    }

    @Test
    void postProcess_invoiceWasDecreasedAndAppliedAmountIsNowZero() {
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        String principalName = "pn1";
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
        InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        String adjusteeInvoiceNumber = "1";
        Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        KualiDecimal adjusteeAppliedAmount = new KualiDecimal(2);
        Mockito.when((Object)adjusteeIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeAppliedAmount);
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        KualiDecimal adjustmentAppliedAmount = new KualiDecimal(0);
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentAppliedAmount);
        CustomerInvoiceDocument invoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)adjustmentIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
        String documentNumber = "dn1";
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
        String noteText = String.format("Reopened by %s with APPA %s", "pn1", "dn1");
        Note noteMock = (Note)Mockito.mock(Note.class);
        Mockito.when((Object)this.documentServiceMock.createNoteFromDocument((Document)invoiceMock, noteText)).thenReturn((Object)noteMock);
        localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
        ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setOpenInvoiceIndicator(true);
        ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setClosedDate(null);
        ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).addNote(noteMock);
        ((NoteService)Mockito.verify((Object)this.noteServiceMock)).save(noteMock);
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).updateDocument((Document)invoiceMock);
    }

    @Test
    void postProcess_invoicePaidAppliedsMarkedAsAdjusted() {
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        String principalName = "pn1";
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
        Date now = new Date(new java.util.Date().getTime());
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)now).when((Object)localCutSpy)).determineNow();
        InvoicePaidApplied adjusteeIpaMock1 = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        String adjusteeInvoiceNumber = "1";
        Mockito.when((Object)adjusteeIpaMock1.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        Mockito.when((Object)adjusteeIpaMock1.getInvoiceItemAppliedAmount()).thenReturn((Object)new KualiDecimal(1));
        Integer adjusteeIpaItemNumber = 1;
        Mockito.when((Object)adjusteeIpaMock1.getInvoiceItemNumber()).thenReturn((Object)adjusteeIpaItemNumber);
        InvoicePaidApplied adjusteeIpaMock2 = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjusteeIpaMock2.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        Mockito.when((Object)adjusteeIpaMock2.getInvoiceItemNumber()).thenReturn((Object)2);
        Mockito.when((Object)adjusteeIpaMock2.getInvoiceItemAppliedAmount()).thenReturn((Object)new KualiDecimal(2));
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock1, adjusteeIpaMock2);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)new KualiDecimal(3));
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemOpenAmount()).thenReturn((Object)new KualiDecimal(3));
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemNumber()).thenReturn((Object)adjusteeIpaItemNumber);
        CustomerInvoiceDocument invoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)adjustmentIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
        String documentNumber = "dn1";
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
        localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
        ((InvoicePaidApplied)Mockito.verify((Object)adjusteeIpaMock1)).setAdjusted(true);
        ((InvoicePaidApplied)Mockito.verify((Object)adjusteeIpaMock2, (VerificationMode)Mockito.times((int)0))).setAdjusted(true);
        ((BusinessObjectService)Mockito.verify((Object)this.businessObjectServiceMock)).save((PersistableBusinessObject)adjusteeIpaMock1);
    }

    @Test
    void postProcess_invoiceWasAddedAndOpenAmountIsZero() {
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        String principalName = "pn1";
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
        Date now = new Date(new java.util.Date().getTime());
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)now).when((Object)localCutSpy)).determineNow();
        InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        String adjusteeInvoiceNumber = "1";
        Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        KualiDecimal adjusteeAppliedAmount = new KualiDecimal(2);
        Mockito.when((Object)adjusteeIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeAppliedAmount);
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        CustomerInvoiceDocument adjusteeInvoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)adjusteeIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)adjusteeInvoiceMock);
        InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        String adjustmentInvoiceNumber = "2";
        Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"2");
        KualiDecimal adjustmentAppliedAmount = new KualiDecimal(3);
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentAppliedAmount);
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemOpenAmount()).thenReturn((Object)KualiDecimal.ZERO);
        CustomerInvoiceDocument adjustmentInvoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)adjustmentIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)adjustmentInvoiceMock);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
        String documentNumber = "dn1";
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
        String reopenedNoteText = String.format("Reopened by %s with APPA %s", "pn1", "dn1");
        Note reopenedNoteMock = (Note)Mockito.mock(Note.class);
        Mockito.when((Object)this.documentServiceMock.createNoteFromDocument((Document)adjusteeInvoiceMock, reopenedNoteText)).thenReturn((Object)reopenedNoteMock);
        String closedNoteText = String.format("Closed by %s with APPA %s", "pn1", "dn1");
        Note closedNoteMock = (Note)Mockito.mock(Note.class);
        Mockito.when((Object)this.documentServiceMock.createNoteFromDocument((Document)adjustmentInvoiceMock, closedNoteText)).thenReturn((Object)closedNoteMock);
        localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
        ((CustomerInvoiceDocument)Mockito.verify((Object)adjusteeInvoiceMock)).setOpenInvoiceIndicator(true);
        ((CustomerInvoiceDocument)Mockito.verify((Object)adjusteeInvoiceMock)).setClosedDate(null);
        ((CustomerInvoiceDocument)Mockito.verify((Object)adjusteeInvoiceMock)).addNote(reopenedNoteMock);
        ((NoteService)Mockito.verify((Object)this.noteServiceMock)).save(reopenedNoteMock);
        ((CustomerInvoiceDocument)Mockito.verify((Object)adjustmentInvoiceMock)).setOpenInvoiceIndicator(false);
        ((CustomerInvoiceDocument)Mockito.verify((Object)adjustmentInvoiceMock)).setClosedDate(now);
        ((CustomerInvoiceDocument)Mockito.verify((Object)adjustmentInvoiceMock)).addNote(closedNoteMock);
        ((NoteService)Mockito.verify((Object)this.noteServiceMock)).save(closedNoteMock);
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).updateDocument((Document)adjusteeInvoiceMock);
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).updateDocument((Document)adjustmentInvoiceMock);
    }

    @Test
    void postProcess_invoiceWasIncreasedAndOpenAmountIsNowZero() {
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        String principalName = "pn1";
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
        Date now = new Date(new java.util.Date().getTime());
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)now).when((Object)localCutSpy)).determineNow();
        InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        String adjusteeInvoiceNumber = "1";
        Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        KualiDecimal adjusteeAppliedAmount = new KualiDecimal(2);
        Mockito.when((Object)adjusteeIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeAppliedAmount);
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        KualiDecimal adjustmentAppliedAmount = new KualiDecimal(3);
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentAppliedAmount);
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemOpenAmount()).thenReturn((Object)KualiDecimal.ZERO);
        CustomerInvoiceDocument invoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)adjustmentIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
        String documentNumber = "dn1";
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
        String noteText = String.format("Closed by %s with APPA %s", "pn1", "dn1");
        Note noteMock = (Note)Mockito.mock(Note.class);
        Mockito.when((Object)this.documentServiceMock.createNoteFromDocument((Document)invoiceMock, noteText)).thenReturn((Object)noteMock);
        localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
        ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setOpenInvoiceIndicator(false);
        ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).setClosedDate(now);
        ((CustomerInvoiceDocument)Mockito.verify((Object)invoiceMock)).addNote(noteMock);
        ((NoteService)Mockito.verify((Object)this.noteServiceMock)).save(noteMock);
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).updateDocument((Document)invoiceMock);
    }

    @Test
    void postProcess_invoicePaidAppliedOpenAmountsAreUpdated() {
        PaymentApplicationAdjustmentDocumentService localCutSpy = (PaymentApplicationAdjustmentDocumentService)Mockito.spy((Object)this.cut);
        String principalName = "pn1";
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)"pn1").when((Object)localCutSpy)).getPrincipalName();
        Date now = new Date(new java.util.Date().getTime());
        ((PaymentApplicationAdjustmentDocumentService)Mockito.doReturn((Object)now).when((Object)localCutSpy)).determineNow();
        InvoicePaidApplied adjusteeIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        String adjusteeInvoiceNumber = "1";
        Mockito.when((Object)adjusteeIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        KualiDecimal adjusteeAppliedAmount = new KualiDecimal(2);
        Mockito.when((Object)adjusteeIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjusteeAppliedAmount);
        List<InvoicePaidApplied> adjusteeInvoicePaidApplieds = List.of(adjusteeIpaMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)adjusteeDocumentMock.getInvoicePaidApplieds()).thenReturn(adjusteeInvoicePaidApplieds);
        KualiDecimal invoiceItemOpenAmount = new KualiDecimal(10);
        CustomerInvoiceDetail customerInvoiceDetailMock = (CustomerInvoiceDetail)Mockito.mock(CustomerInvoiceDetail.class);
        Mockito.when((Object)customerInvoiceDetailMock.getAmountOpen()).thenReturn((Object)invoiceItemOpenAmount);
        InvoicePaidApplied adjustmentIpaMock = (InvoicePaidApplied)Mockito.mock(InvoicePaidApplied.class);
        Mockito.when((Object)adjustmentIpaMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)"1");
        Mockito.when((Object)adjusteeIpaMock.getInvoiceItemNumber()).thenReturn((Object)1);
        Mockito.when((Object)this.customerInvoiceDetailServiceMock.getCustomerInvoiceDetail("1", adjustmentIpaMock.getInvoiceItemNumber())).thenReturn((Object)customerInvoiceDetailMock);
        KualiDecimal adjustmentAppliedAmount = new KualiDecimal(3);
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemAppliedAmount()).thenReturn((Object)adjustmentAppliedAmount);
        Mockito.when((Object)adjustmentIpaMock.getInvoiceItemOpenAmount()).thenReturn((Object)KualiDecimal.ZERO);
        CustomerInvoiceDocument invoiceMock = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)adjustmentIpaMock.getCustomerInvoiceDocument()).thenReturn((Object)invoiceMock);
        List<InvoicePaidApplied> adjustmentInvoicePaidApplieds = List.of(adjustmentIpaMock);
        String documentNumber = "dn1";
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getInvoicePaidApplieds()).thenReturn(adjustmentInvoicePaidApplieds);
        Mockito.when((Object)adjustmentDocumentMock.getDocumentNumber()).thenReturn((Object)"dn1");
        String noteText = String.format("Closed by %s with APPA %s", "pn1", "dn1");
        Note noteMock = (Note)Mockito.mock(Note.class);
        Mockito.when((Object)this.documentServiceMock.createNoteFromDocument((Document)invoiceMock, noteText)).thenReturn((Object)noteMock);
        localCutSpy.postProcess((Document)adjusteeDocumentMock, (Document)adjustmentDocumentMock);
        ((InvoicePaidApplied)Mockito.verify((Object)adjustmentIpaMock)).setInvoiceItemOpenAmount(invoiceItemOpenAmount);
    }

    @Test
    void fillInFiscalPeriodYear_early_return_for_empty_collection() {
        List glpes = List.of();
        this.cut.fillInFiscalPeriodYear(glpes);
        ((UniversityDateService)Mockito.verify((Object)this.universityDateServiceMock, (VerificationMode)Mockito.times((int)0))).getCurrentUniversityDate();
    }

    @Test
    void fillInFiscalPeriodYear_both_pieces_of_data_present_is_a_noop() {
        String glpeFiscalPeriod = "glpeFiscalPeriod";
        Integer glpeFiscalYear = ZonedDateTime.now().getYear();
        GeneralLedgerPendingEntry glpeMock = (GeneralLedgerPendingEntry)Mockito.mock(GeneralLedgerPendingEntry.class);
        Mockito.when((Object)glpeMock.getUniversityFiscalPeriodCode()).thenReturn((Object)"glpeFiscalPeriod");
        Mockito.when((Object)glpeMock.getUniversityFiscalYear()).thenReturn((Object)glpeFiscalYear);
        List<GeneralLedgerPendingEntry> glpes = List.of(glpeMock);
        String universityFiscalAccountingPeriod = "universityFiscalAccountingPeriod";
        Integer universityFiscalYear = 1999;
        UniversityDate universityDateMock = (UniversityDate)Mockito.mock(UniversityDate.class);
        Mockito.when((Object)universityDateMock.getUniversityFiscalAccountingPeriod()).thenReturn((Object)"universityFiscalAccountingPeriod");
        Mockito.when((Object)universityDateMock.getUniversityFiscalYear()).thenReturn((Object)universityFiscalYear);
        Mockito.when((Object)this.universityDateServiceMock.getCurrentUniversityDate()).thenReturn((Object)universityDateMock);
        this.cut.fillInFiscalPeriodYear(glpes);
        ((UniversityDateService)Mockito.verify((Object)this.universityDateServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentUniversityDate();
        ((GeneralLedgerPendingEntry)Mockito.verify((Object)glpeMock, (VerificationMode)Mockito.times((int)0))).setUniversityFiscalPeriodCode(ArgumentMatchers.anyString());
        ((GeneralLedgerPendingEntry)Mockito.verify((Object)glpeMock, (VerificationMode)Mockito.times((int)0))).setUniversityFiscalYear(Integer.valueOf(ArgumentMatchers.anyInt()));
    }

    @ParameterizedTest(name="{2}")
    @MethodSource(value={"fillInFiscalPeriodYearArgs"})
    void fillInFiscalPeriodYear_at_least_one_piece_of_data_is_missing_so_both_should_be_updated(String glpeFiscalPeriod, Integer glpeFiscalYear, String description) {
        GeneralLedgerPendingEntry glpeMock = (GeneralLedgerPendingEntry)Mockito.mock(GeneralLedgerPendingEntry.class);
        Mockito.when((Object)glpeMock.getUniversityFiscalPeriodCode()).thenReturn((Object)glpeFiscalPeriod);
        Mockito.when((Object)glpeMock.getUniversityFiscalYear()).thenReturn((Object)glpeFiscalYear);
        List<GeneralLedgerPendingEntry> glpes = List.of(glpeMock);
        String universityFiscalAccountingPeriod = "universityFiscalAccountingPeriod";
        Integer universityFiscalYear = 1999;
        UniversityDate universityDateMock = (UniversityDate)Mockito.mock(UniversityDate.class);
        Mockito.when((Object)universityDateMock.getUniversityFiscalAccountingPeriod()).thenReturn((Object)"universityFiscalAccountingPeriod");
        Mockito.when((Object)universityDateMock.getUniversityFiscalYear()).thenReturn((Object)universityFiscalYear);
        Mockito.when((Object)this.universityDateServiceMock.getCurrentUniversityDate()).thenReturn((Object)universityDateMock);
        this.cut.fillInFiscalPeriodYear(glpes);
        ((UniversityDateService)Mockito.verify((Object)this.universityDateServiceMock, (VerificationMode)Mockito.times((int)1))).getCurrentUniversityDate();
        ((GeneralLedgerPendingEntry)Mockito.verify((Object)glpeMock)).setUniversityFiscalPeriodCode("universityFiscalAccountingPeriod");
        ((GeneralLedgerPendingEntry)Mockito.verify((Object)glpeMock)).setUniversityFiscalYear(universityFiscalYear);
    }

    private static Stream<Arguments> fillInFiscalPeriodYearArgs() {
        Integer currentYear = ZonedDateTime.now().getYear();
        return Stream.of(Arguments.of((Object[])new Object[]{"currentFiscalPeriod", null, "Year is null"}), Arguments.of((Object[])new Object[]{null, currentYear, "Period is null"}), Arguments.of((Object[])new Object[]{"", currentYear, "Period is empty"}), Arguments.of((Object[])new Object[]{" ", currentYear, "Period is blank"}), Arguments.of((Object[])new Object[]{null, null, "Period & Year are null"}), Arguments.of((Object[])new Object[]{"", null, "Period is empty & Year is null"}), Arguments.of((Object[])new Object[]{" ", null, "Period is blank & Year is null"}));
    }
}

