/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.datadictionary.validation.result.DictionaryValidationResult;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.service.PredeterminedBillingScheduleMaintenanceService;
import org.kuali.kfs.module.ar.document.validation.PredeterminedBillingScheduleRule;
import org.kuali.kfs.module.ar.service.impl.AccountsReceivableModuleBillingServiceImpl;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class PredeterminedBillingScheduleRuleTest {
    private static final String PROPOSAL_NUM = "1";
    private static final String CHART_CODE = "BL";
    private static final String ACCT_NUM = "1234567";
    @Spy
    private PredeterminedBillingScheduleRule cutSpy = new PredeterminedBillingScheduleRule();
    @Mock
    private AccountsReceivableModuleBillingServiceImpl accountsReceivableModuleBillingSvcMock;
    @Mock
    private Bill bill1Mock;
    @Mock
    private Bill bill2Mock;
    @Mock
    private ContractsAndGrantsBillingAward awardMock;
    @Mock
    private ContractsAndGrantsBillingAwardAccount awardAccountMock;
    @Mock
    private DictionaryValidationService dictionaryValidationSvcMock;
    @Mock
    private MaintenanceDocument predeterminedBillingScheduleMaintDocMock;
    @Mock
    private PredeterminedBillingSchedule predeterminedBillingScheduleMock;
    @Mock
    private PredeterminedBillingScheduleMaintenanceService predeterminedBillingScheduleMaintenanceSvdMock;

    PredeterminedBillingScheduleRuleTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        Mockito.when((Object)this.awardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)this.awardMock.getActiveAwardAccounts()).thenReturn(Collections.singletonList(this.awardAccountMock));
        Mockito.when((Object)this.awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.awardAccountMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getProposalNumber()).thenReturn((Object)PROPOSAL_NUM);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getChartOfAccountsCode()).thenReturn((Object)CHART_CODE);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)ACCT_NUM);
        this.setupBillMocks();
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(48000.0));
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)this.accountsReceivableModuleBillingSvcMock).when((Object)this.cutSpy)).getAccountsReceivableModuleBillingService();
        ((PredeterminedBillingScheduleRule)Mockito.doReturn((Object)this.predeterminedBillingScheduleMaintenanceSvdMock).when((Object)this.cutSpy)).getPredeterminedBillingScheduleMaintenanceService();
        this.cutSpy.newPredeterminedBillingScheduleCopy = this.predeterminedBillingScheduleMock;
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)new DictionaryValidationResult());
        this.cutSpy.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        GlobalVariables.getMessageMap().getErrorMessages().clear();
    }

    @AfterEach
    void tearDown() {
        this.cutSpy.setDictionaryValidationService(null);
        GlobalVariables.getMessageMap().getErrorMessages().clear();
    }

    private void setupBillMocks() {
        this.setupBill(this.bill1Mock, 1L, "test*1");
        this.setupBill(this.bill2Mock, 2L, "test*2");
        ArrayList<Bill> bills = new ArrayList<Bill>();
        bills.add(this.bill1Mock);
        bills.add(this.bill2Mock);
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getBills()).thenReturn(bills);
    }

    private void setupBill(Bill bill1Mock, long l, String s) {
        Mockito.when((Object)bill1Mock.getBillIdentifier()).thenReturn((Object)l);
        Mockito.when((Object)bill1Mock.getBillNumber()).thenReturn((Object)s);
        Mockito.when((Object)bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)bill1Mock.isActive()).thenReturn((Object)true);
    }

    @Test
    void processCustomAddCollectionLineBusinessRules_Valid() {
        Bill newBillMock = (Bill)Mockito.mock(Bill.class);
        Mockito.when((Object)newBillMock.getBillIdentifier()).thenReturn((Object)3L);
        Mockito.when((Object)newBillMock.getBillNumber()).thenReturn((Object)"test*3");
        Mockito.when((Object)newBillMock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(1000.0));
        Assertions.assertTrue((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Bills", (PersistableBusinessObject)newBillMock));
    }

    @Test
    void processCustomAddCollectionLineBusinessRules_DuplicateBillNumber() {
        Bill newBillMock = (Bill)Mockito.mock(Bill.class);
        Mockito.when((Object)newBillMock.getBillIdentifier()).thenReturn((Object)3L);
        Mockito.when((Object)newBillMock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)newBillMock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(2000.0));
        Assertions.assertFalse((boolean)this.cutSpy.processCustomAddCollectionLineBusinessRules(null, "Bills", (PersistableBusinessObject)newBillMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.Bills")).get(0);
        Assertions.assertEquals((Object)"error.duplicate.bill.number", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)0, (int)messageParameters.length);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_Valid() {
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillingFrequencyNoPredeterminedBilling() {
        Mockito.when((Object)this.awardMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup")).get(0);
        Assertions.assertEquals((Object)"error.cg.award.predetermined.billing.schedule.incorrect.billing.frequency", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)1, (int)messageParameters.length);
        Assertions.assertEquals((Object)PROPOSAL_NUM, (Object)messageParameters[0]);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_DuplicateMilestoneNumbers_OneCopiedToInvoice() {
        Mockito.when((Object)this.bill2Mock.getBillNumber()).thenReturn((Object)"test*1");
        Mockito.when((Object)this.predeterminedBillingScheduleMaintenanceSvdMock.hasBillBeenCopiedToInvoice(PROPOSAL_NUM, this.bill1Mock.getBillIdentifier().toString())).thenReturn((Object)true);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        String errorPath = "bills[1].billNumber";
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assertions.assertEquals((Object)"error.duplicate.bill.number", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_DuplicateMilestoneNumbers_NoneCopiedToInvoice() {
        Mockito.when((Object)this.bill2Mock.getBillNumber()).thenReturn((Object)"test*1");
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)2, (int)GlobalVariables.getMessageMap().getErrorCount());
        String errorPath = "bills[0].billNumber";
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assertions.assertEquals((Object)"error.duplicate.bill.number", (Object)errorMessage.getErrorKey());
        errorPath = "bills[1].billNumber";
        errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject." + errorPath)).get(0);
        Assertions.assertEquals((Object)"error.duplicate.bill.number", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_MilestoneAmountGreaterThanAwardAmount_CurrentSchedule() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.totalScheduledAccount");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.bill.total.exceeds.award.total", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillInactiveLargeAmount_CurrentSchedule() {
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, ACCT_NUM)).thenReturn((Object)new KualiDecimal(1000.0));
        Mockito.when((Object)this.bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(50000.0));
        Mockito.when((Object)this.bill1Mock.isActive()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_MilestoneAmountGreaterThanAwardAmount_AllSchedules() {
        Mockito.when((Object)this.bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(5000.0));
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.totalScheduledAccount");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.bill.total.exceeds.award.total", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillInactiveLargeAmount_AllSchedules() {
        Mockito.when((Object)this.bill1Mock.getEstimatedAmount()).thenReturn((Object)new KualiDecimal(5000.0));
        Mockito.when((Object)this.bill1Mock.isActive()).thenReturn((Object)false);
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_billMissingEstimatedAmount_noGlobalErrors() {
        Mockito.when((Object)this.bill1Mock.getEstimatedAmount()).thenReturn(null);
        Assertions.assertTrue((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_ChartAccountDoesNotExistOnAward() {
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAccountNumber()).thenReturn((Object)"9876543");
        Mockito.when((Object)this.accountsReceivableModuleBillingSvcMock.getBillsTotalAmountForOtherSchedules(PROPOSAL_NUM, CHART_CODE, "9876543")).thenReturn((Object)KualiDecimal.ZERO);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.accountNumber");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.predetermined.billing.schedule.account.does.not.exist.on.award", (Object)errorMessage.getErrorKey());
    }

    @Test
    void processCustomRouteDocumentBusinessRules_AwardDoesNotExist_NullAward() {
        Mockito.when((Object)this.predeterminedBillingScheduleMock.getAward()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.award.does.not.exist", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)1, (int)messageParameters.length);
        Assertions.assertEquals((Object)PROPOSAL_NUM, (Object)messageParameters[0]);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_AwardDoesNotExist_NullProposalNumber() {
        Mockito.when((Object)this.awardMock.getProposalNumber()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.proposalNumberForAwardAccountLookup");
        Assertions.assertNotNull((Object)errorMessages);
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assertions.assertEquals((Object)"error.award.does.not.exist", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assertions.assertEquals((int)1, (int)messageParameters.length);
        Assertions.assertEquals((Object)PROPOSAL_NUM, (Object)messageParameters[0]);
    }

    @Test
    void processCustomRouteDocumentBusinessRules_BillFailsDataDictionaryValidation() {
        DictionaryValidationResult dictionaryValidationResultMock = (DictionaryValidationResult)Mockito.mock(DictionaryValidationResult.class);
        Mockito.when((Object)dictionaryValidationResultMock.getNumberOfErrors()).thenReturn((Object)1);
        Mockito.when((Object)this.dictionaryValidationSvcMock.validate(ArgumentMatchers.any(Bill.class))).thenReturn((Object)dictionaryValidationResultMock);
        Assertions.assertFalse((boolean)this.cutSpy.processCustomRouteDocumentBusinessRules(this.predeterminedBillingScheduleMaintDocMock));
    }
}

