/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.kns.service.DictionaryValidationService;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.businessobject.PaymentMedium;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CashControlDocumentRule;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.context.IntegTestUtils;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.impl.document.WorkflowDocumentImpl;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.springframework.util.AutoPopulatingList;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class CashControlDocumentRuleTest {
    private CashControlDocumentRule cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;
    @Mock
    private CashControlDocument cashControlDocMock;
    @Mock
    private DictionaryValidationService dictionaryValidationSvcMock;
    @Mock
    private DocumentService documentSvcMock;
    private static final KualiDecimal NEGATIVE_AMOUNT = new KualiDecimal(-1);
    private static final KualiDecimal POSITIVE_AMOUNT = new KualiDecimal(2);
    private static final String CUSTOMER_PAYMENT_MEDIUM_NOT_VALID_CODE = "MEH";
    private List<CashControlDetail> cashControlDetails = new ArrayList<CashControlDetail>();

    CashControlDocumentRuleTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CK");
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetails()).thenReturn(this.cashControlDetails);
        Mockito.when((Object)this.cashControlDocMock.getCashControlDetail(ArgumentMatchers.anyInt())).thenAnswer(invocation -> this.cashControlDetails.get((Integer)invocation.getArgument(0)));
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("customerPaymentMediumCode", "CA");
        Mockito.when((Object)((PaymentMedium)this.businessObjectSvcMock.findByPrimaryKey(PaymentMedium.class, criteria))).thenReturn((Object)((PaymentMedium)Mockito.mock(PaymentMedium.class)));
        this.cut = new CashControlDocumentRule();
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
        this.cut.setDictionaryValidationService(this.dictionaryValidationSvcMock);
        this.cut.setDocumentService(this.documentSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @AfterEach
    void tearDown() {
        this.cut.setDictionaryValidationService(null);
    }

    @Test
    void validateCashControlDetails_ValidLineAmount_True() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(POSITIVE_AMOUNT);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertTrue((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock), (String)("Document should have passed validation. " + GlobalVariables.getMessageMap()));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void validateCashControlDetails_NegativeLineAmount_False() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(NEGATIVE_AMOUNT);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertFalse((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.cashControlDetail[0].financialDocumentLineAmount")).get(0);
        Assertions.assertEquals((Object)"error.ar.LineAmountCannotBeNegative", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateCashControlDetails_ZeroLineAmount_False() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertFalse((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.cashControlDetail[0].financialDocumentLineAmount")).get(0);
        Assertions.assertEquals((Object)"error.ar.LineAmountCannotBeZero", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateCashControlDetails_ZeroLineAmount_CanceledPaymentApplication_True() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        PaymentApplicationDocument paymentApplicationDocMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isCanceled()).thenReturn((Object)true);
        FinancialSystemDocumentHeader financialSystemDocumentHeaderMock = (FinancialSystemDocumentHeader)Mockito.mock(FinancialSystemDocumentHeader.class);
        Mockito.when((Object)financialSystemDocumentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)paymentApplicationDocMock.getFinancialSystemDocumentHeader()).thenReturn((Object)financialSystemDocumentHeaderMock);
        cashControlDetail.setReferenceFinancialDocument(paymentApplicationDocMock);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertTrue((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void validateCashControlDetails_ZeroLineAmount_DisapprovedPaymentApplication_True() {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        PaymentApplicationDocument paymentApplicationDocMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isDisapproved()).thenReturn((Object)true);
        FinancialSystemDocumentHeader financialSystemDocumentHeaderMock = (FinancialSystemDocumentHeader)Mockito.mock(FinancialSystemDocumentHeader.class);
        Mockito.when((Object)financialSystemDocumentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)paymentApplicationDocMock.getFinancialSystemDocumentHeader()).thenReturn((Object)financialSystemDocumentHeaderMock);
        cashControlDetail.setReferenceFinancialDocument(paymentApplicationDocMock);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertTrue((boolean)this.cut.validateCashControlDetails(this.cashControlDocMock));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkPaymentMedium_Valid_True() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Assertions.assertTrue((boolean)this.cut.checkPaymentMedium(this.cashControlDocMock), (String)("Business Rules should not have failed: " + IntegTestUtils.dumpMessageMapErrors()));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkPaymentMedium_NotValid_False() {
        this.cashControlDocMock.setCustomerPaymentMediumCode(CUSTOMER_PAYMENT_MEDIUM_NOT_VALID_CODE);
        Assertions.assertFalse((boolean)this.cut.checkPaymentMedium(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.customerPaymentMediumCode")).get(0);
        Assertions.assertEquals((Object)"error.ar.CustomerPaymentMediumIsNotValid", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void checkPaymentMedium_Null_False() {
        this.cashControlDocMock.setCustomerPaymentMediumCode(null);
        Assertions.assertFalse((boolean)this.cut.checkPaymentMedium(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.customerPaymentMediumCode")).get(0);
        Assertions.assertEquals((Object)"error.ar.CustomerPaymentMediumIsNotValid", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void checkRefDocNumber_Valid_Cash_True() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.cashControlDocMock.getReferenceFinancialDocumentNumber()).thenReturn((Object)"12345");
        Mockito.when((Object)this.documentSvcMock.documentExists("12345")).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.cut.checkRefDocNumber(this.cashControlDocMock), (String)("Business Rules should not have failed: " + IntegTestUtils.dumpMessageMapErrors()));
        Assertions.assertEquals((int)0, (int)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    void checkRefDocNumber_Null_Cash_False() {
        Mockito.when((Object)this.cashControlDocMock.getCustomerPaymentMediumCode()).thenReturn((Object)"CA");
        Mockito.when((Object)this.cashControlDocMock.getReferenceFinancialDocumentNumber()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.checkRefDocNumber(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.referenceFinancialDocumentNumber")).get(0);
        Assertions.assertEquals((Object)"error.ar.ReferenceDocNumberMustBeValidforPaymentMediumCash", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void checkAllAppDocsApproved_NoAppDocs_True() {
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_ApprovedAppDoc_True() {
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isApproved()).thenReturn((Object)true);
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument(workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    private CashControlDetail setupCashControlDetailWithWorkflowDocument(WorkflowDocument workflowDocumentMock) {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
        PaymentApplicationDocument paymentApplicationDocMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        Mockito.when((Object)paymentApplicationDocMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        cashControlDetail.setReferenceFinancialDocument(paymentApplicationDocMock);
        return cashControlDetail;
    }

    @Test
    void checkAllAppDocsApproved_ProcessedAppDoc_True() {
        WorkflowDocumentImpl workflowDocumentMock = (WorkflowDocumentImpl)Mockito.mock(WorkflowDocumentImpl.class);
        Mockito.when((Object)workflowDocumentMock.isProcessed()).thenReturn((Object)true);
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)workflowDocumentMock)).isApproved();
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument((WorkflowDocument)workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_FinalAppDoc_True() {
        WorkflowDocumentImpl workflowDocumentMock = (WorkflowDocumentImpl)Mockito.mock(WorkflowDocumentImpl.class);
        Mockito.when((Object)workflowDocumentMock.isFinal()).thenReturn((Object)true);
        ((WorkflowDocumentImpl)Mockito.doCallRealMethod().when((Object)workflowDocumentMock)).isApproved();
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument((WorkflowDocument)workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_CanceledAppDoc_True() {
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isCanceled()).thenReturn((Object)true);
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument(workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_DisapprovedAppDoc_False() {
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isDisapproved()).thenReturn((Object)true);
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument(workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertTrue((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
    }

    @Test
    void checkAllAppDocsApproved_EnrouteAppDoc_False() {
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.isEnroute()).thenReturn((Object)true);
        CashControlDetail cashControlDetail = this.setupCashControlDetailWithWorkflowDocument(workflowDocumentMock);
        this.cashControlDetails.add(cashControlDetail);
        Assertions.assertFalse((boolean)this.cut.checkAllAppDocsApprovedOrCanceled(this.cashControlDocMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.cashControlDetail[0].status")).get(0);
        Assertions.assertEquals((Object)"error.ar.AllApplicationDocumentsMustBeApprovedCanceledOrDisapproved", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void checkCashControlDocumentHasDetails_HasDetails_True() {
        this.cashControlDetails.add(new CashControlDetail());
        Assertions.assertTrue((boolean)this.cut.checkCashControlDocumentHasDetails(this.cashControlDocMock));
    }

    @Test
    void checkCashControlDocumentHasDetails_NoDetails_False() {
        Assertions.assertFalse((boolean)this.cut.checkCashControlDocumentHasDetails(this.cashControlDocMock));
    }
}

