/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentHeaderService;
import org.kuali.kfs.krad.service.KRADServiceLocatorWeb;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsCollectionActivityInvoiceDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsCollectionActivityDocument;
import org.kuali.kfs.module.ar.document.validation.impl.ContractsGrantsCollectionActivityDocumentRule;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class ContractsGrantsCollectionActivityDocumentRuleTest {
    private ContractsGrantsCollectionActivityDocumentRule cut;
    private ContractsGrantsCollectionActivityDocument contractsGrantsCollectionActivityDocument;
    private static final String ACTIVITY_CODE = "LSTS";

    ContractsGrantsCollectionActivityDocumentRuleTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        try (MockedStatic kradServiceLocatorWebStaticMock = Mockito.mockStatic(KRADServiceLocatorWeb.class);){
            DocumentHeaderService documentHeaderServiceMock = (DocumentHeaderService)Mockito.mock(DocumentHeaderService.class);
            Class<FinancialSystemDocumentHeader> documentHeaderBaseClass = FinancialSystemDocumentHeader.class;
            Mockito.when((Object)documentHeaderServiceMock.getDocumentHeaderBaseClass()).thenReturn(documentHeaderBaseClass);
            kradServiceLocatorWebStaticMock.when(KRADServiceLocatorWeb::getDocumentHeaderService).thenReturn((Object)documentHeaderServiceMock);
            this.cut = (ContractsGrantsCollectionActivityDocumentRule)Mockito.spy((Object)new ContractsGrantsCollectionActivityDocumentRule());
            this.contractsGrantsCollectionActivityDocument = new ContractsGrantsCollectionActivityDocument();
        }
        this.contractsGrantsCollectionActivityDocument.getDocumentHeader().setDocumentDescription("Testing document");
        DataDictionaryService dataDictionarySvcMock = (DataDictionaryService)Mockito.mock(DataDictionaryService.class);
        Mockito.when((Object)dataDictionarySvcMock.getAttributeLabel(ContractsGrantsCollectionActivityDocument.class, "proposalNumber")).thenReturn((Object)"Proposal Number");
        ContractsGrantsCollectionActivityDocumentRule.setDataDictionaryService((DataDictionaryService)dataDictionarySvcMock);
    }

    @Test
    void validateCollectionActivityDocument_Valid_True() {
        this.contractsGrantsCollectionActivityDocument.setProposalNumber("11");
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        ArrayList<ContractsGrantsCollectionActivityInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsCollectionActivityInvoiceDetail>();
        ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail = new ContractsGrantsCollectionActivityInvoiceDetail();
        invoiceDetails.add(invoiceDetail);
        this.contractsGrantsCollectionActivityDocument.setInvoiceDetails(invoiceDetails);
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void validateCollectionActivityDocument_Invalid_False() {
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void validateCollectionActivityDocument_missingProposalNumber_False() {
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        ArrayList<ContractsGrantsCollectionActivityInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsCollectionActivityInvoiceDetail>();
        ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail = new ContractsGrantsCollectionActivityInvoiceDetail();
        invoiceDetails.add(invoiceDetail);
        this.contractsGrantsCollectionActivityDocument.setInvoiceDetails(invoiceDetails);
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void validateCollectionActivityDocument__missingInvoiceDetails_False() {
        this.contractsGrantsCollectionActivityDocument.setProposalNumber("11");
        this.contractsGrantsCollectionActivityDocument.setActivityCode(ACTIVITY_CODE);
        this.contractsGrantsCollectionActivityDocument.setActivityDate(new Date(System.currentTimeMillis()));
        this.contractsGrantsCollectionActivityDocument.setActivityText("testing activity comment");
        boolean result = this.cut.validateCollectionActivityDocument(this.contractsGrantsCollectionActivityDocument);
        Assertions.assertFalse((boolean)result);
    }
}

