/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceBilledByOrganizationCodeValidation;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class CustomerInvoiceBilledByOrganizationCodeValidationTest {
    private CustomerInvoiceBilledByOrganizationCodeValidation cut;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocMock;

    CustomerInvoiceBilledByOrganizationCodeValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new CustomerInvoiceBilledByOrganizationCodeValidation();
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocMock);
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    void validate_ValidBilledByOrganizationCode_True() {
        Mockito.when((Object)this.customerInvoiceDocMock.getBilledByOrganization()).thenReturn((Object)new Organization());
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_InvalidBilledByOrganizationCode_False() {
        Mockito.when((Object)this.customerInvoiceDocMock.getBillByChartOfAccount()).thenReturn(null);
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Assertions.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.document.customerInvoiceDocument.invalidBilledByOrganizationCode"));
    }
}

