/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDetailUnitOfMeasureValidation;
import org.kuali.kfs.sys.businessobject.UnitOfMeasure;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class CustomerInvoiceDetailUnitOfMeasureValidationTest {
    private static final String VALID_UNIT_OF_MEASURE_CODE = "EA";
    private static final String INVALID_UNIT_OF_MEASURE_CODE = "XX";
    private CustomerInvoiceDetailUnitOfMeasureValidation cut;
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    CustomerInvoiceDetailUnitOfMeasureValidationTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new CustomerInvoiceDetailUnitOfMeasureValidation();
        this.cut.setCustomerInvoiceDetail(new CustomerInvoiceDetail());
        this.cut.setBusinessObjectService(this.businessObjectSvcMock);
    }

    @Test
    void validate_ValidUnitOfMeasure() {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("itemUnitOfMeasureCode", VALID_UNIT_OF_MEASURE_CODE);
        Mockito.when((Object)((UnitOfMeasure)this.businessObjectSvcMock.findByPrimaryKey(UnitOfMeasure.class, criteria))).thenReturn((Object)new UnitOfMeasure());
        this.cut.getCustomerInvoiceDetail().setInvoiceItemUnitOfMeasureCode(VALID_UNIT_OF_MEASURE_CODE);
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_InvalidUnitOfMeasure() {
        this.cut.getCustomerInvoiceDetail().setInvoiceItemUnitOfMeasureCode(INVALID_UNIT_OF_MEASURE_CODE);
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }
}

