/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Calendar;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.validation.impl.CustomerInvoiceDueDateValidation;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.service.ConfigurableDateService;
import org.kuali.kfs.sys.service.impl.ConfigurableDateTimeServiceImpl;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class CustomerInvoiceDueDateValidationTest {
    private CustomerInvoiceDueDateValidation cut;
    @Mock
    private CustomerInvoiceDocument customerInvoiceDocumentMock;
    @Mock
    private ParameterService parameterSvcMock;
    private ConfigurableDateService configurableDateService;

    CustomerInvoiceDueDateValidationTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.customerInvoiceDocumentMock.getFinancialSystemDocumentHeader()).thenReturn((Object)new FinancialSystemDocumentHeader());
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString(CustomerInvoiceDocument.class, "MAXIMUM_NUMBER_OF_DAYS_AFTER_CURRENT_DATE_FOR_INVOICE_DUE_DATE")).thenReturn((Object)"10");
        this.configurableDateService = new ConfigurableDateTimeServiceImpl();
        this.cut = new CustomerInvoiceDueDateValidation();
        this.cut.setCustomerInvoiceDocument(this.customerInvoiceDocumentMock);
        this.cut.setDateTimeService((DateTimeService)this.configurableDateService);
        this.cut.setParameterService(this.parameterSvcMock);
    }

    @Test
    void validate_ValidBillingDateBeforeDueDate() {
        Mockito.when((Object)this.parameterSvcMock.getParameterValueAsString(CustomerInvoiceDocument.class, "MAXIMUM_NUMBER_OF_DAYS_AFTER_CURRENT_DATE_FOR_INVOICE_DUE_DATE")).thenReturn((Object)"90");
        Date billingDate = new Date();
        this.configurableDateService.setCurrentDate(billingDate);
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, 1);
        Date dueDateOneDayAfterBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateOneDayAfterBillingDate.getTime()));
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_InvalidBillingDateEqualToOrAfterDueDate() {
        Date billingDate = new Date();
        this.configurableDateService.setCurrentDate(billingDate);
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, -1);
        Date dueDateOneDayBeforeBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateOneDayBeforeBillingDate.getTime()));
        Assertions.assertFalse((boolean)this.cut.validate(null));
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(billingDate.getTime()));
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }

    @Test
    void validate_ValidBillingDateNotAfterMaximumNumberOfDays() {
        Date billingDate = new Date();
        this.configurableDateService.setCurrentDate(billingDate);
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, 9);
        Date dueDateNineDaysAfterBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateNineDaysAfterBillingDate.getTime()));
        Assertions.assertTrue((boolean)this.cut.validate(null));
    }

    @Test
    void validate_InvalidBillingDateEqualToOrAfterMaximumNumberOfDays() {
        Date billingDate = new Date();
        this.configurableDateService.setCurrentDate(billingDate);
        Calendar c = Calendar.getInstance();
        c.setTime(billingDate);
        c.add(5, 10);
        Date dueDateTenDaysAfterBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateTenDaysAfterBillingDate.getTime()));
        Assertions.assertFalse((boolean)this.cut.validate(null));
        c.add(5, 11);
        Date dueDateElevenDaysAfterBillingDate = c.getTime();
        Mockito.when((Object)this.customerInvoiceDocumentMock.getInvoiceDueDate()).thenReturn((Object)new java.sql.Date(dueDateElevenDaysAfterBillingDate.getTime()));
        Assertions.assertFalse((boolean)this.cut.validate(null));
    }
}

