/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.FinalBilledIndicatorDocument;
import org.kuali.kfs.module.ar.document.validation.impl.FinalBilledIndicatorValidation;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class FinalBilledIndicatorValidationTest {
    @Mock
    private DocumentService documentSvcMock;
    @Mock
    private FinalBilledIndicatorDocument finalBilledIndicatorDocumentMock;
    private FinalBilledIndicatorEntry finalBilledIndicatorEntry;
    private List<FinalBilledIndicatorEntry> finalBilledIndicatorEntries;
    private InvoiceGeneralDetail invoiceGeneralDetail;
    @Mock
    private WorkflowDocument workflowDocumentMock;

    FinalBilledIndicatorValidationTest() {
    }

    @BeforeEach
    void setUp() throws WorkflowException {
        FinalBilledIndicatorValidation.setDocumentService((DocumentService)this.documentSvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.setupDocumentAndBusinessObjectMocks();
    }

    private void setupDocumentAndBusinessObjectMocks() throws WorkflowException {
        this.finalBilledIndicatorEntries = new ArrayList<FinalBilledIndicatorEntry>();
        this.finalBilledIndicatorEntry = new FinalBilledIndicatorEntry();
        this.finalBilledIndicatorEntry.setInvoiceDocumentNumber("1");
        this.finalBilledIndicatorEntries.add(this.finalBilledIndicatorEntry);
        Mockito.when((Object)this.finalBilledIndicatorDocumentMock.getInvoiceEntries()).thenReturn(this.finalBilledIndicatorEntries);
        Mockito.when((Object)this.workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"CINV");
        Mockito.when((Object)this.workflowDocumentMock.isFinal()).thenReturn((Object)true);
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)this.workflowDocumentMock);
        this.invoiceGeneralDetail = new InvoiceGeneralDetail();
        this.invoiceGeneralDetail.setFinalBillIndicator(true);
        ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock = (ContractsGrantsInvoiceDocument)Mockito.mock(ContractsGrantsInvoiceDocument.class);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetail);
        Mockito.when((Object)this.documentSvcMock.documentExists("1")).thenReturn((Object)true);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1")).thenReturn((Object)contractsGrantsInvoiceDocumentMock);
    }

    @Test
    void validateDocument() {
        Assertions.assertTrue((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
    }

    @Test
    void validateDocument_NoFinalBilledEntries() {
        Mockito.when((Object)this.finalBilledIndicatorDocumentMock.getInvoiceEntries()).thenReturn(Collections.emptyList());
        Assertions.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.no.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_NullEntry() {
        this.finalBilledIndicatorEntries.add(null);
        Assertions.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.no.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_NoInvoiceNumber() {
        this.finalBilledIndicatorEntry.setInvoiceDocumentNumber(null);
        Assertions.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.no.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_MissingDocument() {
        this.finalBilledIndicatorEntry.setInvoiceDocumentNumber("2");
        Assertions.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.invalid.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_InvalidDocumentType() {
        Mockito.when((Object)this.workflowDocumentMock.getDocumentTypeName()).thenReturn((Object)"LCR");
        Assertions.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.invalid.invoice", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_WorkflowException() throws WorkflowException {
        Mockito.when((Object)this.documentSvcMock.documentExists("2")).thenReturn((Object)true);
        Mockito.when((Object)this.documentSvcMock.getByDocumentHeaderId("1")).thenThrow(new Throwable[]{new WorkflowException("test exception")});
        Exception e = (Exception)Assertions.assertThrows(RuntimeException.class, () -> FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((Object)"problem during FinalBilledIndicatorValidation.validContractsGrantsInvoiceValidation()", (Object)e.getMessage());
        Assertions.assertTrue((boolean)(e.getCause() instanceof WorkflowException));
    }

    @Test
    void validateDocument_DocumentEnroute() {
        Mockito.when((Object)this.workflowDocumentMock.isFinal()).thenReturn((Object)false);
        Mockito.when((Object)this.workflowDocumentMock.isEnroute()).thenReturn((Object)true);
        Assertions.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.invoice.not.final", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }

    @Test
    void validateDocument_NotMarkedFinal() {
        this.invoiceGeneralDetail.setFinalBillIndicator(false);
        Assertions.assertFalse((boolean)FinalBilledIndicatorValidation.validateDocument((Document)this.finalBilledIndicatorDocumentMock));
        Assertions.assertEquals((int)1, (int)GlobalVariables.getMessageMap().getErrorCount());
        Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
        Assertions.assertEquals((int)1, (int)errorMessages.size());
        List finalBilledIndicatorErrorMessages = (List)errorMessages.get("document.invoiceEntries");
        Assertions.assertEquals((int)1, (int)finalBilledIndicatorErrorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)finalBilledIndicatorErrorMessages.get(0);
        Assertions.assertEquals((Object)"error.final.billed.indicator.invoice.not.marked.final.bill", (Object)errorMessage.getErrorKey());
        Assertions.assertEquals((int)0, (int)errorMessage.getMessageParameters().length);
    }
}

