/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.LinkedList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.impl.ContractsGrantsInvoiceDocumentServiceImpl;
import org.kuali.kfs.module.ar.document.validation.impl.InvoiceAmountLessThanInvoiceMinimumSuspensionCategory;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class InvoiceAmountLessThanInvoiceMinimumSuspensionCategoryTest {
    private InvoiceAmountLessThanInvoiceMinimumSuspensionCategory cut;
    @Mock
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocumentMock;
    @Mock
    private ContractsAndGrantsBillingAward awardMock;
    @Spy
    private ContractsGrantsInvoiceDocumentServiceImpl contractsGrantsInvoiceDocumentSvcSpy;
    @Mock
    private InvoiceGeneralDetail invoiceGeneralDetailMock;

    InvoiceAmountLessThanInvoiceMinimumSuspensionCategoryTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.awardMock.getMinInvoiceAmount()).thenReturn((Object)new KualiDecimal(100.0));
        Mockito.when((Object)this.invoiceGeneralDetailMock.getAward()).thenReturn((Object)this.awardMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceGeneralDetail()).thenReturn((Object)this.invoiceGeneralDetailMock);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceInvoiceAmount()).thenReturn((Object)KualiDecimal.ZERO);
        ((ContractsGrantsInvoiceDocumentServiceImpl)Mockito.doNothing().when((Object)this.contractsGrantsInvoiceDocumentSvcSpy)).recalculateTotalAmountBilledToDate(this.contractsGrantsInvoiceDocumentMock);
        ((ContractsGrantsInvoiceDocumentServiceImpl)Mockito.doNothing().when((Object)this.contractsGrantsInvoiceDocumentSvcSpy)).calculatePreviouslyBilledAmounts(this.contractsGrantsInvoiceDocumentMock);
        this.cut = new InvoiceAmountLessThanInvoiceMinimumSuspensionCategory();
        this.cut.setContractsGrantsInvoiceDocumentService((ContractsGrantsInvoiceDocumentService)this.contractsGrantsInvoiceDocumentSvcSpy);
    }

    @Test
    void shouldSuspend_Monthly_InvoiceAmountGreaterThanMinimum_No() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceInvoiceAmount()).thenReturn((Object)new KualiDecimal(500.0));
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_Monthly_InvoiceAmountLessThanMinimum_Yes() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode());
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getTotalInvoiceInvoiceAmount()).thenReturn((Object)new KualiDecimal(50.0));
        Assertions.assertTrue((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_PredeterminedBilling_TotalBillAmountGreaterThanMinimum_No() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        LinkedList<InvoiceBill> bills = new LinkedList<InvoiceBill>();
        InvoiceBill bill = new InvoiceBill();
        bill.setEstimatedAmount(new KualiDecimal(500.0));
        bills.add(bill);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceBills()).thenReturn(bills);
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_PredeterminedBilling_TotalBillAmountLessThanMinimum_Yes() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode());
        LinkedList<InvoiceBill> bills = new LinkedList<InvoiceBill>();
        InvoiceBill bill = new InvoiceBill();
        bill.setEstimatedAmount(new KualiDecimal(50.0));
        bills.add(bill);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceBills()).thenReturn(bills);
        Assertions.assertTrue((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_Milestone_TotalBillAmountGreaterThanMinimum_No() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        LinkedList<InvoiceMilestone> milestones = new LinkedList<InvoiceMilestone>();
        InvoiceMilestone milestone = new InvoiceMilestone();
        milestone.setMilestoneAmount(new KualiDecimal(500.0));
        milestones.add(milestone);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceMilestones()).thenReturn(milestones);
        Assertions.assertFalse((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }

    @Test
    void shouldSuspend_Milestone_TotalBillAmountLessThanMinimum_Yes() {
        Mockito.when((Object)this.invoiceGeneralDetailMock.getBillingFrequencyCode()).thenReturn((Object)ArConstants.BillingFrequencyValues.MILESTONE.getCode());
        LinkedList<InvoiceMilestone> milestones = new LinkedList<InvoiceMilestone>();
        InvoiceMilestone milestone = new InvoiceMilestone();
        milestone.setMilestoneAmount(new KualiDecimal(50.0));
        milestones.add(milestone);
        Mockito.when((Object)this.contractsGrantsInvoiceDocumentMock.getInvoiceMilestones()).thenReturn(milestones);
        Assertions.assertTrue((boolean)this.cut.shouldSuspend(this.contractsGrantsInvoiceDocumentMock));
    }
}

