/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.document.validation.impl.MilestoneScheduleRuleUtil;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class MilestoneScheduleRuleUtilTest {
    private static final String PROPOSAL_NUMBER = "39928";
    private static final String CHART_CODE = "BL";
    private static final String ACCOUNT_NUMBER = "1031400";
    @Mock
    private BusinessObjectService businessObjectSvcMock;

    MilestoneScheduleRuleUtilTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber(PROPOSAL_NUMBER);
        milestoneSchedule.setChartOfAccountsCode(CHART_CODE);
        milestoneSchedule.setAccountNumber(ACCOUNT_NUMBER);
        milestoneSchedule.setObjectId("a different objectId");
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", PROPOSAL_NUMBER);
        primaryKeys.put("chartOfAccountsCode", CHART_CODE);
        primaryKeys.put("accountNumber", ACCOUNT_NUMBER);
        Mockito.when((Object)((MilestoneSchedule)this.businessObjectSvcMock.findByPrimaryKey(MilestoneSchedule.class, primaryKeys))).thenReturn((Object)milestoneSchedule);
        MilestoneScheduleRuleUtil.setBusinessObjectService((BusinessObjectService)this.businessObjectSvcMock);
    }

    @Test
    void checkIfMilestonesExists_NullMilestoneSchedule() {
        Assertions.assertFalse((boolean)MilestoneScheduleRuleUtil.checkIfMilestonesExists(null));
    }

    @Test
    void checkIfMilestonesExists_MissingMilestoneSchedule() {
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        Assertions.assertFalse((boolean)MilestoneScheduleRuleUtil.checkIfMilestonesExists((MilestoneSchedule)milestoneSchedule));
    }

    @Test
    void checkIfMilestonesExists_ValidMilestoneSchedule() {
        MilestoneSchedule milestoneSchedule = new MilestoneSchedule();
        milestoneSchedule.setProposalNumber(PROPOSAL_NUMBER);
        milestoneSchedule.setChartOfAccountsCode(CHART_CODE);
        milestoneSchedule.setAccountNumber(ACCOUNT_NUMBER);
        milestoneSchedule.setObjectId("objectId");
        Assertions.assertTrue((boolean)MilestoneScheduleRuleUtil.checkIfMilestonesExists((MilestoneSchedule)milestoneSchedule));
    }
}

