/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.util.List;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Response;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.kim.impl.group.GroupBo;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.kns.web.struts.form.KualiForm;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.AdHocRoutePerson;
import org.kuali.kfs.krad.bo.AdHocRouteRecipient;
import org.kuali.kfs.krad.bo.AdHocRouteWorkgroup;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.rest.responses.AdHocRoutePersonResponse;
import org.kuali.kfs.krad.rest.responses.AdHocRouteWorkgroupResponse;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.impl.AdHocRoutingService;
import org.kuali.kfs.krad.service.impl.SuperUserService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.impl.PaymentApplicationAdjustmentDocumentService;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationAdjustmentAction;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationAdjustmentForm;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRoutingRequest;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionRequest;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.ActionRequestType;
import org.kuali.rice.kew.api.action.DocumentActionParameters;
import org.kuali.rice.kew.api.action.RecipientType;
import org.kuali.rice.kew.api.action.WorkflowDocumentActionsService;
import org.kuali.rice.kew.api.document.WorkflowDocumentService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.springframework.mock.web.MockHttpServletResponse;

@Execution(value=ExecutionMode.SAME_THREAD)
@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class PaymentApplicationAdjustmentActionTest {
    @Mock
    private SuperUserService superUserServiceMock;
    @Mock
    private BusinessObjectService businessObjectServiceMock;
    @Mock
    private AdHocRoutingService adHocRoutingServiceMock;
    @Mock
    private PersonService personServiceMock;
    @Mock
    private DocumentService documentServiceMock;
    @Spy
    private PaymentApplicationAdjustmentAction cutSpy;

    PaymentApplicationAdjustmentActionTest() {
    }

    @BeforeEach
    void setup() {
        GlobalVariables.clear();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)this.personServiceMock).when((Object)this.cutSpy)).getPersonService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)this.adHocRoutingServiceMock).when((Object)this.cutSpy)).getAdHocRoutingService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)this.businessObjectServiceMock).when((Object)this.cutSpy)).getBusinessObjectService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)this.documentServiceMock).when((Object)this.cutSpy)).getDocumentService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)this.superUserServiceMock).when((Object)this.cutSpy)).getSuperUserService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)Mockito.mock(PaymentApplicationAdjustmentDocumentService.class)).when((Object)this.cutSpy)).getPaymentApplicationAdjustmentDocumentService();
    }

    @AfterEach
    void tearDown() {
        GlobalVariables.clear();
    }

    @DisplayName(value="Given the 'invoiceNumber' request parameter is invalid, then a BAD_REQUEST error should be returned")
    @ParameterizedTest(name="invoiceNumber = {0}")
    @MethodSource(value={"addInvoiceInvalidBadRequestArgs"})
    void addInvoice_invalid_bad_request(String invoiceNumber) throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)("{ \"invoiceNumber\":\"" + invoiceNumber + "\"}"));
        ActionForward actual = this.cutSpy.addInvoice(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Missing 'invoiceNumber' request parameter");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    private static Stream<Arguments> addInvoiceInvalidBadRequestArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{""}), Arguments.of((Object[])new Object[]{" "}));
    }

    @Test
    void addInvoice_invalid_invoice_not_found() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String invoiceNumber = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"invoiceNumber\":\"123\"}");
        Mockito.when((Object)((CustomerInvoiceDocument)this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"123"))).thenReturn(null);
        ActionForward actual = this.cutSpy.addInvoice(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.NOT_FOUND;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Requested invoice not found : invoiceNumber=123");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addInvoice_invalid_invoice_does_not_have_open_amount() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String invoiceNumber = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"invoiceNumber\":\"123\"}");
        CustomerInvoiceDocument invoice = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)((CustomerInvoiceDocument)this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"123"))).thenReturn((Object)invoice);
        Mockito.when((Object)invoice.getOpenAmount()).thenReturn(null);
        ActionForward actual = this.cutSpy.addInvoice(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.PRECONDITION_FAILED;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Invoice does not have an open amount : invoiceNumber=123");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addInvoice_invalid_invoice_has_open_amount_that_is_not_positive() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String invoiceNumber = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"invoiceNumber\":\"123\"}");
        CustomerInvoiceDocument invoice = (CustomerInvoiceDocument)Mockito.mock(CustomerInvoiceDocument.class);
        Mockito.when((Object)((CustomerInvoiceDocument)this.businessObjectServiceMock.findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)"123"))).thenReturn((Object)invoice);
        KualiDecimal openAmount = new KualiDecimal(0);
        Mockito.when((Object)invoice.getOpenAmount()).thenReturn((Object)openAmount);
        ActionForward actual = this.cutSpy.addInvoice(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.PRECONDITION_FAILED;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Invoice does not have an open amount : invoiceNumber=123");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @DisplayName(value="Given the 'customerNumber' request parameter is invalid, then a BAD_REQUEST error should be returned")
    @ParameterizedTest(name="customerNumber = {0}")
    @MethodSource(value={"addCustomerInvalidBadRequestArgs"})
    void addCustomer_invalid_bad_request(String customerNumber) throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)("{ \"customerNumber\":\"" + customerNumber + "\"}"));
        ActionForward actual = this.cutSpy.addCustomer(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Missing 'customerNumber' request parameter");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    private static Stream<Arguments> addCustomerInvalidBadRequestArgs() {
        return Stream.of(Arguments.of((Object[])new Object[]{""}), Arguments.of((Object[])new Object[]{" "}));
    }

    @Test
    void addCustomer_invalid_customer_not_found() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String customerNumber = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"customerNumber\":\"123\"}");
        Mockito.when((Object)((Customer)this.businessObjectServiceMock.findBySinglePrimaryKey(Customer.class, (Object)"123"))).thenReturn(null);
        ActionForward actual = this.cutSpy.addCustomer(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.NOT_FOUND;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Requested customer not found : customerNumber=123");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRouteWorkgroup_groupIdMissing() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String action = "action";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"group\": { \"id\":\"\", \"action\":\"action\"} }");
        ActionForward actual = this.cutSpy.addAdHocRouteWorkgroup(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Group id is required");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRouteWorkgroup_actionMissing() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String groupId = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"group\": { \"id\":\"123\", \"action\":\"\"} }");
        ActionForward actual = this.cutSpy.addAdHocRouteWorkgroup(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Action is required");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRouteWorkgroup_noMatchingGroup() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String groupId = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"group\": { \"id\":\"123\", \"action\":\"aAction\"} }");
        Mockito.when((Object)((GroupBo)this.businessObjectServiceMock.findBySinglePrimaryKey((Class)ArgumentMatchers.eq(GroupBo.class), ArgumentMatchers.eq((Object)"123")))).thenReturn(null);
        ActionForward actual = this.cutSpy.addAdHocRouteWorkgroup(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.NOT_FOUND;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "No group found with id=123");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRouteWorkgroup_userCannotSendRequest() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String groupId = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"group\": { \"id\":\"123\", \"action\":\"aAction\"} }");
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)((GroupBo)this.businessObjectServiceMock.findBySinglePrimaryKey((Class)ArgumentMatchers.eq(GroupBo.class), ArgumentMatchers.eq((Object)"123")))).thenReturn((Object)((GroupBo)Mockito.mock(GroupBo.class)));
        Mockito.when((Object)this.adHocRoutingServiceMock.canSendAdHocRequest((Document)ArgumentMatchers.any(Document.class), (AdHocRouteRecipient)ArgumentMatchers.any(AdHocRouteWorkgroup.class), (Person)ArgumentMatchers.eq((Object)personMock))).thenReturn((Object)false);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ActionForward actual = this.cutSpy.addAdHocRouteWorkgroup(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.FORBIDDEN;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "No permission to add workgroup with id=123");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRouteWorkgroup_successfulAdd_returnsWorkgroupResponse() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        Mockito.when((Object)formMock.getDocument()).thenReturn((Object)((Document)Mockito.mock(Document.class)));
        AdHocRouteWorkgroupResponse workgroupResponse = new AdHocRouteWorkgroupResponse("theId", "theName", "theNamespaceCode", "theAction", "theGroupUrl");
        Mockito.when((Object)formMock.createAdHocRouteWorkgroupResponse((GroupBo)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)workgroupResponse);
        String groupId = "123";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"group\": { \"id\":\"123\", \"action\":\"aAction\"} }");
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)((GroupBo)this.businessObjectServiceMock.findBySinglePrimaryKey((Class)ArgumentMatchers.eq(GroupBo.class), ArgumentMatchers.eq((Object)"123")))).thenReturn((Object)((GroupBo)Mockito.mock(GroupBo.class)));
        Mockito.when((Object)this.adHocRoutingServiceMock.canSendAdHocRequest((Document)ArgumentMatchers.any(Document.class), (AdHocRouteRecipient)ArgumentMatchers.any(AdHocRouteWorkgroup.class), (Person)ArgumentMatchers.eq((Object)personMock))).thenReturn((Object)true);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ActionForward actual = this.cutSpy.addAdHocRouteWorkgroup(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = "{  \"id\": \"theId\",  \"name\": \"theName\",  \"namespaceCode\": \"theNamespaceCode\",  \"action\": \"theAction\",  \"type\": \"group\",  \"nameLink\": {      \"value\": \"theName\",      \"url\": \"theGroupUrl\",      \"type\": \"link\"  }}";
        JSONAssert.assertEquals((String)"{  \"id\": \"theId\",  \"name\": \"theName\",  \"namespaceCode\": \"theNamespaceCode\",  \"action\": \"theAction\",  \"type\": \"group\",  \"nameLink\": {      \"value\": \"theName\",      \"url\": \"theGroupUrl\",      \"type\": \"link\"  }}", (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRoutePerson_principalNameMissing() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String action = "action";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"person\": { \"principalName\":\"\", \"action\":\"action\"} }");
        ActionForward actual = this.cutSpy.addAdHocRoutePerson(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "principalName is required");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRoutePerson_actionMissing() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String principalName = "aName";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"person\": { \"principalName\":\"aName\", \"action\":\"\"} }");
        ActionForward actual = this.cutSpy.addAdHocRoutePerson(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "action is required");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRoutePerson_noMatchingPrincipal() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        ActionForm formMock = (ActionForm)Mockito.mock(ActionForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String principalName = "aName";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"person\": { \"principalName\":\"aName\", \"action\":\"aAction\"} }");
        Mockito.when((Object)this.personServiceMock.getPersonByPrincipalName((String)ArgumentMatchers.eq((Object)"aName"))).thenReturn(null);
        ActionForward actual = this.cutSpy.addAdHocRoutePerson(mappingMock, formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.NOT_FOUND;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "No person found with principalName=aName");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRoutePerson_userCannotSendRequest() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String principalName = "aName";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"person\": { \"principalName\":\"aName\", \"action\":\"aAction\"} }");
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)this.personServiceMock.getPersonByPrincipalName((String)ArgumentMatchers.eq((Object)"aName"))).thenReturn((Object)((Person)Mockito.mock(Person.class)));
        Mockito.when((Object)this.adHocRoutingServiceMock.canSendAdHocRequest((Document)ArgumentMatchers.any(Document.class), (AdHocRouteRecipient)ArgumentMatchers.any(AdHocRoutePerson.class), (Person)ArgumentMatchers.eq((Object)personMock))).thenReturn((Object)false);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ActionForward actual = this.cutSpy.addAdHocRoutePerson(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.FORBIDDEN;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "No permission to add principal with principalName=aName");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void addAdHocRoutePerson_successfulAdd_returnsPersonResponse() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        Mockito.when((Object)formMock.getDocument()).thenReturn((Object)((Document)Mockito.mock(Document.class)));
        AdHocRoutePersonResponse personResponse = new AdHocRoutePersonResponse("thePrincipalName", "theName", "theAction", "thePersonUrl");
        Mockito.when((Object)formMock.createAdHocRoutePersonResponse((Person)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)personResponse);
        String principalName = "aName";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"person\": { \"principalName\":\"aName\", \"action\":\"aAction\"} }");
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)this.personServiceMock.getPersonByPrincipalName((String)ArgumentMatchers.eq((Object)"aName"))).thenReturn((Object)((Person)Mockito.mock(Person.class)));
        Mockito.when((Object)this.adHocRoutingServiceMock.canSendAdHocRequest((Document)ArgumentMatchers.any(Document.class), (AdHocRouteRecipient)ArgumentMatchers.any(AdHocRoutePerson.class), (Person)ArgumentMatchers.eq((Object)personMock))).thenReturn((Object)true);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ActionForward actual = this.cutSpy.addAdHocRoutePerson(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = "{  \"principalName\": \"thePrincipalName\",  \"name\": \"theName\",  \"action\": \"theAction\",  \"type\": \"person\",  \"personLink\": {      \"value\": \"theName\",      \"url\": \"thePersonUrl\",      \"type\": \"link\"  }}";
        JSONAssert.assertEquals((String)"{  \"principalName\": \"thePrincipalName\",  \"name\": \"theName\",  \"action\": \"theAction\",  \"type\": \"person\",  \"personLink\": {      \"value\": \"theName\",      \"url\": \"thePersonUrl\",      \"type\": \"link\"  }}", (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void sendNoteWorkflowNotification_invalid_noteId_missing() throws Exception {
        String principalName = "thePrincipalName";
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"noteId\":\"\", \"principalName\": \"thePrincipalName\"}");
        ActionForward actual = this.cutSpy.sendNoteWorkflowNotification(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Missing 'noteId' request parameter");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void sendNoteWorkflowNotification_invalid_principalName_missing() throws Exception {
        String noteId = "123";
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"noteId\":\"123\", \"principalName\": \"\"}");
        ActionForward actual = this.cutSpy.sendNoteWorkflowNotification(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Missing 'principalName' request parameter");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void sendNoteWorkflowNotification_success() throws Exception {
        String noteId = "123";
        String principalName = "thePrincipalName";
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        PaymentApplicationAdjustmentDocument documentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Note noteMock = (Note)Mockito.mock(Note.class);
        AdHocRoutePerson recipientMock = (AdHocRoutePerson)Mockito.mock(AdHocRoutePerson.class);
        Mockito.when((Object)recipientMock.getId()).thenReturn((Object)"thePrincipalName");
        Mockito.when((Object)noteMock.getAdHocRouteRecipient()).thenReturn((Object)recipientMock);
        Mockito.when((Object)documentMock.getNoteById("123")).thenReturn((Object)noteMock);
        Mockito.when((Object)documentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)((WorkflowDocument)Mockito.mock(WorkflowDocument.class)));
        Mockito.when((Object)formMock.getPaymentApplicationAdjustmentDocument()).thenReturn((Object)documentMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"noteId\":\"123\", \"principalName\": \"thePrincipalName\"}");
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)"").when((Object)this.cutSpy)).determineNoteWorkflowNotificationAction((HttpServletRequest)ArgumentMatchers.any(), (KualiDocumentFormBase)ArgumentMatchers.any(), (Note)ArgumentMatchers.any());
        KualiRuleService ruleServiceMock = (KualiRuleService)Mockito.mock(KualiRuleService.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)ruleServiceMock).when((Object)this.cutSpy)).getKualiRuleService();
        Mockito.when((Object)ruleServiceMock.applyRules((KualiDocumentEvent)ArgumentMatchers.any())).thenReturn((Object)true);
        ((DocumentService)Mockito.doNothing().when((Object)this.documentServiceMock)).sendNoteRouteNotification((Document)documentMock, noteMock, personMock);
        ActionForward actual = this.cutSpy.sendNoteWorkflowNotification(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        ((AdHocRoutePerson)Mockito.verify((Object)recipientMock, (VerificationMode)Mockito.times((int)1))).setId("thePrincipalName");
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.times((int)1))).sendNoteRouteNotification((Document)documentMock, noteMock, personMock);
    }

    @Test
    void sendNoteWorkflowNotification_invalid_rules_fail() throws Exception {
        String noteId = "123";
        String principalName = "thePrincipalName";
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        PaymentApplicationAdjustmentDocument documentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Note noteMock = (Note)Mockito.mock(Note.class);
        AdHocRoutePerson recipientMock = (AdHocRoutePerson)Mockito.mock(AdHocRoutePerson.class);
        Mockito.when((Object)recipientMock.getId()).thenReturn((Object)"thePrincipalName");
        Mockito.when((Object)noteMock.getAdHocRouteRecipient()).thenReturn((Object)recipientMock);
        Mockito.when((Object)documentMock.getNoteById("123")).thenReturn((Object)noteMock);
        Mockito.when((Object)documentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)((WorkflowDocument)Mockito.mock(WorkflowDocument.class)));
        Mockito.when((Object)formMock.getDocument()).thenReturn((Object)documentMock);
        Mockito.when((Object)formMock.getPaymentApplicationAdjustmentDocument()).thenReturn((Object)documentMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"noteId\":\"123\", \"principalName\": \"thePrincipalName\"}");
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)"").when((Object)this.cutSpy)).determineNoteWorkflowNotificationAction((HttpServletRequest)ArgumentMatchers.any(), (KualiDocumentFormBase)ArgumentMatchers.any(), (Note)ArgumentMatchers.any());
        KualiRuleService ruleServiceMock = (KualiRuleService)Mockito.mock(KualiRuleService.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)ruleServiceMock).when((Object)this.cutSpy)).getKualiRuleService();
        Mockito.when((Object)ruleServiceMock.applyRules((KualiDocumentEvent)ArgumentMatchers.any())).thenReturn((Object)false);
        ((DocumentService)Mockito.doNothing().when((Object)this.documentServiceMock)).sendNoteRouteNotification((Document)documentMock, noteMock, personMock);
        ActionForward actual = this.cutSpy.sendNoteWorkflowNotification(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Unable to send note notification: documentNumber=null, noteId=123, principalName=thePrincipalName, message=Invalid recipient");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void sendNoteWorkflowNotification_invalid_document_not_saved() throws Exception {
        String noteId = "123";
        String principalName = "thePrincipalName";
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        PaymentApplicationAdjustmentDocument documentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        DocumentHeader documentHeaderMock = (DocumentHeader)Mockito.mock(DocumentHeader.class);
        Note noteMock = (Note)Mockito.mock(Note.class);
        AdHocRoutePerson recipientMock = (AdHocRoutePerson)Mockito.mock(AdHocRoutePerson.class);
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)formMock.getDocument()).thenReturn((Object)documentMock);
        Mockito.when((Object)formMock.getPaymentApplicationAdjustmentDocument()).thenReturn((Object)documentMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        Mockito.when((Object)recipientMock.getId()).thenReturn((Object)"thePrincipalName");
        Mockito.when((Object)noteMock.getAdHocRouteRecipient()).thenReturn((Object)recipientMock);
        Mockito.when((Object)documentMock.getNoteById("123")).thenReturn((Object)noteMock);
        Mockito.when((Object)documentMock.getDocumentHeader()).thenReturn((Object)documentHeaderMock);
        Mockito.when((Object)workflowDocumentMock.isInitiated()).thenReturn((Object)true);
        Mockito.when((Object)documentHeaderMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"noteId\":\"123\", \"principalName\": \"thePrincipalName\"}");
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)"").when((Object)this.cutSpy)).determineNoteWorkflowNotificationAction((HttpServletRequest)ArgumentMatchers.any(), (KualiDocumentFormBase)ArgumentMatchers.any(), (Note)ArgumentMatchers.any());
        KualiRuleService ruleServiceMock = (KualiRuleService)Mockito.mock(KualiRuleService.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)ruleServiceMock).when((Object)this.cutSpy)).getKualiRuleService();
        Mockito.when((Object)ruleServiceMock.applyRules((KualiDocumentEvent)ArgumentMatchers.any())).thenReturn((Object)true);
        ((DocumentService)Mockito.doNothing().when((Object)this.documentServiceMock)).sendNoteRouteNotification((Document)documentMock, noteMock, personMock);
        ActionForward actual = this.cutSpy.sendNoteWorkflowNotification(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Unable to send note notification: documentNumber=null, noteId=123, principalName=thePrincipalName, message=Document is not saved");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void superUserAction_missingAnnotation_returnsBadRequest() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{}");
        this.cutSpy.superUserAction(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Missing 'annotation' request parameter");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void superUserAction_missingAction_returnsBadRequest() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"annotation\": \"myAnnotation\" }");
        this.cutSpy.superUserAction(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Missing 'action' request parameter");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void superUserAction_approveAction_approvesDocument() throws WorkflowException {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String annotation = "myAnnotation";
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"annotation\": \"myAnnotation\", \"action\": \"approve\" }");
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        String principalId = "principalId";
        Mockito.when((Object)personMock.getPrincipalId()).thenReturn((Object)"principalId");
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        String documentTypeId = "DocumentTypeId";
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.getDocumentTypeId()).thenReturn((Object)"DocumentTypeId");
        Mockito.when((Object)formMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        String docId = "1234";
        Mockito.when((Object)formMock.getDocId()).thenReturn((Object)"1234");
        WorkflowDocumentActionsService workflowDocumentActionsServiceMock = (WorkflowDocumentActionsService)Mockito.mock(WorkflowDocumentActionsService.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)workflowDocumentActionsServiceMock).when((Object)this.cutSpy)).getWorkflowDocumentActionsService((String)ArgumentMatchers.eq((Object)"DocumentTypeId"));
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ArgumentCaptor actionParametersArgumentCaptor = ArgumentCaptor.forClass(DocumentActionParameters.class);
        Mockito.when((Object)workflowDocumentActionsServiceMock.superUserBlanketApprove((DocumentActionParameters)actionParametersArgumentCaptor.capture(), ArgumentMatchers.eq((boolean)true))).thenReturn(null);
        this.cutSpy.superUserAction(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        ((SuperUserService)Mockito.verify((Object)this.superUserServiceMock)).blanketApprove((String)ArgumentMatchers.eq((Object)"DocumentTypeId"), (String)ArgumentMatchers.eq((Object)"1234"), (Person)ArgumentMatchers.eq((Object)personMock), (String)ArgumentMatchers.eq((Object)"myAnnotation"));
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
    }

    @Test
    void superUserAction_disapproveAction_disapprovesDocument() throws WorkflowException {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        String annotation = "myAnnotation";
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"annotation\": \"myAnnotation\", \"action\": \"disapprove\" }");
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        String documentTypeId = "DocumentTypeId";
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.getDocumentTypeId()).thenReturn((Object)"DocumentTypeId");
        Mockito.when((Object)formMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        String docId = "1234";
        Mockito.when((Object)formMock.getDocId()).thenReturn((Object)"1234");
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        String adjusteeDocumentNumber = "adjusteeDocumentNumber";
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getAdjusteeDocumentNumber()).thenReturn((Object)"adjusteeDocumentNumber");
        Mockito.when((Object)formMock.getDocument()).thenReturn((Object)adjustmentDocumentMock);
        PaymentApplicationDocument adjusteeDocumentMock = (PaymentApplicationDocument)Mockito.mock(PaymentApplicationDocument.class);
        Mockito.when((Object)this.documentServiceMock.getByDocumentHeaderId("adjusteeDocumentNumber")).thenReturn((Object)adjusteeDocumentMock);
        this.cutSpy.superUserAction(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        ((SuperUserService)Mockito.verify((Object)this.superUserServiceMock)).disapprove((String)ArgumentMatchers.eq((Object)"DocumentTypeId"), (String)ArgumentMatchers.eq((Object)"1234"), (Person)ArgumentMatchers.eq((Object)personMock), (String)ArgumentMatchers.eq((Object)"myAnnotation"));
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        ((PaymentApplicationDocument)Mockito.verify((Object)adjusteeDocumentMock)).clearAdjusterDocumentNumber();
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).updateDocument((Document)adjusteeDocumentMock);
    }

    @Test
    void getGeneralLedgerPendingEntries_success_returnsGlpes() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        String glpeJson = "[{ \"objectId\": \"123\" }]";
        Mockito.when((Object)formMock.getGeneralLedgerPendingEntriesJson()).thenReturn((Object)"[{ \"objectId\": \"123\" }]");
        ActionForward actual = this.cutSpy.getGeneralLedgerPendingEntries(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        JSONAssert.assertEquals((String)"[{ \"objectId\": \"123\" }]", (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void getButtonGroup_success_returnsButtons() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).populateAuthorizationFields((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        String buttonsJson = "{ \"buttons\": [{ \"name\": \"save\" }] }";
        Mockito.when((Object)formMock.getButtonGroupJson()).thenReturn((Object)"{ \"buttons\": [{ \"name\": \"save\" }] }");
        ActionForward actual = this.cutSpy.getButtonGroup(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        JSONAssert.assertEquals((String)"{ \"buttons\": [{ \"name\": \"save\" }] }", (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void getDocumentActions_success_returnsActions() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).populateAuthorizationFields((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        String actionsJson = "{ \"canEdit\": \"true\" }";
        Mockito.when((Object)formMock.getDocumentActionsJson()).thenReturn((Object)"{ \"canEdit\": \"true\" }");
        ActionForward actual = this.cutSpy.getDocumentActions(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        JSONAssert.assertEquals((String)"{ \"canEdit\": \"true\" }", (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void getRouteLog_success_returnsRouteLog() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        String routeLogJson = "{ \"foo\": [{ \"bar\": \"baz\" }] }";
        Mockito.when((Object)formMock.getRouteLogResponseJson()).thenReturn((Object)"{ \"foo\": [{ \"bar\": \"baz\" }] }");
        ActionForward actual = this.cutSpy.getRouteLog(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        JSONAssert.assertEquals((String)"{ \"foo\": [{ \"bar\": \"baz\" }] }", (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void cancel_cancelsDocument() throws Exception {
        String adjusteeDocumentNumber = "adjusteeDocumentNumber";
        PaymentApplicationAdjustmentDocument adjustmentDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)adjustmentDocumentMock.getAdjusteeDocumentNumber()).thenReturn((Object)"adjusteeDocumentNumber");
        PaymentApplicationAdjustmentDocument adjusteeDocumentMock = (PaymentApplicationAdjustmentDocument)Mockito.mock(PaymentApplicationAdjustmentDocument.class);
        Mockito.when((Object)this.documentServiceMock.getByDocumentHeaderId("adjusteeDocumentNumber")).thenReturn((Object)adjusteeDocumentMock);
        PaymentApplicationAdjustmentForm appaFormMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        Mockito.when((Object)appaFormMock.getDocument()).thenReturn((Object)adjustmentDocumentMock);
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)appaFormMock));
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).doProcessingAfterPost((KualiForm)ArgumentMatchers.eq((Object)appaFormMock), (HttpServletRequest)ArgumentMatchers.eq((Object)requestMock));
        String annotation = "anAnnotation";
        Mockito.when((Object)appaFormMock.getAnnotation()).thenReturn((Object)"anAnnotation");
        this.cutSpy.cancel((ActionMapping)Mockito.mock(ActionMapping.class), (ActionForm)appaFormMock, requestMock, (HttpServletResponse)new MockHttpServletResponse());
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).cancelDocument((Document)ArgumentMatchers.eq((Object)adjustmentDocumentMock), (String)ArgumentMatchers.eq((Object)"anAnnotation"));
        ((PaymentApplicationAdjustmentDocument)Mockito.verify((Object)adjusteeDocumentMock)).clearAdjustmentDocumentNumber();
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock)).updateDocument((Document)ArgumentMatchers.eq((Object)adjusteeDocumentMock));
    }

    @Test
    void processSuperUserActions_formNotInStateToApproveActions_returnsForbidden() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        Mockito.when((Object)formMock.isStateAllowsApproveSingleActionRequest()).thenReturn((Object)false);
        this.cutSpy.processSuperUserActions(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Response.Status expectedStatus = Response.Status.FORBIDDEN;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "User is not permitted to take requested actions");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void processSuperUserActions_missingAnnotation_returnsBadRequest() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)formMock.isStateAllowsApproveSingleActionRequest()).thenReturn((Object)true);
        String requestJson = "{ \"actionIds\": [] }";
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"actionIds\": [] }");
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        this.cutSpy.processSuperUserActions(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Missing 'annotation' request parameter");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void processSuperUserActions_missingActions_returnsBadRequest() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)formMock.isStateAllowsApproveSingleActionRequest()).thenReturn((Object)true);
        String requestJson = "{ \"annotation\": \"myAnnotation\" }";
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"annotation\": \"myAnnotation\" }");
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        this.cutSpy.processSuperUserActions(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        String expectedJson = this.buildJsonResponseMessage(expectedStatus, "Invalid 'actionIds'. Expected list");
        JSONAssert.assertEquals((String)expectedJson, (String)actualJson, (JSONCompareMode)JSONCompareMode.STRICT);
    }

    @Test
    void processSuperUserActions_processesActions() throws Exception {
        String docId = "1234";
        String documentTypeId = "ABC";
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        WorkflowDocument workflowDocumentMock = (WorkflowDocument)Mockito.mock(WorkflowDocument.class);
        Mockito.when((Object)workflowDocumentMock.getDocumentTypeId()).thenReturn((Object)"ABC");
        Mockito.when((Object)formMock.getDocId()).thenReturn((Object)"1234");
        Mockito.when((Object)formMock.getWorkflowDocument()).thenReturn((Object)workflowDocumentMock);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)formMock.isStateAllowsApproveSingleActionRequest()).thenReturn((Object)true);
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        String annotation = "myAnnotation";
        String requestJson = "{ \"annotation\": \"myAnnotation\", \"actionIds\": [\"1\", \"2\"] }";
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"annotation\": \"myAnnotation\", \"actionIds\": [\"1\", \"2\"] }");
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        WorkflowDocumentService workflowDocumentServiceMock = (WorkflowDocumentService)Mockito.mock(WorkflowDocumentService.class);
        List<ActionRequest> actionRequests = List.of(ActionRequest.Builder.create((String)"1", (ActionRequestType)ActionRequestType.fromCode((String)"C"), (ActionRequestStatus)ActionRequestStatus.DONE, (String)"1234", (String)"5667", (RecipientType)RecipientType.PRINCIPAL).build(), ActionRequest.Builder.create((String)"2", (ActionRequestType)ActionRequestType.fromCode((String)"C"), (ActionRequestStatus)ActionRequestStatus.DONE, (String)"1234", (String)"5667", (RecipientType)RecipientType.PRINCIPAL).build(), ActionRequest.Builder.create((String)"3", (ActionRequestType)ActionRequestType.fromCode((String)"C"), (ActionRequestStatus)ActionRequestStatus.DONE, (String)"1234", (String)"5667", (RecipientType)RecipientType.PRINCIPAL).build());
        Mockito.when((Object)workflowDocumentServiceMock.getPendingActionRequests((String)ArgumentMatchers.eq((Object)"1234"))).thenReturn(actionRequests);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)workflowDocumentServiceMock).when((Object)this.cutSpy)).getWorkflowDocumentService();
        this.cutSpy.processSuperUserActions(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        ((SuperUserService)Mockito.verify((Object)this.superUserServiceMock, (VerificationMode)Mockito.times((int)2))).takeRequestedAction((ActionRequest)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"ABC"), (String)ArgumentMatchers.eq((Object)"1234"), (Person)ArgumentMatchers.eq((Object)personMock), (String)ArgumentMatchers.eq((Object)"myAnnotation"));
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
    }

    @Test
    void sendAdHocRequests_error_bad_request() throws Exception {
        ActionForward actual;
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        UserSession userSessionMock = (UserSession)Mockito.mock(UserSession.class);
        Person personMock = (Person)Mockito.mock(Person.class);
        HttpSession sessionMock = (HttpSession)Mockito.mock(HttpSession.class);
        KualiRuleService ruleServiceMock = (KualiRuleService)Mockito.mock(KualiRuleService.class);
        Document documentMock = (Document)Mockito.mock(Document.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)this.adHocRoutingServiceMock).when((Object)this.cutSpy)).getAdHocRoutingService();
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)this.documentServiceMock).when((Object)this.cutSpy)).getDocumentService();
        String recipientPrincipalName = "khuntley";
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        Mockito.when((Object)userSessionMock.getPerson()).thenReturn((Object)personMock);
        Mockito.when((Object)sessionMock.getAttribute((String)ArgumentMatchers.eq((Object)"cf.UserSession"))).thenReturn((Object)userSessionMock);
        Mockito.when((Object)requestMock.getSession()).thenReturn((Object)sessionMock);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"adHocRouting\":{\"groups\":[],\"persons\":[{ \"principalName\": \"khuntley\", \"action\": \"F\" }]}, \"invoiceApplications\":[], \"nonAppliedHoldings\":[], \"accountingLines\":[] }");
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)ruleServiceMock).when((Object)this.cutSpy)).getKualiRuleService();
        ((KualiRuleService)Mockito.doReturn((Object)true).when((Object)ruleServiceMock)).applyRules((KualiDocumentEvent)ArgumentMatchers.any());
        Mockito.when((Object)formMock.getDocument()).thenReturn((Object)documentMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ((DocumentService)Mockito.doThrow((Throwable[])new Throwable[]{new WorkflowException("blah")}).when((Object)this.documentServiceMock)).sendAdHocRequests((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        try (MockedStatic kimApiServiceLocatorMockedStatic = Mockito.mockStatic(KimApiServiceLocator.class);){
            kimApiServiceLocatorMockedStatic.when(KimApiServiceLocator::getPersonService).thenReturn((Object)this.personServiceMock);
            actual = this.cutSpy.sendAdHocRequests(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        }
        Assertions.assertNull((Object)actual);
        ((PaymentApplicationAdjustmentAction)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.times((int)1))).updateAdHocRouting((HttpServletRequest)ArgumentMatchers.eq((Object)requestMock), (KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock), (AdHocRoutingRequest)ArgumentMatchers.any());
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.times((int)1))).sendAdHocRequests((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
    }

    @Test
    void sendAdHocRequests_error_no_recipients() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"adHocRouting\":{\"groups\":[],\"persons\":[]}, \"invoiceApplications\":[], \"nonAppliedHoldings\":[], \"accountingLines\":[] }");
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ActionForward actual = this.cutSpy.sendAdHocRequests(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        ((PaymentApplicationAdjustmentAction)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.times((int)0))).updateAdHocRouting((HttpServletRequest)ArgumentMatchers.eq((Object)requestMock), (KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock), (AdHocRoutingRequest)ArgumentMatchers.any());
    }

    @Test
    void sendAdHocRequests_success_notifications_sent() throws Exception {
        ActionMapping mappingMock = (ActionMapping)Mockito.mock(ActionMapping.class);
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        KualiRuleService ruleServiceMock = (KualiRuleService)Mockito.mock(KualiRuleService.class);
        Document documentMock = (Document)Mockito.mock(Document.class);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)this.documentServiceMock).when((Object)this.cutSpy)).getDocumentService();
        String recipientPrincipalName = "khuntley";
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{ \"adHocRouting\":{\"groups\":[],\"persons\":[{ \"principalName\": \"khuntley\", \"action\": \"F\" }]}, \"invoiceApplications\":[], \"nonAppliedHoldings\":[], \"accountingLines\":[] }");
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)ruleServiceMock).when((Object)this.cutSpy)).getKualiRuleService();
        ((KualiRuleService)Mockito.doReturn((Object)true).when((Object)ruleServiceMock)).applyRules((KualiDocumentEvent)ArgumentMatchers.any());
        Mockito.when((Object)formMock.getDocument()).thenReturn((Object)documentMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).loadDocument((KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock));
        ((PaymentApplicationAdjustmentAction)Mockito.doNothing().when((Object)this.cutSpy)).updateAdHocRouting((HttpServletRequest)ArgumentMatchers.eq((Object)requestMock), (KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock), (AdHocRoutingRequest)ArgumentMatchers.any());
        ((DocumentService)Mockito.doNothing().when((Object)this.documentServiceMock)).sendAdHocRequests((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        ActionForward actual = this.cutSpy.sendAdHocRequests(mappingMock, (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        Assertions.assertNull((Object)actual);
        ((PaymentApplicationAdjustmentAction)Mockito.verify((Object)this.cutSpy, (VerificationMode)Mockito.times((int)1))).updateAdHocRouting((HttpServletRequest)ArgumentMatchers.eq((Object)requestMock), (KualiDocumentFormBase)ArgumentMatchers.eq((Object)formMock), (AdHocRoutingRequest)ArgumentMatchers.any());
        ((DocumentService)Mockito.verify((Object)this.documentServiceMock, (VerificationMode)Mockito.times((int)1))).sendAdHocRequests((Document)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (List)ArgumentMatchers.any());
        Response.Status expectedStatus = Response.Status.OK;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
    }

    @Test
    void saveWithNonArAccountingLineWithClosedAccount() throws Exception {
        ActionForward actual;
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String chartCode = "BL";
        String accountNumber = "2131401";
        String requestJson = "{   \"invoiceApplications\":[],   \"nonAppliedHoldings\":[],   \"accountingLines\":[      {         \"chartCode\": \"BL\",         \"accountNumber\": \"2131401\",         \"object\": \"0000\",         \"amount\": 330      }   ] }";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{   \"invoiceApplications\":[],   \"nonAppliedHoldings\":[],   \"accountingLines\":[      {         \"chartCode\": \"BL\",         \"accountNumber\": \"2131401\",         \"object\": \"0000\",         \"amount\": 330      }   ] }");
        Account accountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)accountMock.isClosed()).thenReturn((Object)true);
        AccountService accountServiceMock = (AccountService)Mockito.mock(AccountService.class);
        Mockito.when((Object)accountServiceMock.getByPrimaryId((String)ArgumentMatchers.eq((Object)"BL"), (String)ArgumentMatchers.eq((Object)"2131401"))).thenReturn((Object)accountMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)accountServiceMock).when((Object)this.cutSpy)).getAccountService();
        String documentNumber = "documentNumber";
        Document documentMock = (Document)Mockito.mock(Document.class);
        Mockito.when((Object)documentMock.getDocumentNumber()).thenReturn((Object)"documentNumber");
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        Mockito.when((Object)formMock.getDocument()).thenReturn((Object)documentMock);
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn(Mockito.mock(ConfigurationService.class));
            actual = this.cutSpy.save((ActionMapping)Mockito.mock(ActionMapping.class), (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        }
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        Assertions.assertTrue((boolean)actualJson.contains("accountingLines.0.accountNumber"));
        Assertions.assertTrue((boolean)actualJson.contains("modal.message"));
        Assertions.assertTrue((boolean)actualJson.contains("modal.title"));
    }

    @Test
    void submitWithNonArAccountingLineWithClosedAccount() throws Exception {
        ActionForward actual;
        MockHttpServletResponse responseMock = new MockHttpServletResponse();
        String chartCode = "BL";
        String accountNumber = "2131401";
        String requestJson = "{   \"invoiceApplications\":[],   \"nonAppliedHoldings\":[],   \"accountingLines\":[      {         \"chartCode\": \"BL\",         \"accountNumber\": \"2131401\",         \"object\": \"0000\",         \"amount\": 330      }   ] }";
        HttpServletRequest requestMock = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)requestMock.getParameter("data")).thenReturn((Object)"{   \"invoiceApplications\":[],   \"nonAppliedHoldings\":[],   \"accountingLines\":[      {         \"chartCode\": \"BL\",         \"accountNumber\": \"2131401\",         \"object\": \"0000\",         \"amount\": 330      }   ] }");
        Account accountMock = (Account)Mockito.mock(Account.class);
        Mockito.when((Object)accountMock.isClosed()).thenReturn((Object)true);
        AccountService accountServiceMock = (AccountService)Mockito.mock(AccountService.class);
        Mockito.when((Object)accountServiceMock.getByPrimaryId((String)ArgumentMatchers.eq((Object)"BL"), (String)ArgumentMatchers.eq((Object)"2131401"))).thenReturn((Object)accountMock);
        ((PaymentApplicationAdjustmentAction)Mockito.doReturn((Object)accountServiceMock).when((Object)this.cutSpy)).getAccountService();
        String documentNumber = "documentNumber";
        Document documentMock = (Document)Mockito.mock(Document.class);
        Mockito.when((Object)documentMock.getDocumentNumber()).thenReturn((Object)"documentNumber");
        PaymentApplicationAdjustmentForm formMock = (PaymentApplicationAdjustmentForm)Mockito.mock(PaymentApplicationAdjustmentForm.class);
        Mockito.when((Object)formMock.getDocument()).thenReturn((Object)documentMock);
        try (MockedStatic springContextMockedStatic = Mockito.mockStatic(SpringContext.class);){
            springContextMockedStatic.when(() -> SpringContext.getBean(ConfigurationService.class)).thenReturn(Mockito.mock(ConfigurationService.class));
            actual = this.cutSpy.route((ActionMapping)Mockito.mock(ActionMapping.class), (ActionForm)formMock, requestMock, (HttpServletResponse)responseMock);
        }
        Assertions.assertNull((Object)actual);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        Assertions.assertEquals((int)expectedStatus.getStatusCode(), (int)responseMock.getStatus());
        String actualJson = responseMock.getContentAsString();
        Assertions.assertTrue((boolean)actualJson.contains("accountingLines.0.accountNumber"));
        Assertions.assertTrue((boolean)actualJson.contains("modal.message"));
        Assertions.assertTrue((boolean)actualJson.contains("modal.title"));
    }

    String buildJsonResponseMessage(Response.Status status, String message) {
        return "{  \"status\": \"" + status.name() + "\",  \"message\": \"" + message + "\"}";
    }
}

