/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiIntegTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

@ConfigureContext
public class AccountsReceivableProcessingOrganizationRoleTypeServiceImplIntegTest
extends KualiIntegTestBase {
    protected static final String AR_NAMESPACE = "KFS-AR";
    protected static final String AR_BILLER_ROLE = "Biller";
    protected static final String AR_PROCESSOR_ROLE = "Processor";
    protected static final String AR_DOC_USER = "besnead";
    protected static final String AR_DOC_CHART = "BA";
    protected static final String AR_DOC_ORG = "MOTR";
    protected static final String AR_DOC_USER_2 = "rginn";
    protected static final String AR_DOC_CHART_2 = "IN";
    protected static final String AR_DOC_ORG_2 = "LART";
    private static RoleService roleManagementService;
    private String arUserPrincipalId;
    private String arUserPrincipalId2;

    protected Map<String, String> buildDocQualifier() {
        HashMap<String, String> qualification = new HashMap<String, String>();
        qualification.put("chartOfAccountsCode", AR_DOC_CHART);
        qualification.put("organizationCode", AR_DOC_ORG);
        return qualification;
    }

    protected Map<String, String> buildDocQualifier_2() {
        HashMap<String, String> qualification = new HashMap<String, String>();
        qualification.put("chartOfAccountsCode", AR_DOC_CHART_2);
        qualification.put("organizationCode", AR_DOC_ORG_2);
        return qualification;
    }

    protected String getArUserPrincipalId() {
        if (this.arUserPrincipalId == null) {
            this.arUserPrincipalId = ((IdentityService)SpringContext.getBean(IdentityService.class)).getPrincipalByPrincipalName(AR_DOC_USER).getPrincipalId();
        }
        return this.arUserPrincipalId;
    }

    protected String getArUserPrincipalId_2() {
        if (this.arUserPrincipalId2 == null) {
            this.arUserPrincipalId2 = ((IdentityService)SpringContext.getBean(IdentityService.class)).getPrincipalByPrincipalName(AR_DOC_USER_2).getPrincipalId();
        }
        return this.arUserPrincipalId2;
    }

    public void testPrincipalHasRole_Data1() {
        ArrayList<String> tempRoleIdList = new ArrayList<String>(1);
        Map<String, String> qualification = this.buildDocQualifier();
        String billerRoleId = this.getRoleService().getRoleIdByNamespaceCodeAndName(AR_NAMESPACE, AR_BILLER_ROLE);
        AccountsReceivableProcessingOrganizationRoleTypeServiceImplIntegTest.assertNotNull((String)"unable to find biller role", (Object)billerRoleId);
        tempRoleIdList.add(billerRoleId);
        boolean result = this.getRoleService().principalHasRole(this.getArUserPrincipalId(), tempRoleIdList, qualification);
        AccountsReceivableProcessingOrganizationRoleTypeServiceImplIntegTest.assertTrue((String)"exact match on billing org should have passed", (boolean)result);
        String processorRoleId = this.getRoleService().getRoleIdByNamespaceCodeAndName(AR_NAMESPACE, AR_PROCESSOR_ROLE);
        AccountsReceivableProcessingOrganizationRoleTypeServiceImplIntegTest.assertNotNull((String)"unable to find processor role", (Object)processorRoleId);
        tempRoleIdList.clear();
        tempRoleIdList.add(processorRoleId);
        result = this.getRoleService().principalHasRole(this.getArUserPrincipalId(), tempRoleIdList, qualification);
        AccountsReceivableProcessingOrganizationRoleTypeServiceImplIntegTest.assertFalse((String)"test on main user for processing org should have failed - does not have processing org on KFS-SYS User role", (boolean)result);
    }

    public void testPrincipalHasRole_Data2() {
        ArrayList<String> tempRoleIdList = new ArrayList<String>(1);
        Map<String, String> qualification = this.buildDocQualifier_2();
        String billerRoleId = this.getRoleService().getRoleIdByNamespaceCodeAndName(AR_NAMESPACE, AR_BILLER_ROLE);
        AccountsReceivableProcessingOrganizationRoleTypeServiceImplIntegTest.assertNotNull((String)"unable to find biller role", (Object)billerRoleId);
        tempRoleIdList.add(billerRoleId);
        boolean result = this.getRoleService().principalHasRole(this.getArUserPrincipalId_2(), tempRoleIdList, qualification);
        AccountsReceivableProcessingOrganizationRoleTypeServiceImplIntegTest.assertTrue((String)"exact match on billing org should have passed - user has processing org, not billing org, but all processors are also billers", (boolean)result);
        String processorRoleId = this.getRoleService().getRoleIdByNamespaceCodeAndName(AR_NAMESPACE, AR_PROCESSOR_ROLE);
        AccountsReceivableProcessingOrganizationRoleTypeServiceImplIntegTest.assertNotNull((String)"unable to find processor role", (Object)processorRoleId);
        tempRoleIdList.clear();
        tempRoleIdList.add(processorRoleId);
        result = this.getRoleService().principalHasRole(this.getArUserPrincipalId_2(), tempRoleIdList, qualification);
        AccountsReceivableProcessingOrganizationRoleTypeServiceImplIntegTest.assertTrue((String)"principalHasRole test for processor role should have passed - user has processing org on KFS-SYS User role", (boolean)result);
    }

    public RoleService getRoleService() {
        if (roleManagementService == null) {
            roleManagementService = KimApiServiceLocator.getRoleService();
        }
        return roleManagementService;
    }
}

