/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.sql.Date;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsInstrumentType;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResult;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceLookupResultAward;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.fixture.ARAgencyMockFixture;
import org.kuali.kfs.module.ar.report.service.impl.ContractsGrantsInvoiceReportServiceImpl;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class ContractsGrantsInvoiceReportServiceImplTest {
    private ContractsGrantsInvoiceReportServiceImpl cut;
    private Date awardBeginningDate;
    private Date awardEndingDate;
    private Date secondAwardBeginningDate;
    private Date secondAwardEndingDate;
    private Date thirdAwardBeginningDate;
    private Date thirdAwardEndingDate;
    @Mock
    private ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationSvcMock;

    ContractsGrantsInvoiceReportServiceImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.cut = new ContractsGrantsInvoiceReportServiceImpl();
        this.cut.setContractsGrantsBillingAwardVerificationService(this.contractsGrantsBillingAwardVerificationSvcMock);
        this.setupDates();
    }

    private void setupDates() {
        this.awardBeginningDate = Date.valueOf(LocalDate.now());
        this.awardEndingDate = Date.valueOf(LocalDate.now().plusYears(1L));
        this.secondAwardBeginningDate = Date.valueOf(LocalDate.now().minusMonths(1L));
        this.secondAwardEndingDate = Date.valueOf(LocalDate.now().plusYears(1L));
        this.thirdAwardBeginningDate = Date.valueOf(LocalDate.now().plusMonths(1L));
        this.thirdAwardEndingDate = Date.valueOf(LocalDate.now().plusYears(1L));
    }

    private void setupContractsAndGrantsBillingAwardMock(ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock, ContractsAndGrantsInstrumentType instrumentTypeMock, String proposalNumber, String billingFrequencyCode, Date awardBeginningDate, Date awardEndingDate, String instrumentTypeCode, String invoicingOptionDescription, double awardTotalAmount) {
        String instrumentTypeDescription = instrumentTypeCode + "-Description";
        Mockito.when((Object)instrumentTypeMock.getInstrumentTypeDescription()).thenReturn((Object)instrumentTypeDescription);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getProposalNumber()).thenReturn((Object)proposalNumber);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getBillingFrequencyCode()).thenReturn((Object)billingFrequencyCode);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAwardBeginningDate()).thenReturn((Object)awardBeginningDate);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAwardEndingDate()).thenReturn((Object)awardEndingDate);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getInstrumentType()).thenReturn((Object)instrumentTypeMock);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getInvoicingOptionDescription()).thenReturn((Object)invoicingOptionDescription);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAwardTotalAmount()).thenReturn((Object)new KualiDecimal(awardTotalAmount));
    }

    private void setupContractsAndGrantsBillingAwardMock2(ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock, ContractsAndGrantsInstrumentType instrumentTypeMock, String proposalNumber, String billingFrequencyCode, Date awardBeginningDate, Date awardEndingDate, String instrumentTypeCode, String invoicingOptionDescription, double awardTotalAmount, ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgency) {
        this.setupContractsAndGrantsBillingAwardMock(contractsAndGrantsBillingAwardMock, instrumentTypeMock, proposalNumber, billingFrequencyCode, awardBeginningDate, awardEndingDate, instrumentTypeCode, invoicingOptionDescription, awardTotalAmount);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAgency()).thenReturn((Object)contractsAndGrantsBillingAgency);
    }

    private void setupContractsAndGrantsBillingAwardMock3(ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock, ContractsAndGrantsInstrumentType instrumentTypeMock, String proposalNumber, String billingFrequencyCode, Date awardBeginningDate, Date awardEndingDate, String instrumentTypeCode, String invoicingOptionDescription, double awardTotalAmount, ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgency) {
        this.setupContractsAndGrantsBillingAwardMock(contractsAndGrantsBillingAwardMock, instrumentTypeMock, proposalNumber, billingFrequencyCode, awardBeginningDate, awardEndingDate, instrumentTypeCode, invoicingOptionDescription, awardTotalAmount);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAgency()).thenReturn((Object)contractsAndGrantsBillingAgency);
        String agencyNumber = contractsAndGrantsBillingAgency.getAgencyNumber();
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
    }

    private void setupContractsAndGrantsBillingAwardMock4(ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock, ContractsAndGrantsInstrumentType instrumentTypeMock, String proposalNumber, String billingFrequencyCode, Date awardBeginningDate, Date awardEndingDate, String instrumentTypeCode, String invoicingOptionDescription, double awardTotalAmount, ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgency) {
        this.setupContractsAndGrantsBillingAwardMock(contractsAndGrantsBillingAwardMock, instrumentTypeMock, proposalNumber, billingFrequencyCode, awardBeginningDate, awardEndingDate, instrumentTypeCode, invoicingOptionDescription, awardTotalAmount);
        String agencyNumber = contractsAndGrantsBillingAgency.getAgencyNumber();
        Mockito.when((Object)contractsAndGrantsBillingAwardMock.getAgencyNumber()).thenReturn((Object)agencyNumber);
    }

    private void setupAwardAccountMock(ContractsAndGrantsBillingAwardAccount awardAccountMock, String chartOfAccountsCode, String accountNumber, ContractsAndGrantsBillingAward award) {
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)chartOfAccountsCode);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Mockito.when((Object)awardAccountMock.getAward()).thenReturn((Object)award);
    }

    private void setupAwardAccountMock1(ContractsAndGrantsBillingAwardAccount awardAccountMock, String chartOfAccountsCode, String accountNumber) {
        Mockito.when((Object)awardAccountMock.getChartOfAccountsCode()).thenReturn((Object)chartOfAccountsCode);
        Mockito.when((Object)awardAccountMock.getAccountNumber()).thenReturn((Object)accountNumber);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationSvcMock.isAwardAccountValidToInvoiceBasedOnSchedule(awardAccountMock)).thenReturn((Object)true);
    }

    @Test
    void getPopulatedContractsGrantsInvoiceLookupResults_NoAwards() {
        ArrayList awards = new ArrayList();
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResults(awards);
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceLookupResults.size());
    }

    @Test
    void getPopulatedContractsGrantsInvoiceLookupResults_OneAwardTwoAwardAccounts(@Mock ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock1, @Mock ContractsAndGrantsInstrumentType instrumentTypeMock1, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock2) {
        ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgencyMock1 = ARAgencyMockFixture.CG_AGENCY2.createAgencyMock();
        this.setupContractsAndGrantsBillingAwardMock3(contractsAndGrantsBillingAwardMock1, instrumentTypeMock1, "1", ArConstants.BillingFrequencyValues.MONTHLY.getCode(), this.awardBeginningDate, this.awardEndingDate, "ITC1", "Invoicing Option Description 1", 1000.0, contractsAndGrantsBillingAgencyMock1);
        this.setupAwardAccountMock1(awardAccountMock1, "C1", "A1");
        this.setupAwardAccountMock1(awardAccountMock2, "C2", "A2");
        Mockito.when((Object)contractsAndGrantsBillingAwardMock1.getActiveAwardAccounts()).thenReturn(Arrays.asList(awardAccountMock1, awardAccountMock2));
        List<ContractsAndGrantsBillingAward> awards = Collections.singletonList(contractsAndGrantsBillingAwardMock1);
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResults(awards);
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceLookupResults.size());
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult = (ContractsGrantsInvoiceLookupResult)contractsGrantsInvoiceLookupResults.iterator().next();
        Assertions.assertEquals((Object)"A1", (Object)contractsGrantsInvoiceLookupResult.getAgencyNumber());
        Assertions.assertEquals((Object)"Agency Reporting Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyReportingName());
        Assertions.assertEquals((Object)"Agency Full Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyFullName());
        Assertions.assertEquals((Object)"C1", (Object)contractsGrantsInvoiceLookupResult.getCustomerNumber());
        Assertions.assertEquals((int)2, (int)contractsGrantsInvoiceLookupResult.getLookupResultAwards().size());
        int lookupResultAwardCount = 1;
        for (ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward : contractsGrantsInvoiceLookupResult.getLookupResultAwards()) {
            Assertions.assertEquals((Object)"1", (Object)contractsGrantsInvoiceLookupResultAward.getProposalNumber());
            Assertions.assertEquals((Object)("C" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getChartOfAccountsCode());
            Assertions.assertEquals((Object)("A" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getAccountNumber());
            Assertions.assertEquals((Object)this.awardBeginningDate, (Object)contractsGrantsInvoiceLookupResultAward.getAwardBeginningDate());
            Assertions.assertEquals((Object)this.awardEndingDate, (Object)contractsGrantsInvoiceLookupResultAward.getAwardEndingDate());
            Assertions.assertEquals((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode(), (Object)contractsGrantsInvoiceLookupResultAward.getBillingFrequencyCode());
            Assertions.assertEquals((Object)"ITC1-Description", (Object)contractsGrantsInvoiceLookupResultAward.getInstrumentTypeDescription());
            Assertions.assertEquals((Object)"Invoicing Option Description 1", (Object)contractsGrantsInvoiceLookupResultAward.getInvoicingOptionDescription());
            Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)contractsGrantsInvoiceLookupResultAward.getAwardTotalAmount());
            ++lookupResultAwardCount;
        }
    }

    @Test
    void getPopulatedContractsGrantsInvoiceLookupResults_MultipleAgenciesAwardsAndAwardAccounts(@Mock ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock1, @Mock ContractsAndGrantsInstrumentType instrumentTypeMock1, @Mock ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock2, @Mock ContractsAndGrantsInstrumentType instrumentTypeMock2, @Mock ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock3, @Mock ContractsAndGrantsInstrumentType instrumentTypeMock3, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock2, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock3, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock4, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock5, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock6) {
        ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward2;
        ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgencyMock1 = ARAgencyMockFixture.CG_AGENCY2.createAgencyMock();
        ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgencyMock2 = ARAgencyMockFixture.CG_AGENCY3.createAgencyMock();
        this.setupContractsAndGrantsBillingAwardMock3(contractsAndGrantsBillingAwardMock1, instrumentTypeMock1, "1", ArConstants.BillingFrequencyValues.MONTHLY.getCode(), this.awardBeginningDate, this.awardEndingDate, "ITC1", "Invoicing Option Description 1", 1000.0, contractsAndGrantsBillingAgencyMock1);
        this.setupContractsAndGrantsBillingAwardMock4(contractsAndGrantsBillingAwardMock2, instrumentTypeMock2, "2", ArConstants.BillingFrequencyValues.MILESTONE.getCode(), this.secondAwardBeginningDate, this.secondAwardEndingDate, "ITC2", "Invoicing Option Description 2", 2000.0, contractsAndGrantsBillingAgencyMock1);
        this.setupContractsAndGrantsBillingAwardMock3(contractsAndGrantsBillingAwardMock3, instrumentTypeMock3, "3", ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), this.thirdAwardBeginningDate, this.thirdAwardEndingDate, "ITC3", "Invoicing Option Description 3", 3000.0, contractsAndGrantsBillingAgencyMock2);
        this.setupAwardAccountMock1(awardAccountMock1, "C1", "A1");
        this.setupAwardAccountMock1(awardAccountMock2, "C2", "A2");
        this.setupAwardAccountMock1(awardAccountMock3, "C3", "A3");
        this.setupAwardAccountMock1(awardAccountMock4, "C4", "A4");
        Mockito.when((Object)contractsAndGrantsBillingAwardMock1.getActiveAwardAccounts()).thenReturn(Arrays.asList(awardAccountMock1, awardAccountMock2));
        Mockito.when((Object)contractsAndGrantsBillingAwardMock2.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock3));
        Mockito.when((Object)contractsAndGrantsBillingAwardMock3.getActiveAwardAccounts()).thenReturn(Collections.singletonList(awardAccountMock4));
        ArrayList<ContractsAndGrantsBillingAward> awards = new ArrayList<ContractsAndGrantsBillingAward>();
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationSvcMock.isAwardAccountValidToInvoiceBasedOnSchedule(awardAccountMock5)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationSvcMock.isAwardAccountValidToInvoiceBasedOnSchedule(awardAccountMock6)).thenReturn((Object)true);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationSvcMock.isAwardAccountValidToInvoiceBasedOnSchedule(awardAccountMock5)).thenReturn((Object)false);
        Mockito.when((Object)this.contractsGrantsBillingAwardVerificationSvcMock.isAwardAccountValidToInvoiceBasedOnSchedule(awardAccountMock6)).thenReturn((Object)false);
        Mockito.when((Object)contractsAndGrantsBillingAwardMock2.getActiveAwardAccounts()).thenReturn(Arrays.asList(awardAccountMock3, awardAccountMock5));
        Mockito.when((Object)contractsAndGrantsBillingAwardMock3.getActiveAwardAccounts()).thenReturn(Arrays.asList(awardAccountMock4, awardAccountMock6));
        awards.add(contractsAndGrantsBillingAwardMock1);
        awards.add(contractsAndGrantsBillingAwardMock2);
        awards.add(contractsAndGrantsBillingAwardMock3);
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResults(awards);
        Assertions.assertEquals((int)2, (int)contractsGrantsInvoiceLookupResults.size());
        Iterator iter = contractsGrantsInvoiceLookupResults.iterator();
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult = (ContractsGrantsInvoiceLookupResult)iter.next();
        Assertions.assertEquals((Object)"A1", (Object)contractsGrantsInvoiceLookupResult.getAgencyNumber());
        Assertions.assertEquals((Object)"Agency Reporting Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyReportingName());
        Assertions.assertEquals((Object)"Agency Full Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyFullName());
        Assertions.assertEquals((Object)"C1", (Object)contractsGrantsInvoiceLookupResult.getCustomerNumber());
        Assertions.assertEquals((int)3, (int)contractsGrantsInvoiceLookupResult.getLookupResultAwards().size());
        String[] expectedProposalNumbers = new String[]{"1", "1", "2"};
        Date[] expectedAwardBeginningDates = new Date[]{this.awardBeginningDate, this.awardBeginningDate, this.secondAwardBeginningDate};
        Date[] expectedAwardEndingDates = new Date[]{this.awardEndingDate, this.awardEndingDate, this.secondAwardEndingDate};
        String[] expectedBillingFrequencyCodes = new String[]{ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ArConstants.BillingFrequencyValues.MILESTONE.getCode()};
        String[] expectedInstrumentTypeDescriptions = new String[]{"ITC1-Description", "ITC1-Description", "ITC2-Description"};
        String[] expectedInvoicingOptionDescriptions = new String[]{"Invoicing Option Description 1", "Invoicing Option Description 1", "Invoicing Option Description 2"};
        KualiDecimal[] expectedAwardTotalAmounts = new KualiDecimal[]{new KualiDecimal(1000.0), new KualiDecimal(1000.0), new KualiDecimal(2000.0)};
        int lookupResultAwardCount = 1;
        for (ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward2 : contractsGrantsInvoiceLookupResult.getLookupResultAwards()) {
            Assertions.assertEquals((Object)expectedProposalNumbers[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getProposalNumber());
            Assertions.assertEquals((Object)("C" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward2.getChartOfAccountsCode());
            Assertions.assertEquals((Object)("A" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward2.getAccountNumber());
            Assertions.assertEquals((Object)expectedAwardBeginningDates[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getAwardBeginningDate());
            Assertions.assertEquals((Object)expectedAwardEndingDates[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getAwardEndingDate());
            Assertions.assertEquals((Object)expectedBillingFrequencyCodes[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getBillingFrequencyCode());
            Assertions.assertEquals((Object)expectedInstrumentTypeDescriptions[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getInstrumentTypeDescription());
            Assertions.assertEquals((Object)expectedInvoicingOptionDescriptions[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getInvoicingOptionDescription());
            Assertions.assertEquals((Object)expectedAwardTotalAmounts[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward2.getAwardTotalAmount());
            ++lookupResultAwardCount;
        }
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult2 = (ContractsGrantsInvoiceLookupResult)iter.next();
        Assertions.assertEquals((Object)"A2", (Object)contractsGrantsInvoiceLookupResult2.getAgencyNumber());
        Assertions.assertEquals((Object)"Agency Reporting Name 2", (Object)contractsGrantsInvoiceLookupResult2.getAgencyReportingName());
        Assertions.assertEquals((Object)"Agency Full Name 2", (Object)contractsGrantsInvoiceLookupResult2.getAgencyFullName());
        Assertions.assertEquals((Object)"C2", (Object)contractsGrantsInvoiceLookupResult2.getCustomerNumber());
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceLookupResult2.getLookupResultAwards().size());
        contractsGrantsInvoiceLookupResultAward2 = (ContractsGrantsInvoiceLookupResultAward)contractsGrantsInvoiceLookupResult2.getLookupResultAwards().iterator().next();
        Assertions.assertEquals((Object)"3", (Object)contractsGrantsInvoiceLookupResultAward2.getProposalNumber());
        Assertions.assertEquals((Object)"C4", (Object)contractsGrantsInvoiceLookupResultAward2.getChartOfAccountsCode());
        Assertions.assertEquals((Object)"A4", (Object)contractsGrantsInvoiceLookupResultAward2.getAccountNumber());
        Assertions.assertEquals((Object)this.thirdAwardBeginningDate, (Object)contractsGrantsInvoiceLookupResultAward2.getAwardBeginningDate());
        Assertions.assertEquals((Object)this.thirdAwardEndingDate, (Object)contractsGrantsInvoiceLookupResultAward2.getAwardEndingDate());
        Assertions.assertEquals((Object)ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), (Object)contractsGrantsInvoiceLookupResultAward2.getBillingFrequencyCode());
        Assertions.assertEquals((Object)"ITC3-Description", (Object)contractsGrantsInvoiceLookupResultAward2.getInstrumentTypeDescription());
        Assertions.assertEquals((Object)"Invoicing Option Description 3", (Object)contractsGrantsInvoiceLookupResultAward2.getInvoicingOptionDescription());
        Assertions.assertEquals((Object)new KualiDecimal(3000.0), (Object)contractsGrantsInvoiceLookupResultAward2.getAwardTotalAmount());
    }

    @Test
    void getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts_NoAwardAccounts() {
        ArrayList awardAccounts = new ArrayList();
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts(awardAccounts);
        Assertions.assertEquals((int)0, (int)contractsGrantsInvoiceLookupResults.size());
    }

    @Test
    void getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts_TwoAwardAccounts(@Mock ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock1, @Mock ContractsAndGrantsInstrumentType instrumentTypeMock1, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock2) {
        ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgencyMock1 = ARAgencyMockFixture.CG_AGENCY2.createAgencyMock();
        this.setupContractsAndGrantsBillingAwardMock2(contractsAndGrantsBillingAwardMock1, instrumentTypeMock1, "1", ArConstants.BillingFrequencyValues.MONTHLY.getCode(), this.awardBeginningDate, this.awardEndingDate, "ITC1", "Invoicing Option Description 1", 1000.0, contractsAndGrantsBillingAgencyMock1);
        this.setupAwardAccountMock(awardAccountMock1, "C1", "A1", contractsAndGrantsBillingAwardMock1);
        this.setupAwardAccountMock(awardAccountMock2, "C2", "A2", contractsAndGrantsBillingAwardMock1);
        List<ContractsAndGrantsBillingAwardAccount> awardAccounts = Arrays.asList(awardAccountMock1, awardAccountMock2);
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts(awardAccounts);
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceLookupResults.size());
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult = (ContractsGrantsInvoiceLookupResult)contractsGrantsInvoiceLookupResults.iterator().next();
        Assertions.assertEquals((Object)"A1", (Object)contractsGrantsInvoiceLookupResult.getAgencyNumber());
        Assertions.assertEquals((Object)"Agency Reporting Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyReportingName());
        Assertions.assertEquals((Object)"Agency Full Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyFullName());
        Assertions.assertEquals((Object)"C1", (Object)contractsGrantsInvoiceLookupResult.getCustomerNumber());
        Assertions.assertEquals((int)2, (int)contractsGrantsInvoiceLookupResult.getLookupResultAwards().size());
        int lookupResultAwardCount = 1;
        for (ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward : contractsGrantsInvoiceLookupResult.getLookupResultAwards()) {
            Assertions.assertEquals((Object)"1", (Object)contractsGrantsInvoiceLookupResultAward.getProposalNumber());
            Assertions.assertEquals((Object)("C" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getChartOfAccountsCode());
            Assertions.assertEquals((Object)("A" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getAccountNumber());
            Assertions.assertEquals((Object)this.awardBeginningDate, (Object)contractsGrantsInvoiceLookupResultAward.getAwardBeginningDate());
            Assertions.assertEquals((Object)this.awardEndingDate, (Object)contractsGrantsInvoiceLookupResultAward.getAwardEndingDate());
            Assertions.assertEquals((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode(), (Object)contractsGrantsInvoiceLookupResultAward.getBillingFrequencyCode());
            Assertions.assertEquals((Object)"ITC1-Description", (Object)contractsGrantsInvoiceLookupResultAward.getInstrumentTypeDescription());
            Assertions.assertEquals((Object)"Invoicing Option Description 1", (Object)contractsGrantsInvoiceLookupResultAward.getInvoicingOptionDescription());
            Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)contractsGrantsInvoiceLookupResultAward.getAwardTotalAmount());
            ++lookupResultAwardCount;
        }
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceLookupResult.getAwards().size());
        ContractsAndGrantsBillingAward awardToCompare = (ContractsAndGrantsBillingAward)contractsGrantsInvoiceLookupResult.getAwards().iterator().next();
        Assertions.assertEquals((Object)"1", (Object)awardToCompare.getProposalNumber());
        Assertions.assertEquals((Object)this.awardBeginningDate, (Object)awardToCompare.getAwardBeginningDate());
        Assertions.assertEquals((Object)this.awardEndingDate, (Object)awardToCompare.getAwardEndingDate());
        Assertions.assertEquals((Object)ArConstants.BillingFrequencyValues.MONTHLY.getCode(), (Object)awardToCompare.getBillingFrequencyCode());
        Assertions.assertEquals((Object)"ITC1-Description", (Object)awardToCompare.getInstrumentType().getInstrumentTypeDescription());
        Assertions.assertEquals((Object)"Invoicing Option Description 1", (Object)awardToCompare.getInvoicingOptionDescription());
        Assertions.assertEquals((Object)new KualiDecimal(1000.0), (Object)awardToCompare.getAwardTotalAmount());
    }

    @Test
    void getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts_MultipleAgenciesAwardsAndAwardAccounts(@Mock ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock1, @Mock ContractsAndGrantsInstrumentType instrumentTypeMock1, @Mock ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock2, @Mock ContractsAndGrantsInstrumentType instrumentTypeMock2, @Mock ContractsAndGrantsBillingAward contractsAndGrantsBillingAwardMock3, @Mock ContractsAndGrantsInstrumentType instrumentTypeMock3, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock1, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock2, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock3, @Mock ContractsAndGrantsBillingAwardAccount awardAccountMock4) {
        ContractsAndGrantsBillingAgency contractsAndGrantsBillingAgencyMock1 = ARAgencyMockFixture.CG_AGENCY2.createAgencyMock();
        this.setupContractsAndGrantsBillingAwardMock(contractsAndGrantsBillingAwardMock1, instrumentTypeMock1, "1", ArConstants.BillingFrequencyValues.MONTHLY.getCode(), this.awardBeginningDate, this.awardEndingDate, "ITC1", "Invoicing Option Description 1", 1000.0);
        this.setupContractsAndGrantsBillingAwardMock2(contractsAndGrantsBillingAwardMock2, instrumentTypeMock2, "2", ArConstants.BillingFrequencyValues.MILESTONE.getCode(), this.secondAwardBeginningDate, this.secondAwardEndingDate, "ITC2", "Invoicing Option Description 2", 2000.0, contractsAndGrantsBillingAgencyMock1);
        this.setupContractsAndGrantsBillingAwardMock(contractsAndGrantsBillingAwardMock3, instrumentTypeMock3, "3", ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode(), this.thirdAwardBeginningDate, this.thirdAwardEndingDate, "ITC3", "Invoicing Option Description 3", 3000.0);
        this.setupAwardAccountMock(awardAccountMock1, "C1", "A1", contractsAndGrantsBillingAwardMock1);
        this.setupAwardAccountMock(awardAccountMock2, "C2", "A2", contractsAndGrantsBillingAwardMock1);
        this.setupAwardAccountMock(awardAccountMock3, "C3", "A3", contractsAndGrantsBillingAwardMock2);
        this.setupAwardAccountMock(awardAccountMock4, "C4", "A4", contractsAndGrantsBillingAwardMock3);
        List<ContractsAndGrantsBillingAwardAccount> awardAccounts = Arrays.asList(awardAccountMock1, awardAccountMock2, awardAccountMock3, awardAccountMock4);
        Collection contractsGrantsInvoiceLookupResults = this.cut.getPopulatedContractsGrantsInvoiceLookupResultsFromAwardAccounts(awardAccounts);
        Assertions.assertEquals((int)1, (int)contractsGrantsInvoiceLookupResults.size());
        Iterator iter = contractsGrantsInvoiceLookupResults.iterator();
        ContractsGrantsInvoiceLookupResult contractsGrantsInvoiceLookupResult = (ContractsGrantsInvoiceLookupResult)iter.next();
        Assertions.assertEquals((Object)"A1", (Object)contractsGrantsInvoiceLookupResult.getAgencyNumber());
        Assertions.assertEquals((Object)"Agency Reporting Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyReportingName());
        Assertions.assertEquals((Object)"Agency Full Name", (Object)contractsGrantsInvoiceLookupResult.getAgencyFullName());
        Assertions.assertEquals((Object)"C1", (Object)contractsGrantsInvoiceLookupResult.getCustomerNumber());
        Assertions.assertEquals((int)4, (int)contractsGrantsInvoiceLookupResult.getLookupResultAwards().size());
        String[] expectedProposalNumbers = new String[]{"1", "1", "2", "3"};
        Date[] expectedAwardBeginningDates = new Date[]{this.awardBeginningDate, this.awardBeginningDate, this.secondAwardBeginningDate, this.thirdAwardBeginningDate};
        Date[] expectedAwardEndingDates = new Date[]{this.awardEndingDate, this.awardEndingDate, this.secondAwardEndingDate, this.thirdAwardEndingDate};
        String[] expectedBillingFrequencyCodes = new String[]{ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ArConstants.BillingFrequencyValues.MONTHLY.getCode(), ArConstants.BillingFrequencyValues.MILESTONE.getCode(), ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.getCode()};
        String[] expectedInstrumentTypeDescriptions = new String[]{"ITC1-Description", "ITC1-Description", "ITC2-Description", "ITC3-Description"};
        String[] expectedInvoicingOptionDescriptions = new String[]{"Invoicing Option Description 1", "Invoicing Option Description 1", "Invoicing Option Description 2", "Invoicing Option Description 3"};
        KualiDecimal[] expectedAwardTotalAmounts = new KualiDecimal[]{new KualiDecimal(1000.0), new KualiDecimal(1000.0), new KualiDecimal(2000.0), new KualiDecimal(3000.0)};
        int lookupResultAwardCount = 1;
        for (ContractsGrantsInvoiceLookupResultAward contractsGrantsInvoiceLookupResultAward : contractsGrantsInvoiceLookupResult.getLookupResultAwards()) {
            Assertions.assertEquals((Object)expectedProposalNumbers[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getProposalNumber());
            Assertions.assertEquals((Object)("C" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getChartOfAccountsCode());
            Assertions.assertEquals((Object)("A" + lookupResultAwardCount), (Object)contractsGrantsInvoiceLookupResultAward.getAccountNumber());
            Assertions.assertEquals((Object)expectedAwardBeginningDates[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getAwardBeginningDate());
            Assertions.assertEquals((Object)expectedAwardEndingDates[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getAwardEndingDate());
            Assertions.assertEquals((Object)expectedBillingFrequencyCodes[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getBillingFrequencyCode());
            Assertions.assertEquals((Object)expectedInstrumentTypeDescriptions[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getInstrumentTypeDescription());
            Assertions.assertEquals((Object)expectedInvoicingOptionDescriptions[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getInvoicingOptionDescription());
            Assertions.assertEquals((Object)expectedAwardTotalAmounts[lookupResultAwardCount - 1], (Object)contractsGrantsInvoiceLookupResultAward.getAwardTotalAmount());
            ++lookupResultAwardCount;
        }
        Collection awards = contractsGrantsInvoiceLookupResult.getAwards();
        Assertions.assertEquals((int)3, (int)awards.size());
        for (ContractsAndGrantsBillingAward contractsAndGrantsBillingAward : awards) {
            int expectedIndex = Integer.parseInt(contractsAndGrantsBillingAward.getProposalNumber());
            Assertions.assertEquals((Object)expectedProposalNumbers[expectedIndex], (Object)contractsAndGrantsBillingAward.getProposalNumber());
            Assertions.assertEquals((Object)expectedAwardBeginningDates[expectedIndex], (Object)contractsAndGrantsBillingAward.getAwardBeginningDate());
            Assertions.assertEquals((Object)expectedAwardEndingDates[expectedIndex], (Object)contractsAndGrantsBillingAward.getAwardEndingDate());
            Assertions.assertEquals((Object)expectedBillingFrequencyCodes[expectedIndex], (Object)contractsAndGrantsBillingAward.getBillingFrequencyCode());
            Assertions.assertEquals((Object)expectedInstrumentTypeDescriptions[expectedIndex], (Object)contractsAndGrantsBillingAward.getInstrumentType().getInstrumentTypeDescription());
            Assertions.assertEquals((Object)expectedInvoicingOptionDescriptions[expectedIndex], (Object)contractsAndGrantsBillingAward.getInvoicingOptionDescription());
            Assertions.assertEquals((Object)expectedAwardTotalAmounts[expectedIndex], (Object)contractsAndGrantsBillingAward.getAwardTotalAmount());
        }
    }
}

