/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;
import org.kuali.rice.core.api.util.type.KualiDecimal;

class AccountingLineTest {
    static final String CHART_CODE = "CHART_CODE";
    static final String ACCOUNT_NUMBER = "ACCOUNT_NUMBER";
    static final String SUB_ACCOUNT_NUMBER = "SUB_ACCOUNT_NUMBER";
    static final String OBJECT = "OBJECT";
    static final String SUB_OBJECT = "SUB_OBJECT";
    static final String PROJECT_CODE = "PROJECT_CODE";
    static final String ORG_REF_ID = "ORG_REF_ID";
    static final String DESCRIPTION = "DESCRIPTION";
    static final KualiDecimal AMOUNT = new KualiDecimal(42);
    static final String CUT_AS_JSON = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"subAccountNumber\": \"SUB_ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"subObject\": \"SUB_OBJECT\",    \"projectCode\": \"PROJECT_CODE\",    \"orgRefId\": \"ORG_REF_ID\",    \"description\": \"DESCRIPTION\",    \"amount\": " + AMOUNT + "}";
    static final String CUT_AS_JSON_MINIMAL = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
    private static final JsonMapper MAPPER = new JsonMapper();
    private static final PaymentApplicationAdjustmentRequest.AccountingLine CUT = new PaymentApplicationAdjustmentRequest.AccountingLine("CHART_CODE", "ACCOUNT_NUMBER", "SUB_ACCOUNT_NUMBER", "OBJECT", "SUB_OBJECT", "PROJECT_CODE", "ORG_REF_ID", "DESCRIPTION", AMOUNT);
    private static final PaymentApplicationAdjustmentRequest.AccountingLine CUT_MINIMAL = new PaymentApplicationAdjustmentRequest.AccountingLine("CHART_CODE", "ACCOUNT_NUMBER", null, "OBJECT", null, null, null, null, AMOUNT);

    AccountingLineTest() {
    }

    @DisplayName(value="Given valid JSON, it should be deserialized to the equivalent instance")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeValidArgs"})
    void deserialize_valid(PaymentApplicationAdjustmentRequest.AccountingLine expected, String requestJson) throws Exception {
        PaymentApplicationAdjustmentRequest.AccountingLine actual = (PaymentApplicationAdjustmentRequest.AccountingLine)MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.AccountingLine.class);
        Assertions.assertEquals((Object)expected, (Object)actual);
    }

    private static Stream<Arguments> deserializeValidArgs() {
        String withUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON.substring(1);
        String minimalWithUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON_MINIMAL.substring(1);
        return Stream.of(Arguments.of((Object[])new Object[]{CUT, CUT_AS_JSON}), Arguments.of((Object[])new Object[]{CUT, withUnknown}), Arguments.of((Object[])new Object[]{CUT_MINIMAL, CUT_AS_JSON_MINIMAL}), Arguments.of((Object[])new Object[]{CUT_MINIMAL, minimalWithUnknown}));
    }

    @DisplayName(value="Given invalid JSON, deserialization should fail")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeInvalidArgs"})
    void deserialize_invalid(String requestJson, String expectedErrorMessage) {
        Exception e = (Exception)Assertions.assertThrows(JsonProcessingException.class, () -> MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.AccountingLine.class));
        Assertions.assertTrue((boolean)e.getMessage().contains(expectedErrorMessage));
    }

    private static Stream<Arguments> deserializeInvalidArgs() {
        String minimalJsonWithEmptyChartCode = "{    \"chartCode\": \"\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithBlankChartCode = "{    \"chartCode\": \" \",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithNullChartCode = "{    \"chartCode\": null,    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithMissingChartCode = "{    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithEmptyAccountNumber = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"\",    \"object\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithBlankAccountNumber = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \" \",    \"object\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithNullAccountNumber = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": null,    \"object\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithMissingAccountNumber = "{    \"chartCode\": \"CHART_CODE\",    \"object\": \"OBJECT\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithEmptyObject = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithBlankObject = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \" \",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithNullObject = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": null,    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithMissingObject = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"amount\": " + AMOUNT + "}";
        String minimalJsonWithEmptyAmount = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"amount\": }";
        String minimalJsonWithNullAmount = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"amount\": null}";
        String minimalJsonWithMissingAmount = "{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\"}";
        return Stream.of(Arguments.of((Object[])new Object[]{minimalJsonWithEmptyChartCode, "chartCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithBlankChartCode, "chartCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithNullChartCode, "chartCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithMissingChartCode, "chartCode must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithEmptyAccountNumber, "accountNumber must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithBlankAccountNumber, "accountNumber must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithNullAccountNumber, "accountNumber must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithMissingAccountNumber, "accountNumber must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithEmptyObject, "object must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithBlankObject, "object must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithNullObject, "object must be supplied"}), Arguments.of((Object[])new Object[]{minimalJsonWithMissingObject, "object must be supplied"}), Arguments.of((Object[])new Object[]{"{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"amount\": }", "expected a value"}), Arguments.of((Object[])new Object[]{"{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\",    \"amount\": null}", "amount must be supplied"}), Arguments.of((Object[])new Object[]{"{    \"chartCode\": \"CHART_CODE\",    \"accountNumber\": \"ACCOUNT_NUMBER\",    \"object\": \"OBJECT\"}", "amount must be supplied"}));
    }
}

