/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.module.ar.rest.resource.requests.AdHocRoutePersonRequest;

class AdHocRoutePersonRequestTest {
    static final String PRINCIPAL_NAME = "aPrincipalName";
    static final String ACTION = "anAction";
    static final String CUT_AS_JSON = "{    \"principalName\": \"aPrincipalName\",    \"action\": \"anAction\"}";
    private static final JsonMapper MAPPER = new JsonMapper();
    private final AdHocRoutePersonRequest cut = new AdHocRoutePersonRequest("aPrincipalName", "anAction");

    AdHocRoutePersonRequestTest() {
    }

    @DisplayName(value="Given valid JSON, it should be deserialized to the equivalent instance")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeValidArgs"})
    void deserialize_valid(String requestJson) throws Exception {
        AdHocRoutePersonRequest actual = (AdHocRoutePersonRequest)MAPPER.readValue(requestJson, AdHocRoutePersonRequest.class);
        Assertions.assertEquals((Object)this.cut, (Object)actual);
    }

    private static Stream<Arguments> deserializeValidArgs() {
        String withUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON.substring(1);
        return Stream.of(Arguments.of((Object[])new Object[]{CUT_AS_JSON}), Arguments.of((Object[])new Object[]{withUnknown}));
    }

    @DisplayName(value="Given invalid JSON, deserialization should fail")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeInvalidArgs"})
    void deserialize_invalid(String requestJson) {
        Assertions.assertThrows(JsonProcessingException.class, () -> MAPPER.readValue(requestJson, AdHocRoutePersonRequest.class));
    }

    private static Stream<Arguments> deserializeInvalidArgs() {
        String principalNameMissing = "{    \"action\":\"anAction\"}";
        String actionMissing = "{    \"principalName\":\"aPrincipalName\"}";
        return Stream.of(Arguments.of((Object[])new Object[]{"{    \"action\":\"anAction\"}"}), Arguments.of((Object[])new Object[]{"{    \"principalName\":\"aPrincipalName\"}"}));
    }
}

