/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;
import org.kuali.rice.core.api.util.type.KualiDecimal;

class InvoiceApplicationDetailTest {
    static final KualiDecimal AMOUNT_APPLIED = new KualiDecimal(42);
    static final Integer SEQUENCE_NUMBER = 7;
    static final String CUT_AS_JSON = "{    \"amountApplied\": " + AMOUNT_APPLIED + ",    \"sequenceNumber\": " + SEQUENCE_NUMBER + "}";
    private static final JsonMapper MAPPER = new JsonMapper();
    private final PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail cut = new PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail(AMOUNT_APPLIED, SEQUENCE_NUMBER);

    InvoiceApplicationDetailTest() {
    }

    @DisplayName(value="Given valid JSON, it should be deserialized to the equivalent instance")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeValidArgs"})
    void deserialize_valid(String requestJson) throws Exception {
        PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail actual = (PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail)MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail.class);
        Assertions.assertEquals((Object)this.cut, (Object)actual);
    }

    private static Stream<Arguments> deserializeValidArgs() {
        String withUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON.substring(1);
        return Stream.of(Arguments.of((Object[])new Object[]{CUT_AS_JSON}), Arguments.of((Object[])new Object[]{withUnknown}));
    }

    @DisplayName(value="Given invalid JSON, deserialization should fail")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeInvalidArgs"})
    void deserialize_invalid(String requestJson) {
        Assertions.assertThrows(JsonProcessingException.class, () -> MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.InvoiceApplicationDetail.class));
    }

    private static Stream<Arguments> deserializeInvalidArgs() {
        String missingAmountApplied1 = "{    \"sequenceNumber\": " + SEQUENCE_NUMBER + "}";
        String missingAmountApplied2 = "{    \"amountApplied\": ,    \"sequenceNumber\": " + SEQUENCE_NUMBER + "}";
        String missingAmountApplied3 = "{    \"amountApplied\": null,    \"sequenceNumber\": " + SEQUENCE_NUMBER + "}";
        String missingSequenceNumber1 = "{    \"amountApplied\": " + AMOUNT_APPLIED + "}";
        String missingSequenceNumber2 = "{    \"amountApplied\": " + AMOUNT_APPLIED + ",    \"sequenceNumber\": }";
        String missingSequenceNumber3 = "{    \"amountApplied\": " + AMOUNT_APPLIED + ",    \"sequenceNumber\": null}";
        String negativeSequenceNumber = "{    \"amountApplied\": " + AMOUNT_APPLIED + ",    \"sequenceNumber\": -1}";
        return Stream.of(Arguments.of((Object[])new Object[]{missingAmountApplied1}), Arguments.of((Object[])new Object[]{missingAmountApplied2}), Arguments.of((Object[])new Object[]{missingAmountApplied3}), Arguments.of((Object[])new Object[]{missingSequenceNumber1}), Arguments.of((Object[])new Object[]{missingSequenceNumber2}), Arguments.of((Object[])new Object[]{missingSequenceNumber3}), Arguments.of((Object[])new Object[]{negativeSequenceNumber}));
    }
}

