/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.module.ar.rest.resource.requests.PaymentApplicationAdjustmentRequest;
import org.kuali.rice.core.api.util.type.KualiDecimal;

class NonAppliedHoldingTest {
    static final KualiDecimal AMOUNT = new KualiDecimal(42);
    static final String CUSTOMER_NUMBER = "CN";
    static final String CUT_AS_JSON = "{    \"amount\": " + AMOUNT + ",    \"customerNumber\": \"CN\"}";
    private static final JsonMapper MAPPER = new JsonMapper();
    private final PaymentApplicationAdjustmentRequest.NonAppliedHolding cut = new PaymentApplicationAdjustmentRequest.NonAppliedHolding(AMOUNT, "CN");

    NonAppliedHoldingTest() {
    }

    @DisplayName(value="Given valid JSON, it should be deserialized to the equivalent instance")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeValidArgs"})
    void deserialize_valid(String requestJson) throws Exception {
        PaymentApplicationAdjustmentRequest.NonAppliedHolding actual = (PaymentApplicationAdjustmentRequest.NonAppliedHolding)MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.NonAppliedHolding.class);
        Assertions.assertEquals((Object)this.cut, (Object)actual);
    }

    private static Stream<Arguments> deserializeValidArgs() {
        String withUnknown = "{    \"unknown\": \"unknown\"," + CUT_AS_JSON.substring(1);
        return Stream.of(Arguments.of((Object[])new Object[]{CUT_AS_JSON}), Arguments.of((Object[])new Object[]{withUnknown}));
    }

    @DisplayName(value="Given invalid JSON, deserialization should fail")
    @ParameterizedTest(name="requestJson = {0}")
    @MethodSource(value={"deserializeInvalidArgs"})
    void deserialize_invalid(String requestJson) {
        Assertions.assertThrows(JsonProcessingException.class, () -> MAPPER.readValue(requestJson, PaymentApplicationAdjustmentRequest.NonAppliedHolding.class));
    }

    private static Stream<Arguments> deserializeInvalidArgs() {
        String missingAmount1 = "{    \"customerNumber\": \"CN\"}";
        String missingAmount2 = "{    \"amount\": ,    \"customerNumber\": \"CN\"}";
        String missingAmount3 = "{    \"amount\": null,    \"customerNumber\": \"CN\"}";
        String missingCustomerNumber1 = "{    \"amount\": " + AMOUNT + "\"}";
        String missingCustomerNumber2 = "{    \"amount\": " + AMOUNT + ",    \"customerNumber\": \"\"}";
        String missingCustomerNumber3 = "{    \"amount\": " + AMOUNT + ",    \"customerNumber\": \" \"}";
        String missingCustomerNumber4 = "{    \"amount\": " + AMOUNT + ",    \"customerNumber\": null }";
        return Stream.of(Arguments.of((Object[])new Object[]{"{    \"customerNumber\": \"CN\"}"}), Arguments.of((Object[])new Object[]{"{    \"amount\": ,    \"customerNumber\": \"CN\"}"}), Arguments.of((Object[])new Object[]{"{    \"amount\": null,    \"customerNumber\": \"CN\"}"}), Arguments.of((Object[])new Object[]{missingCustomerNumber1}), Arguments.of((Object[])new Object[]{missingCustomerNumber2}), Arguments.of((Object[])new Object[]{missingCustomerNumber3}), Arguments.of((Object[])new Object[]{missingCustomerNumber4}));
    }
}

