/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.rest.resource.responses;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.sql.Date;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.rest.resource.responses.PaymentApplicationAdjustmentInvoiceResponse;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.WARN)
class PaymentApplicationAdjustmentInvoiceResponseTest {
    private static final String DOCUMENT_NUMBER = "1234";
    private static final String CUSTOMER_URL = "customerUrl";
    private static final String DOCUMENT_URL = "documentUrl";
    private static final String INVOICE_DOC_NUMBER = "5555";
    private static final Date BILLING_DATE = new Date(123L);
    private static final String CUSTOMER_NUMBER = "6789";
    private static final String INVOICE_HEADER_TEXT = "header text";
    private static final String CUSTOMER_NAME = "customerName";
    private static final KualiDecimal INVOICE_TOTAL_AMOUNT = new KualiDecimal(100);
    private static final String FIRST_DETAIL_CHART_CODE = "A";
    private static final String FIRST_DETAIL_ACCOUNT_NUMBER = "5790";
    private static final Integer FIRST_DETAIL_SEQUENCE_NUMBER = 1;
    private static final String FIRST_DETAIL_INVOICE_ITEM_DESCRIPTION = "firstDescription";
    private static final KualiDecimal FIRST_DETAIL_AMOUNT = new KualiDecimal(10);
    private static final KualiDecimal FIRST_DETAIL_APPLIED_AMOUNT = new KualiDecimal(1);
    private static final String SECOND_DETAIL_CHART_CODE = "B";
    private static final String SECOND_DETAIL_ACCOUNT_NUMBER = "8890";
    private static final Integer SECOND_DETAIL_SEQUENCE_NUMBER = 2;
    private static final String SECOND_DETAIL_INVOICE_ITEM_DESCRIPTION = "secondDescription";
    private static final KualiDecimal SECOND_DETAIL_AMOUNT = new KualiDecimal(5);
    private static final KualiDecimal SECOND_DETAIL_APPLIED_AMOUNT = new KualiDecimal(2);
    private static final JsonMapper MAPPER = new JsonMapper();
    @Mock
    CustomerInvoiceDocument invoiceDocumentMock;
    @Mock
    CustomerInvoiceDetail firstCustomerDetailMock;
    @Mock
    CustomerInvoiceDetail secondCustomerDetailMock;
    @Mock
    InvoicePaidApplied firstInvoicePaidAppliedMock;
    @Mock
    InvoicePaidApplied secondInvoicePaidAppliedMock;
    @Mock
    Customer customerMock;

    PaymentApplicationAdjustmentInvoiceResponseTest() {
    }

    @BeforeEach
    void setup() {
        Mockito.when((Object)this.invoiceDocumentMock.getCustomer()).thenReturn((Object)this.customerMock);
        Mockito.when((Object)this.invoiceDocumentMock.getCustomerInvoiceDetailsWithoutDiscounts()).thenReturn(List.of(this.firstCustomerDetailMock, this.secondCustomerDetailMock));
        Mockito.when((Object)this.firstCustomerDetailMock.getChartOfAccountsCode()).thenReturn((Object)FIRST_DETAIL_CHART_CODE);
        Mockito.when((Object)this.firstCustomerDetailMock.getAccountNumber()).thenReturn((Object)FIRST_DETAIL_ACCOUNT_NUMBER);
        Mockito.when((Object)this.firstCustomerDetailMock.getInvoiceItemNumber()).thenReturn((Object)FIRST_DETAIL_SEQUENCE_NUMBER);
        Mockito.when((Object)this.firstCustomerDetailMock.getInvoiceItemDescription()).thenReturn((Object)FIRST_DETAIL_INVOICE_ITEM_DESCRIPTION);
        Mockito.when((Object)this.firstCustomerDetailMock.getAmount()).thenReturn((Object)FIRST_DETAIL_AMOUNT);
        Mockito.when((Object)this.firstInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)INVOICE_DOC_NUMBER);
        Mockito.when((Object)this.firstInvoicePaidAppliedMock.getInvoiceItemNumber()).thenReturn((Object)FIRST_DETAIL_SEQUENCE_NUMBER);
        Mockito.when((Object)this.firstInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)FIRST_DETAIL_APPLIED_AMOUNT);
        Mockito.when((Object)this.secondCustomerDetailMock.getChartOfAccountsCode()).thenReturn((Object)SECOND_DETAIL_CHART_CODE);
        Mockito.when((Object)this.secondCustomerDetailMock.getAccountNumber()).thenReturn((Object)SECOND_DETAIL_ACCOUNT_NUMBER);
        Mockito.when((Object)this.secondCustomerDetailMock.getInvoiceItemNumber()).thenReturn((Object)SECOND_DETAIL_SEQUENCE_NUMBER);
        Mockito.when((Object)this.secondCustomerDetailMock.getInvoiceItemDescription()).thenReturn((Object)SECOND_DETAIL_INVOICE_ITEM_DESCRIPTION);
        Mockito.when((Object)this.secondCustomerDetailMock.getAmount()).thenReturn((Object)SECOND_DETAIL_AMOUNT);
        Mockito.when((Object)this.secondInvoicePaidAppliedMock.getFinancialDocumentReferenceInvoiceNumber()).thenReturn((Object)INVOICE_DOC_NUMBER);
        Mockito.when((Object)this.secondInvoicePaidAppliedMock.getInvoiceItemNumber()).thenReturn((Object)SECOND_DETAIL_SEQUENCE_NUMBER);
        Mockito.when((Object)this.secondInvoicePaidAppliedMock.getInvoiceItemAppliedAmount()).thenReturn((Object)SECOND_DETAIL_APPLIED_AMOUNT);
    }

    @ParameterizedTest(name="Construction throws IllegalArgumentException with {arguments}")
    @MethodSource(value={"invalidConstructorArgs"})
    void failedConstructionPath(String docNumber, CustomerInvoiceDocument invoice, List<InvoicePaidApplied> invoicePaidApplieds, String documentUrl, String customerUrl) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new PaymentApplicationAdjustmentInvoiceResponse(docNumber, invoice, invoicePaidApplieds, documentUrl, customerUrl));
    }

    private static Stream<Arguments> invalidConstructorArgs() {
        List invoicePaidApplieds = Collections.emptyList();
        return Stream.of(Arguments.of((Object[])new Object[]{null, Mockito.mock(CustomerInvoiceDocument.class), invoicePaidApplieds, DOCUMENT_URL, CUSTOMER_URL}), Arguments.of((Object[])new Object[]{DOCUMENT_NUMBER, null, invoicePaidApplieds, DOCUMENT_URL, CUSTOMER_URL}), Arguments.of((Object[])new Object[]{DOCUMENT_NUMBER, Mockito.mock(CustomerInvoiceDocument.class), null, DOCUMENT_URL, CUSTOMER_URL}), Arguments.of((Object[])new Object[]{DOCUMENT_NUMBER, Mockito.mock(CustomerInvoiceDocument.class), invoicePaidApplieds, null, CUSTOMER_URL}), Arguments.of((Object[])new Object[]{DOCUMENT_NUMBER, Mockito.mock(CustomerInvoiceDocument.class), invoicePaidApplieds, DOCUMENT_URL, null}));
    }

    @Test
    void serialize() throws Exception {
        Mockito.when((Object)this.invoiceDocumentMock.getDocumentNumber()).thenReturn((Object)INVOICE_DOC_NUMBER);
        Mockito.when((Object)this.invoiceDocumentMock.getBillingDate()).thenReturn((Object)BILLING_DATE);
        Mockito.when((Object)this.invoiceDocumentMock.getInvoiceHeaderText()).thenReturn((Object)INVOICE_HEADER_TEXT);
        Mockito.when((Object)this.invoiceDocumentMock.getTotalDollarAmount()).thenReturn((Object)INVOICE_TOTAL_AMOUNT);
        Mockito.when((Object)this.customerMock.getCustomerName()).thenReturn((Object)CUSTOMER_NAME);
        Mockito.when((Object)this.customerMock.getCustomerNumber()).thenReturn((Object)CUSTOMER_NUMBER);
        PaymentApplicationAdjustmentInvoiceResponse cut = new PaymentApplicationAdjustmentInvoiceResponse(DOCUMENT_NUMBER, this.invoiceDocumentMock, List.of(this.firstInvoicePaidAppliedMock, this.secondInvoicePaidAppliedMock), DOCUMENT_URL, CUSTOMER_URL);
        KualiDecimal expectedAmountToApply = (KualiDecimal)FIRST_DETAIL_APPLIED_AMOUNT.add((AbstractKualiDecimal)SECOND_DETAIL_APPLIED_AMOUNT);
        String actual = MAPPER.writeValueAsString((Object)cut);
        String expected = "{\"documentNumber\": \"5555\",\"customerNumber\": \"6789\",\"invoiceBillingDate\": " + BILLING_DATE.getTime() + ",\"headerText\": \"header text\",\"customerName\": \"customerName\",\"totalAmount\": " + INVOICE_TOTAL_AMOUNT + ",\"amountToApply\": " + expectedAmountToApply + ",\"openAmount\": " + INVOICE_TOTAL_AMOUNT.subtract((AbstractKualiDecimal)expectedAmountToApply) + ",\"detailApplications\": [{\"chartOfAccountsCode\": \"A\",\"accountNumber\": \"5790\",\"invoiceItemDescription\": \"firstDescription\",\"sequenceNumber\": " + FIRST_DETAIL_SEQUENCE_NUMBER + ",\"amount\": " + FIRST_DETAIL_AMOUNT + ",\"amountApplied\": " + FIRST_DETAIL_APPLIED_AMOUNT + ",\"amountOpen\": " + FIRST_DETAIL_AMOUNT.subtract((AbstractKualiDecimal)FIRST_DETAIL_APPLIED_AMOUNT) + "},{\"chartOfAccountsCode\": \"B\",\"accountNumber\": \"8890\",\"invoiceItemDescription\": \"secondDescription\",\"sequenceNumber\": " + SECOND_DETAIL_SEQUENCE_NUMBER + ",\"amount\": " + SECOND_DETAIL_AMOUNT + ",\"amountApplied\": " + SECOND_DETAIL_APPLIED_AMOUNT + ",\"amountOpen\": " + SECOND_DETAIL_AMOUNT.subtract((AbstractKualiDecimal)SECOND_DETAIL_APPLIED_AMOUNT) + "}],\"documentLink\": {\"type\": \"link\",\"url\": \"documentUrl\",\"value\": \"5555\"},\"customerLink\": {\"type\": \"link\",\"url\": \"customerUrl\",\"value\": \"6789\"}}";
        JSONAssert.assertEquals((String)expected, (String)actual, (JSONCompareMode)JSONCompareMode.STRICT);
    }
}

