/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.ar.batch.service.LetterOfCreditCreateService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.CashControlDocumentService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.PaymentApplicationDocumentService;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;

public class LetterOfCreditCreateServiceImpl
implements LetterOfCreditCreateService {
    private static final Logger LOG = LogManager.getLogger();
    protected CashControlDocumentService cashControlDocumentService;
    protected ConfigurationService configService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected GeneralLedgerPendingEntryService generalLedgerPendingEntryService;
    protected KualiModuleService kualiModuleService;
    protected ParameterService parameterService;
    protected WorkflowDocumentService workflowDocumentService;
    protected PaymentApplicationDocumentService paymentApplicationDocumentService;

    @Override
    @Transactional
    public void routeCashControlDocument(CashControlDocument cashControlDocument, PrintWriter errorFile) {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Routing Cash control document # " + cashControlDocument.getDocumentNumber() + ".");
            }
            this.documentService.prepareWorkflowDocument((Document)cashControlDocument);
            this.workflowDocumentService.route(cashControlDocument.getDocumentHeader().getWorkflowDocument(), "", null);
        }
        catch (WorkflowException e) {
            String errorString = "Error routing document # " + cashControlDocument.getDocumentNumber();
            errorFile.println(errorString);
            LOG.error(errorString + " " + e.getMessage());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void processLettersOfCredit(String batchFileDirectoryName) {
        String runtimeStamp = this.dateTimeService.toDateTimeStringForFilename(new java.util.Date());
        String errOutputFile = batchFileDirectoryName + File.separator + "cgin_loc_by_loc_fund_create_doc_err_" + runtimeStamp + ".txt";
        File errOutPutFile = new File(errOutputFile);
        try (PrintWriter errorFile = null;){
            errorFile = new PrintWriter(errOutPutFile, StandardCharsets.UTF_8);
            Collection<ContractsGrantsInvoiceDocument> cgInvoices = this.retrieveLetterOfCreditInvoices();
            if (CollectionUtils.isNotEmpty(cgInvoices)) {
                CashControlDocument cashControlDoc = this.createCashControlDocument(errorFile);
                for (ContractsGrantsInvoiceDocument cgInvoice : cgInvoices) {
                    if (cgInvoice.getOpenAmount().isGreaterThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
                        this.processLetterOfCreditInvoice(cgInvoice, cashControlDoc, errorFile);
                        continue;
                    }
                    String errorString = this.configService.getPropertyValueAsString("error.loc.invoice.paid");
                    errorFile.println(MessageFormat.format(errorString, cgInvoice.getDocumentNumber()));
                }
                this.routeCashControlDocument(cashControlDoc, errorFile);
            } else {
                String errorString = this.configService.getPropertyValueAsString("error.loc.no.invoices.to.process");
                errorFile.println(errorString);
            }
        }
    }

    @Override
    @Transactional
    public void processLetterOfCreditInvoice(ContractsGrantsInvoiceDocument cgInvoice, CashControlDocument cashControlDoc, PrintWriter errorFile) {
        CashControlDetail cashControlDetail = this.createCashControlDetail(cgInvoice);
        try {
            this.cashControlDocumentService.addNewCashControlDetail(this.configService.getPropertyValueAsString("message.ar.createdByCashControlDocument"), cashControlDoc, cashControlDetail);
            String payAppDocNumber = cashControlDetail.getReferenceFinancialDocumentNumber();
            PaymentApplicationDocument payAppDoc = (PaymentApplicationDocument)this.documentService.getByDocumentHeaderId(payAppDocNumber);
            payAppDoc = this.paymentApplicationDocumentService.createInvoicePaidAppliedsForEntireInvoiceDocument(cgInvoice, payAppDoc);
            this.getGeneralLedgerPendingEntryService().generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)payAppDoc);
            this.documentService.saveDocument((Document)payAppDoc);
            if (LOG.isInfoEnabled()) {
                LOG.info("Routing Payment Application document # " + payAppDoc.getDocumentNumber() + ".");
            }
            this.documentService.prepareWorkflowDocument((Document)payAppDoc);
            this.workflowDocumentService.route(payAppDoc.getDocumentHeader().getWorkflowDocument(), "", null);
        }
        catch (WorkflowException ex) {
            String error = "Error creating Cash Control Detail/Payment Application Document, Cash Control doc # " + cashControlDoc.getDocumentNumber();
            errorFile.println(error);
            LOG.error(error + " " + ex.getMessage());
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    @Transactional
    public CashControlDocument createCashControlDocument(PrintWriter errorFile) {
        CashControlDocument cashControlDoc = null;
        try {
            cashControlDoc = (CashControlDocument)this.documentService.getNewDocument(CashControlDocument.class);
            cashControlDoc.getDocumentHeader().setDocumentDescription(this.configService.getPropertyValueAsString("message.ar.cashControlDocCreatedByLOC"));
            AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
            accountsReceivableDocumentHeader.setDocumentNumber(cashControlDoc.getDocumentNumber());
            String defaultProcessingChartCode = this.parameterService.getParameterValueAsString(CashControlDocument.class, "DEFAULT_PROCESSING_CHART");
            String defaultProcessingOrgCode = this.parameterService.getParameterValueAsString(CashControlDocument.class, "DEFAULT_PROCESSING_ORG");
            accountsReceivableDocumentHeader.setProcessingChartOfAccountCode(defaultProcessingChartCode);
            accountsReceivableDocumentHeader.setProcessingOrganizationCode(defaultProcessingOrgCode);
            cashControlDoc.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
            cashControlDoc.setCustomerPaymentMediumCode("WT");
            this.documentService.saveDocument((Document)cashControlDoc);
        }
        catch (WorkflowException ex) {
            String error = "Error creating Cash Control Document, Cash Control doc # " + (ObjectUtils.isNotNull(cashControlDoc) ? cashControlDoc.getDocumentNumber() : null);
            errorFile.println(error);
            LOG.error(error + " " + ex.getMessage());
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return cashControlDoc;
    }

    protected CashControlDetail createCashControlDetail(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        CashControlDetail cashControlDetail = new CashControlDetail();
        cashControlDetail.setCustomerNumber(contractsGrantsInvoiceDocument.getAccountsReceivableDocumentHeader().getCustomerNumber());
        cashControlDetail.setFinancialDocumentLineAmount(contractsGrantsInvoiceDocument.getOpenAmount());
        Timestamp ts = new Timestamp(new java.util.Date().getTime());
        Date today = new Date(ts.getTime());
        cashControlDetail.setCustomerPaymentDate(today);
        return cashControlDetail;
    }

    protected Collection<ContractsGrantsInvoiceDocument> retrieveLetterOfCreditInvoices() {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("invoiceGeneralDetail.letterOfCreditCreationType", SearchOperator.NOT_NULL.op());
        fieldValues.put("openInvoiceIndicator", "true");
        fieldValues.put("documentHeader.financialDocumentStatusCode", "A");
        return this.contractsGrantsInvoiceDocumentService.retrieveAllCGInvoicesByCriteria(fieldValues);
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public CashControlDocumentService getCashControlDocumentService() {
        return this.cashControlDocumentService;
    }

    public void setCashControlDocumentService(CashControlDocumentService cashControlDocumentService) {
        this.cashControlDocumentService = cashControlDocumentService;
    }

    public WorkflowDocumentService getWorkflowDocumentService() {
        return this.workflowDocumentService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public GeneralLedgerPendingEntryService getGeneralLedgerPendingEntryService() {
        return this.generalLedgerPendingEntryService;
    }

    public void setGeneralLedgerPendingEntryService(GeneralLedgerPendingEntryService generalLedgerPendingEntryService) {
        this.generalLedgerPendingEntryService = generalLedgerPendingEntryService;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public ConfigurationService getConfigService() {
        return this.configService;
    }

    public void setConfigService(ConfigurationService configService) {
        this.configService = configService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public PaymentApplicationDocumentService getPaymentApplicationDocumentService() {
        return this.paymentApplicationDocumentService;
    }

    public void setPaymentApplicationDocumentService(PaymentApplicationDocumentService paymentApplicationDocumentService) {
        this.paymentApplicationDocumentService = paymentApplicationDocumentService;
    }
}

