/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.vo;

import java.sql.Date;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.converters.SqlDateConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.datadictionary.legacy.MaintenanceDocumentDictionaryService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.module.ar.batch.report.CustomerLoadBatchErrors;
import org.kuali.kfs.module.ar.batch.vo.CustomerAddressDigesterVO;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerAddressEmail;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerDigesterAdapter {
    private static final Logger LOG = LogManager.getLogger();
    private static final Class<Customer> BO_CLASS = Customer.class;
    private DateTimeService dateTimeService;
    private MaintenanceDocumentDictionaryService maintDocDDService;
    private SequenceAccessorService sequenceAccessorService;
    private Customer customer;
    private String customerName;
    private CustomerLoadBatchErrors errors;
    private CustomerDigesterVO customerDigesterVO;

    public Customer convert(CustomerDigesterVO customerDigesterVO, CustomerLoadBatchErrors errors) {
        if (customerDigesterVO == null) {
            throw new IllegalArgumentException("Parameter customerDigesterVO may not be null.");
        }
        this.customerDigesterVO = customerDigesterVO;
        if (StringUtils.isBlank((CharSequence)customerDigesterVO.getCustomerName())) {
            LOG.error("CustomerName can never be empty-string or null.");
            this.addError("customerName", String.class, customerDigesterVO.getCustomerName(), "CustomerName can never be empty-string or null.");
            return null;
        }
        this.customer = new Customer();
        this.customerName = this.customerDigesterVO.getCustomerName();
        if (errors == null) {
            LOG.error("Passed in CustomerLoadBatchErrors must not be null.");
            throw new IllegalArgumentException("Passed in CustomerLoadBatchErrors must not be null.");
        }
        this.errors = errors;
        this.convertCustomerStringProperties();
        this.convertCustomerDateProperties();
        this.convertCustomerKualiDecimalProperties();
        this.convertCustomerBooleanProperties();
        this.convertCustomerAddresses();
        return this.customer;
    }

    private void convertCustomerStringProperties() {
        this.customer.setCustomerNumber(this.applyDefaultValue("customerNumber", this.customerDigesterVO.getCustomerNumber()));
        this.customer.setCustomerName(this.applyDefaultValue("customerName", this.customerDigesterVO.getCustomerName()));
        this.customer.setCustomerParentCompanyNumber(this.applyDefaultValue("customerParentCompanyNumber", this.customerDigesterVO.getCustomerParentCompanyNumber()));
        this.customer.setCustomerTypeCode(this.applyDefaultValue("customerTypeCode", this.customerDigesterVO.getCustomerTypeCode()));
        this.customer.setCustomerTaxTypeCode(this.applyDefaultValue("customerTaxTypeCode", this.customerDigesterVO.getCustomerTaxTypeCode()));
        this.customer.setCustomerTaxNbr(this.applyDefaultValue("customerTaxNbr", this.customerDigesterVO.getCustomerTaxNbr()));
        this.customer.setCustomerPhoneNumber(this.applyDefaultValue("customerPhoneNumber", this.customerDigesterVO.getCustomerPhoneNumber()));
        this.customer.setCustomer800PhoneNumber(this.applyDefaultValue("customer800PhoneNumber", this.customerDigesterVO.getCustomer800PhoneNumber()));
        this.customer.setCustomerContactName(this.applyDefaultValue("customerContactName", this.customerDigesterVO.getCustomerContactName()));
        this.customer.setCustomerContactPhoneNumber(this.applyDefaultValue("customerContactPhoneNumber", this.customerDigesterVO.getCustomerContactPhoneNumber()));
        this.customer.setCustomerFaxNumber(this.applyDefaultValue("customerFaxNumber", this.customerDigesterVO.getCustomerFaxNumber()));
        this.customer.setCustomerCreditApprovedByName(this.applyDefaultValue("customerCreditApprovedByName", this.customerDigesterVO.getCustomerCreditApprovedByName()));
        this.customer.setCustomerEmailAddress(this.applyDefaultValue("customerEmailAddress", this.customerDigesterVO.getCustomerEmailAddress()));
    }

    private void convertCustomerDateProperties() {
        Date todayDate = this.dateTimeService.getCurrentSqlDate();
        this.customer.setCustomerAddressChangeDate(todayDate);
        this.customer.setCustomerRecordAddDate(todayDate);
        this.customer.setCustomerLastActivityDate(todayDate);
        this.customer.setCustomerBirthDate(this.convertToJavaSqlDate("customerBirthDate", this.applyDefaultValue("customerBirthDate", this.customerDigesterVO.getCustomerBirthDate())));
    }

    private void convertCustomerKualiDecimalProperties() {
        this.customer.setCustomerCreditLimitAmount(this.convertToKualiDecimal("customerCreditLimitAmount", this.applyDefaultValue("customerCreditLimitAmount", this.customerDigesterVO.getCustomerCreditLimitAmount())));
    }

    private void convertCustomerBooleanProperties() {
        this.customer.setActive(CustomerDigesterAdapter.convertToLittleBoolean(this.applyDefaultValue("customerActiveIndicator", this.customerDigesterVO.getCustomerActiveIndicator())));
        this.customer.setCustomerTaxExemptIndicator(CustomerDigesterAdapter.convertToLittleBoolean(this.applyDefaultValue("customerTaxExemptIndicator", this.customerDigesterVO.getCustomerTaxExemptIndicator())));
    }

    private void convertCustomerAddresses() {
        for (CustomerAddressDigesterVO addressVO : this.customerDigesterVO.getCustomerAddresses()) {
            CustomerAddress customerAddress = this.convertCustomerAddress(addressVO, this.customer.getCustomerNumber());
            this.customer.getCustomerAddresses().add(customerAddress);
        }
    }

    private CustomerAddress convertCustomerAddress(CustomerAddressDigesterVO customerAddressDigesterVO, String customerNumber) {
        CustomerAddress customerAddress = new CustomerAddress();
        customerAddress.setCustomerNumber(customerNumber);
        customerAddress.setCustomerAddressName(this.applyDefaultValue("customerAddressName", customerAddressDigesterVO.getCustomerAddressName()));
        customerAddress.setCustomerLine1StreetAddress(this.applyDefaultValue("customerLine1StreetAddress", customerAddressDigesterVO.getCustomerLine1StreetAddress()));
        customerAddress.setCustomerLine2StreetAddress(this.applyDefaultValue("customerLine2StreetAddress", customerAddressDigesterVO.getCustomerLine2StreetAddress()));
        customerAddress.setCustomerCityName(this.applyDefaultValue("customerCityName", customerAddressDigesterVO.getCustomerCityName()));
        customerAddress.setCustomerStateCode(this.applyDefaultValue("customerStateCode", customerAddressDigesterVO.getCustomerStateCode()));
        customerAddress.setCustomerZipCode(this.applyDefaultValue("customerZipCode", customerAddressDigesterVO.getCustomerZipCode()));
        customerAddress.setCustomerCountryCode(this.applyDefaultValue("customerCountryCode", customerAddressDigesterVO.getCustomerCountryCode()));
        customerAddress.setCustomerAddressInternationalProvinceName(this.applyDefaultValue("customerAddressInternationalProvinceName", customerAddressDigesterVO.getCustomerAddressInternationalProvinceName()));
        customerAddress.setCustomerInternationalMailCode(this.applyDefaultValue("customerInternationalMailCode", customerAddressDigesterVO.getCustomerInternationalMailCode()));
        String customerEmailAddress = customerAddressDigesterVO.getCustomerEmailAddress();
        if (StringUtils.isNotBlank((CharSequence)customerEmailAddress)) {
            CustomerAddressEmail customerAddressEmail = new CustomerAddressEmail();
            customerAddressEmail.setCustomerNumber(customerNumber);
            customerAddressEmail.setCustomerAddressIdentifier(Math.toIntExact(this.sequenceAccessorService.getNextAvailableSequenceNumber("CUST_ADDR_ID_SEQ", CustomerAddress.class)));
            customerAddressEmail.setCustomerAddressIdentifier(null);
            customerAddressEmail.setCustomerEmailAddress(this.applyDefaultValue("customerEmailAddress", customerEmailAddress));
            customerAddressEmail.setActive(true);
            customerAddress.getCustomerAddressEmails().add(customerAddressEmail);
        }
        customerAddress.setCustomerAddressTypeCode(this.applyDefaultValue("customerAddressTypeCode", customerAddressDigesterVO.getCustomerAddressTypeCode()));
        customerAddress.setCustomerAddressEndDate(this.convertToJavaSqlDate("customerAddressEndDate", this.applyDefaultValue("customerAddressEndDate", customerAddressDigesterVO.getCustomerAddressEndDate())));
        return customerAddress;
    }

    private Date convertToJavaSqlDate(String propertyName, String dateValue) {
        Date date;
        Object obj;
        if (StringUtils.isBlank((CharSequence)dateValue)) {
            return null;
        }
        SqlDateConverter converter = new SqlDateConverter();
        try {
            obj = converter.convert(Date.class, (Object)dateValue);
        }
        catch (ConversionException e) {
            LOG.error("Failed to convert the value [" + dateValue + "] from field [" + propertyName + "] to a Date.");
            this.addError(propertyName, Date.class, dateValue, "Could not convert value to target type.");
            return null;
        }
        try {
            date = (Date)obj;
        }
        catch (Exception e) {
            LOG.error("Failed to cast the converters results to a Date.");
            this.addError(propertyName, Date.class, dateValue, "Could not convert value to target type.");
            return null;
        }
        if (!(obj instanceof Date)) {
            LOG.error("Failed to convert the value [" + dateValue + "] from field [" + propertyName + "] to a Date.");
            this.addError(propertyName, Date.class, dateValue, "Could not convert value to target type.");
            return null;
        }
        return date;
    }

    private KualiDecimal convertToKualiDecimal(String propertyName, String stringDecimal) {
        KualiDecimal kualiDecimal;
        if (StringUtils.isBlank((CharSequence)stringDecimal)) {
            return null;
        }
        try {
            kualiDecimal = new KualiDecimal(stringDecimal);
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to convert the value [" + stringDecimal + "] from field [" + propertyName + "] to a KualiDecimal.");
            this.addError(propertyName, KualiDecimal.class, stringDecimal, "Could not convert value to target type.");
            return null;
        }
        return kualiDecimal;
    }

    private static boolean convertToLittleBoolean(String stringBoolean) {
        if (StringUtils.isBlank((CharSequence)stringBoolean)) {
            return false;
        }
        if ("Y".equalsIgnoreCase(stringBoolean)) {
            return true;
        }
        if ("YES".equalsIgnoreCase(stringBoolean)) {
            return true;
        }
        if ("TRUE".equalsIgnoreCase(stringBoolean)) {
            return true;
        }
        if ("T".equalsIgnoreCase(stringBoolean)) {
            return true;
        }
        return "1".equalsIgnoreCase(stringBoolean);
    }

    private String applyDefaultValue(String propertyName, String batchValue) {
        if (StringUtils.isNotBlank((CharSequence)batchValue)) {
            return batchValue;
        }
        String incomingValue = StringUtils.isBlank((CharSequence)batchValue) ? null : StringUtils.trimToNull((String)batchValue);
        String defaultValue = this.maintDocDDService.getFieldDefaultValue(BO_CLASS, propertyName);
        if (incomingValue == null && StringUtils.isNotBlank((CharSequence)defaultValue)) {
            LOG.info("Applied DD default value of '" + defaultValue + "' to field [" + propertyName + "].");
            return defaultValue;
        }
        return incomingValue == null ? "" : incomingValue;
    }

    private void addError(String propertyName, Class<?> propertyClass, String origValue, String description) {
        LOG.error("Failed conversion on field [" + propertyName + "] with value: '" + origValue + "': " + description);
        this.errors.addError(this.customerName, propertyName, propertyClass, origValue, description);
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setMaintDocDDService(MaintenanceDocumentDictionaryService maintDocDDService) {
        this.maintDocDDService = maintDocDDService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }
}

