/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;

public class TimeBasedBillingPeriod
extends BillingPeriod {
    public TimeBasedBillingPeriod(ArConstants.BillingFrequencyValues billingFrequency, Date awardStartDate, Date currentDate, Date lastBilledDate, AccountingPeriodService accountingPeriodService) {
        super(billingFrequency, awardStartDate, currentDate, lastBilledDate, accountingPeriodService);
    }

    @Override
    protected Date determineEndDateByFrequency() {
        AccountingPeriod accountingPeriod = this.findPreviousAccountingPeriod(this.currentDate);
        return accountingPeriod.getUniversityFiscalPeriodEndDate();
    }

    protected Integer calculatePreviousPeriodByFrequency(Integer currentAccountingPeriodCode, int periodsInBillingFrequency) {
        int subAmt = currentAccountingPeriodCode % periodsInBillingFrequency == 0 ? periodsInBillingFrequency : currentAccountingPeriodCode % periodsInBillingFrequency;
        Integer previousAccountingPeriodCode = currentAccountingPeriodCode - subAmt;
        return previousAccountingPeriodCode;
    }

    @Override
    protected boolean canThisBeBilledByBillingFrequency() {
        if (ArConstants.BillingFrequencyValues.ANNUALLY.equals((Object)this.billingFrequency) && this.accountingPeriodService.getByDate(this.lastBilledDate).getUniversityFiscalYear() >= this.accountingPeriodService.getByDate(this.currentDate).getUniversityFiscalYear()) {
            return false;
        }
        return !StringUtils.equals((CharSequence)this.findPreviousAccountingPeriod(this.currentDate).getUniversityFiscalPeriodCode(), (CharSequence)this.findPreviousAccountingPeriod(this.lastBilledDate).getUniversityFiscalPeriodCode()) || !this.accountingPeriodService.getByDate(this.lastBilledDate).getUniversityFiscalYear().equals(this.accountingPeriodService.getByDate(this.currentDate).getUniversityFiscalYear());
    }

    @Override
    protected Date determineStartDate() {
        if (this.lastBilledDate == null) {
            if (this.awardStartDate.after(this.currentDate)) {
                AccountingPeriod previousAccountingPeriod = this.findPreviousAccountingPeriod(this.currentDate);
                AccountingPeriod beforePreviousAccountingPeriod = this.findPreviousAccountingPeriod(previousAccountingPeriod.getUniversityFiscalPeriodEndDate());
                return this.calculateNextDay(beforePreviousAccountingPeriod.getUniversityFiscalPeriodEndDate());
            }
            return this.awardStartDate;
        }
        return this.determineStartDateByFrequency();
    }

    @Override
    protected Date determineStartDateByFrequency() {
        AccountingPeriod lastBilledDateAccountingPeriod = this.findPreviousAccountingPeriod(this.lastBilledDate);
        return this.calculateNextDay(lastBilledDateAccountingPeriod.getUniversityFiscalPeriodEndDate());
    }

    protected AccountingPeriod findPreviousAccountingPeriod(Date date) {
        AccountingPeriod currentAccountingPeriod = this.findAccountingPeriodBy(date);
        Integer currentAccountingPeriodCode = Integer.parseInt(currentAccountingPeriod.getUniversityFiscalPeriodCode());
        Integer previousAccountingPeriodCode = this.findPreviousAccountingPeriodCode(currentAccountingPeriodCode);
        Integer currentFiscalYear = currentAccountingPeriod.getUniversityFiscalYear();
        if (previousAccountingPeriodCode == 0) {
            previousAccountingPeriodCode = 12;
            currentFiscalYear = currentFiscalYear - 1;
        }
        String periodCode = previousAccountingPeriodCode < 10 ? "0" + previousAccountingPeriodCode : "" + previousAccountingPeriodCode;
        return this.accountingPeriodService.getByPeriod(periodCode, currentFiscalYear);
    }

    protected Integer findPreviousAccountingPeriodCode(Integer currentAccountingPeriodCode) {
        Integer previousAccountingPeriodCode = ArConstants.BillingFrequencyValues.MONTHLY.equals((Object)this.billingFrequency) || ArConstants.BillingFrequencyValues.MANUAL.equals((Object)this.billingFrequency) || ArConstants.BillingFrequencyValues.MILESTONE.equals((Object)this.billingFrequency) || ArConstants.BillingFrequencyValues.PREDETERMINED_BILLING.equals((Object)this.billingFrequency) ? this.calculatePreviousPeriodByFrequency(currentAccountingPeriodCode, 1) : (ArConstants.BillingFrequencyValues.QUARTERLY.equals((Object)this.billingFrequency) ? this.calculatePreviousPeriodByFrequency(currentAccountingPeriodCode, 3) : (ArConstants.BillingFrequencyValues.SEMI_ANNUALLY.equals((Object)this.billingFrequency) ? this.calculatePreviousPeriodByFrequency(currentAccountingPeriodCode, 6) : this.calculatePreviousPeriodByFrequency(currentAccountingPeriodCode, 12)));
        return previousAccountingPeriodCode;
    }
}

